/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.jmsconnector.descriptor.gui;

import com.sap.engine.services.jmsconnector.descriptor.gui.ListValues;
import java.awt.Component;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.UIManager;

public class ListRenderer
extends JLabel
implements ListCellRenderer {
    public static final byte ALIAS = 1;
    private byte type = 0;
    private Icon destination;
    private Icon factory;
    private Icon alias;

    public ListRenderer() {
        this.setOpaque(true);
        this.initImages();
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
        if (!(value instanceof ListValues) && !(value instanceof String)) {
            return this;
        }
        if (value instanceof String) {
            String info = (String)value;
            switch (this.type) {
                case 1: {
                    this.setIcon(this.alias);
                    break;
                }
                default: {
                    this.setIcon(this.alias);
                    break;
                }
            }
        } else {
            ListValues info = (ListValues)value;
            switch (info.getType()) {
                case 0: {
                    this.setIcon(this.destination);
                    break;
                }
                case 1: {
                    this.setIcon(this.factory);
                }
            }
        }
        this.setText(value.toString());
        this.setBackground(isSelected ? UIManager.getColor("List.selectionBackground") : UIManager.getColor("Tree.textBackground"));
        this.setForeground(isSelected ? UIManager.getColor("List.selectionForeground") : UIManager.getColor("Tree.textForeground"));
        return this;
    }

    private void initImages() {
        try {
            this.destination = new ImageIcon(this.getClass().getResource("images/destinations.gif"));
            this.factory = new ImageIcon(this.getClass().getResource("images/factories.gif"));
            this.alias = new ImageIcon(this.getClass().getResource("images/alias.gif"));
        }
        catch (Exception e) {
            this.log(e);
        }
    }

    public void setType(byte _type) {
        this.type = _type;
    }

    private void log(Exception exc) {
    }
}

