/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.server.generator;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.engine.services.iiop.server.generator.ClassDescriptor;
import com.sap.engine.services.iiop.server.generator.ClassDescriptorDocument;
import com.sap.engine.services.iiop.server.generator.DescriptorWriter;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class StubTieGenerator {
    private String className;
    private TransformerFactory factory;
    private String workDir;
    private Vector xml;
    private String inXSLStub;
    private String inXSLTie;
    private String[] interfaces;
    private Vector remoteObjects;
    private Class[] remoteInterfaces;
    private boolean onlyStub;
    private Vector stubsAndTies;
    private boolean generateAdditional;
    private DescriptorWriter descriptor;
    private Hashtable remoteMethods;
    private Hashtable access;
    private static String[] strings = new String[]{"_Stub.java", "_Tie.java", ".xml"};
    private static String dot = ".";
    private static String unL = "_";
    static /* synthetic */ Class class$java$rmi$Remote;

    public StubTieGenerator(Class cls, String workDir, Hashtable access, boolean generateAdditional) throws Exception {
        SystemProperties.setProperty("javax.xml.transform.TransformerFactory", "com.sap.engine.lib.jaxp.TransformerFactoryImpl");
        ClassLoader storedContextLoader = null;
        try {
            storedContextLoader = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            this.factory = TransformerFactory.newInstance();
            this.descriptor = new DescriptorWriter(cls, access);
            this.className = cls.getName();
            this.inXSLStub = "com/sap/engine/services/iiop/recources/xsl/template_Stub.xsl";
            this.inXSLTie = "com/sap/engine/services/iiop/recources/xsl/template_Tie.xsl";
            this.stubsAndTies = new Vector();
            this.workDir = workDir;
            if (cls.isInterface()) {
                this.onlyStub = true;
            }
            this.generateAdditional = generateAdditional;
            this.access = access;
            this.remoteInterfaces = this.descriptor.getRemoteInterfaces();
            this.remoteMethods = this.descriptor.getRemoteMethods();
            this.xml = this.generateXML(this.className);
            Object var7_6 = null;
            Thread.currentThread().setContextClassLoader(storedContextLoader);
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            Thread.currentThread().setContextClassLoader(storedContextLoader);
            throw throwable;
        }
    }

    public Vector generate() {
        if (!this.onlyStub) {
            this.generateTie();
        }
        this.generateStubs();
        this.removeXmlFiles();
        return this.stubsAndTies;
    }

    public void generateStubs() {
        block13: {
            try {
                if (this.xml.size() <= 0) break block13;
                String[] stubRes = new String[this.xml.size()];
                String[] temp = new String[stubRes.length];
                if (this.xml.size() == 1) {
                    if (this.onlyStub) {
                        temp[0] = unL + this.className.substring(this.className.lastIndexOf(dot) + 1) + strings[0];
                        stubRes[0] = this.makeFile(temp[0], this.className);
                    } else {
                        temp[0] = unL + this.interfaces[0].substring(this.interfaces[0].lastIndexOf(dot) + 1) + strings[0];
                        stubRes[0] = this.makeFile(temp[0], this.interfaces[0]);
                    }
                } else if (!this.generateAdditional) {
                    temp[0] = unL + this.className.substring(this.className.lastIndexOf(dot) + 1) + strings[0];
                    stubRes[0] = this.makeFile(temp[0], this.className);
                    int i = 1;
                    while (i < this.interfaces.length + 1) {
                        temp[i] = unL + this.interfaces[i - 1].substring(this.interfaces[i - 1].lastIndexOf(dot) + 1) + strings[0];
                        stubRes[i] = this.makeFile(temp[i], this.interfaces[i - 1]);
                        Transformer transformer = this.factory.newTransformer(new StreamSource(this.getClass().getClassLoader().getResourceAsStream(this.inXSLStub)));
                        transformer.transform(new StreamSource((String)this.xml.elementAt(i)), new StreamResult(stubRes[i]));
                        this.stubsAndTies.addElement(stubRes[i]);
                        ++i;
                    }
                } else {
                    int i;
                    int count = this.interfaces.length;
                    if (count == 1) {
                        temp[0] = unL + this.interfaces[0].substring(this.interfaces[0].lastIndexOf(dot) + 1) + strings[0];
                        stubRes[0] = this.makeFile(temp[0], this.interfaces[0]);
                    } else {
                        ++count;
                        temp[0] = unL + this.className.substring(this.className.lastIndexOf(dot) + 1) + strings[0];
                        stubRes[0] = this.makeFile(temp[0], this.className);
                        i = 1;
                        while (i < count) {
                            temp[i] = unL + this.interfaces[i - 1].substring(this.interfaces[i - 1].lastIndexOf(dot) + 1) + strings[0];
                            stubRes[i] = this.makeFile(temp[i], this.interfaces[i - 1]);
                            Transformer transformer = this.factory.newTransformer(new StreamSource(this.getClass().getClassLoader().getResourceAsStream(this.inXSLStub)));
                            transformer.transform(new StreamSource((String)this.xml.elementAt(i)), new StreamResult(stubRes[i]));
                            this.stubsAndTies.addElement(stubRes[i]);
                            ++i;
                        }
                    }
                    i = count;
                    while (i < this.xml.size()) {
                        String name = (String)this.remoteObjects.elementAt(i - count);
                        temp[i] = unL + name.substring(name.lastIndexOf(dot) + 1) + strings[0];
                        stubRes[i] = this.makeFile(temp[i], name);
                        Transformer transformer = this.factory.newTransformer(new StreamSource(this.getClass().getClassLoader().getResourceAsStream(this.inXSLStub)));
                        transformer.transform(new StreamSource((String)this.xml.elementAt(i)), new StreamResult(stubRes[i]));
                        this.stubsAndTies.addElement(stubRes[i]);
                        ++i;
                    }
                }
                Transformer transformer = this.factory.newTransformer(new StreamSource(this.getClass().getClassLoader().getResourceAsStream(this.inXSLStub)));
                transformer.transform(new StreamSource((String)this.xml.elementAt(0)), new StreamResult(stubRes[0]));
                this.stubsAndTies.addElement(stubRes[0]);
            }
            catch (Exception ex) {
                Logger.traceError("StubTieGenerator.generateStubs()", "Error during parsing XML file. Cannot generate stub file." + Logger.exceptionTrace(ex));
            }
        }
    }

    public void generateTie() {
        try {
            if (this.xml.size() > 0) {
                String temp = unL + this.className.substring(this.className.lastIndexOf(dot) + 1) + strings[1];
                String tieRes = this.makeFile(temp, this.className);
                Transformer transformer = this.factory.newTransformer(new StreamSource(this.getClass().getClassLoader().getResourceAsStream(this.inXSLTie)));
                transformer.transform(new StreamSource((String)this.xml.elementAt(0)), new StreamResult(tieRes));
                this.stubsAndTies.addElement(tieRes);
            }
        }
        catch (Exception ex) {
            Logger.traceError("StubTieGenerator.generateTie()", "Error during parsing XML file. Cannot generate tie file." + Logger.exceptionTrace(ex));
        }
    }

    public Vector generateXML(String clsName) {
        Vector<String> xmls;
        block20: {
            int interfLen = this.remoteInterfaces.length;
            this.interfaces = new String[interfLen];
            xmls = new Vector<String>();
            try {
                if (this.remoteInterfaces != null) {
                    if (interfLen > 1) {
                        int k = 0;
                        while (k < interfLen) {
                            this.interfaces[k] = this.remoteInterfaces[k].getName();
                            ++k;
                        }
                        String temp = clsName.substring(clsName.lastIndexOf(dot) + 1) + strings[2];
                        String xmlFile = this.makeFile(temp, clsName);
                        xmls.addElement(xmlFile);
                        int c = 1;
                        while (c < interfLen + 1) {
                            temp = this.interfaces[c - 1].substring(this.interfaces[c - 1].lastIndexOf(dot) + 1) + strings[2];
                            xmlFile = this.makeFile(temp, this.interfaces[c - 1]);
                            xmls.addElement(xmlFile);
                            ++c;
                        }
                        DescriptorWriter[] dw = new DescriptorWriter[interfLen];
                        ClassDescriptor[] cd = new ClassDescriptor[interfLen];
                        ClassDescriptorDocument[] cdd = new ClassDescriptorDocument[interfLen];
                        int k2 = 0;
                        while (k2 < interfLen) {
                            dw[k2] = new DescriptorWriter(this.remoteInterfaces[k2], this.access);
                            cd[k2] = dw[k2].setClassToDescriptor();
                            cdd[k2] = new ClassDescriptorDocument(cd[k2]);
                            cdd[k2].writeDTDtoFile((String)xmls.elementAt(k2 + 1));
                            ++k2;
                        }
                    } else if (interfLen == 1) {
                        this.interfaces[0] = this.remoteInterfaces[0].getName();
                        String temp = this.className.substring(this.className.lastIndexOf(dot) + 1) + strings[2];
                        String xmlFile = this.makeFile(temp, this.className);
                        xmls.addElement(xmlFile);
                    } else {
                        return new Vector();
                    }
                    ClassDescriptor cd = this.descriptor.setClassToDescriptor();
                    ClassDescriptorDocument cdd = new ClassDescriptorDocument(cd);
                    cdd.writeDTDtoFile((String)xmls.elementAt(0));
                    if (this.generateAdditional) {
                        this.remoteObjects = new Vector();
                        String methName = "";
                        Enumeration en = this.remoteMethods.keys();
                        while (en.hasMoreElements()) {
                            methName = (String)en.nextElement();
                            Method method = (Method)this.remoteMethods.get(methName);
                            Class<?>[] param = method.getParameterTypes();
                            Class<?> retType = method.getReturnType();
                            String type = retType.getName();
                            if ((class$java$rmi$Remote == null ? StubTieGenerator.class$("java.rmi.Remote") : class$java$rmi$Remote) != retType && (class$java$rmi$Remote == null ? StubTieGenerator.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(retType) && !this.remoteObjects.contains(type)) {
                                this.remoteObjects.addElement(type);
                            }
                            int j = 0;
                            while (j < param.length) {
                                String var = param[j].getName();
                                if ((class$java$rmi$Remote == null ? StubTieGenerator.class$("java.rmi.Remote") : class$java$rmi$Remote) != param[j] && (class$java$rmi$Remote == null ? StubTieGenerator.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(param[j]) && !this.remoteObjects.contains(var)) {
                                    this.remoteObjects.addElement(var);
                                }
                                ++j;
                            }
                        }
                        int objSize = this.remoteObjects.size();
                        if (objSize > 0) {
                            int j = 0;
                            while (j < objSize) {
                                String name = (String)this.remoteObjects.elementAt(j);
                                String temp = name.substring(name.lastIndexOf(dot) + 1) + strings[2];
                                String xmlFile = this.makeFile(temp, name);
                                xmls.addElement(xmlFile);
                                ++j;
                            }
                            DescriptorWriter[] dw = new DescriptorWriter[objSize];
                            ClassDescriptor[] classd = new ClassDescriptor[objSize];
                            ClassDescriptorDocument[] classdd = new ClassDescriptorDocument[objSize];
                            int k = 0;
                            while (k < objSize) {
                                dw[k] = new DescriptorWriter(Class.forName((String)this.remoteObjects.elementAt(k)), this.access);
                                classd[k] = dw[k].setClassToDescriptor();
                                classdd[k] = new ClassDescriptorDocument(classd[k]);
                                if (interfLen == 1) {
                                    classdd[k].writeDTDtoFile((String)xmls.elementAt(1 + k));
                                } else {
                                    classdd[k].writeDTDtoFile((String)xmls.elementAt(interfLen + 1 + k));
                                }
                                ++k;
                            }
                        }
                    }
                    break block20;
                }
                return new Vector();
            }
            catch (Exception e) {
                Logger.traceError("StubTieGenerator.generateXML(String)", "Needed XML file, but it cannot be generated." + Logger.exceptionTrace(e));
            }
        }
        return xmls;
    }

    private String replace(String s, String s1, String s2) {
        StringBuffer buffer = new StringBuffer(s);
        int i = s.indexOf(s1);
        while (i != -1) {
            buffer.replace(i, s1.length() + s.indexOf(s1), s2);
            s = buffer.toString();
            i = s.indexOf(s1);
        }
        return s;
    }

    public void removeXmlFiles() {
        int k = 0;
        while (k < this.xml.size()) {
            File f = new File((String)this.xml.elementAt(k));
            f.delete();
            this.xml.removeElementAt(k--);
            ++k;
        }
    }

    private String makeFile(String fileName, String className) {
        StringBuffer buffer = new StringBuffer(this.workDir);
        buffer.append(File.separator);
        if (className.indexOf(dot) != -1) {
            buffer.append(this.replace(className.substring(0, className.lastIndexOf(dot)), dot, File.separator));
        }
        buffer.append(File.separator);
        buffer.append(fileName);
        String fileRes = buffer.toString();
        File file = new File(fileRes);
        file.getParentFile().mkdirs();
        return fileRes;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

