/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.server.generator;

import com.sap.engine.services.iiop.internal.util.RepositoryID;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.engine.services.iiop.server.generator.ClassDescriptor;
import com.sap.engine.services.iiop.server.generator.ClassDescriptorField;
import com.sap.engine.services.iiop.server.generator.ClassDescriptorMethod;
import com.sap.engine.services.iiop.server.generator.ClassDescriptorMethodException;
import com.sap.engine.services.iiop.server.generator.ClassDescriptorMethodParameter;
import com.sap.engine.services.iiop.server.generator.ClassDescriptorReturnType;
import com.sap.engine.services.iiop.server.generator.ExceptionHandler;
import com.sap.engine.services.iiop.server.generator.IDLNames;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;

public class DescriptorWriter {
    private ClassDescriptor descriptor;
    private Class remoteClass;
    private Class[] remoteInterfaces;
    private Hashtable remoteMethods = new Hashtable();
    private String name;
    private String methodName;
    private String[] rmiRepositoryID;
    private String[] superInterfaces;
    private ClassDescriptorField[] field;
    private ClassDescriptorMethod[] method;
    private ClassDescriptorMethodParameter[] parameter;
    private ClassDescriptorMethodException[] exception;
    private ClassDescriptorReturnType returnType;
    private Class parent;
    private Class[] interfaces;
    private Method[] methods;
    private Class[] exceptions;
    private ExceptionHandler exHandler;
    private Class[] parameters;
    private Field[] fields;
    private final String yes = "Yes";
    private final String no = "No";
    private boolean interfaceFlag;
    private Hashtable access;
    private Method[] innerMethods;
    private ClassDescriptorMethod[] innerMethod;
    private ValueHandler vh;
    static /* synthetic */ Class class$javax$rmi$PortableRemoteObject;
    static /* synthetic */ Class class$java$rmi$RemoteException;
    static /* synthetic */ Class class$org$omg$CORBA$Object;
    static /* synthetic */ Class class$java$rmi$Remote;

    public DescriptorWriter(Class _class, Hashtable access) throws IOException {
        this.remoteClass = _class;
        if ((class$javax$rmi$PortableRemoteObject == null ? (class$javax$rmi$PortableRemoteObject = DescriptorWriter.class$("javax.rmi.PortableRemoteObject")) : class$javax$rmi$PortableRemoteObject).isAssignableFrom(this.remoteClass)) {
            // empty if block
        }
        this.access = access;
        this.remoteMethods = new Hashtable();
        Vector tempInterfaces = new Vector();
        this.getRemoteInterfaces(this.remoteClass, tempInterfaces);
        this.getRemoteMethods(tempInterfaces, this.remoteMethods);
        if (tempInterfaces.size() > 0) {
            this.remoteInterfaces = new Class[tempInterfaces.size()];
            tempInterfaces.copyInto(this.remoteInterfaces);
        } else {
            this.remoteInterfaces = new Class[0];
        }
        this.exHandler = new ExceptionHandler();
        this.descriptor = new ClassDescriptor();
    }

    public ClassDescriptor setClassToDescriptor() {
        try {
            this.name = this.remoteClass.getName();
            if (this.name.indexOf(".") != -1) {
                this.descriptor.setName(this.name.substring(this.name.lastIndexOf(".") + 1));
                this.descriptor.setPackage(this.name.substring(0, this.name.lastIndexOf(".")));
            } else {
                this.descriptor.setName(this.name);
            }
            this.parent = this.remoteClass.getSuperclass();
            if (this.parent != null) {
                this.descriptor.setSuperClass(this.parent.getName());
            }
            this.interfaces = this.remoteInterfaces;
            if (this.interfaces != null) {
                this.superInterfaces = new String[this.interfaces.length];
                int k = 0;
                while (k < this.interfaces.length) {
                    this.superInterfaces[k] = this.interfaces[k].getName();
                    ++k;
                }
                this.descriptor.setSuperInterface(this.superInterfaces);
            }
            int modifierClass = this.remoteClass.getModifiers();
            Modifier modifier = new Modifier();
            String modStr = Modifier.toString(modifierClass);
            if (Modifier.isPublic(modifierClass)) {
                this.descriptor.setAccessFlag("public");
            } else {
                this.descriptor.setAccessFlag(modStr);
            }
            if (Modifier.isAbstract(modifierClass)) {
                this.descriptor.setAttribute("abstract");
            }
            if (Modifier.isInterface(modifierClass)) {
                this.descriptor.setAttribute("interface");
                this.interfaceFlag = true;
            }
            if (!this.interfaceFlag) {
                this.descriptor.setAttribute("class");
            }
            if (this.interfaceFlag) {
                this.rmiRepositoryID = new String[1];
                if (this.vh == null) {
                    this.vh = Util.createValueHandler();
                }
                this.rmiRepositoryID[0] = this.vh.getRMIRepositoryID(this.remoteClass);
                this.descriptor.setRMIRepositoryID(this.rmiRepositoryID);
                this.descriptor.setForStubName(this.name.substring(this.name.lastIndexOf(".") + 1));
            } else {
                if (this.interfaces != null) {
                    String interfName = this.interfaces[0].getName();
                    if (interfName.indexOf(".") != -1) {
                        this.descriptor.setInterfacePackage(interfName.substring(0, interfName.lastIndexOf(".")));
                    }
                    if (this.interfaces.length == 1) {
                        this.rmiRepositoryID = new String[1];
                        if (this.vh == null) {
                            this.vh = Util.createValueHandler();
                        }
                        this.rmiRepositoryID[0] = this.vh.getRMIRepositoryID(this.interfaces[0]);
                        this.descriptor.setForStubName(this.superInterfaces[0].substring(this.superInterfaces[0].lastIndexOf(".") + 1));
                    } else {
                        this.rmiRepositoryID = new String[this.interfaces.length + 1];
                        if (this.vh == null) {
                            this.vh = Util.createValueHandler();
                        }
                        this.rmiRepositoryID[0] = this.vh.getRMIRepositoryID(this.remoteClass);
                        int k = 0;
                        while (k < this.interfaces.length) {
                            this.rmiRepositoryID[k + 1] = this.vh.getRMIRepositoryID(this.interfaces[k]);
                            ++k;
                        }
                        this.descriptor.setForStubName(this.name.substring(this.name.lastIndexOf(".") + 1));
                    }
                }
                this.descriptor.setRMIRepositoryID(this.rmiRepositoryID);
            }
            Integer resourceId = null;
            if (this.access != null) {
                resourceId = (Integer)this.access.get(this.remoteClass);
            }
            if (resourceId != null) {
                this.descriptor.setResourceId(resourceId.toString());
            }
            this.setMethods();
            this.setFields();
        }
        catch (Exception e) {
            Logger.traceError("DescriptorWriter.setClassToDescriptor()", "Error during setting remoteClass to descriptor. Reasons is: \n" + Logger.exceptionTrace(e));
        }
        return this.descriptor;
    }

    private void setMethods() {
        if (!this.interfaceFlag) {
            Enumeration metKeys = this.remoteMethods.keys();
            this.method = new ClassDescriptorMethod[this.remoteMethods.size()];
            this.methods = new Method[this.remoteMethods.size()];
            int k = 0;
            while (metKeys.hasMoreElements()) {
                this.methodName = (String)metKeys.nextElement();
                this.methods[k] = (Method)this.remoteMethods.get(this.methodName);
                ++k;
            }
        } else {
            this.methods = this.remoteClass.getMethods();
            if (this.methods != null) {
                this.method = new ClassDescriptorMethod[this.methods.length];
            }
        }
        String[] idlNames = IDLNames.getIDLnames(this.methods);
        int count = 0;
        while (count < this.methods.length) {
            this.method[count] = new ClassDescriptorMethod();
            this.method[count].setName(this.methods[count].getName());
            this.method[count].setIDLname(idlNames[count]);
            int modifierMethod = this.methods[count].getModifiers();
            Modifier mod = new Modifier();
            String modifierStr = Modifier.toString(modifierMethod);
            if (Modifier.isPublic(modifierMethod)) {
                this.method[count].setAccessFlag("public");
            } else if (Modifier.isPrivate(modifierMethod)) {
                this.method[count].setAccessFlag("private");
            } else if (Modifier.isProtected(modifierMethod)) {
                this.method[count].setAccessFlag("protected");
            } else if (modifierStr != null) {
                this.method[count].setAttribute(modifierStr);
            }
            this.exceptions = this.exHandler.handler(this.methods[count].getExceptionTypes());
            if (this.exceptions != null) {
                this.exception = new ClassDescriptorMethodException[this.exceptions.length];
                int i = 0;
                while (i < this.exceptions.length) {
                    this.exception[i] = new ClassDescriptorMethodException();
                    this.exception[i].setName(this.exceptions[i].getName().replace('$', '.'));
                    if ((class$java$rmi$RemoteException == null ? DescriptorWriter.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(this.exceptions[i])) {
                        this.exception[i].setIsRemoteException("Yes");
                    } else {
                        this.exception[i].setIsRemoteException("No");
                    }
                    if (this.exceptions[i].getName() != "java.rmi.RemoteException") {
                        this.exception[i].setIDLRepID(this.replaceStr(new String(RepositoryID.getIDLRepositoryID(this.exceptions[i])), "$", "__"));
                    }
                    ++i;
                }
                this.method[count].setException(this.exception);
            }
            this.returnType = new ClassDescriptorReturnType();
            Class<?> type = this.methods[count].getReturnType();
            String rType = DescriptorWriter.signature(type);
            if (rType.equals("void")) {
                this.returnType.setIsReturnType("No");
            } else {
                this.returnType.setIsReturnType("Yes");
            }
            String clasname = type.getName();
            if (clasname.indexOf(".") != -1) {
                this.returnType.setForStubName(clasname.substring(clasname.lastIndexOf(".") + 1).replace('$', '.'));
            } else {
                this.returnType.setForStubName("NoStub");
            }
            this.returnType.setClassType(rType.replace('$', '.'));
            if (type.isInterface()) {
                this.returnType.setIsInterface("Yes");
            } else {
                this.returnType.setIsInterface("No");
            }
            if ((class$org$omg$CORBA$Object == null ? DescriptorWriter.class$("org.omg.CORBA.Object") : class$org$omg$CORBA$Object).isAssignableFrom(type)) {
                this.returnType.setToWriteAsObject("Yes");
            } else {
                this.returnType.setToWriteAsObject("No");
            }
            this.innerMethods = type.getMethods();
            this.innerMethod = new ClassDescriptorMethod[this.innerMethods.length];
            int c = 0;
            while (c < this.innerMethods.length) {
                this.innerMethod[c] = new ClassDescriptorMethod();
                this.innerMethod[c].setName(this.innerMethods[c].getName());
                Class[] exc = new Class[this.innerMethods[c].getExceptionTypes().length];
                exc = this.innerMethods[c].getExceptionTypes();
                int rr = 0;
                while (rr < exc.length) {
                    ++rr;
                }
                this.exceptions = this.exHandler.handler(this.innerMethods[c].getExceptionTypes());
                if (this.exceptions != null) {
                    this.exception = new ClassDescriptorMethodException[this.exceptions.length];
                    int k = 0;
                    while (k < this.exceptions.length) {
                        this.exception[k] = new ClassDescriptorMethodException();
                        this.exception[k].setName(this.exceptions[k].getName().replace('$', '.'));
                        if ((class$java$rmi$RemoteException == null ? DescriptorWriter.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(this.exceptions[k])) {
                            this.exception[k].setIsRemoteException("Yes");
                        } else {
                            this.exception[k].setIsRemoteException("No");
                        }
                        if (this.exceptions[k].getName() != "java.rmi.RemoteException") {
                            this.exception[k].setIDLRepID(this.replaceStr(new String(RepositoryID.getIDLRepositoryID(this.exceptions[k])), "$", "__"));
                        }
                        ++k;
                    }
                    this.innerMethod[c].setException(this.exception);
                }
                ++c;
            }
            this.returnType.setMethod(this.innerMethod);
            this.method[count].setReturnType(this.returnType);
            this.parameters = this.methods[count].getParameterTypes();
            if (this.parameters != null) {
                this.parameter = new ClassDescriptorMethodParameter[this.parameters.length];
                int i = 0;
                while (i < this.parameters.length) {
                    this.parameter[i] = new ClassDescriptorMethodParameter();
                    this.parameter[i].setType(DescriptorWriter.signature(this.parameters[i]).replace('$', '.'));
                    if (this.parameters[i].isInterface()) {
                        this.parameter[i].setInterface("Yes");
                    } else {
                        this.parameter[i].setInterface("No");
                    }
                    String classsname = this.parameters[i].getName();
                    if (classsname.indexOf(".") != -1) {
                        this.parameter[i].setForStubName(classsname.substring(classsname.lastIndexOf(".") + 1).replace('$', '.'));
                    } else {
                        this.parameter[i].setForStubName("NoStub");
                    }
                    if ((class$java$rmi$Remote == null ? DescriptorWriter.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(this.parameters[i])) {
                        this.parameter[i].setRemote("Yes");
                    } else {
                        this.parameter[i].setRemote("No");
                    }
                    if ((class$org$omg$CORBA$Object == null ? DescriptorWriter.class$("org.omg.CORBA.Object") : class$org$omg$CORBA$Object).isAssignableFrom(this.parameters[i])) {
                        this.parameter[i].setToWriteAsObject("Yes");
                    } else {
                        this.parameter[i].setToWriteAsObject("No");
                    }
                    this.innerMethods = this.parameters[i].getMethods();
                    this.innerMethod = new ClassDescriptorMethod[this.innerMethods.length];
                    int c2 = 0;
                    while (c2 < this.innerMethods.length) {
                        this.innerMethod[c2] = new ClassDescriptorMethod();
                        this.innerMethod[c2].setName(this.innerMethods[c2].getName());
                        this.exceptions = this.exHandler.handler(this.innerMethods[c2].getExceptionTypes());
                        if (this.exceptions != null) {
                            this.exception = new ClassDescriptorMethodException[this.exceptions.length];
                            int k = 0;
                            while (k < this.exceptions.length) {
                                this.exception[k] = new ClassDescriptorMethodException();
                                this.exception[k].setName(this.exceptions[k].getName().replace('$', '.'));
                                if ((class$java$rmi$RemoteException == null ? DescriptorWriter.class$("java.rmi.RemoteException") : class$java$rmi$RemoteException).isAssignableFrom(this.exceptions[k])) {
                                    this.exception[k].setIsRemoteException("Yes");
                                } else {
                                    this.exception[k].setIsRemoteException("No");
                                }
                                if (this.exceptions[k].getName() != "java.rmi.RemoteException") {
                                    this.exception[k].setIDLRepID(this.replaceStr(new String(RepositoryID.getIDLRepositoryID(this.exceptions[k])), "$", "__"));
                                }
                                ++k;
                            }
                            this.innerMethod[c2].setException(this.exception);
                        }
                        ++c2;
                    }
                    this.parameter[i].setMethod(this.innerMethod);
                    ++i;
                }
                this.method[count].setParameter(this.parameter);
            }
            if ((class$java$rmi$Remote == null ? DescriptorWriter.class$("java.rmi.Remote") : class$java$rmi$Remote).isAssignableFrom(type)) {
                this.method[count].setRemoteType("Yes");
            } else {
                this.method[count].setRemoteType("No");
            }
            ++count;
        }
        this.descriptor.setMethod(this.method);
    }

    private String replaceStr(String base, String old, String rep) {
        int i = base.indexOf(old);
        if (i != -1) {
            return base.substring(0, i - 1) + rep + base.substring(i + 1);
        }
        return base;
    }

    private void setFields() {
        this.fields = this.remoteClass.getFields();
        if (this.fields != null) {
            this.field = new ClassDescriptorField[this.fields.length];
            int count = 0;
            while (count < this.fields.length) {
                this.field[count] = new ClassDescriptorField();
                this.field[count].setName(this.fields[count].getName());
                int modifierField = this.fields[count].getModifiers();
                Modifier modif = new Modifier();
                String modifStr = Modifier.toString(modifierField);
                if (Modifier.isPublic(modifierField)) {
                    this.field[count].setAccessFlag("public");
                } else if (Modifier.isPrivate(modifierField)) {
                    this.field[count].setAccessFlag("private");
                } else if (Modifier.isProtected(modifierField)) {
                    this.field[count].setAccessFlag("protected");
                } else if (!modifStr.equals("")) {
                    this.field[count].setAttribute(modifStr);
                }
                String fieldType = DescriptorWriter.signature(this.fields[count].getType());
                this.field[count].setType(fieldType);
                ++count;
            }
            this.descriptor.setField(this.field);
        }
    }

    private void getRemoteInterfaces(Class _target, Vector interfaceBuffer) {
        if (_target != null) {
            this.getRemoteInterfaces(_target.getSuperclass(), interfaceBuffer);
            Class<?>[] temp_interfaces = _target.getInterfaces();
            int k = 0;
            while (k < temp_interfaces.length) {
                this.update(temp_interfaces[k], interfaceBuffer);
                ++k;
            }
        }
    }

    public void getRemoteMethods(Vector _target, Hashtable methodBuffer) {
        int k = 0;
        while (k < _target.size()) {
            Method[] methodi = ((Class)_target.elementAt(k)).getMethods();
            if (methodi != null) {
                int i = 0;
                while (i < methodi.length) {
                    if (!methodi[i].getName().startsWith("<clinit>")) {
                        String methodiName = methodi[i].toString();
                        methodiName = methodiName.substring(methodiName.indexOf(40), methodiName.lastIndexOf(41) + 1);
                        methodiName = methodi[i].getName() + methodiName;
                        if (!methodBuffer.contains(methodiName)) {
                            Method mm = null;
                            try {
                                mm = this.remoteClass.getMethod(methodi[i].getName(), methodi[i].getParameterTypes());
                            }
                            catch (Exception e) {
                                mm = methodi[i];
                            }
                            methodBuffer.put(methodiName, mm);
                        }
                    }
                    ++i;
                }
            }
            ++k;
        }
    }

    public Hashtable getRemoteMethods() {
        return this.remoteMethods;
    }

    public Class[] getRemoteInterfaces() {
        return this.remoteInterfaces;
    }

    public boolean update(Class _interface, Vector buffer) {
        if (!(class$java$rmi$Remote == null ? (class$java$rmi$Remote = DescriptorWriter.class$("java.rmi.Remote")) : class$java$rmi$Remote).isAssignableFrom(_interface)) {
            return false;
        }
        int i = 0;
        while (i < buffer.size()) {
            if (_interface.isAssignableFrom((Class)buffer.elementAt(i))) {
                return false;
            }
            if (((Class)buffer.elementAt(i)).isAssignableFrom(_interface)) {
                buffer.removeElementAt(i--);
            }
            ++i;
        }
        buffer.addElement(_interface);
        return true;
    }

    public static String signature(Class _class) {
        String type = _class.getName();
        int last = type.lastIndexOf(91);
        if (last < 0) {
            return type;
        }
        char descriptor = type.charAt(last + 1);
        type = type.substring(last + 1);
        String arrDimension = "[]";
        int i = 0;
        while (i < last) {
            arrDimension = arrDimension + "[]";
            ++i;
        }
        switch (descriptor) {
            case 'B': {
                type = "byte" + arrDimension;
                break;
            }
            case 'C': {
                type = "char" + arrDimension;
                break;
            }
            case 'D': {
                type = "double" + arrDimension;
                break;
            }
            case 'F': {
                type = "float" + arrDimension;
                break;
            }
            case 'I': {
                type = "int" + arrDimension;
                break;
            }
            case 'J': {
                type = "long" + arrDimension;
                break;
            }
            case 'S': {
                type = "short" + arrDimension;
                break;
            }
            case 'Z': {
                type = "boolean" + arrDimension;
                break;
            }
            case 'L': {
                type = type.substring(1, type.length() - 1) + arrDimension;
            }
        }
        return type;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

