/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.server;

import com.sap.engine.interfaces.cross.ProviderContainer;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.engine.services.iiop.server.generator.StubTieGenerator;
import java.util.Hashtable;
import java.util.Vector;

public class IIOPGenerator {
    public ProviderContainer generateSupport(Class[] objects, Class[] interfaces, Hashtable access, String workDir) {
        return this.generateSupport(objects, interfaces, access, workDir, false);
    }

    public ProviderContainer generateSupport(Class[] objects, Class[] interfaces, Hashtable access, String workDir, boolean applyExecutionContext) {
        Vector<String> vAll = new Vector<String>();
        Vector temp = null;
        Vector<String> client = new Vector<String>();
        int i = 0;
        while (i < objects.length) {
            try {
                StubTieGenerator generator = new StubTieGenerator(objects[i], workDir, access, false);
                temp = generator.generate();
                int size = temp.size();
                int j = 0;
                while (j < size) {
                    String tmp = (String)temp.elementAt(j);
                    String generated = tmp.substring(workDir.length() + 1, tmp.lastIndexOf(46));
                    vAll.addElement(generated);
                    if (generated.endsWith("_Stub")) {
                        client.addElement(generated);
                    }
                    ++j;
                }
                Logger.traceDebug("IIOPGenerator.generateSupport(Class[], Class[], Hashtable, String, boolean)", "Generate support finishted succesfully");
            }
            catch (Exception ex) {
                Logger.traceError("IIOPGenerator.generateSupport(Class[], Class[], Hashtable, String, boolean)", "Error when generating support" + Logger.exceptionTrace(ex));
            }
            ++i;
        }
        Object[] serverSupport = new String[vAll.size()];
        vAll.copyInto(serverSupport);
        Object[] clientSupport = new String[client.size()];
        client.copyInto(clientSupport);
        return new ProviderContainer((String[])serverSupport, (String[])clientSupport, workDir);
    }
}

