/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.ApplicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.ServiceRuntimeException;
import com.sap.engine.frame.container.event.ContainerEventListener;
import com.sap.engine.frame.core.thread.ThreadSystem;
import com.sap.engine.frame.state.ManagementInterface;
import com.sap.engine.interfaces.cross.CrossInterface;
import com.sap.engine.interfaces.security.SecurityContext;
import com.sap.engine.lib.security.CSI.CSIAppConfigurationEntry;
import com.sap.engine.services.iiop.csiv2.EJBIORGenerator;
import com.sap.engine.services.iiop.internal.ORB;
import com.sap.engine.services.iiop.internal.giop.ConnectionParser;
import com.sap.engine.services.iiop.logging.EngineLogger;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.engine.services.iiop.server.CommunicationLayerImpl;
import com.sap.engine.services.iiop.server.IIOPManagement;
import com.sap.engine.services.iiop.system.CommunicationLayer;
import com.sap.engine.system.ORBSingletonProxy;
import com.sap.tc.logging.Location;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;
import javax.security.auth.login.AppConfigurationEntry;

public class CorbaServiceFrame
implements ApplicationServiceFrame,
ContainerEventListener {
    private ORB orb = null;
    private ApplicationServiceContext appContext;
    private CommunicationLayerImpl layer;
    private boolean waitAppCtx = false;
    private ManagementInterface manInterface;
    private static Properties defaultProperties = null;
    private static int tempId;
    private static SecurityContext basicContext;
    private static SecurityContext iiopContext;
    private static ThreadSystem threadSystem;

    public void start(ApplicationServiceContext appContext) throws ServiceException {
        this.appContext = appContext;
        Logger.logLocation = Location.getLocation((String)this.getClass().getPackage().getName());
        Logger.theLogger = new EngineLogger();
        threadSystem = appContext.getCoreContext().getThreadSystem();
        tempId = appContext.getClusterContext().getClusterMonitor().getCurrentParticipant().getClusterId();
        CommunicationLayerImpl.setContext(appContext);
        org.omg.CORBA.ORB orbProxy = org.omg.CORBA.ORB.init();
        this.orb = new ORB();
        if (!this.orb.initExecutionContext(appContext)) {
            this.waitAppCtx = true;
        }
        ((ORBSingletonProxy)orbProxy).set_delegate((org.omg.CORBA.ORB)this.orb);
        this.orb.set_(new String[0], CorbaServiceFrame.getDefaultProperties());
        ConnectionParser.orb = this.orb;
        this.layer = (CommunicationLayerImpl)CommunicationLayer.init("com.sap.engine.services.iiop.server.CommunicationLayerImpl", this.orb);
        EJBIORGenerator iorGen = new EJBIORGenerator((org.omg.CORBA.ORB)this.orb);
        appContext.getContainerContext().getObjectRegistry().registerInterfaceProvider("csiv2", iorGen);
        try {
            this.layer.setEJBIORGenerator(iorGen);
        }
        catch (Exception e) {
            Logger.traceWarning("CorbaServiceFrame.start()", e.getMessage());
        }
        int mask = 64;
        HashSet<String> names = new HashSet<String>(3);
        names.add("cross");
        names.add("appcontext");
        names.add("security");
        appContext.getServiceState().registerContainerEventListener(mask, names, this);
        this.manInterface = new IIOPManagement();
        appContext.getServiceState().registerManagementInterface(this.manInterface);
    }

    public void stop() throws ServiceRuntimeException {
        if (iiopContext != null) {
            basicContext.unregisterPolicyConfiguration("service.iiop");
        }
        this.appContext.getServiceState().unregisterManagementInterface();
        this.appContext.getServiceState().unregisterContainerEventListener();
        this.appContext.getContainerContext().getObjectRegistry().unregisterInterfaceProvider("csiv2");
        this.layer.stop();
        this.layer = null;
        org.omg.CORBA.ORB orbProxy = org.omg.CORBA.ORB.init();
        try {
            orbProxy.shutdown(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        ((ORBSingletonProxy)orbProxy).set_delegate(null);
        this.orb.dropdown();
        this.orb = null;
        basicContext = null;
        iiopContext = null;
        threadSystem = null;
        defaultProperties = null;
    }

    public boolean changeProperties(Properties properties) throws IllegalArgumentException {
        return true;
    }

    public ApplicationServiceContext getServiceContext() {
        return this.appContext;
    }

    public static int getClusterId() {
        return tempId;
    }

    public static Properties getDefaultProperties() {
        if (defaultProperties == null) {
            defaultProperties = new Properties();
            ((Hashtable)defaultProperties).put("org.omg.CORBA.ORBClass", "com.sap.engine.services.iiop.internal.ORB");
            ((Hashtable)defaultProperties).put("CommunicationLayerClass", "com.sap.engine.services.iiop.server.CommunicationLayerImpl");
        }
        return defaultProperties;
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals("cross")) {
            this.layer.registerProvider((CrossInterface)interfaceImpl);
        } else if (this.waitAppCtx && interfaceName.equals("appcontext")) {
            this.orb.initExecutionContext(this.appContext);
            this.waitAppCtx = false;
        } else if (interfaceName.equals("security")) {
            basicContext = (SecurityContext)interfaceImpl;
            try {
                iiopContext = basicContext.getPolicyConfigurationContext("service.iiop");
                if (iiopContext == null) {
                    basicContext.registerPolicyConfiguration("service.iiop");
                    iiopContext = basicContext.getPolicyConfigurationContext("service.iiop");
                    iiopContext.getAuthenticationContext().setLoginModules(new AppConfigurationEntry[]{new CSIAppConfigurationEntry()});
                }
            }
            catch (Exception e) {
                Logger.traceWarning("CorbaServiceFrame.interfaceAvailable()", e.getMessage());
            }
        }
    }

    public void interfaceNotAvailable(String interfaceName) {
    }

    public void markForShutdown(long timeout) {
    }

    public void containerStarted() {
    }

    public void beginContainerStop() {
    }

    public void serviceStarted(String serviceName, Object serviceInterface) {
    }

    public void serviceNotStarted(String serviceName) {
    }

    public void beginServiceStop(String serviceName) {
    }

    public void serviceStopped(String serviceName) {
    }

    public boolean setServiceProperty(String key, String value) {
        return false;
    }

    public boolean setServiceProperties(Properties serviceProperties) {
        return false;
    }

    public static SecurityContext getSecurityBasicContext() {
        return basicContext;
    }

    public static SecurityContext getSecurityIIOPContext() {
        return iiopContext;
    }

    public static ThreadSystem getThreadSystem() {
        return threadSystem;
    }

    public ManagementInterface getManagementInterface() {
        return this.manInterface;
    }

    static {
        basicContext = null;
        iiopContext = null;
        threadSystem = null;
    }
}

