/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.server;

import com.sap.engine.frame.ApplicationServiceContext;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.ClusterException;
import com.sap.engine.frame.cluster.event.ServiceEventListener;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.cluster.message.MultipleAnswer;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.cluster.session.ApplicationSessionContext;
import com.sap.engine.frame.cluster.session.ApplicationSessionProcessor;
import com.sap.engine.interfaces.cross.CrossInterface;
import com.sap.engine.interfaces.csiv2.SimpleProfileInterface;
import com.sap.engine.lib.io.ObjectSerializer;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.lib.lang.ConvertTools;
import com.sap.engine.lib.util.ConcurrentHashMapIntObject;
import com.sap.engine.lib.util.ConcurrentHashMapLongObject;
import com.sap.engine.services.iiop.CORBA.IOR;
import com.sap.engine.services.iiop.CORBA.Profile;
import com.sap.engine.services.iiop.CORBA.portable.CORBAInputStream;
import com.sap.engine.services.iiop.core.MessageConstants;
import com.sap.engine.services.iiop.csiv2.CSIIOP.CompoundSecMech;
import com.sap.engine.services.iiop.csiv2.CSIIOP.CompoundSecMechListHelper;
import com.sap.engine.services.iiop.csiv2.CSIIOP.SSL;
import com.sap.engine.services.iiop.csiv2.CSIIOP.SSLHelper;
import com.sap.engine.services.iiop.csiv2.CSIIOP.TLS_SEC_TRANS;
import com.sap.engine.services.iiop.csiv2.CSIIOP.TLS_SEC_TRANSHelper;
import com.sap.engine.services.iiop.csiv2.CSIIOP.TransportAddress;
import com.sap.engine.services.iiop.csiv2.EJBIORGenerator;
import com.sap.engine.services.iiop.internal.giop.ConnectionParser;
import com.sap.engine.services.iiop.internal.giop.OutgoingMessage;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.engine.services.iiop.server.IIOPProvider;
import com.sap.engine.services.iiop.server.portable.Delegate;
import com.sap.engine.services.iiop.server.portable.Delegate_1_0;
import com.sap.engine.services.iiop.server.portable.Delegate_1_1;
import com.sap.engine.services.iiop.server.portable.Delegate_1_2;
import com.sap.engine.services.iiop.system.CommunicationLayer;
import java.io.IOException;
import java.util.Vector;
import org.omg.CORBA.COMM_FAILURE;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;

public class CommunicationLayerImpl
extends CommunicationLayer
implements ApplicationSessionProcessor,
MessageConstants,
MessageListener,
ServiceEventListener {
    private static ApplicationServiceContext context;
    private MessageContext messageContext;
    private ApplicationSessionContext sessionContext;
    private CrossInterface crossInterface;
    private String[] urls = null;
    private String[] sslUrls = null;
    public ConcurrentHashMapIntObject clusterElements = new ConcurrentHashMapIntObject();
    public ConcurrentHashMapIntObject clusterSSLElements = new ConcurrentHashMapIntObject();
    public ConvertTools ct = new ConvertTools(false);
    private static Object so;
    private ClusterMonitor monitor;
    private ConcurrentHashMapLongObject connections = new ConcurrentHashMapLongObject();
    private static IIOPProvider broker;
    private Vector profileList;
    private EJBIORGenerator ejbIORGenerator = null;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public CommunicationLayerImpl() {
        Object object = so;
        synchronized (object) {
            while (context == null) {
                try {
                    so.wait();
                }
                catch (InterruptedException e) {
                    Logger.traceError("CommunicationLayerImpl.CommunicationLayerImpl()", Logger.exceptionTrace(e));
                }
            }
        }
        this.messageContext = context.getClusterContext().getMessageContext();
        this.sessionContext = context.getClusterContext().getApplicationSessionContext();
        this.monitor = context.getClusterContext().getClusterMonitor();
        try {
            this.sessionContext.registerProcessor(this);
        }
        catch (ListenerAlreadyRegisteredException e) {
            Logger.traceError("CommunicationLayerImpl.CommunicationLayerImpl()", Logger.exceptionTrace((Throwable)((Object)e)));
        }
        try {
            this.messageContext.registerListener(this);
        }
        catch (Exception ex) {
            Logger.traceError("CommunicationLayerImpl.CommunicationLayerImpl()", Logger.exceptionTrace(ex));
        }
        try {
            context.getServiceState().registerServiceEventListener(this);
        }
        catch (Exception ex) {
            Logger.traceError("CommunicationLayerImpl.CommunicationLayerImpl()", Logger.exceptionTrace(ex));
        }
        ClusterElement[] elements = this.monitor.getServiceNodes();
        this.getClusterURLs(elements);
        this.getClusterSSL_URLs(elements);
        this.setProfileURL();
    }

    protected static void setContext(ApplicationServiceContext ctx) {
        context = ctx;
        Object object = so;
        synchronized (object) {
            so.notifyAll();
        }
    }

    protected void registerProvider(CrossInterface crossInterface) {
        this.crossInterface = crossInterface;
        if (broker == null) {
            broker = new IIOPProvider(context);
        }
        crossInterface.registerProtocolProvider(broker);
    }

    protected void stop() {
        if (broker != null) {
            this.crossInterface.unregisterProtocolProvider(broker.getName());
            broker = null;
        }
        so = new Object();
        context.getServiceState().unregisterServiceEventListener();
        try {
            this.messageContext.unregisterListener();
        }
        catch (Exception ex) {
            Logger.traceError("CommunicationLayerImpl.stop()", Logger.exceptionTrace(ex));
        }
        this.sessionContext.unregisterProcessor();
        CommunicationLayer.thisLayer = null;
        context = null;
        this.urls = null;
        this.sslUrls = null;
    }

    protected static void removeContext() {
        context = null;
    }

    public String[] getURL() {
        return (String[])this.urls.clone();
    }

    public void getRequestPart(int containerId, int connId) {
    }

    public long calculateKey(int int1, int int2) {
        long result = int1;
        result <<= 32;
        return result |= (long)int2;
    }

    public void request(int serverId, int clientId, byte[] request, int offset, int length) {
        ConnectionParser parser;
        long key = this.calculateKey(serverId, clientId);
        if (this.connections.containsKey(key)) {
            parser = (ConnectionParser)this.connections.get(key);
            if (parser.toRemove()) {
                this.connections.remove(key);
                parser = new ConnectionParser();
                this.connections.put(key, parser);
            }
        } else {
            parser = new ConnectionParser();
            this.connections.put(key, parser);
        }
        byte[] req = new byte[length];
        System.arraycopy(request, offset, req, 0, length);
        OutgoingMessage outMessage = parser.readMessage(req);
        if (outMessage.forSend()) {
            this.send(outMessage.toByteArray_forSend(), 0, outMessage.byteArray_forSend_length(), clientId, serverId);
        }
    }

    public void send(byte[] request, int clientId, int serverId) {
        this.send(request, 0, request.length, clientId, serverId);
    }

    public void send(byte[] request, int pos, int len, int clientId, int serverId) {
        try {
            this.sessionContext.getConnection().send(serverId, clientId, request, pos, len);
        }
        catch (ClusterException e) {
            Logger.logError("Communication failure !!! " + Logger.exceptionTrace((Throwable)((Object)e)));
            Logger.traceError("CommunicationLayerImpl.send(byte[], int, int, int, int)", Logger.exceptionTrace((Throwable)((Object)e)));
        }
    }

    public void getClusterURLs(ClusterElement[] elements) {
        try {
            String[] buffArr = null;
            int urlCnt = 0;
            MultipleAnswer mAnswer = this.messageContext.sendAndWaitForAnswer(this.monitor.getCurrentParticipant().getGroupId(), (byte)1, 20, new byte[0], 0, 0, 0L);
            int[] participants = mAnswer.participants();
            Vector<String[]> tempURLs = new Vector<String[]>();
            int i = 0;
            while (i < participants.length) {
                int clusterId = participants[i];
                MessageAnswer answer = mAnswer.getAnswer(clusterId);
                byte[] a = new byte[answer.getLength()];
                System.arraycopy(answer.getMessage(), answer.getOffset(), a, 0, a.length);
                String[] tempURL = (String[])ObjectSerializer.getObject(a);
                tempURLs.addElement(tempURL);
                this.clusterElements.put(clusterId, tempURL);
                urlCnt += tempURL.length;
                ++i;
            }
            int pos = 0;
            if (this.urls != null) {
                buffArr = new String[this.urls.length + urlCnt];
                System.arraycopy(this.urls, 0, buffArr, 0, this.urls.length);
                pos = this.urls.length;
            } else {
                buffArr = new String[urlCnt];
            }
            int i2 = 0;
            while (i2 < tempURLs.size()) {
                String[] tempURL = (String[])tempURLs.elementAt(i2);
                System.arraycopy(tempURL, 0, buffArr, pos, tempURL.length);
                pos += tempURL.length;
                ++i2;
            }
            this.urls = buffArr;
            if (this.listener != null) {
                this.listener.addedURLs(this.urls);
            }
        }
        catch (Exception ex) {
            Logger.traceError("CommunicationLayerImpl.getClusterURLs(ClusterElement[])", "Error collecting URL from all dispatchers in the cluster" + Logger.exceptionTrace(ex));
        }
    }

    public void getClusterSSL_URLs(ClusterElement[] elements) {
        try {
            String[] buffArr = null;
            int urlCnt = 0;
            MultipleAnswer mAnswer = this.messageContext.sendAndWaitForAnswer(this.monitor.getCurrentParticipant().getGroupId(), (byte)1, 25, new byte[0], 0, 0, 0L);
            int[] participants = mAnswer.participants();
            Vector<String[]> tempURLs = new Vector<String[]>();
            int i = 0;
            while (i < participants.length) {
                int clusterId = participants[i];
                MessageAnswer answer = mAnswer.getAnswer(clusterId);
                byte[] a = new byte[answer.getLength()];
                System.arraycopy(answer.getMessage(), answer.getOffset(), a, 0, a.length);
                String[] tempURL = (String[])ObjectSerializer.getObject(a);
                tempURLs.addElement(tempURL);
                this.clusterSSLElements.put(clusterId, tempURL);
                urlCnt += tempURL.length;
                ++i;
            }
            int pos = 0;
            if (this.sslUrls != null) {
                buffArr = new String[this.sslUrls.length + urlCnt];
                System.arraycopy(this.sslUrls, 0, buffArr, 0, this.sslUrls.length);
                pos = this.sslUrls.length;
            } else {
                buffArr = new String[urlCnt];
            }
            int i2 = 0;
            while (i2 < tempURLs.size()) {
                String[] tempURL = (String[])tempURLs.elementAt(i2);
                System.arraycopy(tempURL, 0, buffArr, pos, tempURL.length);
                pos += tempURL.length;
                ++i2;
            }
            this.sslUrls = buffArr;
        }
        catch (Exception ex) {
            Logger.traceError("CommunicationLayerImpl.getClusterSSL_URLs(ClusterElement[])", "Error collecting SSL URL from all dispatchers in the cluster" + Logger.exceptionTrace(ex));
        }
    }

    public void receive(int clusterId, int messageId, byte[] message, int off, int len) {
        switch (messageId) {
            case 55: {
                int clientId = Convert.byteArrToInt(message, off);
                Delegate.closeConnection(clientId, clusterId);
                long key = this.calculateKey(clusterId, clientId);
                if (this.connections.containsKey(key)) {
                    ((ConnectionParser)this.connections.get(key)).connectionLost();
                }
                this.connections.remove(key);
                break;
            }
        }
    }

    public MessageAnswer receiveWait(int clusterId, int messageId, byte[] message, int off, int len) {
        int clientId = Convert.byteArrToInt(message, off);
        long key = this.calculateKey(clusterId, clientId);
        this.connections.remove(key);
        return null;
    }

    public void serviceStarted(ClusterElement element) {
        try {
            int clusterId = element.getClusterId();
            if (element.getType() == 2 || element.getGroupId() != this.monitor.getCurrentParticipant().getGroupId()) {
                return;
            }
            MessageAnswer answer = this.messageContext.sendAndWaitForAnswer(clusterId, 20, new byte[0], 0, 0, 3000L);
            byte[] a = new byte[answer.getLength()];
            System.arraycopy(answer.getMessage(), answer.getOffset(), a, 0, a.length);
            String[] newURLs = (String[])ObjectSerializer.getObject(a);
            this.clusterElements.put(clusterId, newURLs);
            CommunicationLayerImpl communicationLayerImpl = this;
            synchronized (communicationLayerImpl) {
                if (this.urls != null) {
                    String[] buffArr = new String[this.urls.length + newURLs.length];
                    System.arraycopy(this.urls, 0, buffArr, 0, this.urls.length);
                    System.arraycopy(newURLs, 0, buffArr, this.urls.length, newURLs.length);
                    this.urls = buffArr;
                } else {
                    this.urls = newURLs;
                }
            }
            if (this.listener != null) {
                this.listener.addedURLs(newURLs);
            }
            answer = this.messageContext.sendAndWaitForAnswer(clusterId, 25, new byte[0], 0, 0, 3000L);
            a = new byte[answer.getLength()];
            System.arraycopy(answer.getMessage(), answer.getOffset(), a, 0, a.length);
            newURLs = (String[])ObjectSerializer.getObject(a);
            this.clusterSSLElements.put(clusterId, newURLs);
            CommunicationLayerImpl communicationLayerImpl2 = this;
            synchronized (communicationLayerImpl2) {
                String[] buffArr = new String[this.sslUrls.length + newURLs.length];
                System.arraycopy(this.sslUrls, 0, buffArr, 0, this.sslUrls.length);
                System.arraycopy(newURLs, 0, buffArr, this.sslUrls.length, newURLs.length);
                this.sslUrls = buffArr;
                this.ejbIORGenerator.resetHostAndPort(this.getSSLAddress());
            }
            this.setProfileURL();
            if (this.crossInterface != null && broker == null) {
                broker = new IIOPProvider(context);
                this.crossInterface.registerProtocolProvider(broker);
            } else if (broker != null) {
                broker.sendInitilObjects(element.getClusterId());
            }
        }
        catch (Exception ex) {
            Logger.traceError("CommunicationLayerImpl.serviceStarted(ClusterElement)", Logger.exceptionTrace(ex));
        }
    }

    public void serviceStopped(ClusterElement element) {
        int clusterId = element.getClusterId();
        if (element.getType() == 1) {
            String[] oldURLs = (String[])this.clusterElements.get(clusterId);
            if (oldURLs == null) {
                return;
            }
            this.clusterElements.remove(clusterId);
            CommunicationLayerImpl communicationLayerImpl = this;
            synchronized (communicationLayerImpl) {
                String[] buffArr = new String[this.urls.length - oldURLs.length];
                Object[] a = this.clusterElements.getAllValues();
                int pos = 0;
                int i = 0;
                while (i < a.length) {
                    System.arraycopy(a[i], 0, buffArr, pos, ((String[])a[i]).length);
                    pos += ((String[])a[i]).length;
                    ++i;
                }
                this.urls = buffArr;
            }
            if (this.listener != null) {
                this.listener.removedURLs(oldURLs);
            }
            String[] oldSSLUrls = (String[])this.clusterSSLElements.get(clusterId);
            this.clusterSSLElements.remove(clusterId);
            if (oldSSLUrls != null) {
                CommunicationLayerImpl communicationLayerImpl2 = this;
                synchronized (communicationLayerImpl2) {
                    String[] buffArr = new String[this.sslUrls.length - oldSSLUrls.length];
                    Object[] a = this.clusterSSLElements.getAllValues();
                    int pos = 0;
                    int i = 0;
                    while (i < a.length) {
                        System.arraycopy(a[i], 0, buffArr, pos, ((String[])a[i]).length);
                        pos += ((String[])a[i]).length;
                        ++i;
                    }
                    this.sslUrls = buffArr;
                    this.ejbIORGenerator.resetHostAndPort(this.getSSLAddress());
                }
            }
            Delegate.closeConnections(clusterId);
        }
    }

    public int[] retrieveConnAndDispID(byte[] host, int port, boolean useSSL) {
        int[] resultIDs = new int[2];
        byte[] _port = this.ct.intToArr(port);
        int[] IDs = this.clusterElements.getAllKeys();
        if (IDs.length == 0) {
            return null;
        }
        resultIDs[0] = IDs[0];
        MessageAnswer answer = null;
        byte[] info = new byte[_port.length + host.length];
        System.arraycopy(_port, 0, info, 0, _port.length);
        System.arraycopy(host, 0, info, 4, host.length);
        try {
            answer = useSSL ? this.messageContext.sendAndWaitForAnswer(IDs[0], 4011, info, 0, info.length, 0L) : this.messageContext.sendAndWaitForAnswer(IDs[0], 40, info, 0, info.length, 0L);
            if (answer.getLength() == 0) {
                throw new COMM_FAILURE("Could not connect to host and port " + new String(host, 0, host.length) + ":" + port + ", useSSL=" + useSSL + ".", 1398079490, CompletionStatus.COMPLETED_NO);
            }
            byte[] a = new byte[answer.getLength()];
            System.arraycopy(answer.getMessage(), answer.getOffset(), a, 0, a.length);
            resultIDs[1] = this.ct.arrToInt(a);
            return resultIDs;
        }
        catch (COMM_FAILURE ce) {
            throw ce;
        }
        catch (Exception e) {
            Logger.traceError("CommunicationLayerImpl.retrieveConnAndDispID(byte[], int, boolean)", Logger.exceptionTrace(e));
            return null;
        }
    }

    public org.omg.CORBA.portable.Delegate getDelegate(IOR ior) {
        int port;
        boolean useSSL;
        Profile prof = ior.getProfile();
        byte[] host = null;
        Logger.traceDebug("CommunicationLayerImpl.getDelegate(IOR)", "Request from " + prof.getHost() + " : " + prof.getPort());
        boolean bl = useSSL = prof.getPort() == 0;
        if (useSSL) {
            TransportAddress sslAddress = this.parseSSLTransportAddress(prof);
            host = sslAddress.host_name.getBytes();
            port = sslAddress.port;
        } else {
            host = prof.getHost().getBytes();
            port = prof.getPort();
        }
        int[] d_c_id = this.retrieveConnAndDispID(host, port, useSSL);
        if (d_c_id == null) {
            return null;
        }
        byte versionMinor = ior.getProfile().getVersionMinor();
        Delegate delegate = null;
        switch (versionMinor) {
            case 0: {
                delegate = new Delegate_1_0((ORB)CommunicationLayer.orb, ior);
                break;
            }
            case 1: {
                delegate = new Delegate_1_1((ORB)CommunicationLayer.orb, ior);
                break;
            }
            case 2: {
                delegate = new Delegate_1_2((ORB)CommunicationLayer.orb, ior);
                break;
            }
            default: {
                delegate = new Delegate_1_0((ORB)CommunicationLayer.orb, ior);
            }
        }
        delegate.setDispIDAndConnID(d_c_id[0], d_c_id[1]);
        delegate.sender = this;
        return delegate;
    }

    public void send(byte[] data, String tohost, int toport) throws IOException {
        this.send(data, 0, data.length, tohost, toport);
    }

    public void send(byte[] data, int pos, int len, String tohost, int toport) throws IOException {
        byte[] host = tohost.getBytes();
        byte[] port = this.ct.intToArr(toport);
        byte[] info = new byte[port.length + host.length];
        System.arraycopy(port, 0, info, 0, port.length);
        System.arraycopy(host, 0, info, 4, host.length);
        int connID = 0;
        int[] IDs = this.clusterElements.getAllKeys();
        Logger.traceDebug("CommunicationLayerImpl.send(byte[], int, int, String, int)", "Send reqeust to " + tohost + " : " + toport);
        if (IDs.length == 0) {
            throw new IOException("ID019153: Not available dispatcher");
        }
        try {
            MessageAnswer answer = this.messageContext.sendAndWaitForAnswer(IDs[0], 40, info, 0, info.length, 0L);
            byte[] a = new byte[answer.getLength()];
            if (a.length == 0) {
                throw new IOException();
            }
            System.arraycopy(answer.getMessage(), answer.getOffset(), a, 0, a.length);
            connID = this.ct.arrToInt(a);
            try {
                this.sessionContext.getConnection().send(IDs[0], connID, data, pos, len);
            }
            catch (ClusterException e) {
                Logger.logError("Communication error !!!");
                Logger.traceError("CommunicationLayerImpl.send(byte[], int, int, String, int)", Logger.exceptionTrace((Throwable)((Object)e)));
            }
        }
        catch (Exception e) {
            Logger.traceError("CommunicationLayerImpl.send(byte[], int, int, String, int)", Logger.exceptionTrace(e));
            throw new IOException(e.toString());
        }
    }

    public void send(byte[] data, String tohost, int toport, boolean usedSsl) throws IOException {
        if (!usedSsl) {
            this.send(data, tohost, toport);
        } else {
            byte[] host = tohost.getBytes();
            byte[] port = this.ct.intToArr(toport);
            byte[] info = new byte[port.length + host.length];
            System.arraycopy(port, 0, info, 0, port.length);
            System.arraycopy(host, 0, info, 4, host.length);
            int connID = 0;
            int[] IDs = this.clusterElements.getAllKeys();
            Logger.traceDebug("CommunicationLayerImpl.send(byte[], String, int, boolean)", "Send reqeust to " + tohost + " : " + toport);
            if (IDs.length == 0) {
                throw new IOException("ID019154: Not available dispatcher");
            }
            try {
                MessageAnswer answer = this.messageContext.sendAndWaitForAnswer(IDs[0], 4011, info, 0, info.length, 0L);
                byte[] a = new byte[answer.getLength()];
                if (a.length == 0) {
                    throw new IOException();
                }
                System.arraycopy(answer.getMessage(), answer.getOffset(), a, 0, a.length);
                connID = this.ct.arrToInt(a);
                try {
                    this.sessionContext.getConnection().send(IDs[0], connID, data, 0, data.length);
                }
                catch (ClusterException e) {
                    Logger.logError("Communication error !!!");
                    Logger.traceError("CommunicationLayerImpl.send(byte[], String, int, boolean)", Logger.exceptionTrace((Throwable)((Object)e)));
                }
            }
            catch (Exception e) {
                Logger.traceError("CommunicationLayerImpl.send(byte[], String, int, boolean)", Logger.exceptionTrace(e));
                throw new IOException(e.getMessage());
            }
        }
    }

    public void setProfileURL() {
        if (this.urls != null && this.urls.length > 0) {
            this.profileList = new Vector();
            String host = this.getURL()[0];
            int index = 0;
            int port = 0;
            if (host != null) {
                index = host.indexOf(58);
                port = Integer.parseInt(host.substring(index + 1));
                host = host.substring(1, index);
                this.profileList.add(new Profile(host, port));
            }
        }
    }

    public int openSSLServerSocket(int port) throws IOException {
        Vector sslAddress = this.getSSLAddress();
        if (sslAddress != null) {
            int sslPort = (Integer)sslAddress.elementAt(1);
            return sslPort;
        }
        return 0;
    }

    public static ApplicationServiceContext getServiceContext() {
        return context;
    }

    public TransportAddress parseSSLTransportAddress(Profile profile) {
        SimpleProfileInterface[] simpleProfiles = profile.getComponents();
        SimpleProfileInterface taggedComponent = null;
        int i = 0;
        while (i < simpleProfiles.length) {
            if (simpleProfiles[i].getTag() == 33) {
                taggedComponent = simpleProfiles[i];
                break;
            }
            if (simpleProfiles[i].getTag() == 20) {
                taggedComponent = simpleProfiles[i];
                break;
            }
            ++i;
        }
        if (taggedComponent == null) {
            return null;
        }
        if (taggedComponent.getTag() == 20) {
            byte[] taggedData = taggedComponent.getData();
            CORBAInputStream stream = new CORBAInputStream(taggedData);
            stream.setEndian(stream.read_boolean());
            SSL sslComp = SSLHelper.read((InputStream)stream);
            return new TransportAddress(profile.getHost(), sslComp.port);
        }
        byte[] taggedData = taggedComponent.getData();
        CORBAInputStream stream = new CORBAInputStream(taggedData);
        stream.setEndian(stream.read_boolean());
        CompoundSecMech[] list = CompoundSecMechListHelper.read((InputStream)stream).mechanism_list;
        if (list == null || list.length == 0) {
            return null;
        }
        SimpleProfileInterface transportMech = list[0].transport_mech;
        if (transportMech.getTag() == 34) {
            return null;
        }
        if (transportMech.getTag() == 36) {
            byte[] transportData = transportMech.getData();
            CORBAInputStream inputStream = new CORBAInputStream(transportData);
            boolean endian = inputStream.read_boolean();
            inputStream.setEndian(endian);
            TLS_SEC_TRANS transport = TLS_SEC_TRANSHelper.read((InputStream)inputStream);
            TransportAddress[] addresses = transport.addresses;
            if (addresses == null || addresses.length == 0) {
                return null;
            }
            return addresses[0];
        }
        return null;
    }

    public void setEJBIORGenerator(EJBIORGenerator ejbIORGenerator) {
        this.ejbIORGenerator = ejbIORGenerator;
        ejbIORGenerator.resetHostAndPort(this.getSSLAddress());
    }

    public Vector getSSLAddress() {
        if (this.sslUrls == null || this.sslUrls.length == 0) {
            return null;
        }
        String addr = this.sslUrls[0];
        int sslPort = 0;
        try {
            sslPort = new Integer(addr.substring(addr.indexOf(58) + 1));
        }
        catch (NumberFormatException nfe) {
            sslPort = 0;
        }
        if (sslPort == 0) {
            return null;
        }
        Vector<Object> sslAddress = new Vector<Object>();
        sslAddress.addElement(addr.substring(1, addr.indexOf(58)));
        sslAddress.addElement(new Integer(sslPort));
        return sslAddress;
    }

    static {
        so = new Object();
    }
}

