/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal.util;

import com.sap.engine.services.iiop.logging.Logger;
import java.io.Serializable;
import java.lang.reflect.Member;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.NoSuchElementException;

public class RepositoryIDCacheTable
implements Serializable {
    static final long serialVersionUID = -7680494716778716331L;
    public CompareByName comparator = new CompareByName();
    private transient TableEntry[] table;
    private transient int count;
    private static final short KEY = 1;
    private static final int PERCENT_FOR_MEMORY_LEVEL = 20;
    private int memLevel;

    public RepositoryIDCacheTable() {
        this(7, 0.75f);
    }

    public RepositoryIDCacheTable(int i) {
        this(i, 0.75f);
    }

    public RepositoryIDCacheTable(int i, float f) {
        if (i <= 0 || (double)f <= 0.0) {
            throw new IllegalArgumentException("ID010020");
        }
        this.table = new TableEntry[i];
    }

    private synchronized boolean equal(Object obj, Object obj1) {
        return obj.equals(obj1);
    }

    public synchronized Enumeration keys() {
        return new TableEnumerator(this.table, 1);
    }

    public synchronized Object get(Object _key) {
        int i = _key.hashCode();
        int j = (i & Integer.MAX_VALUE) % this.table.length;
        TableEntry tableEntry = this.table[j];
        while (tableEntry != null) {
            if (tableEntry.hash == i && this.equal(tableEntry.key, _key)) {
                if (tableEntry.previous != null) {
                    tableEntry.previous.next = tableEntry.next;
                } else {
                    this.table[j] = tableEntry;
                }
                return tableEntry.value;
            }
            tableEntry.previous = tableEntry;
            tableEntry = tableEntry.next;
        }
        return null;
    }

    public synchronized Object put(Object _key, Object _value) {
        if (_value == null) {
            throw new NullPointerException();
        }
        int i = _key.hashCode();
        int j = (i & Integer.MAX_VALUE) % this.table.length;
        TableEntry tableEntry = this.table[j];
        while (tableEntry != null) {
            if (tableEntry.hash == i && this.equal(tableEntry.key, _key)) {
                Object obj = tableEntry.value;
                tableEntry.value = _value;
                return obj;
            }
            tableEntry = tableEntry.next;
        }
        TableEntry tentry = new TableEntry();
        tentry.hash = i;
        tentry.key = _key;
        tentry.value = _value;
        tentry.next = this.table[j];
        this.table[j] = tentry;
        ++this.count;
        ++this.table[j].size;
        return null;
    }

    public int size() {
        return this.count;
    }

    public void free(int level, boolean fromMemory) {
        try {
            if (!fromMemory || level < 2 || level < this.memLevel) {
                return;
            }
            int oldCount = this.count;
            this.count = oldCount * (5 - level) * 20 / 100;
            RepositoryIDCacheTable repositoryIDCacheTable = this;
            synchronized (repositoryIDCacheTable) {
                int i = 0;
                while (i < this.table.length) {
                    if (this.table[i] != null) {
                        int oldSize = this.table[i].size;
                        int newSize = oldSize * (5 - level) * 20 / 100;
                        TableEntry tableEntry = this.table[i];
                        tableEntry.size = newSize;
                        int j = 0;
                        while (j < newSize) {
                            tableEntry = tableEntry.next;
                            ++j;
                        }
                        tableEntry.next = null;
                        this.table[i] = tableEntry;
                    }
                    ++i;
                }
            }
            this.memLevel = level;
        }
        catch (Exception ex) {
            Logger.traceError("RepositoryIDCacheTable.free(int, boolean)", Logger.exceptionTrace(ex));
        }
    }

    class TableEnumerator
    implements Enumeration {
        short mode;
        int index;
        TableEntry[] table;
        TableEntry entry;

        TableEnumerator(TableEntry[] tentry, short modes) {
            this.table = tentry;
            this.mode = modes;
            this.index = tentry.length;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasMoreElements() {
            if (this.entry == null) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                this.entry = this.table[this.index];
                if (this.entry == null) continue;
                return true;
lbl6:
                // 2 sources

                ** while (this.index-- > 0)
            }
lbl7:
            // 1 sources

            return false;
        }

        public Object nextElement() {
            if (this.entry == null) {
                while (this.index-- > 0 && (this.entry = this.table[this.index]) == null) {
                }
            }
            if (this.entry != null) {
                TableEntry tentry = this.entry;
                this.entry = tentry.next;
                switch (this.mode) {
                    case 0: {
                        return tentry;
                    }
                    case 1: {
                        return tentry.key;
                    }
                    case 2: {
                        return tentry.value;
                    }
                }
            }
            throw new NoSuchElementException("ID010021: TableEnumerator");
        }
    }

    class CompareByName
    implements Comparator {
        CompareByName() {
        }

        public int compare(Object obj, Object obj1) {
            String s = ((Member)obj).getName();
            String s1 = ((Member)obj1).getName();
            return s.compareTo(s1);
        }

        public boolean equals(Object obj) {
            return obj.equals(this);
        }
    }

    public class TableEntry {
        int hash;
        Object key;
        Object value;
        TableEntry next;
        TableEntry previous;
        int size;
    }
}

