/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal.util;

import com.sap.engine.services.iiop.internal.util.IDFactoryItem;
import com.sap.engine.services.iiop.internal.util.IDFactoryUnit;
import com.sap.engine.services.iiop.logging.Logger;

public class IDFactory {
    public static final int DEFAULT_LIST_SIZE = 500;
    public static final int DEFAULT_MAX_UNITS = 3;
    private static final IDFactoryItem nullItem = new IDFactoryItem(-1);
    private IDFactoryUnit list = null;
    private IDFactoryUnit notifyAvailUnit = null;
    private int maxUnits = 0;
    private int unitSize = 0;
    private int count = 0;
    private int offset = 0;
    private int increase_threshold = 0;
    private int decrease_threshold = 0;
    private Object requestQueue = new Object();

    public IDFactory() {
        this(500, 3, 0);
    }

    public IDFactory(int size, int max_units, int offset) {
        this.unitSize = size;
        this.maxUnits = max_units;
        this.offset = offset;
        this.list = new IDFactoryUnit(size, 0);
        this.increase_threshold = (int)((double)this.unitSize * 0.75);
        this.decrease_threshold = (int)((double)this.unitSize * 0.25);
    }

    public void resize(int newSize, int newMaxUnits) throws IllegalArgumentException {
        if (newSize <= 0 || newMaxUnits <= 0) {
            String messageWithId = "ID019105: IDFactory::resize() - new value is negative ";
            Logger.traceError("IDFactory.resize(int, int)", messageWithId + " (" + newSize + "/" + newMaxUnits + ") is negative.");
            throw new IllegalArgumentException(messageWithId);
        }
        if (this.count > newSize * newMaxUnits) {
            String messageWithId = "ID019106: IDFactory::resize() - the requested size is too small ";
            Logger.traceError("IDFactory.resize(int, int)", messageWithId);
            throw new IllegalArgumentException(messageWithId);
        }
        this.list = this.list.resize(this.list, newSize);
    }

    public synchronized int requestID() {
        IDFactoryUnit lastUnit = this.list;
        IDFactoryUnit loopUnit = this.list;
        IDFactoryUnit availUnit = null;
        do {
            if (lastUnit.getFirstAvail() >= 0 && availUnit == null) {
                availUnit = lastUnit;
            }
            if ((loopUnit = loopUnit.getNextUnit()) == null) continue;
            lastUnit = loopUnit;
        } while (loopUnit != null);
        if ((lastUnit.getCount() > this.increase_threshold || availUnit == null) && lastUnit.getID() < this.maxUnits - 1) {
            lastUnit.setNextUnit(new IDFactoryUnit(this.unitSize, lastUnit.getID() + 1));
            lastUnit = lastUnit.getNextUnit();
            if (availUnit == null) {
                availUnit = lastUnit;
            }
        }
        while (availUnit == null) {
            try {
                this.wait();
                availUnit = this.notifyAvailUnit;
                if (availUnit.getFirstAvail() >= 0) continue;
                availUnit = null;
            }
            catch (Exception e) {
                Logger.traceError("IDFactory.requestID()", Logger.exceptionTrace(e));
            }
        }
        int id = availUnit.getNextAvailableItemID();
        ++this.count;
        int _id = this.offset + id + this.unitSize * availUnit.getID();
        return _id;
    }

    private IDFactoryUnit getUnit(int id) throws IndexOutOfBoundsException {
        if (id < 0) {
            String messageWithId = "ID019107: IDFactory::getUnit() - requested ID is negative ";
            Logger.traceError("IDFactory.getUnit(int)", messageWithId);
            throw new IndexOutOfBoundsException(messageWithId);
        }
        int currUnit = (id - this.offset) / this.unitSize;
        if (id > 0 && currUnit > this.maxUnits) {
            String messageWithId = "ID019108: IDFactory::getUnit() - requested ID is out of bounds ";
            Logger.traceError("IDFactory.getUnit(int)", messageWithId);
            throw new IndexOutOfBoundsException(messageWithId);
        }
        IDFactoryUnit unit = this.list;
        while (unit.getNextUnit() != null && currUnit > 0) {
            unit = unit.getNextUnit();
            --currUnit;
        }
        if (currUnit > 0) {
            String messageWithId = "ID019109: IDFactory::getUnit() - no such unit ";
            Logger.traceError("IDFactory.getUnit(int)", messageWithId);
            throw new IndexOutOfBoundsException(messageWithId);
        }
        return unit;
    }

    public IDFactoryUnit getUnitList() {
        return this.list;
    }

    private int getItem(int id) {
        return (id - this.offset) % this.unitSize;
    }

    public synchronized void disposeID(int id) throws IllegalArgumentException {
        if (id == -1) {
            return;
        }
        IDFactoryUnit unit = this.getUnit(id);
        int itemID = this.getItem(id);
        unit.releaseItemID(itemID);
        --this.count;
        IDFactoryUnit prev = this.list;
        IDFactoryUnit next = this.list.getNextUnit();
        while (next != null) {
            prev = next;
            next = next.getNextUnit();
        }
        if (prev.getCount() < this.decrease_threshold && next != null && next.getCount() == 0) {
            prev.setNextUnit(null);
        }
        this.notifyAvailUnit = unit;
        this.notify();
    }

    public void itemWait(int id) throws IllegalArgumentException {
        IDFactoryUnit unit = this.getUnit(id);
        IDFactoryItem item = unit.get(this.getItem(id));
        if (item.getNext() != -2) {
            String messageWithId = "ID019111: IDFactory::itemWait - item was not requested before this operation";
            Logger.traceError("IDFactory.itemWait(int)", messageWithId);
            throw new IllegalArgumentException(messageWithId);
        }
        try {
            IDFactoryItem messageWithId = item;
            synchronized (messageWithId) {
                item.wait();
            }
        }
        catch (Exception e) {
            Logger.traceError("IDFactory.itemWait(int)", Logger.exceptionTrace(e));
        }
    }

    public void itemAwake(int id) throws IllegalArgumentException {
        IDFactoryUnit unit = this.getUnit(id);
        IDFactoryItem item = unit.get(this.getItem(id));
        if (item.getNext() != -2) {
            String messageWithId = "IDFactory::itemAwake - item was not requested  before this operation";
            Logger.traceError("IDFactory.itemAwake(int)", messageWithId);
            throw new IllegalArgumentException(messageWithId);
        }
        try {
            IDFactoryItem messageWithId = item;
            synchronized (messageWithId) {
                item.notify();
            }
        }
        catch (Exception e) {
            Logger.traceError("IDFactory.itemAwake(int)", Logger.exceptionTrace(e));
        }
    }

    public IDFactoryItem get(int id) {
        if (id == -1) {
            return nullItem;
        }
        IDFactoryUnit unit = this.getUnit(id);
        IDFactoryItem item = unit.get(this.getItem(id));
        if (item.getNext() != -2) {
            String messageWithId = "ID019112: IDFactory::get - item was not requested  before this operation";
            Logger.traceError("IDFactory.get(int)", messageWithId);
            throw new IllegalArgumentException(messageWithId);
        }
        return item;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getUnitSize() {
        return this.unitSize;
    }

    public int getMaxUnits() {
        return this.maxUnits;
    }

    public int getSize() {
        return this.count;
    }

    public void printAvail() {
        IDFactoryUnit unit = this.list;
        while (unit != null) {
            unit.printAvail();
            unit = unit.getNextUnit();
        }
    }

    public void disposeAll() {
        int i = 0;
        while (i < this.unitSize * this.maxUnits) {
            try {
                this.disposeID(i);
            }
            catch (Exception e) {
                Logger.traceError("IDFactory.disposeAll()", Logger.exceptionTrace(e));
            }
            ++i;
        }
    }
}

