/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal.portable.cache;

import com.sap.engine.services.iiop.internal.portable.cache.ObjectList;

public class StreamCache {
    private static int hashIndex = 101;
    private ObjectList[] cacheStore;

    public StreamCache() {
        this.init();
    }

    public StreamCache(int hashIndex) {
        StreamCache.hashIndex = hashIndex > 0 ? hashIndex : 1;
        this.init();
    }

    private void init() {
        this.cacheStore = new ObjectList[hashIndex];
    }

    public void put(Object object, int position) {
        int id = System.identityHashCode(object);
        int index = Math.abs(id) % hashIndex;
        if (this.cacheStore[index] != null) {
            this.cacheStore[index].put(object, id, position);
        } else {
            this.cacheStore[index] = new ObjectList(object, id, position);
        }
    }

    public int get(Object object) {
        int id = System.identityHashCode(object);
        int index = Math.abs(id) % hashIndex;
        int res = -1;
        if (this.cacheStore[index] != null) {
            res = this.cacheStore[index].get(object, id);
        }
        return res;
    }

    public boolean contains(Object object) {
        int id = System.identityHashCode(object);
        int index = Math.abs(id) % hashIndex;
        boolean res = false;
        if (this.cacheStore[index] != null) {
            res = this.cacheStore[index].contains(object, id);
        }
        return res;
    }

    public static void main(String[] args) {
        int i = 0;
        while (i < 11) {
            int hashInd = i * 11;
            int cnt = 1000;
            Integer[] arr = new Integer[cnt];
            long time = System.currentTimeMillis();
            StreamCache cache = new StreamCache(hashInd);
            int j = 0;
            while (j < cnt) {
                arr[j] = new Integer(j);
                if (!cache.contains(arr[j])) {
                    cache.put(arr[j], j);
                } else {
                    cache.get(arr[j]);
                }
                ++j;
            }
            int j2 = 0;
            while (j2 < cnt) {
                if (!cache.contains(arr[j2])) {
                    cache.get(arr[j2]);
                }
                ++j2;
            }
            System.out.println("HashIndex : " + hashInd + "   time >>> " + (System.currentTimeMillis() - time));
            ++i;
        }
    }
}

