/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal.portable;

import com.sap.engine.services.iiop.internal.portable.IIOPInputStream;
import com.sap.engine.services.iiop.logging.Logger;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectStreamClass;
import java.io.ObjectStreamConstants;
import java.io.ObjectStreamField;
import java.util.Hashtable;
import java.util.Stack;
import org.omg.CORBA.MARSHAL;

public class ObjectReader
implements ObjectStreamConstants {
    ByteArrayOutputStream arrayOutput = new ByteArrayOutputStream();
    DataOutputStream dataOutput = new DataOutputStream(this.arrayOutput);
    Stack stack = new Stack();
    Hashtable handleTable = new Hashtable();
    int handlePos = 0;
    IIOPInputStream in;
    static /* synthetic */ Class class$java$io$Serializable;

    public ObjectReader() {
        this.in = null;
    }

    protected ObjectReader(IIOPInputStream in) {
        this.in = in;
    }

    protected void setInputStream(IIOPInputStream in) {
        this.in = in;
    }

    public Object make(Class forClass) throws IOException, ClassNotFoundException {
        try {
            this.dataOutput.writeShort(-21267);
            this.dataOutput.writeShort(5);
        }
        catch (IOException ioEx) {
            Logger.traceError("ObjectReader.make(Class)", Logger.exceptionTrace(ioEx));
            throw ioEx;
        }
        catch (Exception ex) {
            Logger.traceError("ObjectReader.make(Class)", Logger.exceptionTrace(ex));
            throw new IOException("ID019103:  IO Problem - write Stream header");
        }
        this.write(forClass);
        ByteArrayInputStream arrayInput = new ByteArrayInputStream(this.toByteArray());
        ObjectInputStream objectInput = new ObjectInputStream(arrayInput);
        return objectInput.readObject();
    }

    private void write(Class forClass) throws IOException {
        int streamPos = this.in.getPos();
        Integer pos = (Integer)this.handleTable.get(new Integer(streamPos));
        if (pos != null) {
            this.dataOutput.write(113);
            this.dataOutput.write(pos + 0x7E0000);
            return;
        }
        if (forClass.isArray()) {
            this.writeArray(forClass);
        } else {
            this.writeObject(forClass);
        }
    }

    private void writeArray(Class forClass) {
    }

    private void writeObject(Class forClass) throws IOException {
        int streamPos = this.in.getPos();
        ObjectStreamClass classDescriptor = ObjectStreamClass.lookup(forClass);
        this.dataOutput.write(115);
        this.writeClassDesc(classDescriptor);
        this.handleTable.put(new Integer(streamPos), new Integer(this.handlePos++));
        Class superClass = forClass.getSuperclass();
        ObjectStreamClass superDesc = null;
        this.stack.push(classDescriptor);
        superDesc = ObjectStreamClass.lookup(superClass);
        while (superDesc != null) {
            this.stack.push(superDesc);
            superClass = superClass.getSuperclass();
            superDesc = ObjectStreamClass.lookup(superClass);
        }
        superDesc = (ObjectStreamClass)this.stack.pop();
        do {
            this.writeClassData(superDesc);
        } while (!this.stack.empty() && (superDesc = (ObjectStreamClass)this.stack.pop()) != null);
    }

    private void writeClassDesc(ObjectStreamClass classDesc) throws IOException {
        if (classDesc == null) {
            this.dataOutput.write(112);
        } else {
            Integer pos = (Integer)this.handleTable.get(classDesc);
            if (pos != null) {
                this.dataOutput.write(113);
                this.dataOutput.writeInt(pos + 0x7E0000);
            } else {
                this.handleTable.put(classDesc, new Integer(this.handlePos++));
                this.writeNewClassDesc(classDesc);
            }
        }
    }

    private void writeNewClassDesc(ObjectStreamClass classDesc) throws IOException {
        this.dataOutput.write(114);
        this.dataOutput.writeUTF(classDesc.getName());
        this.dataOutput.writeLong(classDesc.getSerialVersionUID());
        this.writeClassDescInfo(classDesc);
    }

    private void writeClassDescInfo(ObjectStreamClass classDesc) throws IOException {
        this.writeClassDescFlags(classDesc.forClass());
        this.writeFields(classDesc.getFields());
        this.writeClassAnnotation();
        ObjectStreamClass superclass = ObjectStreamClass.lookup(classDesc.forClass().getSuperclass());
        this.writeClassDesc(superclass);
    }

    private void writeClassDescFlags(Class _class) throws IOException {
        int flag = (class$java$io$Serializable == null ? (class$java$io$Serializable = ObjectReader.class$("java.io.Serializable")) : class$java$io$Serializable).isAssignableFrom(_class) ? 2 : 4;
        this.dataOutput.write(flag);
    }

    private void writeFields(ObjectStreamField[] streamField) throws IOException {
        this.dataOutput.writeShort((short)streamField.length);
        int i = 0;
        while (i < streamField.length) {
            this.writeFieldDesc(streamField[i]);
            ++i;
        }
    }

    private void writeFieldDesc(ObjectStreamField _field) throws IOException {
        this.dataOutput.write((byte)_field.getTypeCode());
        this.dataOutput.writeUTF(_field.getName());
        if (!_field.isPrimitive()) {
            this.dataOutput.write(116);
            this.dataOutput.writeUTF(_field.getTypeString());
            this.handleTable.put(_field.getTypeString(), new Integer(this.handlePos++));
        }
    }

    private void writeClassAnnotation() throws IOException {
        this.dataOutput.write(120);
    }

    private void writeClassData(ObjectStreamClass classDesc) throws IOException {
        ObjectStreamField[] fields = classDesc.getFields();
        int i = 0;
        while (i < fields.length) {
            if (fields[i].isPrimitive()) {
                this.writePrimitivType(fields[i]);
            } else {
                this.writeObjectType(fields[i]);
            }
            ++i;
        }
    }

    private void writePrimitivType(ObjectStreamField descriptor) {
        try {
            switch (descriptor.getTypeCode()) {
                case 'B': {
                    this.dataOutput.write(this.in.read_octet());
                    break;
                }
                case 'C': {
                    this.dataOutput.writeChar(this.in.read_char());
                    break;
                }
                case 'D': {
                    this.dataOutput.writeDouble(this.in.read_double());
                    break;
                }
                case 'F': {
                    this.dataOutput.writeFloat(this.in.read_float());
                    break;
                }
                case 'I': {
                    this.dataOutput.writeInt(this.in.read_long());
                    break;
                }
                case 'J': {
                    this.dataOutput.writeLong(this.in.read_longlong());
                    break;
                }
                case 'S': {
                    this.dataOutput.writeShort(this.in.read_short());
                    break;
                }
                case 'Z': {
                    this.dataOutput.writeBoolean(this.in.read_boolean());
                }
            }
        }
        catch (Exception illegalAcc) {
            Logger.traceError("ObjectReader.writePrimitivType(ObjectStreamField)", Logger.exceptionTrace(illegalAcc));
        }
    }

    private void writeObjectType(ObjectStreamField descriptor) throws IOException {
        int valueTag = this.in.read_long();
        if (valueTag == 0) {
            this.dataOutput.write(112);
            return;
        }
        if (valueTag == -1) {
            this.dataOutput.write(113);
            Integer pos = (Integer)this.handleTable.get(new Integer(this.in.unaligned_read_long()));
            this.dataOutput.writeInt(pos + 0x7E0000);
            return;
        }
        if (valueTag < 0x7FFFFF00 || valueTag > Integer.MAX_VALUE) {
            throw new MARSHAL("ID019104: Exception: Invalid value Tag");
        }
        String repId = this.in.read_string();
        String className = repId.substring(4, repId.indexOf(":", 5));
        try {
            Class<?> obClass = this.getClass().getClassLoader().loadClass(className);
            this.write(obClass);
        }
        catch (ClassNotFoundException cnf) {
            Logger.traceError("ObjectReader.writeObjectType(ObjectStreamField)", Logger.exceptionTrace(cnf));
        }
    }

    public byte[] toByteArray() {
        try {
            this.dataOutput.close();
            this.arrayOutput.flush();
        }
        catch (Exception ex) {
            Logger.traceError("ObjectReader.toByteArray()", Logger.exceptionTrace(ex));
        }
        byte[] result = this.arrayOutput.toByteArray();
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

