/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal.portable;

import com.sap.engine.lib.util.HashMapIntObject;
import com.sap.engine.services.iiop.CORBA.ORB;
import com.sap.engine.services.iiop.CORBA.portable.CORBAInputStream;
import com.sap.engine.services.iiop.logging.Logger;
import java.io.Serializable;
import java.lang.reflect.Method;
import javax.rmi.CORBA.Util;
import javax.rmi.CORBA.ValueHandler;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.IndirectionException;
import org.omg.CORBA.portable.InputStream;
import org.omg.SendingContext.RunTime;

public class IIOPInputStream
extends CORBAInputStream {
    public static final String HELPER = "Helper";
    public static final String READ = "read";
    public static final String IDL_WSTRING = "IDL:omg.org/CORBA/WStringValue:1.0";
    public static final String RMI = "RMI:";
    public static final String RMI_CLASSDESCR = "RMI:javax.rmi.CORBA.ClassDesc";
    public static final String DP = ":";
    public static final String EMPTY_STR = "";
    public HashMapIntObject objectCache = new HashMapIntObject();
    public HashMapIntObject RepIdCache = new HashMapIntObject();
    private ValueHandler valueHandler;
    protected RunTime default_codebase = null;
    static /* synthetic */ Class class$org$omg$CORBA$portable$IDLEntity;
    static /* synthetic */ Class class$org$omg$CORBA$portable$InputStream;

    public IIOPInputStream(byte[] data) {
        super(data);
    }

    public IIOPInputStream(ORB orb0, byte[] data, boolean littleEndian) {
        super(orb0, data, littleEndian);
    }

    public IIOPInputStream(ORB orb0, byte[] data) {
        super(orb0, data);
    }

    public void setDefault_codebase(RunTime default_codebase) {
        this.default_codebase = default_codebase;
    }

    public RunTime getDefault_codebase() {
        return this.default_codebase;
    }

    public Serializable read_value(Class clz) {
        return this.read_value(clz.getClassLoader(), clz);
    }

    public Serializable read_value() {
        return this.read_value(null, null);
    }

    public Serializable read_value(ClassLoader baseLoader, Class arg_type) {
        java.lang.Object serializableValue;
        boolean flag;
        int position;
        block44: {
            boolean hasCodeBase;
            this.trace("IIOPInputStream.read_value()", "READ VALUE at : " + this.getPos());
            String repositoryId = EMPTY_STR;
            int valueTag = this.read_long();
            position = this.getPos();
            this.trace("IIOPInputStream.read_value()", "READ VALUE at : ");
            this.trace("IIOPInputStream.read_value()", "VALUE TAG : " + valueTag + "  POS : " + position);
            if (valueTag == 0) {
                return null;
            }
            if (valueTag == -1) {
                int cashePosition = this.unaligned_read_long();
                this.trace("IIOPInputStream.read_value()", ">>INDIRECTION : " + cashePosition);
                if (this.valueHandler == null) {
                    throw new IndirectionException(cashePosition);
                }
                this.trace("IIOPInputStream.read_value()", "GET INDIRECTION KEY : " + (position += cashePosition + 4));
                Serializable ser = (Serializable)this.objectCache.get(position);
                this.trace("IIOPInputStream.read_value()", ">>INDIRECTED : " + ser);
                if (ser == null) {
                    throw new IndirectionException(position);
                }
                this.startBlock();
                return ser;
            }
            flag = this.isChunked;
            serializableValue = null;
            String codebase = EMPTY_STR;
            boolean bl = hasCodeBase = (valueTag & 1) == 1;
            if (hasCodeBase) {
                codebase = (String)((java.lang.Object)this.read_value());
            }
            this.isChunked = (valueTag & 8) != 0;
            switch (valueTag & 6) {
                case 0: {
                    if (this.valueHandler == null) {
                        this.valueHandler = Util.createValueHandler();
                    }
                    repositoryId = this.valueHandler.getRMIRepositoryID(arg_type);
                    break;
                }
                case 2: {
                    repositoryId = this.readRepositoryId();
                    break;
                }
                case 6: {
                    repositoryId = this.readRepositoryIds();
                }
            }
            this.trace("IIOPInputStream.read_value()", "REP ID : " + repositoryId);
            this.startBlock();
            --this.endTag;
            this.trace("IIOPInputStream.read_value()", "endTag: " + this.endTag);
            try {
                Class valueClass;
                String className;
                block45: {
                    if (repositoryId.equals(IDL_WSTRING)) {
                        serializableValue = this.read_wstring();
                        break block44;
                    }
                    if (repositoryId.startsWith(RMI_CLASSDESCR)) {
                        codebase = (String)((java.lang.Object)this.read_value());
                        String classNameIDL = (String)((java.lang.Object)this.read_value());
                        String className2 = classNameIDL.substring(4, classNameIDL.substring(5).indexOf(DP) + 5);
                        try {
                            serializableValue = Class.forName(className2, true, Thread.currentThread().getContextClassLoader());
                        }
                        catch (ClassNotFoundException e) {
                            if (hasCodeBase) {
                                serializableValue = Util.loadClass((String)className2, (String)codebase, (ClassLoader)Thread.currentThread().getContextClassLoader());
                                break block44;
                            }
                            if (this.default_codebase != null) {
                                serializableValue = Util.loadClass((String)className2, (String)this.orb.object_to_string((Object)this.default_codebase), (ClassLoader)Thread.currentThread().getContextClassLoader());
                                break block44;
                            }
                            serializableValue = Util.loadClass((String)className2, (String)EMPTY_STR, (ClassLoader)Thread.currentThread().getContextClassLoader());
                        }
                        break block44;
                    }
                    if (!repositoryId.startsWith(RMI)) break block44;
                    className = repositoryId.substring(4, repositoryId.indexOf(DP, 5));
                    valueClass = null;
                    if (baseLoader != null) {
                        try {
                            valueClass = Class.forName(className, true, baseLoader);
                        }
                        catch (ClassNotFoundException cls) {
                            try {
                                valueClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                            }
                            catch (ClassNotFoundException _cls) {
                                if (hasCodeBase) {
                                    valueClass = Util.loadClass((String)className, (String)codebase, (ClassLoader)Thread.currentThread().getContextClassLoader());
                                    break block45;
                                }
                                if (this.default_codebase != null) {
                                    valueClass = Util.loadClass((String)className, (String)this.orb.object_to_string((Object)this.default_codebase), (ClassLoader)Thread.currentThread().getContextClassLoader());
                                    break block45;
                                }
                                valueClass = Util.loadClass((String)className, (String)EMPTY_STR, (ClassLoader)Thread.currentThread().getContextClassLoader());
                            }
                        }
                    } else {
                        try {
                            valueClass = Class.forName(className, true, Thread.currentThread().getContextClassLoader());
                        }
                        catch (ClassNotFoundException cnfex) {
                            valueClass = hasCodeBase ? Util.loadClass((String)className, (String)codebase, (ClassLoader)Thread.currentThread().getContextClassLoader()) : (this.default_codebase != null ? Util.loadClass((String)className, (String)this.orb.object_to_string((Object)this.default_codebase), (ClassLoader)Thread.currentThread().getContextClassLoader()) : Util.loadClass((String)className, (String)EMPTY_STR, (ClassLoader)Thread.currentThread().getContextClassLoader()));
                        }
                    }
                }
                if ((class$org$omg$CORBA$portable$IDLEntity == null ? (class$org$omg$CORBA$portable$IDLEntity = IIOPInputStream.class$("org.omg.CORBA.portable.IDLEntity")) : class$org$omg$CORBA$portable$IDLEntity).isAssignableFrom(valueClass)) {
                    ClassLoader classloader = valueClass != null ? valueClass.getClassLoader() : null;
                    try {
                        Class<?> class2 = Class.forName(valueClass.getName() + HELPER, true, classloader);
                        Class[] aclass = new Class[]{class$org$omg$CORBA$portable$InputStream == null ? (class$org$omg$CORBA$portable$InputStream = IIOPInputStream.class$("org.omg.CORBA.portable.InputStream")) : class$org$omg$CORBA$portable$InputStream};
                        Method method = class2.getDeclaredMethod(READ, aclass);
                        java.lang.Object[] aobj = new java.lang.Object[]{this};
                        serializableValue = (Serializable)method.invoke(null, aobj);
                        break block44;
                    }
                    catch (Exception classnotfoundexception) {
                        try {
                            serializableValue = hasCodeBase ? Util.loadClass((String)className, (String)codebase, (ClassLoader)classloader) : (this.default_codebase != null ? Util.loadClass((String)className, (String)this.orb.object_to_string((Object)this.default_codebase), (ClassLoader)classloader) : Util.loadClass((String)className, (String)EMPTY_STR, (ClassLoader)classloader));
                            break block44;
                        }
                        catch (ClassNotFoundException _cnfex) {
                            Logger.traceError("IIOPInputStream.read_value()", Logger.exceptionTrace(_cnfex));
                            throw new MARSHAL(_cnfex.getMessage());
                        }
                    }
                }
                if (this.valueHandler == null) {
                    this.valueHandler = Util.createValueHandler();
                }
                try {
                    try {
                        serializableValue = this.valueHandler.readValue((InputStream)this, position, valueClass, repositoryId, this.default_codebase);
                    }
                    catch (ClassCastException ccex) {
                        Logger.traceWarning("IIOPInputStream.read_value()", "ClassCast exception. May be ValueHandler can't cast the CodeBase object." + Logger.exceptionTrace(ccex));
                        serializableValue = this.valueHandler.readValue((InputStream)this, position, valueClass, repositoryId, null);
                    }
                }
                catch (Exception t) {
                    Logger.traceError("IIOPInputStream.read_value()", Logger.exceptionTrace(t));
                    throw new MARSHAL(t.toString());
                }
            }
            catch (ClassNotFoundException classNotfound) {
                String messageWithId = "ID019101: Class not found";
                Logger.traceError("IIOPInputStream.read_value()", Logger.exceptionTrace(classNotfound));
                throw new MARSHAL(messageWithId);
            }
            catch (MARSHAL marex) {
                throw marex;
            }
            catch (Exception ex) {
                Logger.traceError("IIOPInputStream.read_value()", Logger.exceptionTrace(ex));
                throw new MARSHAL(ex.toString());
            }
        }
        this.endBlock();
        this.readEndTag();
        this.isChunked = flag;
        if (serializableValue != null) {
            this.trace("IIOPInputStream.read_value()", "STORE INDIRECTION AT : " + position);
            this.objectCache.put(position, serializableValue);
        }
        this.startBlock();
        if (serializableValue != null) {
            this.trace("IIOPInputStream.read_value()", "***** READ VALUE RETURNS : " + serializableValue.getClass());
        } else {
            this.trace("IIOPInputStream.read_value()", "***** READ VALUE RETURNS : " + null);
        }
        return serializableValue;
    }

    public java.lang.Object read_abstract_interface() {
        return this.read_abstract_interface(null);
    }

    public java.lang.Object read_abstract_interface(Class class1) {
        boolean flag = this.read_boolean();
        if (flag) {
            Object obj = this.read_Object(class1);
            return obj;
        }
        return this.read_value();
    }

    public String readRepositoryId() {
        int position = this.getPos();
        int i = this.read_long();
        if (i == -1) {
            int off = this.unaligned_read_long();
            return (String)this.RepIdCache.get(position += off + 4);
        }
        byte[] arr = new byte[i - 1];
        this.read_octet_array(arr, 0, i - 1);
        this.unaligned_read_octet();
        this.RepIdCache.put(position, arr);
        return new String(arr);
    }

    private String readRepositoryIds() {
        int i = this.read_long();
        if (i == -1) {
            int j = this.getPos() + this.unaligned_read_long();
            if (this.RepIdCache != null && this.RepIdCache.containsKey(j)) {
                return (String)this.RepIdCache.get(j);
            }
            throw new MARSHAL("Unable to locate array of repository IDs from indirection " + j);
        }
        int k = this.getPos() - 4;
        String rId = this.readRepositoryId();
        this.RepIdCache.put(k, rId);
        int l = 1;
        while (l < i) {
            this.readRepositoryId();
            ++l;
        }
        return rId;
    }

    private void trace(String place, String msg) {
        Logger.traceDebug(place, msg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

