/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.internal;

import com.sap.engine.lib.lang.Convert;
import com.sap.engine.services.iiop.CORBA.CORBAObject;
import com.sap.engine.services.iiop.CORBA.CodecFactoryImpl;
import com.sap.engine.services.iiop.CORBA.IOR;
import com.sap.engine.services.iiop.CORBA.ORB;
import com.sap.engine.services.iiop.CORBA.interceptors.ORBInitInfoImpl;
import com.sap.engine.services.iiop.CORBA.portable.CORBAInputStream;
import com.sap.engine.services.iiop.CORBA.portable.CORBAOutputStream;
import com.sap.engine.services.iiop.CORBA.portable.DelegateImpl;
import com.sap.engine.services.iiop.internal.NameServiceHolder;
import com.sap.engine.services.iiop.internal.TargetHolder;
import com.sap.engine.services.iiop.internal.giop.ConnectionParser;
import com.sap.engine.services.iiop.internal.portable.IIOPOutputStream;
import com.sap.engine.services.iiop.internal.store.ConnectionTableHash;
import com.sap.engine.services.iiop.internal.util.IDFactory;
import com.sap.engine.services.iiop.logging.ClientLogger;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.engine.services.iiop.logging.NoTraceLogger;
import com.sap.engine.services.iiop.system.CommunicationLayer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.DATA_CONVERSION;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ApplicationException;
import org.omg.CORBA.portable.Delegate;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.RemarshalException;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;
import org.omg.CosNaming.NamingContext;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitializer;

public class ClientORB
extends ORB {
    public static final String ROOT_POA_NAME = "RootPOA";
    public static final String NAME_SERVICE_NAME = "NameService";
    public static final String NAME_SERVICE_LOCAL = "NameServiceLocal";
    public static final String PICURRENT_NAME = "PICurrent";
    public static final String CODEC_FACTORY_NAME = "CodecFactory";
    private static String CORBA_OBJECT = "IDL:omg.org/CORBA/Object:1.0";
    protected static String orbId = "";
    public static CommunicationLayer communicationLayer;
    static NamingContext cosNaming;
    static NameServiceHolder namingServant;
    protected static IDFactory idFac;
    protected static ConnectionTableHash table;
    protected static CodecFactory codecFactory;
    private static int corr;
    private HashMap initialReferenceTable = null;
    byte versionMinor = 1;
    public static final String appclientCommunicationLayerClass = "com.sap.engine.services.iiop.client.CommunicationLayerImpl";
    private static final char[] hexDigits;
    static String ORB_Host_Property;
    static String ORB_Port_Property;
    static /* synthetic */ Class class$org$omg$PortableInterceptor$ORBInitializer;

    public ClientORB() {
        this(appclientCommunicationLayerClass);
    }

    public ClientORB(String communicationLayerClass) {
        if (table == null) {
            table = new ConnectionTableHash();
        }
        if (codecFactory == null) {
            codecFactory = new CodecFactoryImpl(this);
        }
        if (this.initialReferenceTable == null) {
            this.initialReferenceTable = new HashMap(3);
            this.initialReferenceTable.put(PICURRENT_NAME, null);
            this.initialReferenceTable.put(CODEC_FACTORY_NAME, codecFactory);
            this.initialReferenceTable.put(ROOT_POA_NAME, this.rootPOA);
        }
        if (communicationLayer == null && communicationLayerClass != null) {
            communicationLayer = CommunicationLayer.init(communicationLayerClass, this);
            ConnectionParser.orb = this;
            Properties props = System.getProperties();
            String providerClass = props.getProperty("sslsocket.provider.class");
            String providerParam = props.getProperty("sslsocket.provider.param");
            String providerPass = props.getProperty("sslsocket.provider.password");
            String traceClient = props.getProperty(Logger.TRACE_CLIENT_KEY);
            Logger.theLogger = traceClient != null && traceClient.equalsIgnoreCase("yes") ? new ClientLogger() : new NoTraceLogger();
            if (providerClass != null) {
                if (providerParam != null) {
                    communicationLayer.setSSLProvider(providerClass, new String[]{providerParam, providerPass});
                } else {
                    communicationLayer.setSSLProvider(providerClass, null);
                }
            }
            if (props != null) {
                String s1 = props.getProperty("org.omg.CORBA.ORBInitialPort");
                if (s1 != null) {
                    try {
                        this.initialPort = Integer.parseInt(s1);
                    }
                    catch (NumberFormatException numberformatexception) {
                        this.initialPort = 900;
                    }
                }
                if ((s1 = props.getProperty("org.omg.CORBA.ORBInitialHost")) != null) {
                    this.initialHost = s1;
                }
                s1 = props.getProperty("GIOPVersionMinor", "1");
                this.versionMinor = Byte.parseByte(s1);
            }
            this.isInitialized = false;
            ORBInitializer[] orbInitializers = this.registerORBInitializers(props);
            if (orbInitializers != null) {
                ORBInitInfoImpl orbInitInfo = new ORBInitInfoImpl((org.omg.CORBA.ORB)this, new String[0], orbId, codecFactory, true);
                this.preInitORBInitializers(orbInitInfo, orbInitializers);
                this.postInitORBInitializers(orbInitInfo, orbInitializers);
            }
            this.isInitialized = true;
        }
    }

    protected void set_parameters(String[] args, Properties props) {
        props = this.cutProperties(props);
        String providerClass = props.getProperty("sslsocket.provider.class");
        String providerParam = props.getProperty("sslsocket.provider.param");
        String providerPass = props.getProperty("sslsocket.provider.password");
        String traceClient = props.getProperty(Logger.TRACE_CLIENT_KEY);
        if (traceClient != null && traceClient.equalsIgnoreCase("yes")) {
            Logger.theLogger = new ClientLogger();
        }
        if (providerClass != null) {
            if (providerParam != null) {
                communicationLayer.setSSLProvider(providerClass, new String[]{providerParam, providerPass});
            } else {
                communicationLayer.setSSLProvider(providerClass, null);
            }
        }
        int i = 0;
        while (i < args.length) {
            if (args[i].equals(ORB.initialArguments[0])) {
                try {
                    this.initialPort = Integer.parseInt(args[++i]);
                }
                catch (NumberFormatException e) {
                    this.initialPort = 900;
                }
            } else if (args[i].equals(ORB.initialArguments[1])) {
                this.initialHost = args[++i];
            } else {
                Logger.logError("Invalid startup parameter: " + args[i]);
            }
            ++i;
        }
        if (props != null) {
            String s1 = props.getProperty("org.omg.CORBA.ORBInitialPort");
            if (s1 != null) {
                try {
                    this.initialPort = Integer.parseInt(s1);
                }
                catch (NumberFormatException numberformatexception) {
                    this.initialPort = 900;
                }
            }
            if ((s1 = props.getProperty("org.omg.CORBA.ORBInitialHost")) != null) {
                this.initialHost = s1;
            }
            s1 = props.getProperty("GIOPVersionMinor", "1");
            this.versionMinor = Byte.parseByte(s1);
        }
        this.isInitialized = false;
        ORBInitializer[] orbInitializers = this.registerORBInitializers(props);
        if (orbInitializers != null) {
            ORBInitInfoImpl orbInitInfo = new ORBInitInfoImpl((org.omg.CORBA.ORB)this, new String[0], orbId, codecFactory, false);
            this.preInitORBInitializers(orbInitInfo, orbInitializers);
            this.postInitORBInitializers(orbInitInfo, orbInitializers);
        }
        this.isInitialized = true;
    }

    public void set_(String[] args, Properties props) {
        if (props.getProperty("IDFactoryUnitSize") != null && props.getProperty("IDFactoryMaxUnits") != null) {
            int newUnitSize = Integer.parseInt(props.getProperty("IDFactoryUnitSize"));
            int newMaxUnits = Integer.parseInt(props.getProperty("IDFactoryMaxUnits"));
            idFac.resize(newUnitSize, newMaxUnits);
        }
    }

    public CommunicationLayer getCommLayer() {
        return communicationLayer;
    }

    public void connect(Object obj) {
        ObjectImpl oi = (ObjectImpl)obj;
        try {
            DelegateImpl di = (DelegateImpl)oi._get_delegate();
            if (di.isConnected()) {
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] objkey = this.getObjectKey(0);
        String[] ids = oi._ids();
        try {
            String host = "localhost";
            int port = 3333;
            try {
                String url = communicationLayer.getURL()[0];
                int idx = url.indexOf("@") + 1;
                int idy = url.indexOf(":", idx);
                if (idy < 0) {
                    host = url.substring(idx);
                } else {
                    host = url.substring(idx, idy);
                    port = Integer.parseInt(url.substring(idy + 1));
                }
            }
            catch (ArrayIndexOutOfBoundsException aiobe) {
                if (Logger.beWarning()) {
                    Logger.traceWarning("ClientORB.connect(org.omg.CORBA.Object)", Logger.exceptionTrace(aiobe));
                }
                Logger.logWarning("IIOP Service is not started on dispatcher !");
            }
            IOR ior = new IOR((org.omg.CORBA.ORB)this, ids[0], host, port, objkey);
            if (this.versionMinor != 1) {
                ior.getProfile().setVersion((byte)1, this.versionMinor);
            }
            DelegateImpl d = new DelegateImpl(this, ior);
            oi._set_delegate((Delegate)d);
            table.put(objkey, obj);
            d.setConnected(true);
        }
        catch (NumberFormatException e) {
            Logger.traceError("ClientORB.connect(org.omg.CORBA.Object)", Logger.exceptionTrace(e));
        }
    }

    byte[] getObjectKey(int serverId) {
        byte[] objkey = new byte[12];
        Convert.writeIntToByteArr(objkey, 0, serverId);
        long time = System.currentTimeMillis();
        ClientORB clientORB = this;
        synchronized (clientORB) {
            objkey[4] = (byte)corr++;
        }
        int i = 0;
        while (i < 7) {
            objkey[i + 5] = (byte)(time >> i * 8 & 0xFFL);
            ++i;
        }
        return objkey;
    }

    public void disconnect(Object obj) {
        table.delete(obj);
    }

    public Object getObject(byte[] bKey) {
        return table.get(bKey);
    }

    public TargetHolder getServant(byte[] bKey) {
        return table.getServant(bKey);
    }

    public String[] list_initial_services() {
        Set init_services_set = this.initialReferenceTable.keySet();
        String[] init_services = new String[init_services_set.size() + 1];
        init_services_set.toArray(init_services);
        init_services[init_services_set.size()] = NAME_SERVICE_NAME;
        return init_services;
    }

    public Object resolve_initial_references(String object_name) throws InvalidName {
        return this.resolve_initial_references(object_name, (byte)1, (byte)0, this.initialHost, this.initialPort);
    }

    private Object resolve_initial_references(String object_name, byte majorVersion, byte minorVersion, String host, int port) throws InvalidName {
        java.lang.Object result = null;
        if (NAME_SERVICE_LOCAL.equals(object_name)) {
            result = this.getCosNaming();
        } else if (this.initialReferenceTable.containsKey(object_name)) {
            result = (Object)this.initialReferenceTable.get(object_name);
            if (result == null && object_name.equals(PICURRENT_NAME)) {
                this.piCurrent = this.getPICurrent();
                this.initialReferenceTable.put(object_name, this.piCurrent);
                result = this.piCurrent;
            }
        } else {
            switch (minorVersion) {
                case 0: {
                    byte[] obj_key = "INIT".getBytes();
                    IOR ior = new IOR((org.omg.CORBA.ORB)this, CORBA_OBJECT, host, port, obj_key, majorVersion, minorVersion);
                    Delegate delegate = communicationLayer.getDelegate(ior);
                    CORBAObject corbaobject = new CORBAObject(ior);
                    OutputStream out = (OutputStream)delegate.request((Object)corbaobject, "get", true);
                    out.write_string(object_name);
                    InputStream inputStream = null;
                    try {
                        inputStream = (InputStream)delegate.invoke((Object)corbaobject, (org.omg.CORBA.portable.OutputStream)out);
                    }
                    catch (ApplicationException e) {
                        if (Logger.beDebug()) {
                            Logger.traceDebug("ClientORB.resolve_initial_references(String, byte, byte, String, int)", Logger.exceptionTrace(e));
                        }
                        inputStream = (InputStream)e.getInputStream();
                        String id = inputStream.read_string();
                        throw new RuntimeException(id);
                    }
                    catch (RemarshalException e) {
                        if (Logger.beDebug()) {
                            Logger.traceDebug("ClientORB.resolve_initial_references(String, byte, byte, String, int)", Logger.exceptionTrace(e));
                        }
                        return this.resolve_initial_references(object_name, majorVersion, minorVersion, host, port);
                    }
                    result = inputStream.read_Object();
                    break;
                }
                case 1: 
                case 2: {
                    IOR ior = new IOR((org.omg.CORBA.ORB)this, CORBA_OBJECT, host, port, object_name.getBytes(), majorVersion, minorVersion);
                    result = new CORBAObject(ior);
                }
            }
        }
        if (result != null) {
            return result;
        }
        throw new InvalidName(object_name);
    }

    public void register_initial_reference(String id, Object obj) throws InvalidName {
        if (id == null || id.length() == 0) {
            throw new InvalidName();
        }
        java.lang.Object initial_ref = this.initialReferenceTable.get(id);
        if (initial_ref != null) {
            throw new InvalidName(id + " already registered");
        }
        this.initialReferenceTable.put(id, obj);
    }

    public IDFactory getIDFactory() {
        return idFac;
    }

    private String toHex(byte[] ba, int offset, int length) {
        char[] buf = new char[length * 2];
        int j = 0;
        int i = offset;
        while (i < offset + length) {
            byte k = ba[i];
            buf[j++] = hexDigits[k >>> 4 & 0xF];
            buf[j++] = hexDigits[k & 0xF];
            ++i;
        }
        return new String(buf);
    }

    public String object_to_string(Object obj) {
        try {
            IOR ior = null;
            if (obj == null) {
                ior = new IOR((org.omg.CORBA.ORB)this, "", null);
            } else {
                ObjectImpl oi = (ObjectImpl)obj;
                try {
                    ior = ((DelegateImpl)oi._get_delegate()).getIOR();
                }
                catch (Exception e) {
                    this.connect(obj);
                    ior = ((DelegateImpl)oi._get_delegate()).getIOR();
                }
            }
            CORBAOutputStream os = new CORBAOutputStream(512);
            os.write_boolean(os.getEndian());
            ior.write_object((org.omg.CORBA.portable.OutputStream)os);
            String sResult = this.toHex(os.toByteArray_forSend(), 0, os.byteArray_forSend_length());
            sResult = "IOR:" + sResult;
            return sResult;
        }
        catch (Exception e) {
            Logger.traceError("ClientORB.object_to_string(org.omg.CORBA.Object)", Logger.exceptionTrace(e));
            Logger.logError("Object to string for " + obj + " failed.");
            return null;
        }
    }

    private byte getByteFromHex(String s, int off) {
        int i = 0;
        char ch = s.charAt(off);
        if (ch >= '0' && ch <= '9') {
            i = ch - 48 & 0xF;
        } else if (ch >= 'A' && ch <= 'Z') {
            i = ch - 65 + 10 & 0xF;
        } else if (ch >= 'a' && ch <= 'z') {
            i = ch - 97 + 10 & 0xF;
        } else {
            throw new DATA_CONVERSION("ID019089: Bad input parameter. Invalid hex.");
        }
        i <<= 4;
        ch = s.charAt(off + 1);
        if (ch >= '0' && ch <= '9') {
            i |= ch - 48 & 0xF;
        } else if (ch >= 'A' && ch <= 'Z') {
            i |= ch - 65 + 10 & 0xF;
        } else if (ch >= 'a' && ch <= 'z') {
            i |= ch - 97 + 10 & 0xF;
        } else {
            throw new DATA_CONVERSION("ID019090: Bad input parameter. Invalid hex.");
        }
        byte bRes = (byte)(i & 0xFF);
        return bRes;
    }

    private Object string_to_object_Addr(String addr, String keyString) {
        String host = "";
        String port = "";
        byte majorVersion = 1;
        byte minorVersion = 0;
        StringTokenizer tokenizer = new StringTokenizer(addr, ":");
        String token = tokenizer.nextToken();
        if (token.equals("rir")) {
            org.omg.CORBA.ORB orb = org.omg.CORBA.ORB.init();
            if (keyString.length() == 0) {
                keyString = NAME_SERVICE_NAME;
            }
            try {
                return orb.resolve_initial_references(keyString);
            }
            catch (Exception e) {
                Logger.traceError("ClientORB.string_to_object_Addr(String, String)", Logger.exceptionTrace(e));
                throw new BAD_PARAM("BAD RIR ADDRESS : " + e.getMessage(), 9, CompletionStatus.COMPLETED_NO);
            }
        }
        if (token.equals("iiop") || addr.startsWith(":")) {
            int verIndex;
            if (token.equals("iiop")) {
                token = tokenizer.nextToken();
            }
            if ((verIndex = token.indexOf(64)) > -1) {
                int dotIndex = token.indexOf(46);
                majorVersion = (byte)Integer.parseInt(token.substring(0, dotIndex));
                minorVersion = (byte)Integer.parseInt(token.substring(dotIndex + 1, verIndex));
                host = token.substring(verIndex + 1);
            } else {
                host = token;
            }
            port = tokenizer.hasMoreTokens() ? (token = tokenizer.nextToken()) : "900";
        }
        try {
            return this.resolve_initial_references(keyString, majorVersion, minorVersion, host, Integer.parseInt(port));
        }
        catch (Exception e) {
            Logger.traceError("ClientORB.string_to_object_Addr(String, String)", Logger.exceptionTrace(e));
            throw new BAD_PARAM("string_to_object() failed : " + e.getMessage(), 10, CompletionStatus.COMPLETED_NO);
        }
    }

    public Object string_to_object(String str) {
        if (str == null) {
            throw new BAD_PARAM("ID019091: Null input parameter.");
        }
        if (str.startsWith("IOR:")) {
            byte[] b_tmp = new byte[(str.length() - 4) / 2];
            int off = 4;
            int i = 0;
            while (i < b_tmp.length) {
                b_tmp[i] = this.getByteFromHex(str, off);
                off += 2;
                ++i;
            }
            CORBAInputStream is = new CORBAInputStream(this, b_tmp);
            IOR ior = new IOR((org.omg.CORBA.ORB)this);
            is.setEndian(is.read_boolean());
            return ior.read_object(is);
        }
        if (str.startsWith("corbaloc:")) {
            int slashInd = str.indexOf(47);
            String keyString = str.substring(slashInd + 1);
            String obj_adds = str.substring(9, slashInd);
            int komaIndex = obj_adds.indexOf(44);
            if (komaIndex == -1) {
                return this.string_to_object_Addr(obj_adds, keyString);
            }
            if (obj_adds.indexOf("rir") > -1) {
                StringTokenizer addToken = new StringTokenizer(obj_adds, ",");
                while (addToken.hasMoreTokens()) {
                    String addr = addToken.nextToken();
                    if (!addr.startsWith("rir")) continue;
                    return this.string_to_object_Addr(addr, keyString);
                }
            } else {
                StringTokenizer addToken = new StringTokenizer(obj_adds, ",");
                while (addToken.hasMoreTokens()) {
                    try {
                        return this.string_to_object_Addr(addToken.nextToken(), keyString);
                    }
                    catch (Exception e) {
                        if (!Logger.beDebug()) continue;
                        Logger.traceDebug("ClientORB.string_to_object(String)", Logger.exceptionTrace(e));
                    }
                }
            }
            throw new BAD_PARAM("BAD ADDRES : " + str, 8, CompletionStatus.COMPLETED_NO);
        }
        throw new BAD_PARAM("BAD SCHEMA NAME : " + str, 7, CompletionStatus.COMPLETED_NO);
    }

    public org.omg.CORBA.portable.OutputStream create_output_stream() {
        return new IIOPOutputStream(this);
    }

    public Delegate getDelegate(IOR ior) {
        return communicationLayer.getDelegate(ior);
    }

    public void shutdown(boolean com) {
        super.shutdown(com);
    }

    ORBInitializer[] registerORBInitializers(Properties props) {
        String orbInitPrefix = "org.omg.PortableInterceptor.ORBInitializerClass.";
        Enumeration<?> propertyNames = props.propertyNames();
        ArrayList<ORBInitializer> initializerList = new ArrayList<ORBInitializer>();
        while (propertyNames.hasMoreElements()) {
            String propertyName = (String)propertyNames.nextElement();
            if (!propertyName.startsWith(orbInitPrefix)) continue;
            String initClassName = propertyName.substring(orbInitPrefix.length());
            try {
                Class<?> initClass = null;
                try {
                    initClass = Class.forName(initClassName);
                }
                catch (Exception ex) {
                    if (Logger.beDebug()) {
                        Logger.traceDebug("ClientORB.registerORBInitializers(Properties)", Logger.exceptionTrace(ex));
                    }
                    ClassLoader tcxLoder = Thread.currentThread().getContextClassLoader();
                    initClass = Class.forName(initClassName, true, tcxLoder);
                }
                catch (NoClassDefFoundError ncdf) {
                    if (Logger.beDebug()) {
                        Logger.traceDebug("ClientORB.registerORBInitializers(Properties)", Logger.exceptionTrace(ncdf));
                    }
                    ClassLoader tcxLoder = Thread.currentThread().getContextClassLoader();
                    initClass = Class.forName(initClassName, true, tcxLoder);
                }
                if (!(class$org$omg$PortableInterceptor$ORBInitializer == null ? ClientORB.class$("org.omg.PortableInterceptor.ORBInitializer") : class$org$omg$PortableInterceptor$ORBInitializer).isAssignableFrom(initClass) || initClass == null) continue;
                ORBInitializer initializer = (ORBInitializer)initClass.newInstance();
                initializerList.add(initializer);
            }
            catch (Exception e) {
                Logger.traceError("ClientORB.registerORBInitializers(Properties)", Logger.exceptionTrace(e));
            }
        }
        if (initializerList.size() > 0) {
            return initializerList.toArray(new ORBInitializer[0]);
        }
        return null;
    }

    void preInitORBInitializers(ORBInitInfoImpl info, ORBInitializer[] orbInitializers) {
        info.setStage(0);
        int i = 0;
        while (i < orbInitializers.length) {
            ORBInitializer init = orbInitializers[i];
            if (init != null) {
                try {
                    init.pre_init((ORBInitInfo)info);
                }
                catch (Exception e) {
                    Logger.traceError("ClientORB.preInitORBInitializers(ORBInitInfoImpl, ORBInitializer[])", Logger.exceptionTrace(e));
                }
            }
            ++i;
        }
    }

    void postInitORBInitializers(ORBInitInfoImpl info, ORBInitializer[] orbInitializers) {
        info.setStage(1);
        int i = 0;
        while (i < orbInitializers.length) {
            ORBInitializer init = orbInitializers[i];
            if (init != null) {
                try {
                    init.post_init((ORBInitInfo)info);
                }
                catch (Exception e) {
                    Logger.traceError("ClientORB.postInitORBInitializers(ORBInitInfoImpl, ORBInitializer[])", Logger.exceptionTrace(e));
                }
            }
            ++i;
        }
    }

    public boolean is_local(byte[] key) {
        return table.get(key) != null;
    }

    public int getObjectCount() {
        return table.getSize();
    }

    public NameServiceHolder getNamingServant() {
        this.initCosNaming();
        return namingServant;
    }

    public boolean isServerORB() {
        return false;
    }

    protected NamingContext getCosNaming() {
        this.initCosNaming();
        return cosNaming;
    }

    protected void initCosNaming() {
    }

    protected Properties cutProperties(Properties props) {
        if (props != null) {
            Properties sysProps = System.getProperties();
            Properties mergeProps = (Properties)((Hashtable)props).clone();
            Enumeration<?> names = sysProps.propertyNames();
            while (names.hasMoreElements()) {
                String name = (String)names.nextElement();
                ((Hashtable)mergeProps).remove(name);
            }
            return mergeProps;
        }
        return new Properties();
    }

    public void dropdown() {
        idFac = null;
        communicationLayer = null;
        cosNaming = null;
        namingServant = null;
        table = null;
        codecFactory = null;
        corr = 0;
        this.piCurrent = null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        cosNaming = null;
        idFac = new IDFactory();
        table = null;
        codecFactory = null;
        hexDigits = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
        ORB_Host_Property = "org.omg.CORBA.ORBInitialHost";
        ORB_Port_Property = "org.omg.CORBA.ORBInitialPort";
    }
}

