/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.dispatcher;

import com.sap.engine.frame.CommunicationServiceContext;
import com.sap.engine.frame.CommunicationServiceFrame;
import com.sap.engine.frame.ServiceException;
import com.sap.engine.frame.cluster.ClusterElement;
import com.sap.engine.frame.cluster.balance.ApplicationDestination;
import com.sap.engine.frame.cluster.balance.Loadbalance;
import com.sap.engine.frame.cluster.message.ListenerAlreadyRegisteredException;
import com.sap.engine.frame.cluster.message.MessageAnswer;
import com.sap.engine.frame.cluster.message.MessageContext;
import com.sap.engine.frame.cluster.message.MessageListener;
import com.sap.engine.frame.cluster.monitor.ClusterMonitor;
import com.sap.engine.frame.cluster.session.CommunicationSessionContext;
import com.sap.engine.frame.container.event.ContainerEventListenerAdapter;
import com.sap.engine.interfaces.shell.Command;
import com.sap.engine.interfaces.shell.ShellInterface;
import com.sap.engine.lib.io.ObjectSerializer;
import com.sap.engine.lib.lang.Convert;
import com.sap.engine.lib.lang.ConvertTools;
import com.sap.engine.lib.util.ConcurrentHashMapIntInt;
import com.sap.engine.services.iiop.core.MessageConstants;
import com.sap.engine.services.iiop.dispatcher.CorbaSessionProcessor;
import com.sap.engine.services.iiop.dispatcher.command.DumpStreamsCommand;
import com.sap.engine.services.iiop.logging.EngineLogger;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.tc.logging.Location;
import java.io.IOException;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Properties;

public class CorbaServiceFrame
extends ContainerEventListenerAdapter
implements CommunicationServiceFrame,
MessageListener,
MessageConstants {
    public static boolean DEBUG_SERVICE_FRAME = false;
    public static final int DEFAULT_PORT = 3333;
    public static final int DEFAULT_INIT_PORT = 5321;
    public static final String INTERFACE_SHELL = "shell";
    public int listenerPort = 3333;
    public int listenerInitPort = 5321;
    private CommunicationServiceContext sdc = null;
    private ConvertTools ct = new ConvertTools(false);
    protected CommunicationSessionContext sessionContext;
    protected CorbaSessionProcessor sessionProcessor;
    protected static ConcurrentHashMapIntInt connIDHolder = new ConcurrentHashMapIntInt();
    protected static Hashtable connections = new Hashtable();
    protected static MessageContext msgContext = null;
    protected static ClusterMonitor clusterMonitor = null;
    private static Loadbalance loadBalance = null;
    private static int loadBalanceId = -1;
    private static int sslPort = 0;
    private String separator = ":";

    public void start(CommunicationServiceContext _sdc) throws ServiceException {
        Properties sp = _sdc.getServiceState().getProperties();
        this.sdc = _sdc;
        this.sessionContext = _sdc.getClusterContext().getCommunicationSessionContext();
        msgContext = _sdc.getClusterContext().getMessageContext();
        clusterMonitor = _sdc.getClusterContext().getClusterMonitor();
        loadBalance = this.sdc.getClusterContext().getLoadbalanceContext();
        Logger.logLocation = Location.getLocation((String)this.getClass().getPackage().getName());
        Logger.theLogger = new EngineLogger();
        String port = sp.getProperty("port");
        if (port != null) {
            try {
                this.listenerPort = Integer.parseInt(port);
            }
            catch (NumberFormatException nfe) {
                Logger.traceError("CorbaServiceFrame.start(CommunicationServiceContext)", Logger.exceptionTrace(nfe));
                String messageWithId = "ID019083: <Corba Service>: Incorect port value: \"port\" " + port + " in the property file";
                throw new ServiceException(messageWithId);
            }
            this.listenerPort = this.listenerPort == 0 ? 3333 : this.listenerPort;
        }
        try {
            this.sessionContext.openServerSocket(this.listenerPort, "", 500, 5);
        }
        catch (IOException io) {
            Logger.traceError("CorbaServiceFrame.start(CommunicationServiceContext)", Logger.exceptionTrace(io));
            String messageWithId = "ID019084: <Corba Service>: Can't open  server socket.";
            throw new ServiceException(messageWithId);
        }
        String initialContextPort = sp.getProperty("initialContextPort");
        if (initialContextPort != null) {
            try {
                this.listenerInitPort = Integer.parseInt(initialContextPort);
            }
            catch (NumberFormatException nfe) {
                Logger.traceError("CorbaServiceFrame.start(CommunicationServiceContext)", Logger.exceptionTrace(nfe));
                String messageWithId = "ID019085: <Corba Service>: Incorect initialContextPort value: \"listenerInitPort\" " + this.listenerInitPort + "  in the property file";
                throw new ServiceException(messageWithId);
            }
            this.listenerInitPort = this.listenerInitPort == 0 ? 5321 : this.listenerInitPort;
        }
        try {
            this.sessionContext.openServerSocket(this.listenerInitPort, "");
        }
        catch (IOException io) {
            Logger.traceError("CorbaServiceFrame.start(CommunicationServiceContext)", Logger.exceptionTrace(io));
            String messageWithId = "ID019086: <Corba Service>: Can't open  server socket.";
            throw new ServiceException(messageWithId);
        }
        String sslp = sp.getProperty("ssl_socket");
        if (sslp != null) {
            try {
                try {
                    sslPort = Integer.parseInt(sslp);
                }
                catch (NumberFormatException nfe) {
                    sslPort = 0;
                }
                sslPort = this.sessionContext.openServerSocket(sslPort, "ssl");
            }
            catch (Exception io) {
                Logger.traceError("CorbaServiceFrame.start(CommunicationServiceContext)", Logger.exceptionTrace(io));
                String messageWithId = "ID019087: <Corba Service>: Can't open SSL server socket.";
                throw new ServiceException(messageWithId);
            }
        }
        try {
            msgContext.registerListener(this);
        }
        catch (Exception ex) {
            Logger.traceError("CorbaServiceFrame.start(CommunicationServiceContext)", Logger.exceptionTrace(ex));
        }
        this.sessionProcessor = new CorbaSessionProcessor(this.listenerInitPort);
        try {
            this.sessionContext.registerProcessor(this.sessionProcessor);
        }
        catch (ListenerAlreadyRegisteredException e) {
            Logger.traceError("CorbaServiceFrame.start(CommunicationServiceContext)", Logger.exceptionTrace((Throwable)((Object)e)));
        }
        int mask = 64;
        HashSet<String> names = new HashSet<String>(1);
        names.add(INTERFACE_SHELL);
        this.sdc.getServiceState().registerContainerEventListener(mask, names, this);
        ConcurrentHashMapIntInt servers = new ConcurrentHashMapIntInt();
        ClusterElement[] ci = clusterMonitor.getServiceNodes();
        int i = 0;
        while (i < ci.length) {
            if (ci[i].getType() == 2) {
                servers.put(ci[i].getClusterId(), ci[i].getClusterId());
            }
            ++i;
        }
        ApplicationDestination destination = new ApplicationDestination(servers.getAllKeys());
        loadBalanceId = loadBalance.registerConsumer("iiop", destination, "iiop");
    }

    public void stop() {
        this.sessionContext.unregisterProcessor();
        try {
            this.sessionContext.closeServerSocket(this.listenerInitPort);
        }
        catch (Exception ex) {
            Logger.traceError("CorbaServiceFrame.stop() Error while closing server socket on port: " + this.listenerInitPort, Logger.exceptionTrace(ex));
        }
        try {
            this.sessionContext.closeServerSocket(this.listenerPort);
        }
        catch (Exception e) {
            Logger.traceError("CorbaServiceFrame.stop() Error while closing server socket on port: " + this.listenerInitPort, Logger.exceptionTrace(e));
        }
        try {
            this.sessionContext.closeServerSocket(sslPort);
        }
        catch (Exception e) {
            Logger.traceError("CorbaServiceFrame.stop() Error while closing server socket on port: " + this.listenerInitPort, Logger.exceptionTrace(e));
        }
        msgContext.unregisterListener();
        this.sdc.getServiceState().unregisterContainerEventListener();
    }

    public void interfaceAvailable(String interfaceName, Object interfaceImpl) {
        if (interfaceName.equals(INTERFACE_SHELL)) {
            ShellInterface shell = (ShellInterface)interfaceImpl;
            shell.registerCommands(new Command[]{new DumpStreamsCommand(this.sessionProcessor)});
        }
    }

    public boolean changeProperties(Properties props) throws IllegalArgumentException {
        return true;
    }

    public void receive(int clusterId, int messageId, byte[] message, int off, int len) {
        try {
            byte b = message[off];
            byte[] ior = new byte[len - b - 1 + 4];
            System.arraycopy(message, 1 + off + b, ior, 4, ior.length - 4);
            Convert.writeIntToByteArr(ior, 0, ior.length - 4);
            this.sessionProcessor.initialCtx.put(clusterId + this.separator + Convert.byteArrToUString(message, off + 1, b / 2), ior);
        }
        catch (Exception e) {
            Logger.traceError("CorbaServiceFrame.receive(int, int, byte[], int, int)", Logger.exceptionTrace(e));
        }
    }

    public MessageAnswer receiveWait(int clusterId, int messageId, byte[] message, int off, int len) {
        byte[] no_answer;
        byte[] answer = no_answer = new byte[0];
        switch (messageId) {
            case 20: {
                String s = "@" + clusterMonitor.getCurrentParticipant().getAddress().getHostAddress() + this.separator + this.listenerPort;
                try {
                    answer = ObjectSerializer.getByteArray(new String[]{s});
                }
                catch (Exception ex) {
                    answer = no_answer;
                }
                break;
            }
            case 25: {
                String s = "@" + clusterMonitor.getCurrentParticipant().getAddress().getHostAddress() + this.separator + sslPort;
                try {
                    answer = ObjectSerializer.getByteArray(new String[]{s});
                }
                catch (Exception ex) {
                    answer = no_answer;
                }
                break;
            }
            case 4011: {
                try {
                    int port = this.ct.arrToInt(message, off);
                    String host = new String(message, off + 4, len - 4);
                    String id = clusterId + this.separator + host + this.separator + port;
                    Integer cashValue = (Integer)connections.get(id);
                    int conId = 0;
                    if (cashValue == null) {
                        conId = this.sessionContext.openSocket(host, port, "ssl");
                        connections.put(id, new Integer(conId));
                    } else {
                        conId = cashValue;
                    }
                    connIDHolder.put(conId, clusterId);
                    answer = this.ct.intToArr(conId);
                }
                catch (Exception e) {
                    Logger.traceError("CorbaServiceFrame.receiveWait(int, int, byte[], int, int)", Logger.exceptionTrace(e));
                }
                break;
            }
            case 40: {
                int port = 0;
                String host = null;
                try {
                    port = this.ct.arrToInt(message, off);
                    host = new String(message, off + 4, len - 4);
                    String id = clusterId + this.separator + host + this.separator + port;
                    Integer cashValue = (Integer)connections.get(id);
                    int conId = 0;
                    if (cashValue == null) {
                        conId = this.sessionContext.openSocket(host, port, "");
                        connections.put(id, new Integer(conId));
                    } else {
                        conId = cashValue;
                    }
                    connIDHolder.put(conId, clusterId);
                    answer = this.ct.intToArr(conId);
                    Logger.traceDebug("CorbaServiceFrame.receiveWait(int, int, byte[], int, int)", "An object onnected to : " + host + ":" + port + " . Connection ID : " + conId);
                }
                catch (Exception e) {
                    Logger.traceError("CorbaServiceFrame.receiveWait(int, int, byte[], int, int)", "Exception while connecting to " + host + ":" + port + "\n" + Logger.exceptionTrace(e));
                }
                break;
            }
        }
        return new MessageAnswer(answer, 0, answer.length);
    }

    public static int getLessBusyElement() {
        return loadBalance.getLessBusyElement(loadBalanceId);
    }
}

