/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.csiv2.interceptors;

import com.sap.engine.frame.client.ClientException;
import com.sap.engine.frame.client.ClientFactory;
import com.sap.engine.interfaces.csiv2.SAS_ContextSec;
import com.sap.engine.interfaces.csiv2.SimpleProfileInterface;
import com.sap.engine.interfaces.security.SecurityContextObject;
import com.sap.engine.services.iiop.CORBA.portable.CORBAInputStream;
import com.sap.engine.services.iiop.csiv2.CSI.IdentityToken;
import com.sap.engine.services.iiop.csiv2.CSIIOP.TLS_SEC_TRANS;
import com.sap.engine.services.iiop.csiv2.CSIIOP.TLS_SEC_TRANSHelper;
import com.sap.engine.services.iiop.csiv2.interceptors.ClientInterceptor;
import com.sap.engine.services.iiop.logging.Logger;
import javax.security.auth.Subject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;
import org.omg.IOP.Codec;

public class AppclientInterceptor
extends ClientInterceptor {
    public AppclientInterceptor(ORB orb, Codec codec) {
        super(orb, codec);
    }

    protected SecurityContextObject getCurrentSecurityContext() {
        try {
            return (SecurityContextObject)((Object)ClientFactory.getThreadContextFactory().getThreadContext().getContextObject("security"));
        }
        catch (ClientException e) {
            Logger.traceError("AppclientInterceptor.getCurrentSecurityContext()", Logger.exceptionTrace((Throwable)((Object)e)));
            return null;
        }
    }

    protected IdentityToken createIdentityToken(Subject subject, SAS_ContextSec sasContext, SimpleProfileInterface transportMech) {
        if (transportMech != null && transportMech.getTag() == 36) {
            byte[] transportData = transportMech.getData();
            CORBAInputStream inputStream = new CORBAInputStream(transportData);
            boolean endian = inputStream.read_boolean();
            inputStream.setEndian(endian);
            TLS_SEC_TRANS transport = TLS_SEC_TRANSHelper.read((InputStream)inputStream);
            if ((transport.target_requires & 0x40) == 64) {
                return new IdentityToken();
            }
        }
        return super.createIdentityToken(subject, sasContext, transportMech);
    }
}

