/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.csiv2;

import com.sap.engine.interfaces.csiv2.AS_ContextSec;
import com.sap.engine.interfaces.csiv2.EJBIORGeneratorInterface;
import com.sap.engine.interfaces.csiv2.IORDescriptor;
import com.sap.engine.interfaces.csiv2.SAS_ContextSec;
import com.sap.engine.interfaces.csiv2.ServiceConfiguration;
import com.sap.engine.interfaces.csiv2.SimpleProfileInterface;
import com.sap.engine.services.iiop.CORBA.IOR;
import com.sap.engine.services.iiop.CORBA.ORB;
import com.sap.engine.services.iiop.CORBA.Profile;
import com.sap.engine.services.iiop.CORBA.SimpleProfile;
import com.sap.engine.services.iiop.CORBA.portable.DelegateImpl;
import com.sap.engine.services.iiop.csiv2.CSIIOP.CompoundSecMech;
import com.sap.engine.services.iiop.csiv2.CSIIOP.CompoundSecMechList;
import com.sap.engine.services.iiop.csiv2.CSIIOP.CompoundSecMechListHelper;
import com.sap.engine.services.iiop.csiv2.CSIIOP.TLS_SEC_TRANS;
import com.sap.engine.services.iiop.csiv2.CSIIOP.TLS_SEC_TRANSHelper;
import com.sap.engine.services.iiop.csiv2.CSIIOP.TransportAddress;
import com.sap.engine.services.iiop.csiv2.GSSUP.GSSUtils;
import com.sap.engine.services.iiop.internal.portable.IIOPInputStream;
import com.sap.engine.services.iiop.internal.portable.IIOPOutputStream;
import com.sap.engine.services.iiop.logging.Logger;
import java.io.IOException;
import java.rmi.Remote;
import java.util.Vector;
import javax.rmi.CORBA.Util;
import javax.rmi.PortableRemoteObject;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.CORBA.portable.OutputStream;

public class EJBIORGenerator
implements EJBIORGeneratorInterface {
    public static final int SUPPORTED_IDENTITY_TOKEN_TYPES = 15;
    private org.omg.CORBA.ORB orb = null;
    private int sslPort = 684;
    private int mutualsslPort = 684;
    private String host_name = "127.0.0.1";

    public EJBIORGenerator(org.omg.CORBA.ORB orb) {
        this.orb = orb;
    }

    public void resetHostAndPort(Vector sslAddress) {
        if (sslAddress != null) {
            this.host_name = (String)sslAddress.elementAt(0);
            this.mutualsslPort = this.sslPort = ((Integer)sslAddress.elementAt(1)).intValue();
        }
    }

    public SimpleProfileInterface generateSecurityTaggedComponent(IORDescriptor[] desc) {
        if (desc == null || desc.length == 0) {
            return null;
        }
        try {
            CompoundSecMech[] mechList = this.createCompoundSecMechs(desc);
            SimpleProfileInterface sp = this.createTaggedComponent(mechList);
            return sp;
        }
        catch (Exception e) {
            Logger.traceError("EJBIORGenerator.generateSecurityTaggedComponent(IORDescriptor[])", Logger.exceptionTrace(e));
            return null;
        }
    }

    public void addTaggedComponent(PortableRemoteObject pro, SimpleProfileInterface profile) {
        ObjectImpl obj = (ObjectImpl)Util.getTie((Remote)((Remote)pro));
        if (obj != null) {
            this.orb.connect((Object)obj);
            DelegateImpl delegate = (DelegateImpl)obj._get_delegate();
            IOR info = delegate.getIOR();
            Profile theProfile = info.getProfile();
            theProfile.addSimpleProfile(profile);
            if (this.sslRequired(profile)) {
                theProfile.setPort(0);
            }
        }
    }

    private SimpleProfileInterface createTaggedComponent(CompoundSecMech[] mechList) {
        IIOPOutputStream out = new IIOPOutputStream((ORB)this.orb);
        out.setEndian(false);
        out.write_boolean(false);
        boolean stateful = false;
        CompoundSecMechList list = new CompoundSecMechList(stateful, mechList);
        CompoundSecMechListHelper.write((OutputStream)out, list);
        byte[] buf = out.toByteArray();
        SimpleProfile sp = new SimpleProfile(33, buf);
        return sp;
    }

    private CompoundSecMech[] createCompoundSecMechs(IORDescriptor[] desc) throws IOException {
        CompoundSecMech[] mechList = new CompoundSecMech[desc.length];
        int i = 0;
        while (i < desc.length) {
            int target_requires = this.getTargetRequires(desc[i]);
            SimpleProfileInterface transportMech = this.createSSLInfo(desc[i]);
            AS_ContextSec asContext = this.createASContextSec(desc[i]);
            SAS_ContextSec sasContext = this.createSASContextSec(desc[i]);
            int targ_req = target_requires | asContext.target_requires | sasContext.target_requires;
            mechList[i] = new CompoundSecMech((short)targ_req, transportMech, asContext, sasContext);
            ++i;
        }
        return mechList;
    }

    public AS_ContextSec createASContextSec(IORDescriptor iorDesc) throws IOException {
        AS_ContextSec asContext = null;
        int target_supports = 0;
        int target_requires = 0;
        byte[] client_authentication_mechanism = new byte[]{};
        byte[] target_name = new byte[]{};
        String authMethod = null;
        boolean authMethodRequired = false;
        if (iorDesc != null) {
            authMethod = iorDesc.getAuthenticationMethod();
            authMethodRequired = iorDesc.isAuthMethodRequired();
        }
        if (authMethodRequired && authMethod != null) {
            if (authMethod.equals("none")) {
                asContext = new AS_ContextSec((short)target_supports, (short)target_requires, client_authentication_mechanism, target_name);
                return asContext;
            }
            client_authentication_mechanism = this.getMechanism();
            target_name = GSSUtils.createExportedName(GSSUtils.GSSUP_MECH_OID, "default".getBytes());
            target_supports = 64;
            target_requires = 64;
        }
        asContext = new AS_ContextSec((short)target_supports, (short)target_requires, client_authentication_mechanism, target_name);
        return asContext;
    }

    public SAS_ContextSec createSASContextSec(IORDescriptor iorDesc) throws IOException {
        SAS_ContextSec sasContext = null;
        int target_supports = 0;
        boolean target_requires = false;
        ServiceConfiguration[] priv = new ServiceConfiguration[]{};
        String callerPropagation = null;
        java.lang.Object mechanisms = new byte[][]{};
        int supported_identity_token_type = 0;
        if (iorDesc != null) {
            callerPropagation = iorDesc.getCallerPropagation();
        }
        if (callerPropagation != null) {
            if (callerPropagation.equals("none")) {
                sasContext = new SAS_ContextSec((short)target_supports, (short)(target_requires ? 1 : 0), priv, (byte[][])mechanisms, supported_identity_token_type);
                return sasContext;
            }
            target_supports = 1024;
            byte[] upm = this.getMechanism();
            mechanisms = new byte[1][upm.length];
            int i = 0;
            while (i < upm.length) {
                mechanisms[0][i] = upm[i];
                ++i;
            }
            if (target_supports != 0) {
                supported_identity_token_type = 15;
            }
        }
        sasContext = new SAS_ContextSec((short)target_supports, (short)(target_requires ? 1 : 0), priv, (byte[][])mechanisms, supported_identity_token_type);
        return sasContext;
    }

    private SimpleProfileInterface createSSLInfo(IORDescriptor iorDesc) {
        int port = this.sslPort;
        int targetSupports = 0;
        int targetRequires = 0;
        if (iorDesc == null) {
            targetSupports = 102;
        } else {
            targetSupports = this.getTargetSupports(iorDesc);
            targetRequires = this.getTargetRequires(iorDesc);
            if ((targetRequires & 0x40) == 64) {
                port = this.mutualsslPort;
            }
        }
        if ((targetSupports | targetRequires) == 0) {
            byte[] b = new byte[]{};
            SimpleProfile sp = new SimpleProfile(34, b);
            return sp;
        }
        TransportAddress[] listTa = this.generateTransportAddresses(this.host_name, port);
        TLS_SEC_TRANS tls_sec = new TLS_SEC_TRANS((short)targetSupports, (short)targetRequires, listTa);
        IIOPOutputStream out = new IIOPOutputStream((ORB)this.orb);
        out.setEndian(true);
        out.write_boolean(true);
        TLS_SEC_TRANSHelper.write((OutputStream)out, tls_sec);
        byte[] buf = out.toByteArray();
        SimpleProfile tc = new SimpleProfile(36, buf);
        return tc;
    }

    private TransportAddress[] generateTransportAddresses(String host, int sslport) {
        TransportAddress ta = new TransportAddress(host, sslport);
        TransportAddress[] listTa = new TransportAddress[]{ta};
        return listTa;
    }

    public int getTargetSupports(IORDescriptor iorDesc) {
        String establishTrustInClient;
        String establishTrustInTarget;
        String confidentiality;
        if (iorDesc == null) {
            return 0;
        }
        int supports = 0;
        String integrity = iorDesc.getIntegrity();
        if (!integrity.equals("none")) {
            supports |= 2;
        }
        if (!(confidentiality = iorDesc.getConfidentiality()).equals("none")) {
            supports |= 4;
        }
        if (!(establishTrustInTarget = iorDesc.getEstablishTrustInTarget()).equals("none")) {
            supports |= 0x20;
        }
        if (!(establishTrustInClient = iorDesc.getEstablishTrustInClient()).equals("none")) {
            supports |= 0x40;
        }
        return supports;
    }

    public int getTargetRequires(IORDescriptor iorDesc) {
        String establishTrustInClient;
        String establishTrustInTarget;
        String confidentiality;
        if (iorDesc == null) {
            return 0;
        }
        int requires = 0;
        String integrity = iorDesc.getIntegrity();
        if (integrity.equals("required")) {
            requires |= 2;
        }
        if ((confidentiality = iorDesc.getConfidentiality()).equals("required")) {
            requires |= 4;
        }
        if ((establishTrustInTarget = iorDesc.getEstablishTrustInTarget()).equals("required")) {
            requires |= 0x20;
        }
        if ((establishTrustInClient = iorDesc.getEstablishTrustInClient()).equals("required")) {
            requires |= 0x40;
        }
        return requires;
    }

    private byte[] getMechanism() throws IOException {
        return GSSUtils.getDER(GSSUtils.GSSUP_MECH_OID);
    }

    private boolean sslRequired(SimpleProfileInterface taggedComponent) {
        byte[] taggedData = taggedComponent.getData();
        IIOPInputStream stream = new IIOPInputStream(taggedData);
        CompoundSecMech[] list = CompoundSecMechListHelper.read((InputStream)stream).mechanism_list;
        if (list == null || list.length == 0) {
            return false;
        }
        SimpleProfileInterface transportMech = list[0].transport_mech;
        if (transportMech.getTag() == 34) {
            return false;
        }
        if (transportMech.getTag() == 36) {
            byte[] transportData = transportMech.getData();
            IIOPInputStream inputStream = new IIOPInputStream(transportData);
            boolean endian = inputStream.read_boolean();
            inputStream.setEndian(endian);
            TLS_SEC_TRANS transport = TLS_SEC_TRANSHelper.read((InputStream)inputStream);
            return (transport.target_requires & 6) != 0;
        }
        return false;
    }
}

