/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.client.portable.weak;

import com.sap.engine.services.iiop.client.portable.weak.ObjectList;
import java.lang.ref.WeakReference;

public class WeakStorrage {
    private static int hashIndex = 11;
    private ObjectList[] cacheStore;

    public WeakStorrage() {
        this.init();
    }

    public WeakStorrage(int hashIndex) {
        WeakStorrage.hashIndex = hashIndex > 0 ? hashIndex : 1;
        this.init();
    }

    private void init() {
        this.cacheStore = new ObjectList[hashIndex];
    }

    public void put(WeakReference object) {
        int id = System.identityHashCode(object);
        int index = id % hashIndex;
        if (this.cacheStore[index] != null) {
            this.cacheStore[index].put(object);
        } else {
            this.cacheStore[index] = new ObjectList(object);
        }
    }

    public void remove(WeakReference object) {
        int id = System.identityHashCode(object);
        int index = id % hashIndex;
        if (this.cacheStore[index] != null) {
            this.cacheStore[index].remove(object);
        }
    }

    public boolean contains(Object object) {
        int id = System.identityHashCode(object);
        int index = id % hashIndex;
        boolean res = false;
        if (this.cacheStore[index] != null) {
            res = this.cacheStore[index].contains(object);
        }
        return res;
    }

    public WeakReference[] toArray() {
        int all = 0;
        int i = 0;
        while (i < this.cacheStore.length) {
            all += this.cacheStore[i].size();
            ++i;
        }
        WeakReference[] result = new WeakReference[all];
        int start = 0;
        int i2 = 0;
        while (i2 < this.cacheStore.length) {
            System.arraycopy(this.cacheStore[i2].toArray(), 0, result, start, this.cacheStore[i2].size());
            start += this.cacheStore[i2].size();
            ++i2;
        }
        return result;
    }
}

