/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.client;

import com.sap.engine.services.iiop.CORBA.GIOPMessageConstants;
import com.sap.engine.services.iiop.internal.giop.ConnectionParser;
import com.sap.engine.services.iiop.internal.giop.OutgoingMessage;
import com.sap.engine.services.iiop.logging.Logger;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class Connection
implements Runnable,
GIOPMessageConstants {
    Socket socket;
    InputStream in;
    OutputStream out;
    ConnectionParser parser;
    byte[] header = new byte[12];

    public Connection(Socket socket) throws IOException {
        this.socket = socket;
        this.in = socket.getInputStream();
        this.out = socket.getOutputStream();
        this.parser = new ConnectionParser();
    }

    public void send(byte[] data, int pos, int len) throws IOException {
        this.out.write(data, pos, len);
        this.out.flush();
    }

    public void send(byte[] data) throws IOException {
        this.send(data, 0, data.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void run() {
        try {
            while (true) {
                int readed = 0;
                while ((readed += this.in.read(this.header, readed, this.header.length - readed)) != -1 && readed < this.header.length) {
                }
                if (readed == -1) {
                    return;
                }
                byte minorVersion = this.header[5];
                byte endian = this.header[6];
                if (minorVersion != 0) {
                    endian = (byte)(endian & 1);
                }
                int msgSize = 0;
                if (endian == 0) {
                    msgSize = this.header[8] << 24 & 0xFF000000;
                    msgSize |= this.header[9] << 16 & 0xFF0000;
                    msgSize |= this.header[10] << 8 & 0xFF00;
                    msgSize |= this.header[11] & 0xFF;
                } else {
                    msgSize = this.header[8] & 0xFF;
                    msgSize |= this.header[9] << 8 & 0xFF00;
                    msgSize |= this.header[10] << 16 & 0xFF0000;
                    msgSize |= this.header[11] << 24 & 0xFF000000;
                }
                byte[] request = new byte[msgSize + 12];
                System.arraycopy(this.header, 0, request, 0, 12);
                while ((readed += this.in.read(request, readed, request.length - readed)) != -1 && readed < request.length) {
                }
                if (readed == -1) {
                    return;
                }
                if (request[7] == 0 || request[7] == 3 || request[7] == 7 && (request[6] & 2) == 0) {
                    new Thread(new RequestProcessor(this.out, request)).start();
                    continue;
                }
                OutgoingMessage outMessage = this.parser.readMessage(request);
                if (outMessage == null || !outMessage.forSend()) continue;
                OutputStream outputStream = this.out;
                synchronized (outputStream) {
                    try {
                        this.out.write(outMessage.toByteArray());
                        this.out.flush();
                    }
                    catch (Exception e) {
                        Logger.logError("Connection lost....\n" + Logger.exceptionTrace(e));
                    }
                }
            }
        }
        catch (Exception e) {
            Logger.logError("Connection lost....\n" + Logger.exceptionTrace(e));
            return;
        }
    }

    private class RequestProcessor
    implements Runnable {
        private OutputStream out;
        private byte[] request;

        public RequestProcessor(OutputStream out, byte[] request) {
            this.out = out;
            this.request = request;
        }

        public void run() {
            OutgoingMessage outMessage = Connection.this.parser.readMessage(this.request);
            if (outMessage != null && outMessage.forSend()) {
                OutputStream outputStream = this.out;
                synchronized (outputStream) {
                    try {
                        this.out.write(outMessage.toByteArray_forSend(), 0, outMessage.byteArray_forSend_length());
                        this.out.flush();
                    }
                    catch (Exception e) {
                        Logger.logError("Connection lost....\n" + Logger.exceptionTrace(e));
                    }
                }
            }
        }
    }
}

