/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.client;

import com.sap.engine.interfaces.csiv2.SSLSocketProvider;
import com.sap.engine.interfaces.csiv2.SimpleProfileInterface;
import com.sap.engine.services.iiop.CORBA.IOR;
import com.sap.engine.services.iiop.CORBA.Profile;
import com.sap.engine.services.iiop.CORBA.portable.CORBAInputStream;
import com.sap.engine.services.iiop.client.Connection;
import com.sap.engine.services.iiop.client.portable.Delegate;
import com.sap.engine.services.iiop.client.portable.Delegate_1_0;
import com.sap.engine.services.iiop.client.portable.Delegate_1_1;
import com.sap.engine.services.iiop.client.portable.Delegate_1_2;
import com.sap.engine.services.iiop.csiv2.CSIIOP.CompoundSecMech;
import com.sap.engine.services.iiop.csiv2.CSIIOP.CompoundSecMechListHelper;
import com.sap.engine.services.iiop.csiv2.CSIIOP.SSL;
import com.sap.engine.services.iiop.csiv2.CSIIOP.SSLHelper;
import com.sap.engine.services.iiop.csiv2.CSIIOP.TLS_SEC_TRANS;
import com.sap.engine.services.iiop.csiv2.CSIIOP.TLS_SEC_TRANSHelper;
import com.sap.engine.services.iiop.csiv2.CSIIOP.TransportAddress;
import com.sap.engine.services.iiop.logging.Logger;
import com.sap.engine.services.iiop.system.CommunicationLayer;
import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.Hashtable;
import org.omg.CORBA.ORB;
import org.omg.CORBA.portable.InputStream;

public class CommunicationLayerImpl
extends CommunicationLayer
implements Runnable {
    String[] urls;
    ServerSocket listenterServerSocket;
    ServerSocket listenterSSLServerSocket;
    SSLSocketProvider sslProvider = null;
    int sslPort;
    boolean sslThread = false;
    private Hashtable connectionHash = new Hashtable();
    static /* synthetic */ Class class$java$lang$String;

    public CommunicationLayerImpl() {
        try {
            this.listenterServerSocket = new ServerSocket(0);
        }
        catch (IOException e) {
            Logger.logError(Logger.exceptionTrace(e));
        }
        try {
            this.urls = new String[]{"@" + InetAddress.getLocalHost().getHostAddress() + ":" + this.listenterServerSocket.getLocalPort()};
        }
        catch (UnknownHostException e) {
            Logger.logError(Logger.exceptionTrace(e));
        }
        Thread thisThread = new Thread(this);
        thisThread.setDaemon(true);
        thisThread.start();
    }

    public void setSSLProvider(String sslProviderClass, String[] sslProviderParams) {
        if (sslProviderClass != null) {
            try {
                this.sslProvider = sslProviderParams == null ? (SSLSocketProvider)Class.forName(sslProviderClass).newInstance() : (SSLSocketProvider)Class.forName(sslProviderClass).getConstructor(class$java$lang$String == null ? (class$java$lang$String = CommunicationLayerImpl.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = CommunicationLayerImpl.class$("java.lang.String")) : class$java$lang$String).newInstance(sslProviderParams);
            }
            catch (Throwable t) {
                Logger.logError(Logger.exceptionTrace(t));
            }
        }
    }

    public org.omg.CORBA.portable.Delegate getDelegate(IOR ior) {
        int port;
        String host;
        Delegate delegate;
        block18: {
            boolean useSSL;
            Profile profile = ior.getProfile();
            delegate = null;
            Connection con = null;
            boolean bl = useSSL = profile.getPort() == 0;
            if (useSSL) {
                TransportAddress sslAddress = this.parseSSLTransportAddress(profile);
                host = sslAddress.host_name;
                port = sslAddress.port;
            } else {
                host = profile.getHost();
                port = profile.getPort();
            }
            StringBuffer sb = new StringBuffer(host);
            sb.append(port);
            String key = sb.toString();
            try {
                if (this.connectionHash.containsKey(key)) {
                    con = (Connection)this.connectionHash.get(key);
                    break block18;
                }
                CommunicationLayerImpl communicationLayerImpl = this;
                synchronized (communicationLayerImpl) {
                    if (this.connectionHash.containsKey(key)) {
                        con = (Connection)this.connectionHash.get(key);
                    } else if (useSSL) {
                        if (this.sslProvider != null) {
                            con = new Connection(this.sslProvider.getSSLClientSocket(host, port));
                            Thread connthr = new Thread(con);
                            connthr.setDaemon(true);
                            connthr.start();
                            this.connectionHash.put(key, con);
                        }
                    } else {
                        con = new Connection(new Socket(host, port));
                        Thread connthr = new Thread(con);
                        connthr.setDaemon(true);
                        connthr.start();
                        this.connectionHash.put(key, con);
                    }
                }
            }
            catch (Exception e) {
                Logger.logError(Logger.exceptionTrace(e));
            }
        }
        byte versionMinor = ior.getProfile().getVersionMinor();
        switch (versionMinor) {
            case 0: {
                delegate = new Delegate_1_0((ORB)CommunicationLayer.orb, ior);
                break;
            }
            case 1: {
                delegate = new Delegate_1_1((ORB)CommunicationLayer.orb, ior);
                break;
            }
            case 2: {
                delegate = new Delegate_1_2((ORB)CommunicationLayer.orb, ior);
                break;
            }
            default: {
                delegate = new Delegate_1_0((ORB)CommunicationLayer.orb, ior);
            }
        }
        delegate.sender = this;
        delegate.setHostPort(host, port);
        return delegate;
    }

    public String[] getURL() {
        return this.urls;
    }

    public void send(byte[] data, String host, int port) throws IOException {
        this.send(data, 0, data.length, host, port);
    }

    public void send(byte[] data, int pos, int len, String host, int port) throws IOException {
        Connection con;
        StringBuffer sb = new StringBuffer(host);
        sb.append(port);
        String key = sb.toString();
        if (this.connectionHash.containsKey(key)) {
            con = (Connection)this.connectionHash.get(key);
        } else {
            con = new Connection(new Socket(host, port));
            Thread thread = new Thread(con);
            thread.setDaemon(true);
            thread.start();
            this.connectionHash.put(key, con);
        }
        con.send(data, pos, len);
    }

    public int openSSLServerSocket(int port) throws IOException {
        if (this.listenterSSLServerSocket == null) {
            this.listenterSSLServerSocket = this.sslProvider.getSSLServerSocket(port);
            this.sslPort = this.listenterSSLServerSocket.getLocalPort();
            if (this.listenterSSLServerSocket != null) {
                Thread thisThread = new Thread(this);
                thisThread.setDaemon(true);
                thisThread.start();
            }
        }
        return this.sslPort;
    }

    private TransportAddress parseSSLTransportAddress(Profile profile) {
        SimpleProfileInterface[] simpleProfiles = profile.getComponents();
        SimpleProfileInterface taggedComponent = null;
        int i = 0;
        while (i < simpleProfiles.length) {
            if (simpleProfiles[i].getTag() == 33) {
                taggedComponent = simpleProfiles[i];
                break;
            }
            if (simpleProfiles[i].getTag() == 20) {
                taggedComponent = simpleProfiles[i];
                break;
            }
            ++i;
        }
        if (taggedComponent == null) {
            return null;
        }
        if (taggedComponent.getTag() == 20) {
            CORBAInputStream stream = new CORBAInputStream(taggedComponent.getData());
            stream.setEndian(stream.read_boolean());
            SSL sslComp = SSLHelper.read((InputStream)stream);
            return new TransportAddress(profile.getHost(), sslComp.port);
        }
        CORBAInputStream stream = new CORBAInputStream(taggedComponent.getData());
        stream.setEndian(stream.read_boolean());
        CompoundSecMech[] list = CompoundSecMechListHelper.read((InputStream)stream).mechanism_list;
        if (list == null || list.length == 0) {
            return null;
        }
        SimpleProfileInterface transportMech = list[0].transport_mech;
        if (transportMech.getTag() == 34) {
            return null;
        }
        if (transportMech.getTag() == 36) {
            CORBAInputStream inputStream = new CORBAInputStream(transportMech.getData());
            inputStream.setEndian(inputStream.read_boolean());
            TLS_SEC_TRANS transport = TLS_SEC_TRANSHelper.read((InputStream)inputStream);
            TransportAddress[] addresses = transport.addresses;
            if (addresses == null || addresses.length == 0) {
                return null;
            }
            return addresses[0];
        }
        return null;
    }

    public void run() {
        boolean isSSLThread = false;
        CommunicationLayerImpl communicationLayerImpl = this;
        synchronized (communicationLayerImpl) {
            isSSLThread = this.sslThread;
            if (!this.sslThread) {
                this.sslThread = true;
            }
        }
        if (isSSLThread) {
            if (this.listenterSSLServerSocket != null) {
                while (true) {
                    try {
                        Socket socket = this.listenterSSLServerSocket.accept();
                        new Thread(new Connection(socket)).start();
                    }
                    catch (IOException e) {}
                }
            }
        } else {
            while (true) {
                try {
                    Socket socket = this.listenterServerSocket.accept();
                    new Thread(new Connection(socket)).start();
                }
                catch (IOException e) {}
            }
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

