/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.PortableServer.policy;

import com.sap.engine.services.iiop.PortableServer.POAImpl;
import com.sap.engine.services.iiop.PortableServer.RETAINServantHolder;
import com.sap.engine.services.iiop.PortableServer.ServantHolder;
import com.sap.engine.services.iiop.PortableServer.policy.impl.IdAssignmentPolicy;
import com.sap.engine.services.iiop.PortableServer.policy.impl.IdUniquenessPolicy;
import com.sap.engine.services.iiop.PortableServer.policy.impl.ImplicitActivationPolicy;
import com.sap.engine.services.iiop.PortableServer.policy.impl.LifespanPolicy;
import com.sap.engine.services.iiop.PortableServer.policy.impl.RequestProcessingPolicy;
import com.sap.engine.services.iiop.PortableServer.policy.impl.ServantRetentionPolicy;
import com.sap.engine.services.iiop.PortableServer.policy.impl.ThreadPolicy;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.Policy;
import org.omg.PortableServer.Servant;

public class PolicyState {
    private int idAssignmentPolicyValue = 1;
    private int idUniquenessPolicyValue = 0;
    private int implicitActivationPolicyValue = 0;
    private int lifespanPolicyValue = 0;
    private int requestProcessingPolicyValue = 0;
    private int servantRetentionPolicyValue = 0;
    private int threadPolicyValue = 0;
    private Hashtable aom;
    private static long time;
    private static long last_time;
    private static int corr;
    private POAImpl poa;

    public PolicyState(Policy[] policies, POAImpl p) {
        this.poa = p;
        this.parsePolicy(policies);
        if (this.isServantRetention()) {
            this.aom = new Hashtable();
        }
    }

    protected void parsePolicy(Policy[] policies) {
        if (policies != null) {
            int i = 0;
            while (i < policies.length) {
                if (policies[i] instanceof org.omg.PortableServer.ThreadPolicy) {
                    this.threadPolicyValue = ((ThreadPolicy)policies[i]).value().value();
                } else if (policies[i] instanceof org.omg.PortableServer.ServantRetentionPolicy) {
                    this.servantRetentionPolicyValue = ((ServantRetentionPolicy)policies[i]).value().value();
                } else if (policies[i] instanceof org.omg.PortableServer.RequestProcessingPolicy) {
                    this.requestProcessingPolicyValue = ((RequestProcessingPolicy)policies[i]).value().value();
                } else if (policies[i] instanceof org.omg.PortableServer.LifespanPolicy) {
                    this.lifespanPolicyValue = ((LifespanPolicy)policies[i]).value().value();
                } else if (policies[i] instanceof org.omg.PortableServer.ImplicitActivationPolicy) {
                    this.implicitActivationPolicyValue = ((ImplicitActivationPolicy)policies[i]).value().value();
                } else if (policies[i] instanceof org.omg.PortableServer.IdUniquenessPolicy) {
                    this.idUniquenessPolicyValue = ((IdUniquenessPolicy)policies[i]).value().value();
                } else if (policies[i] instanceof org.omg.PortableServer.IdAssignmentPolicy) {
                    this.idAssignmentPolicyValue = ((IdAssignmentPolicy)policies[i]).value().value();
                }
                ++i;
            }
        }
    }

    public int getIdAssignmentPolicyValue() {
        return this.idAssignmentPolicyValue;
    }

    public int getIdUniquenessPolicyValue() {
        return this.idUniquenessPolicyValue;
    }

    public int getImplicitActivationPolicyValue() {
        return this.implicitActivationPolicyValue;
    }

    public int getLifespanPolicyValue() {
        return this.lifespanPolicyValue;
    }

    public int getRequestProcessingPolicyValue() {
        return this.requestProcessingPolicyValue;
    }

    public int getServantRetentionPolicyValue() {
        return this.servantRetentionPolicyValue;
    }

    public int getThreadPolicyValue() {
        return this.threadPolicyValue;
    }

    public boolean isSystemAssignedIds() {
        return this.idAssignmentPolicyValue == 1;
    }

    public boolean isUniqueIds() {
        return this.idUniquenessPolicyValue == 0;
    }

    public boolean isImplicitlyActivated() {
        return this.implicitActivationPolicyValue == 0;
    }

    public boolean isServantRetention() {
        return this.servantRetentionPolicyValue == 0;
    }

    public boolean useDefaultServant() {
        return this.requestProcessingPolicyValue == 1;
    }

    public ServantHolder getServantHolder(byte[] key, String repId) {
        String[] ids = new String[]{repId};
        if (this.isServantRetention()) {
            if (key == null) {
                byte[] new_key = this.generateKey();
                RETAINServantHolder sh = new RETAINServantHolder(this.poa, new_key, ids);
                return sh;
            }
        } else {
            if (key != null) {
                return new RETAINServantHolder(this.poa, key, ids);
            }
            byte[] new_key = this.generateKey();
            return new RETAINServantHolder(this.poa, new_key, ids);
        }
        return null;
    }

    public byte[] generateKey() {
        byte[] objkey = new byte[12];
        long l = -1L;
        int k = -1;
        PolicyState policyState = this;
        synchronized (policyState) {
            l = this.getTime();
            k = this.getCorr();
        }
        objkey[4] = (byte)k;
        int i = 0;
        while (i < 7) {
            objkey[i + 5] = (byte)(l >> i * 8 & 0xFFL);
            ++i;
        }
        return objkey;
    }

    long getTime() {
        last_time = time;
        time = System.currentTimeMillis();
        return time;
    }

    int getCorr() {
        if (time != last_time) {
            corr = 0;
        }
        return corr++;
    }

    public boolean containServant(Servant a) {
        return this.aom.containsValue(a);
    }

    public byte[] servantToKey(Servant a) {
        Enumeration enumeration = this.aom.keys();
        while (enumeration.hasMoreElements()) {
            Object t = enumeration.nextElement();
            Servant s = (Servant)this.aom.get(t);
            if (!s.equals(a)) continue;
            return (byte[])t;
        }
        return null;
    }

    public boolean validateID(byte[] iod) {
        return true;
    }

    public boolean containKey(byte[] key) {
        return this.aom.containsKey(key);
    }

    public void putInAOM(byte[] oid, Servant s) {
        this.aom.put(oid, s);
    }

    public void removeFromAOM(byte[] key) {
        Enumeration enumeration = this.aom.keys();
        while (enumeration.hasMoreElements()) {
            byte[] temp = (byte[])enumeration.nextElement();
            int i = 0;
            while (i < key.length) {
                if (key[i] == temp[i] && i == key.length - 1) {
                    this.aom.remove(temp);
                }
                ++i;
            }
        }
    }

    public Servant locateServant(byte[] key) {
        Enumeration enumeration = this.aom.keys();
        while (enumeration.hasMoreElements()) {
            byte[] temp = (byte[])enumeration.nextElement();
            int i = 0;
            while (i < key.length) {
                if (key[i] == temp[i] && i == key.length - 1) {
                    return (Servant)this.aom.get(temp);
                }
                ++i;
            }
        }
        return (Servant)this.aom.get(key);
    }
}

