/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.CORBA.interceptors;

import com.sap.engine.services.iiop.CORBA.IOR;
import com.sap.engine.services.iiop.CORBA.ORB;
import com.sap.engine.services.iiop.CORBA.portable.DelegateImpl;
import com.sap.engine.services.iiop.internal.ClientORB;
import com.sap.engine.services.iiop.internal.interceptors.InterceptorsStorage;
import com.sap.engine.services.iiop.logging.Logger;
import org.omg.CORBA.BAD_INV_ORDER;
import org.omg.CORBA.BAD_PARAM;
import org.omg.CORBA.CompletionStatus;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.OBJECT_NOT_EXIST;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.ObjectImpl;
import org.omg.IOP.CodecFactory;
import org.omg.PortableInterceptor.ClientRequestInterceptor;
import org.omg.PortableInterceptor.IORInterceptor;
import org.omg.PortableInterceptor.Interceptor;
import org.omg.PortableInterceptor.ORBInitInfo;
import org.omg.PortableInterceptor.ORBInitInfoPackage.DuplicateName;
import org.omg.PortableInterceptor.ORBInitInfoPackage.InvalidName;
import org.omg.PortableInterceptor.PolicyFactory;
import org.omg.PortableInterceptor.ServerRequestInterceptor;

public final class ORBInitInfoImpl
extends LocalObject
implements ORBInitInfo {
    private org.omg.CORBA.ORB orb;
    private String[] args;
    private String orbId;
    private CodecFactory codecFactory;
    private int stage = 0;
    private boolean staticPropeties;
    public static final int STAGE_PRE_INIT = 0;
    public static final int STAGE_POST_INIT = 1;
    public static final int STAGE_CLOSED = 2;
    private static final String MESSAGE_ORBINITINFO_INVALID = "ORBInitInfo object is only valid during ORB_init";

    public ORBInitInfoImpl(org.omg.CORBA.ORB orb, String[] args, String orbId, CodecFactory codecFactory, boolean staticPropeties) {
        this.orb = orb;
        this.args = args;
        this.orbId = orbId;
        this.codecFactory = codecFactory;
        this.staticPropeties = staticPropeties;
    }

    public void setStage(int stage) {
        this.stage = stage;
    }

    public String[] arguments() {
        this.checkStage();
        return this.args;
    }

    public String orb_id() {
        this.checkStage();
        return this.orbId;
    }

    public CodecFactory codec_factory() {
        this.checkStage();
        return this.codecFactory;
    }

    public void register_initial_reference(String id, Object obj) throws InvalidName {
        this.checkStage();
        if (id == null) {
            this.nullParam();
        }
        boolean isNil = false;
        if (obj == null) {
            isNil = true;
        } else if (obj instanceof ObjectImpl) {
            DelegateImpl delegate = (DelegateImpl)((ObjectImpl)obj)._get_delegate();
            IOR ior = delegate.getIOR();
            isNil = ior.is_nil();
        }
        if (isNil) {
            throw new BAD_PARAM("register_initial_reference called with nil Object.", 1330446363, CompletionStatus.COMPLETED_NO);
        }
        try {
            ((ClientORB)this.orb).register_initial_reference(id, obj);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName e) {
            throw new InvalidName(e.getMessage());
        }
    }

    public Object resolve_initial_references(String id) throws InvalidName {
        this.checkStage();
        if (id == null) {
            this.nullParam();
        }
        if (this.stage == 0) {
            throw new BAD_INV_ORDER("Resolve Initial References cannot be called in pre_init");
        }
        Object objRef = null;
        try {
            objRef = this.orb.resolve_initial_references(id);
        }
        catch (org.omg.CORBA.ORBPackage.InvalidName e) {
            Logger.traceError("ORBInitInfoImpl.resolve_initial_references(String)", Logger.exceptionTrace(e));
            throw new InvalidName(e.toString());
        }
        return objRef;
    }

    public void add_client_request_interceptor(ClientRequestInterceptor interceptor) throws DuplicateName {
        this.checkStage();
        if (interceptor == null) {
            this.nullParam();
        }
        if (this.staticPropeties) {
            InterceptorsStorage.register_client_interceptor((Interceptor)interceptor);
        } else {
            InterceptorsStorage.register_client_interceptor(this.orb, (Interceptor)interceptor);
        }
    }

    public void add_server_request_interceptor(ServerRequestInterceptor interceptor) throws DuplicateName {
        this.checkStage();
        if (interceptor == null) {
            this.nullParam();
        }
        if (this.staticPropeties) {
            InterceptorsStorage.register_server_interceptor((Interceptor)interceptor);
        } else {
            InterceptorsStorage.register_server_interceptor(this.orb, (Interceptor)interceptor);
        }
    }

    public void add_ior_interceptor(IORInterceptor interceptor) throws DuplicateName {
        this.checkStage();
        if (interceptor == null) {
            this.nullParam();
        }
        if (this.staticPropeties) {
            InterceptorsStorage.register_ior_interceptor((Interceptor)interceptor);
        } else {
            InterceptorsStorage.register_ior_interceptor(this.orb, (Interceptor)interceptor);
        }
    }

    public int allocate_slot_id() {
        this.checkStage();
        return ((ORB)this.orb).getPICurrent().allocateSlotId();
    }

    public void register_policy_factory(int type, PolicyFactory policy_factory) {
        this.checkStage();
        if (policy_factory == null) {
            this.nullParam();
        }
    }

    private void nullParam() throws BAD_PARAM {
        throw new BAD_PARAM(1, CompletionStatus.COMPLETED_NO);
    }

    private void checkStage() {
        if (this.stage == 2) {
            throw new OBJECT_NOT_EXIST(MESSAGE_ORBINITINFO_INVALID);
        }
    }
}

