/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.CORBA;

import com.sap.engine.services.iiop.CORBA.AnyImpl;
import com.sap.engine.services.iiop.CORBA.ORB;
import com.sap.engine.services.iiop.CORBA.portable.CORBAInputStream;
import com.sap.engine.services.iiop.CORBA.portable.CORBAOutputStream;
import com.sap.engine.services.iiop.logging.Logger;
import org.omg.CORBA.Any;
import org.omg.CORBA.MARSHAL;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.StructMember;
import org.omg.CORBA.TCKind;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.TypeCodePackage.BadKind;
import org.omg.CORBA.TypeCodePackage.Bounds;
import org.omg.CORBA.UnionMember;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public final class TypeCodeImpl
extends TypeCode {
    private ORB orb;
    private static final TypeCodeImpl[] primitiveConstants = new TypeCodeImpl[]{new TypeCodeImpl(0), new TypeCodeImpl(1), new TypeCodeImpl(2), new TypeCodeImpl(3), new TypeCodeImpl(4), new TypeCodeImpl(5), new TypeCodeImpl(6), new TypeCodeImpl(7), new TypeCodeImpl(8), new TypeCodeImpl(9), new TypeCodeImpl(10), new TypeCodeImpl(11), new TypeCodeImpl(12), new TypeCodeImpl(13), new TypeCodeImpl(14), null, null, null, new TypeCodeImpl(18), null, null, null, null, new TypeCodeImpl(23), new TypeCodeImpl(24), new TypeCodeImpl(25), new TypeCodeImpl(26), new TypeCodeImpl(27), new TypeCodeImpl(28), new TypeCodeImpl(29), new TypeCodeImpl(30), new TypeCodeImpl(31), new TypeCodeImpl(32)};
    protected static final int tk_indirect = -1;
    private static final int EMPTY = 0;
    private static final int SIMPLE = 1;
    private static final int COMPLEX = 2;
    private static final int[] typeTable = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2, 2, 2, 2, 1, 2, 2, 2, 2, 0, 0, 0, 0, 1, 1, 2, 2, 2, 2};
    private int _kind = 0;
    private String _id = "";
    private String _name = "";
    private int _memberCount = 0;
    private String[] _memberNames = null;
    private TypeCodeImpl[] _memberTypes = null;
    private AnyImpl[] _unionLabels = null;
    private TypeCodeImpl _discriminator = null;
    private int _defaultIndex = -1;
    private int _length = 0;
    private TypeCodeImpl _contentType = null;
    private short _type_modifier = (short)-1;
    private TypeCodeImpl _concrete_base = null;
    private short[] _memberAccess = null;

    public TypeCodeImpl() {
    }

    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            return true;
        }
        return this.equal((TypeCode)obj);
    }

    public TypeCodeImpl(ORB orb0, TCKind kind) {
        this(kind.value());
        this.orb = orb0;
    }

    public TypeCodeImpl(ORB orb0) {
        this.orb = orb0;
    }

    public TypeCodeImpl(ORB orb0, TypeCode tc) {
        this._kind = tc.kind().value();
        this.orb = orb0;
        try {
            int i;
            switch (this._kind) {
                case 15: 
                case 16: 
                case 22: {
                    this._memberTypes = new TypeCodeImpl[tc.member_count()];
                    i = 0;
                    while (i < tc.member_count()) {
                        this._memberTypes[i] = TypeCodeImpl.convertToNative(this.orb, tc.member_type(i));
                        ++i;
                    }
                }
                case 17: {
                    this._memberNames = new String[tc.member_count()];
                    i = 0;
                    while (i < tc.member_count()) {
                        this._memberNames[i] = tc.member_name(i);
                        ++i;
                    }
                    this._memberCount = tc.member_count();
                }
                case 14: 
                case 21: 
                case 30: 
                case 31: 
                case 32: {
                    this._id = tc.id();
                    this._name = tc.name();
                }
            }
            switch (this._kind) {
                case 16: {
                    this._discriminator = TypeCodeImpl.convertToNative(this.orb, tc.discriminator_type());
                    this._defaultIndex = tc.default_index();
                    this._unionLabels = new AnyImpl[this._memberCount];
                    i = 0;
                    while (i < this._memberCount) {
                        this._unionLabels[i] = new AnyImpl(this.orb, tc.member_label(i));
                        ++i;
                    }
                    break;
                }
            }
            switch (this._kind) {
                case 18: 
                case 19: 
                case 20: 
                case 27: {
                    this._length = tc.length();
                }
            }
            switch (this._kind) {
                case 19: 
                case 20: 
                case 21: 
                case 30: {
                    this._contentType = TypeCodeImpl.convertToNative(this.orb, tc.content_type());
                }
            }
        }
        catch (Bounds e) {
            Logger.traceError("TypeCodeImpl.TypeCodeImpl(ORB , TypeCode)", Logger.exceptionTrace(e));
        }
        catch (BadKind e) {
            Logger.traceError("TypeCodeImpl.TypeCodeImpl(ORB , TypeCode)", Logger.exceptionTrace(e));
        }
    }

    protected TypeCodeImpl(int creationKind) {
        this._kind = creationKind;
        switch (this._kind) {
            case 14: {
                this._id = "IDL:omg.org/CORBA/Object:1.0";
                this._name = "Object";
                break;
            }
            case 18: 
            case 27: {
                this._length = 0;
            }
        }
    }

    public TypeCodeImpl(ORB orb0, int creationKind, String id, String name, StructMember[] members) {
        this.orb = orb0;
        if (creationKind == 15 || creationKind == 22) {
            this._kind = creationKind;
            this._id = id;
            this._name = name;
            this._memberCount = members.length;
            this._memberNames = new String[this._memberCount];
            this._memberTypes = new TypeCodeImpl[this._memberCount];
            int i = 0;
            while (i < this._memberCount) {
                this._memberNames[i] = members[i].name;
                this._memberTypes[i] = TypeCodeImpl.convertToNative(this.orb, members[i].type);
                ++i;
            }
        }
    }

    public TypeCodeImpl(ORB orb0, int creationKind, String id, String name, TypeCode discriminator_type, UnionMember[] members) {
        this.orb = orb0;
        if (creationKind == 16) {
            this._kind = creationKind;
            this._id = id;
            this._name = name;
            this._memberCount = members.length;
            this._discriminator = TypeCodeImpl.convertToNative(this.orb, discriminator_type);
            this._memberNames = new String[this._memberCount];
            this._memberTypes = new TypeCodeImpl[this._memberCount];
            this._unionLabels = new AnyImpl[this._memberCount];
            int i = 0;
            while (i < this._memberCount) {
                this._memberNames[i] = members[i].name;
                this._memberTypes[i] = TypeCodeImpl.convertToNative(this.orb, members[i].type);
                this._unionLabels[i] = new AnyImpl(this.orb, members[i].label);
                if (this._unionLabels[i].type().kind() == TCKind.tk_octet) {
                    this._defaultIndex = i;
                }
                ++i;
            }
        }
    }

    public TypeCodeImpl(ORB orb0, int creationKind, String id, String name, short type_modifier, TypeCode concrete_base, ValueMember[] members) {
        this.orb = orb0;
        if (creationKind == 29) {
            this._kind = creationKind;
            this._id = id;
            this._name = name;
            this._type_modifier = type_modifier;
            if (this._concrete_base != null) {
                this._concrete_base = TypeCodeImpl.convertToNative(orb0, concrete_base);
            }
            this._memberCount = members.length;
            this._memberNames = new String[this._memberCount];
            this._memberTypes = new TypeCodeImpl[this._memberCount];
            this._memberAccess = new short[this._memberCount];
            int i = 0;
            while (i < this._memberCount) {
                this._memberNames[i] = members[i].name;
                this._memberTypes[i] = TypeCodeImpl.convertToNative(orb0, members[i].type);
                this._memberAccess[i] = members[i].access;
                ++i;
            }
        }
    }

    public TypeCodeImpl(ORB orb0, int creationKind, String id, String name, String[] members) {
        this.orb = orb0;
        if (creationKind == 17) {
            this._kind = creationKind;
            this._id = id;
            this._name = name;
            this._memberCount = members.length;
            this._memberNames = new String[this._memberCount];
            int i = 0;
            while (i < this._memberCount) {
                this._memberNames[i] = members[i];
                ++i;
            }
        }
    }

    public TypeCodeImpl(ORB orb0, int creationKind, String id, String name, TypeCode original_type) {
        this.orb = orb0;
        if (creationKind == 21 || creationKind == 30) {
            this._kind = creationKind;
            this._id = id;
            this._name = name;
            this._contentType = TypeCodeImpl.convertToNative(this.orb, original_type);
        }
    }

    public TypeCodeImpl(ORB orb0, int creationKind, String id, String name) {
        if (creationKind == 14 || creationKind == 31 || creationKind == 32) {
            this._kind = creationKind;
            this._id = id;
            this._name = name;
        }
    }

    public TypeCodeImpl(ORB orb0, int creationKind, int bound) {
        if (creationKind == 18 || creationKind == 27) {
            this._kind = creationKind;
            this._length = bound;
        }
    }

    public TypeCodeImpl(ORB orb0, int creationKind, int bound, TypeCode element_type) {
        if (creationKind == 19 || creationKind == 20) {
            this._kind = creationKind;
            this._length = bound;
            this._contentType = TypeCodeImpl.convertToNative(this.orb, element_type);
        }
    }

    public TypeCodeImpl(ORB orb0, int creationKind, int bound, int offset) {
        String messageWithId = "ID019057: Recursive seqencese is not implemented yet.";
        Logger.traceError("TypeCodeImpl.TypeCodeImpl(ORB , int, int, int)", messageWithId);
        throw new NO_IMPLEMENT(messageWithId);
    }

    public static TypeCodeImpl get_primitive_tc(TCKind tcKind) {
        return primitiveConstants[tcKind.value()];
    }

    protected static TypeCodeImpl convertToNative(ORB orb0, TypeCode tc) {
        if (tc instanceof TypeCodeImpl) {
            return (TypeCodeImpl)tc;
        }
        return new TypeCodeImpl(orb0, tc);
    }

    public final boolean equal(TypeCode tc) {
        try {
            if (this._kind != tc.kind().value()) {
                return false;
            }
            switch (typeTable[this._kind]) {
                case 0: {
                    return true;
                }
                case 1: {
                    switch (this._kind) {
                        case 18: 
                        case 27: {
                            return this._length == tc.length();
                        }
                    }
                }
                case 2: {
                    switch (this._kind) {
                        case 14: 
                        case 31: 
                        case 32: {
                            return this._id.compareTo(tc.id()) == 0;
                        }
                        case 15: {
                            if (this._memberCount != tc.member_count()) {
                                return false;
                            }
                            if (this._id.compareTo(tc.id()) != 0) {
                                return false;
                            }
                            int i = 0;
                            while (i < this._memberCount) {
                                if (!this._memberTypes[i].equal(tc.member_type(i))) {
                                    return false;
                                }
                                ++i;
                            }
                            return true;
                        }
                        case 16: {
                            if (this._memberCount != tc.member_count()) {
                                return false;
                            }
                            if (this._id.compareTo(tc.id()) != 0) {
                                return false;
                            }
                            if (this._defaultIndex != tc.default_index()) {
                                return false;
                            }
                            if (!this._discriminator.equal(tc.discriminator_type())) {
                                return false;
                            }
                            int i = 0;
                            while (i < this._memberCount) {
                                if (!this._unionLabels[i].equal(tc.member_label(i))) {
                                    return false;
                                }
                                ++i;
                            }
                            int i2 = 0;
                            while (i2 < this._memberCount) {
                                if (!this._memberTypes[i2].equal(tc.member_type(i2))) {
                                    return false;
                                }
                                ++i2;
                            }
                            return true;
                        }
                        case 17: {
                            if (this._id.compareTo(tc.id()) != 0) {
                                return false;
                            }
                            return this._memberCount == tc.member_count();
                        }
                        case 19: 
                        case 20: {
                            if (this._length != tc.length()) {
                                return false;
                            }
                            return this._contentType.equal(tc.content_type());
                        }
                        case 21: 
                        case 30: {
                            if (this._id.compareTo(tc.id()) != 0) {
                                return false;
                            }
                            return this._contentType.equal(tc.content_type());
                        }
                        case 22: {
                            if (this._memberCount != tc.member_count()) {
                                return false;
                            }
                            if (this._id.compareTo(tc.id()) != 0) {
                                return false;
                            }
                            int i = 0;
                            while (i < this._memberCount) {
                                if (!this._memberTypes[i].equal(tc.member_type(i))) {
                                    return false;
                                }
                                ++i;
                            }
                            return true;
                        }
                    }
                }
            }
        }
        catch (Bounds e) {
            Logger.traceError("TypeCodeImpl.equal(TypeCode)", Logger.exceptionTrace(e));
        }
        catch (BadKind e) {
            Logger.traceError("TypeCodeImpl.equal(TypeCode)", Logger.exceptionTrace(e));
        }
        return false;
    }

    public TCKind kind() {
        return TCKind.from_int((int)this._kind);
    }

    public String id() throws BadKind {
        switch (this._kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 30: 
            case 31: 
            case 32: {
                return this._id;
            }
        }
        String messageWithId = "ID019058: Error typecode.";
        Logger.traceError("TypeCodeImpl.id()", messageWithId);
        throw new BadKind(messageWithId);
    }

    public String name() throws BadKind {
        switch (this._kind) {
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 21: 
            case 22: 
            case 30: 
            case 31: 
            case 32: {
                return this._name;
            }
        }
        String messageWithId = "ID019059: Error typecode.";
        Logger.traceError("TypeCodeImpl.name()", messageWithId);
        throw new BadKind(messageWithId);
    }

    public int member_count() throws BadKind {
        switch (this._kind) {
            case 15: 
            case 16: 
            case 17: 
            case 22: {
                return this._memberCount;
            }
        }
        String messageWithId = "ID019060: Error member count. ";
        Logger.traceError("TypeCodeImpl.member_count()", messageWithId);
        throw new BadKind(messageWithId);
    }

    public String member_name(int index) throws BadKind, Bounds {
        switch (this._kind) {
            case 15: 
            case 16: 
            case 17: 
            case 22: {
                try {
                    return this._memberNames[index];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    String messageWithId = "ID019061: Error member name. ";
                    Logger.traceError("TypeCodeImpl.member_name()", Logger.exceptionTrace(e));
                    throw new Bounds(messageWithId);
                }
            }
        }
        String messageWithId = "ID019062: Error member name. ";
        Logger.traceError("TypeCodeImpl.member_name()", messageWithId);
        throw new BadKind(messageWithId);
    }

    public TypeCode member_type(int index) throws BadKind, Bounds {
        switch (this._kind) {
            case 15: 
            case 16: 
            case 22: {
                try {
                    return this._memberTypes[index];
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    String messageWithId = "ID019063: Error member type. ";
                    Logger.traceError("TypeCodeImpl.member_type()", Logger.exceptionTrace(e));
                    throw new Bounds(messageWithId);
                }
            }
        }
        String messageWithId = "ID019064: Error member type. ";
        Logger.traceError("TypeCodeImpl.member_type()", messageWithId);
        throw new BadKind(messageWithId);
    }

    public Any member_label(int index) throws BadKind, Bounds {
        switch (this._kind) {
            case 16: {
                try {
                    return new AnyImpl(this.orb, this._unionLabels[index]);
                }
                catch (ArrayIndexOutOfBoundsException e) {
                    String messageWithId = "ID019065: Error member label. ";
                    Logger.traceError("TypeCodeImpl.member_label()", Logger.exceptionTrace(e));
                    throw new Bounds(messageWithId);
                }
            }
        }
        String messageWithId = "ID019066: Error member label. ";
        Logger.traceError("TypeCodeImpl.member_label()", messageWithId);
        throw new BadKind(messageWithId);
    }

    public TypeCode discriminator_type() throws BadKind {
        switch (this._kind) {
            case 16: {
                return this._discriminator;
            }
        }
        String messageWithId = "ID019067: Error discriminator type.";
        Logger.traceError("TypeCodeImpl.discriminator_type()", messageWithId);
        throw new BadKind(messageWithId);
    }

    public int default_index() throws BadKind {
        switch (this._kind) {
            case 16: {
                return this._defaultIndex;
            }
        }
        String messageWithId = "ID019068: Error default index.";
        Logger.traceError("TypeCodeImpl.default_index()", messageWithId);
        throw new BadKind(messageWithId);
    }

    public int length() throws BadKind {
        switch (this._kind) {
            case 18: 
            case 19: 
            case 20: 
            case 27: {
                return this._length;
            }
        }
        String messageWithId = "ID019069: Incorect length.";
        Logger.traceError("TypeCodeImpl.length()", messageWithId);
        throw new BadKind(messageWithId);
    }

    public TypeCode content_type() throws BadKind {
        switch (this._kind) {
            case 19: 
            case 20: 
            case 21: 
            case 30: {
                return this._contentType;
            }
        }
        String messageWithId = "ID019070: Error content type.";
        Logger.traceError("TypeCodeImpl.content_type()", messageWithId);
        throw new BadKind(messageWithId);
    }

    public TypeCode concrete_base_type() throws BadKind {
        return null;
    }

    public boolean equivalent(TypeCode tc) {
        return false;
    }

    public short fixed_digits() throws BadKind {
        return 0;
    }

    public short fixed_scale() throws BadKind {
        return 0;
    }

    public TypeCode get_compact_typecode() {
        return this;
    }

    public short member_visibility(int index) throws BadKind, Bounds {
        return 0;
    }

    public short type_modifier() throws BadKind {
        return 0;
    }

    public void read_value(InputStream s) {
        CORBAInputStream _encap = null;
        this._kind = s.read_long();
        if (this._kind < 0 || this._kind > typeTable.length) {
            String messageWithId = "ID019071: Not valid type kind " + this._kind;
            Logger.traceError("TypeCodeImpl.read_value()", messageWithId);
            throw new MARSHAL(messageWithId);
        }
        block0 : switch (typeTable[this._kind]) {
            case 0: {
                break;
            }
            case 1: {
                switch (this._kind) {
                    case 18: 
                    case 27: {
                        this._length = s.read_long();
                        break block0;
                    }
                }
                String messageWithId = "ID019072: Incorrect type kind.";
                Logger.traceError("TypeCodeImpl.read_value()", messageWithId);
                throw new MARSHAL(messageWithId);
            }
            case 2: {
                int encapLength = s.read_long();
                byte[] encapBuffer = new byte[encapLength];
                s.read_octet_array(encapBuffer, 0, encapBuffer.length);
                _encap = new CORBAInputStream(this.orb, encapBuffer);
                _encap.setEndian(_encap.read_boolean());
                switch (this._kind) {
                    case 12: {
                        s.read_TypeCode();
                        break block0;
                    }
                    case 14: 
                    case 32: {
                        this._id = _encap.read_string();
                        this._name = _encap.read_string();
                        break block0;
                    }
                    case 15: {
                        this._id = _encap.read_string();
                        this._name = _encap.read_string();
                        this._memberCount = _encap.read_long();
                        this._memberNames = new String[this._memberCount];
                        this._memberTypes = new TypeCodeImpl[this._memberCount];
                        int i = 0;
                        while (i < this._memberCount) {
                            this._memberNames[i] = _encap.read_string();
                            this._memberTypes[i] = new TypeCodeImpl();
                            this._memberTypes[i].read_value((InputStream)_encap);
                            ++i;
                        }
                        break block0;
                    }
                    case 16: {
                        this._id = _encap.read_string();
                        this._name = _encap.read_string();
                        this._discriminator = new TypeCodeImpl();
                        this._discriminator.read_value((InputStream)_encap);
                        this._defaultIndex = _encap.read_long();
                        this._memberCount = _encap.unaligned_read_long();
                        this._unionLabels = new AnyImpl[this._memberCount];
                        this._memberNames = new String[this._memberCount];
                        this._memberTypes = new TypeCodeImpl[this._memberCount];
                        int i = 0;
                        while (i < this._memberCount) {
                            this._unionLabels[i] = new AnyImpl(this.orb);
                            if (i == this._defaultIndex) {
                                this._unionLabels[i].insert_octet(_encap.read_octet());
                            } else {
                                switch (this._discriminator.kind().value()) {
                                    case 2: {
                                        this._unionLabels[i].insert_short(_encap.read_short());
                                        break;
                                    }
                                    case 3: {
                                        this._unionLabels[i].insert_long(_encap.read_long());
                                        break;
                                    }
                                    case 4: {
                                        this._unionLabels[i].insert_ushort(_encap.read_short());
                                        break;
                                    }
                                    case 5: {
                                        this._unionLabels[i].insert_ulong(_encap.read_long());
                                        break;
                                    }
                                    case 6: {
                                        this._unionLabels[i].insert_float(_encap.read_float());
                                        break;
                                    }
                                    case 7: {
                                        this._unionLabels[i].insert_double(_encap.read_double());
                                        break;
                                    }
                                    case 8: {
                                        this._unionLabels[i].insert_boolean(_encap.read_boolean());
                                        break;
                                    }
                                    case 9: {
                                        this._unionLabels[i].insert_char(_encap.read_char());
                                        break;
                                    }
                                    case 26: {
                                        this._unionLabels[i].insert_wchar(_encap.read_wchar());
                                        break;
                                    }
                                    case 17: {
                                        int value = _encap.read_long();
                                        OutputStream out = this._unionLabels[i].create_output_stream();
                                        out.write_long(value);
                                        this._unionLabels[i].read_value(out.create_input_stream(), this._discriminator);
                                        break;
                                    }
                                    case 23: {
                                        this._unionLabels[i].insert_longlong(_encap.read_longlong());
                                        break;
                                    }
                                    case 24: {
                                        this._unionLabels[i].insert_ulonglong(_encap.read_longlong());
                                        break;
                                    }
                                    default: {
                                        String messageWithId = "ID019073: Incorrect label values, names or types.";
                                        Logger.traceError("TypeCodeImpl.read_value()", messageWithId);
                                        throw new MARSHAL(messageWithId);
                                    }
                                }
                            }
                            this._memberNames[i] = _encap.read_string();
                            this._memberTypes[i] = new TypeCodeImpl();
                            this._memberTypes[i].read_value((InputStream)_encap);
                            ++i;
                        }
                        break block0;
                    }
                    case 17: {
                        this._id = _encap.read_string();
                        this._name = _encap.read_string();
                        this._memberCount = _encap.read_long();
                        this._memberNames = new String[this._memberCount];
                        int i = 0;
                        while (i < this._memberCount) {
                            this._memberNames[i] = _encap.read_string();
                            ++i;
                        }
                        break block0;
                    }
                    case 19: {
                        this._contentType = new TypeCodeImpl();
                        this._contentType.read_value((InputStream)_encap);
                        this._length = _encap.read_long();
                        break block0;
                    }
                    case 20: {
                        this._contentType = new TypeCodeImpl();
                        this._contentType.read_value((InputStream)_encap);
                        this._length = _encap.read_long();
                        break block0;
                    }
                    case 21: 
                    case 30: {
                        this._id = _encap.read_string();
                        this._name = _encap.read_string();
                        this._contentType = new TypeCodeImpl();
                        this._contentType.read_value((InputStream)_encap);
                        break block0;
                    }
                    case 22: {
                        this._id = _encap.read_string();
                        this._name = _encap.read_string();
                        this._memberCount = _encap.read_long();
                        this._memberNames = new String[this._memberCount];
                        this._memberTypes = new TypeCodeImpl[this._memberCount];
                        int i = 0;
                        while (i < this._memberCount) {
                            this._memberNames[i] = _encap.read_string();
                            this._memberTypes[i] = new TypeCodeImpl();
                            this._memberTypes[i].read_value((InputStream)_encap);
                            ++i;
                        }
                        break block0;
                    }
                    case 29: {
                        _encap.read_string();
                        _encap.read_string();
                        _encap.read_short();
                        new TypeCodeImpl(0).read_value((InputStream)_encap);
                        _encap.read_long();
                        return;
                    }
                    default: {
                        String messageWithId = "ID019074: Incorrect type kind" + this._kind;
                        Logger.traceError("TypeCodeImpl.read_value()", messageWithId);
                        throw new MARSHAL(messageWithId);
                    }
                }
            }
        }
    }

    public void write_value(OutputStream s) {
        CORBAOutputStream _encap = null;
        s.write_long(this._kind);
        block0 : switch (typeTable[this._kind]) {
            case 0: {
                break;
            }
            case 1: {
                switch (this._kind) {
                    case 18: 
                    case 27: {
                        s.write_long(this._length);
                        break block0;
                    }
                }
                String messageWithId = "ID019075: Unknown typecode kind.";
                Logger.traceError("TypeCodeImpl.write_value()", messageWithId);
                throw new MARSHAL(messageWithId);
            }
            case 2: {
                _encap = new CORBAOutputStream();
                _encap.write_boolean(false);
                switch (this._kind) {
                    case 14: 
                    case 32: {
                        _encap.write_string(this._id);
                        _encap.write_string(this._name);
                        break;
                    }
                    case 15: {
                        _encap.write_string(this._id);
                        _encap.write_string(this._name);
                        _encap.write_long(this._memberCount);
                        int i = 0;
                        while (i < this._memberCount) {
                            _encap.write_string(this._memberNames[i]);
                            this._memberTypes[i].write_value((OutputStream)_encap);
                            ++i;
                        }
                        break;
                    }
                    case 16: {
                        _encap.write_string(this._id);
                        _encap.write_string(this._name);
                        this._discriminator.write_value((OutputStream)_encap);
                        _encap.write_long(this._defaultIndex);
                        _encap.write_long(this._memberCount);
                        int i = 0;
                        while (i < this._memberCount) {
                            if (i == this._defaultIndex) {
                                _encap.write_octet(this._unionLabels[i].extract_octet());
                            } else {
                                switch (this._discriminator.kind().value()) {
                                    case 2: {
                                        _encap.write_short(this._unionLabels[i].extract_short());
                                        break;
                                    }
                                    case 3: {
                                        _encap.write_long(this._unionLabels[i].extract_long());
                                        break;
                                    }
                                    case 4: {
                                        _encap.write_short(this._unionLabels[i].extract_ushort());
                                        break;
                                    }
                                    case 5: {
                                        _encap.write_long(this._unionLabels[i].extract_ulong());
                                        break;
                                    }
                                    case 6: {
                                        _encap.write_float(this._unionLabels[i].extract_float());
                                        break;
                                    }
                                    case 7: {
                                        _encap.write_double(this._unionLabels[i].extract_double());
                                        break;
                                    }
                                    case 8: {
                                        _encap.write_boolean(this._unionLabels[i].extract_boolean());
                                        break;
                                    }
                                    case 9: {
                                        _encap.write_char(this._unionLabels[i].extract_char());
                                        break;
                                    }
                                    case 26: {
                                        _encap.write_wchar(this._unionLabels[i].extract_wchar());
                                        break;
                                    }
                                    case 17: {
                                        int value = this._unionLabels[i].create_input_stream().read_long();
                                        _encap.write_long(value);
                                        break;
                                    }
                                    case 23: {
                                        _encap.write_longlong(this._unionLabels[i].extract_longlong());
                                        break;
                                    }
                                    case 24: {
                                        _encap.write_longlong(this._unionLabels[i].extract_ulonglong());
                                        break;
                                    }
                                    default: {
                                        throw new MARSHAL("ID019076");
                                    }
                                }
                            }
                            _encap.write_string(this._memberNames[i]);
                            this._memberTypes[i].write_value((OutputStream)_encap);
                            ++i;
                        }
                        break;
                    }
                    case 17: {
                        _encap.write_string(this._id);
                        _encap.write_string(this._name);
                        _encap.write_long(this._memberCount);
                        int i = 0;
                        while (i < this._memberCount) {
                            _encap.write_string(this._memberNames[i]);
                            ++i;
                        }
                        break;
                    }
                    case 19: {
                        this._contentType.write_value((OutputStream)_encap);
                        _encap.write_long(this._length);
                        break;
                    }
                    case 20: {
                        this._contentType.write_value((OutputStream)_encap);
                        _encap.write_long(this._length);
                        break;
                    }
                    case 21: 
                    case 30: {
                        _encap.write_string(this._id);
                        _encap.write_string(this._name);
                        this._contentType.write_value((OutputStream)_encap);
                        break;
                    }
                    case 22: {
                        _encap.write_string(this._id);
                        _encap.write_string(this._name);
                        _encap.write_long(this._memberCount);
                        int i = 0;
                        while (i < this._memberCount) {
                            _encap.write_string(this._memberNames[i]);
                            this._memberTypes[i].write_value((OutputStream)_encap);
                            ++i;
                        }
                        break;
                    }
                    case 29: {
                        _encap.write_string(this._id);
                        _encap.write_string(this._name);
                        _encap.write_short(this._type_modifier);
                        if (this._concrete_base == null) {
                            primitiveConstants[0].write_value((OutputStream)_encap);
                        } else {
                            this._concrete_base.write_value((OutputStream)_encap);
                        }
                        _encap.write_long(this._memberCount);
                        int i = 0;
                        while (i < this._memberCount) {
                            _encap.write_string(this._memberNames[i]);
                            this._memberTypes[i].write_value((OutputStream)_encap);
                            _encap.write_short(this._memberAccess[i]);
                            ++i;
                        }
                        break;
                    }
                    default: {
                        throw new MARSHAL("ID019077");
                    }
                }
                s.write_long(_encap.byteArray_forSend_length());
                s.write_octet_array(_encap.toByteArray_forSend(), 0, _encap.byteArray_forSend_length());
            }
        }
    }

    protected void copy(InputStream src, OutputStream dst) {
        switch (this._kind) {
            case 0: 
            case 1: {
                break;
            }
            case 2: 
            case 4: {
                dst.write_short(src.read_short());
                break;
            }
            case 3: 
            case 5: {
                dst.write_long(src.read_long());
                break;
            }
            case 6: {
                dst.write_float(src.read_float());
                break;
            }
            case 7: {
                dst.write_double(src.read_double());
                break;
            }
            case 23: 
            case 24: {
                dst.write_longlong(src.read_longlong());
                break;
            }
            case 25: {
                dst.write_double(src.read_double());
                break;
            }
            case 8: {
                dst.write_boolean(src.read_boolean());
                break;
            }
            case 9: {
                dst.write_char(src.read_char());
                break;
            }
            case 26: {
                dst.write_wchar(src.read_wchar());
                break;
            }
            case 10: {
                dst.write_octet(src.read_octet());
                break;
            }
            case 18: {
                String s = src.read_string();
                if (this._length != 0 && s.length() > this._length) {
                    String messageWithId = "ID019078: Length bound in typecode is not violated. Error.";
                    Logger.traceError("TypeCodeImpl.copy(InputStream, OutputStream)", messageWithId);
                    throw new MARSHAL(messageWithId);
                }
                dst.write_string(s);
                break;
            }
            case 27: {
                String s = src.read_wstring();
                if (this._length != 0 && s.length() > this._length) {
                    String messageWithId = "ID019078: Length bound in typecode is not violated. Error.";
                    Logger.traceError("TypeCodeImpl.copy(InputStream, OutputStream)", messageWithId);
                    throw new MARSHAL(messageWithId);
                }
                dst.write_wstring(s);
                break;
            }
            case 11: {
                AnyImpl tmp = new AnyImpl(this.orb);
                TypeCodeImpl t = new TypeCodeImpl();
                t.read_value(src);
                t.write_value(dst);
                tmp.read_value(src, t);
                tmp.write_value(dst);
                break;
            }
            case 12: {
                dst.write_TypeCode(src.read_TypeCode());
                break;
            }
            case 13: {
                dst.write_Principal(src.read_Principal());
                break;
            }
            case 14: {
                dst.write_Object(src.read_Object());
                break;
            }
            case 22: {
                dst.write_string(src.read_string());
            }
            case 15: {
                int i = 0;
                while (i < this._memberTypes.length) {
                    this._memberTypes[i].copy(src, dst);
                    ++i;
                }
                break;
            }
            case 16: {
                AnyImpl tagValue = new AnyImpl(this.orb);
                switch (this._discriminator.kind().value()) {
                    case 2: {
                        short value = src.read_short();
                        tagValue.insert_short(value);
                        dst.write_short(value);
                        break;
                    }
                    case 3: {
                        int value = src.read_long();
                        tagValue.insert_long(value);
                        dst.write_long(value);
                        break;
                    }
                    case 4: {
                        short value = src.read_short();
                        tagValue.insert_ushort(value);
                        dst.write_short(value);
                        break;
                    }
                    case 5: {
                        int value = src.read_long();
                        tagValue.insert_ulong(value);
                        dst.write_long(value);
                        break;
                    }
                    case 6: {
                        float value = src.read_float();
                        tagValue.insert_float(value);
                        dst.write_float(value);
                        break;
                    }
                    case 7: {
                        double value = src.read_double();
                        tagValue.insert_double(value);
                        dst.write_double(value);
                        break;
                    }
                    case 8: {
                        boolean value = src.read_boolean();
                        tagValue.insert_boolean(value);
                        dst.write_boolean(value);
                        break;
                    }
                    case 9: {
                        char value = src.read_char();
                        tagValue.insert_char(value);
                        dst.write_char(value);
                        break;
                    }
                    case 17: {
                        int value = src.read_long();
                        tagValue.type(this._discriminator);
                        OutputStream out = tagValue.create_output_stream();
                        out.write_long(value);
                        tagValue.read_value(out.create_input_stream(), this._discriminator);
                        dst.write_long(value);
                        break;
                    }
                    case 23: {
                        long value = src.read_longlong();
                        tagValue.insert_longlong(value);
                        dst.write_longlong(value);
                        break;
                    }
                    case 24: {
                        long value = src.read_longlong();
                        tagValue.insert_ulonglong(value);
                        dst.write_longlong(value);
                        break;
                    }
                    default: {
                        throw new MARSHAL("ID019079");
                    }
                }
                int labelIndex = 0;
                while (labelIndex < this._unionLabels.length) {
                    if (tagValue.equal(this._unionLabels[labelIndex])) {
                        this._memberTypes[labelIndex].copy(src, dst);
                        break;
                    }
                    ++labelIndex;
                }
                if (labelIndex != this._unionLabels.length) break;
                if (this._defaultIndex == -1) {
                    String messageWithId = "ID019080: Default label has not been found.";
                    Logger.traceError("TypeCodeImpl.copy(InputStream, OutputStream)", messageWithId);
                    throw new MARSHAL(messageWithId);
                }
                this._memberTypes[this._defaultIndex].copy(src, dst);
                break;
            }
            case 17: {
                dst.write_long(src.read_long());
                break;
            }
            case 19: {
                int seqLength = src.read_long();
                if (this._length != 0 && seqLength > this._length) {
                    String messageWithId = "ID019081: Sequence bound is not violated.";
                    Logger.traceError("TypeCodeImpl.copy(InputStream, OutputStream)", messageWithId);
                    throw new MARSHAL(messageWithId);
                }
                dst.write_long(seqLength);
                int i = 0;
                while (i < seqLength) {
                    this._contentType.copy(src, dst);
                    ++i;
                }
                break;
            }
            case 20: {
                int i = 0;
                while (i < this._length) {
                    this._contentType.copy(src, dst);
                    ++i;
                }
                break;
            }
            case 21: 
            case 30: {
                this._contentType.copy(src, dst);
                break;
            }
            default: {
                throw new MARSHAL("ID019082");
            }
        }
    }
}

