/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.CORBA;

import com.sap.engine.interfaces.csiv2.SimpleProfileInterface;
import com.sap.engine.services.iiop.CORBA.CodeSetChooser;
import com.sap.engine.services.iiop.CORBA.ORB;
import com.sap.engine.services.iiop.CORBA.SimpleProfile;
import com.sap.engine.services.iiop.CORBA.portable.CORBAInputStream;
import com.sap.engine.services.iiop.CORBA.portable.CORBAOutputStream;

public final class Profile {
    private byte versionMinor = 1;
    private byte versionMajor = 1;
    private int tag = 0;
    private String host;
    private int port;
    private byte[] object_key;
    private SimpleProfileInterface[] components = new SimpleProfileInterface[0];
    private CodeSetChooser csChooser = new CodeSetChooser();
    private boolean builtCSC = false;
    private String codebase = null;
    int length = 0;
    ORB orb;

    public Profile(ORB orb0, String host0, int port0, byte[] objkey) {
        this.orb = orb0;
        this.host = host0;
        this.port = port0;
        this.object_key = objkey;
    }

    public Profile(String host0, int port0) {
        this.host = host0;
        this.port = port0;
    }

    private SimpleProfile buildCSComponent() {
        CORBAOutputStream os = new CORBAOutputStream(128);
        os.write_boolean(os.getEndian());
        os.write_long(this.csChooser.charCodeSet());
        int[] conv = this.csChooser.charConvertions();
        os.write_long(conv.length);
        int i = 0;
        while (i < conv.length) {
            os.write_long(conv[i]);
            ++i;
        }
        os.write_long(this.csChooser.wcharCodeSet());
        conv = this.csChooser.wcharConvertions();
        os.write_long(conv.length);
        int i2 = 0;
        while (i2 < conv.length) {
            os.write_long(conv[i2]);
            ++i2;
        }
        this.builtCSC = true;
        return new SimpleProfile(1, os.toByteArray_forSend(), 0, os.byteArray_forSend_length());
    }

    public Profile(ORB orb0, byte[] data) {
        this.orb = orb0;
        CORBAInputStream is = new CORBAInputStream(orb0, data);
        is.setEndian(is.read_boolean());
        this.loadComponents(is);
    }

    public Profile(ORB orb0, CORBAInputStream is) {
        this.orb = orb0;
        is.beginEncapsulation();
        this.loadComponents(is);
        is.endEncapsulation();
    }

    private void loadComponents(CORBAInputStream is) {
        this.versionMajor = is.read_octet();
        this.versionMinor = is.unaligned_read_octet();
        this.host = is.read_string();
        this.port = is.read_uShort();
        int len = is.read_long();
        this.object_key = new byte[len];
        is.read_octet_array(this.object_key, 0, len);
        this.tag = 0;
        if (this.versionMajor >= 1 && this.versionMinor >= 1) {
            int count = is.read_long();
            this.components = new SimpleProfile[count];
            int i = 0;
            while (i < count) {
                int id = is.read_long();
                if (id == 25) {
                    int length = is.beginSequence();
                    byte[] codebase_bytes = new byte[length];
                    is.read_octet_array(codebase_bytes, 0, length);
                    this.components[i] = new SimpleProfile(id, codebase_bytes);
                    this.codebase = new String(codebase_bytes, 5, length - 5 - 1);
                } else if (id == 1) {
                    this.csChooser.extractCodeSets(is);
                    switch (this.csChooser.verifyCodesets()) {
                        case 0: {
                            this.csChooser.setCharNative(this.csChooser.o_charCodeSet());
                            this.csChooser.setWCharNative(this.csChooser.o_wcharCodeSet());
                            this.components[i] = this.buildCSComponent();
                            break;
                        }
                        case 1: {
                            System.out.println("\n\n\n INV_OBJREF !!!!!!!!!!!!! \n\n\n");
                            break;
                        }
                        case 2: {
                            System.out.println("\n\n\n CODESET_INCOMPATIBLE !!!!!!!!!!!!! \n\n\n");
                        }
                    }
                } else {
                    this.components[i] = new SimpleProfile(id, is);
                }
                ++i;
            }
        } else {
            this.components = null;
        }
    }

    public Profile(ORB orb0, int tag0, byte[] data) {
        this(orb0, data);
        this.tag = tag0;
    }

    public Profile(ORB orb0, int tag0, CORBAInputStream is) {
        this(orb0, is);
        this.tag = tag0;
    }

    public Profile(byte vminor, byte vmajor, int tag0, String host0, int port0, byte[] object_key0, SimpleProfile[] components0) {
        this.versionMinor = vminor;
        this.versionMajor = vmajor;
        this.tag = tag0;
        this.host = host0;
        this.port = port0;
        this.object_key = new byte[object_key0.length];
        System.arraycopy(object_key0, 0, this.object_key, 0, object_key0.length);
        this.components = new SimpleProfile[components0.length];
        int i = 0;
        while (i < this.components.length) {
            this.components[i] = new SimpleProfile(components0[i]);
            ++i;
        }
    }

    public String getCodebase() {
        return this.codebase;
    }

    public void setVersion(byte major, byte minor) {
        this.versionMajor = major;
        this.versionMinor = minor;
    }

    public byte getVersionMinor() {
        return this.versionMinor;
    }

    public byte getVersionMajor() {
        return this.versionMajor;
    }

    public String getHost() {
        return this.host;
    }

    public int getPort() {
        return this.port;
    }

    public int getTAG() {
        return this.tag;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getObjectKeyLength() {
        return this.object_key.length;
    }

    public byte[] getObjectKey_ForSend() {
        return this.object_key;
    }

    public byte[] getObjectKey() {
        byte[] b_res = new byte[this.object_key.length];
        System.arraycopy(this.object_key, 0, b_res, 0, b_res.length);
        return b_res;
    }

    public SimpleProfileInterface[] getComponents() {
        return this.components;
    }

    public byte[] toByteArray() {
        CORBAOutputStream os = new CORBAOutputStream(256);
        os.write_long(this.tag);
        this.write_to_stream(os);
        byte[] array = os.toByteArray_forSend();
        this.length = os.byteArray_forSend_length();
        return array;
    }

    public void write_to_stream(CORBAOutputStream os) {
        os.beginEncapsulation(os.getEndian());
        os.write_octet(this.versionMajor);
        os.write_octet(this.versionMinor);
        os.write_string(this.host);
        os.write_short((short)(this.port & 0xFFFF));
        os.write_long(this.object_key.length);
        os.write_octet_array(this.object_key, 0, this.object_key.length);
        if (this.versionMajor >= 1 && this.versionMinor > 0) {
            if (!this.builtCSC) {
                if (this.components == null || this.components.length == 0) {
                    this.components = new SimpleProfile[1];
                    this.components[0] = this.buildCSComponent();
                } else {
                    SimpleProfile[] temp = new SimpleProfile[this.components.length + 1];
                    System.arraycopy(this.components, 0, temp, 0, this.components.length);
                    temp[this.components.length] = this.buildCSComponent();
                    this.components = temp;
                }
            }
            os.write_long(this.components.length);
            if (this.components != null && this.components.length > 0) {
                int i = 0;
                while (i < this.components.length) {
                    os.write_long(this.components[i].getTag());
                    os.write_long(this.components[i].getData().length);
                    os.write_octet_array(this.components[i].getData(), 0, this.components[i].getData().length);
                    ++i;
                }
            }
        }
        os.endEncapsulation();
    }

    public int getByteArrayLength() {
        return this.length;
    }

    public boolean isEquivalent(Profile p) {
        return this.versionMajor == p.versionMajor && this.versionMinor == p.versionMinor && this.tag == p.tag && this.port == p.port && this.host.equals(p.host) && this.areArrEquals(this.object_key, p.object_key);
    }

    boolean areArrEquals(byte[] b1, byte[] b2) {
        if (b1 == null) {
            return b2 == null;
        }
        if (b2 == null) {
            return false;
        }
        if (b1.length != b2.length) {
            return false;
        }
        int i = 0;
        while (i < b1.length) {
            if (b1[i] != b2[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public void addSimpleProfile(SimpleProfileInterface simple) {
        if (this.components == null) {
            this.components = new SimpleProfileInterface[0];
        }
        SimpleProfile[] newSimple = new SimpleProfile[this.components.length + 1];
        System.arraycopy(this.components, 0, newSimple, 0, this.components.length);
        newSimple[this.components.length] = simple;
        this.components = newSimple;
    }

    public CodeSetChooser getCsChooser() {
        return this.csChooser;
    }

    public static String toString(byte[] bytes, int begin, int length) {
        String hex = "0123456789ABCDEF";
        if (bytes == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        length = Math.min(length, bytes.length);
        int end = begin + length;
        int c = begin;
        while (c < end) {
            int count = 16;
            StringBuffer text = new StringBuffer();
            int j = c;
            while (--count >= 0 && j < end) {
                int charAsInt = bytes[j] & 0xFF;
                sb.append(" " + hex.charAt(charAsInt >> 4) + hex.charAt(charAsInt & 0xF));
                int ch = charAsInt > 31 ? (int)charAsInt : 46;
                text.append((char)ch);
                ++j;
            }
            while (--count >= -2) {
                sb.append("   ");
            }
            sb.append((Object)text);
            if (c < end - 16) {
                sb.append("\r\n");
            }
            c += 16;
        }
        return sb.toString();
    }
}

