/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.CORBA;

import com.sap.engine.interfaces.csiv2.SimpleProfileInterface;
import com.sap.engine.services.iiop.CORBA.CORBAObject;
import com.sap.engine.services.iiop.CORBA.IORInfoImpl;
import com.sap.engine.services.iiop.CORBA.ORB;
import com.sap.engine.services.iiop.CORBA.Profile;
import com.sap.engine.services.iiop.CORBA.portable.CORBAInputStream;
import com.sap.engine.services.iiop.internal.interceptors.InterceptorsStorage;
import org.omg.CORBA.Object;
import org.omg.CORBA.portable.OutputStream;
import org.omg.PortableInterceptor.IORInfo;
import org.omg.PortableInterceptor.IORInterceptor;

public final class IOR
extends IORInfoImpl {
    private String typeID;
    private ORB orb;

    public IOR(org.omg.CORBA.ORB orb0) {
        this.orb = (ORB)orb0;
        this.typeID = "";
    }

    public IOR(org.omg.CORBA.ORB orb0, String typeID0, String host, int port, byte[] objkey) {
        this.orb = (ORB)orb0;
        this.typeID = typeID0;
        this.store.put(0, new Profile(this.orb, host, port, objkey));
        this.invokeIORInterceptors();
    }

    public IOR(org.omg.CORBA.ORB orb0, String typeID0, String host, int port, byte[] objkey, byte verMajor, byte verMinor) {
        this.orb = (ORB)orb0;
        this.typeID = typeID0;
        Profile profile = new Profile(this.orb, host, port, objkey);
        profile.setVersion(verMajor, verMinor);
        this.store.put(0, profile);
        this.invokeIORInterceptors();
    }

    public IOR(org.omg.CORBA.ORB orb0, String typeID0, Profile[] profiles0) {
        this.typeID = typeID0;
        if (profiles0 == null) {
            return;
        }
        this.storeProfiles(profiles0);
        this.invokeIORInterceptors();
        this.orb = (ORB)orb0;
    }

    public Object read_object(CORBAInputStream is) {
        this.typeID = is.read_string();
        int profileCount = is.read_long();
        if (profileCount == 0) {
            return null;
        }
        Profile[] profiles = new Profile[profileCount];
        this.store.clear();
        int i = 0;
        while (i < profileCount) {
            int tag = is.read_long();
            profiles[i] = new Profile(this.orb, tag, is);
            this.store.put(tag, profiles[i]);
            ++i;
        }
        CORBAObject cObj = new CORBAObject(this);
        return cObj;
    }

    public void write_object(OutputStream os) {
        this.write_object(os, this.typeID);
    }

    public void write_object(OutputStream os, String id) {
        os.write_string(id);
        os.write_long(this.store.size());
        int[] keys = this.store.getAllKeys();
        int i = 0;
        while (i < keys.length) {
            Profile prof = (Profile)this.store.get(i);
            os.write_octet_array(prof.toByteArray(), 0, prof.getByteArrayLength());
            ++i;
        }
    }

    public String getTypeID() {
        return this.typeID;
    }

    public Profile getProfile() {
        if (this.store.containsKey(0)) {
            return (Profile)this.store.get(0);
        }
        return new Profile(this.orb, 0, "INIT".getBytes());
    }

    public org.omg.CORBA.ORB getORB() {
        return this.orb;
    }

    public void setORB(ORB orb0) {
        this.orb = orb0;
    }

    public boolean isEquivalent(IOR other) {
        return this.getProfile().isEquivalent(other.getProfile());
    }

    public boolean is_nil() {
        return this.store.size() == 0 && this.typeID.length() == 0;
    }

    private void storeProfiles(Profile[] profiles) {
        if (profiles == null) {
            return;
        }
        int i = 0;
        while (i < profiles.length) {
            this.store.put(profiles[i].getTAG(), profiles[i]);
            ++i;
        }
    }

    private void invokeIORInterceptors() {
        IORInterceptor[] interceptors = (IORInterceptor[])InterceptorsStorage.getIORInterceptors();
        int i = 0;
        while (i < interceptors.length) {
            interceptors[i].establish_components((IORInfo)this);
            ++i;
        }
        IORInterceptor[] local_interceptors = (IORInterceptor[])InterceptorsStorage.getIORInterceptors((org.omg.CORBA.ORB)this.orb);
        int i2 = 0;
        while (i2 < local_interceptors.length) {
            local_interceptors[i2].establish_components((IORInfo)this);
            ++i2;
        }
        Profile profile = (Profile)this.store.get(0);
        if (profile != null) {
            SimpleProfileInterface[] components = profile.getComponents();
            int i3 = 0;
            while (i3 < components.length) {
                if (components[i3].getTag() == 20) {
                    profile.setPort(0);
                }
                ++i3;
            }
        }
    }
}

