/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.iiop.CORBA;

import com.sap.engine.services.iiop.CORBA.NVListImpl;
import com.sap.engine.services.iiop.CORBA.NamedValueImpl;
import com.sap.engine.services.iiop.CORBA.ORB;
import com.sap.engine.services.iiop.logging.Logger;
import java.util.Vector;
import org.omg.CORBA.Any;
import org.omg.CORBA.Bounds;
import org.omg.CORBA.Context;
import org.omg.CORBA.NVList;
import org.omg.CORBA.NamedValue;

public class ContextImpl
extends Context {
    private String name = "";
    private Context parentContext = null;
    private Vector data = new Vector();
    private ORB orb;
    private String star = "*";

    public ContextImpl(ORB orb0) {
        this.orb = orb0;
    }

    public ContextImpl(ORB orb0, Context theParent, String theName) {
        this(orb0);
        this.parentContext = theParent;
        this.name = theName;
    }

    public String context_name() {
        return this.name;
    }

    public Context parent() {
        return this.parentContext;
    }

    public Context create_child(String child_ctx_name) {
        return new ContextImpl(this.orb, this, child_ctx_name);
    }

    public void set_one_value(String propname, Any propvalue) {
        this.data.add(new NamedValueImpl(this.orb, propname, propvalue, 0));
    }

    public void set_values(NVList values) {
        try {
            int i = 0;
            while (i < values.count()) {
                this.data.add(values.item(i));
                ++i;
            }
        }
        catch (Bounds b) {
            Logger.traceError("ContextImpl.set_values(NVList)", Logger.exceptionTrace(b));
        }
    }

    public void delete_values(String propname) {
        boolean found = false;
        Vector vector = this.data;
        synchronized (vector) {
            int i = 0;
            while (i < this.data.size()) {
                if (this.match(((NamedValue)this.data.elementAt(i)).name(), propname)) {
                    found = true;
                    this.data.removeElementAt(i--);
                }
                ++i;
            }
        }
        if (!found) {
            String messageWithId = "ID019026: Context.delete_values(): name not found.";
            Logger.traceError("ContextImpl.delete_values(String)", messageWithId);
            throw new RuntimeException(messageWithId);
        }
    }

    public NVList get_values(String start_scope, int op_flags, String pattern) {
        NVListImpl result = new NVListImpl(this.orb);
        boolean found = false;
        if (start_scope != null && !start_scope.equals(this.name) && this.parentContext == null) {
            String messageWithId = "ID019027: Invalid scope name.";
            Logger.traceError("ContextImpl.get_values(String, int, String)", messageWithId);
            throw new Error(messageWithId);
        }
        if (start_scope != null && !start_scope.equals(this.name) && this.parentContext != null) {
            return this.parentContext.get_values(start_scope, op_flags, pattern);
        }
        if (start_scope == null || start_scope.equals(this.name)) {
            int i = 0;
            while (i < this.data.size()) {
                if (this.match(((NamedValue)this.data.elementAt(i)).name(), pattern)) {
                    found = true;
                    NamedValue nv = (NamedValue)this.data.elementAt(i);
                    result.add_value(nv.name(), nv.value(), 0);
                }
                ++i;
            }
        }
        if (found) {
            return result;
        }
        if (this.parentContext != null && op_flags != 15) {
            return this.parentContext.get_values(start_scope, op_flags, pattern);
        }
        String messageWithId = "ID019028: Property not found.";
        Logger.traceError("ContextImpl.get_values(String, int, String)", messageWithId);
        throw new Error(messageWithId);
    }

    String cutWildcards(String in) {
        String s = in;
        while (s.indexOf("**") != -1) {
            int i = s.indexOf("**");
            String s1 = s.substring(0, i + 1);
            String s2 = s.substring(i + 2);
            s = s1 + s2;
        }
        return s;
    }

    String[] parsePattern(String thePattern) {
        String[] temp;
        String pattern = thePattern;
        String[] arr = new String[10];
        int i = 0;
        while (pattern.indexOf(this.star) != -1) {
            arr[i] = pattern.substring(0, pattern.indexOf(this.star));
            pattern = pattern.substring(pattern.indexOf(this.star) + 1);
            if (++i != arr.length) continue;
            temp = new String[arr.length + 5];
            System.arraycopy(arr, 0, temp, 0, arr.length);
            arr = temp;
        }
        arr[i] = pattern;
        temp = new String[i + 1];
        System.arraycopy(arr, 0, temp, 0, i + 1);
        return temp;
    }

    boolean match(String theName, String thePattern) {
        boolean randomStart = false;
        boolean randomEnd = false;
        String name = theName;
        String pattern = thePattern;
        if (pattern.indexOf(this.star) == -1) {
            return name.equals(pattern);
        }
        if ((pattern = this.cutWildcards(pattern)).startsWith(this.star)) {
            randomStart = true;
            pattern = pattern.substring(1);
        }
        if (pattern.endsWith(this.star)) {
            randomEnd = true;
            pattern = pattern.substring(0, pattern.length() - 1);
        }
        String[] arr = this.parsePattern(pattern);
        if (!randomStart && !name.startsWith(arr[0])) {
            return false;
        }
        if (!randomEnd && !name.endsWith(arr[arr.length - 1])) {
            return false;
        }
        int i = 0;
        while (i < arr.length) {
            if (name.indexOf(arr[i]) == -1) {
                return false;
            }
            name = name.substring(name.indexOf(arr[i]) + arr[i].length());
            ++i;
        }
        return true;
    }
}

