/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httptunneling;

import com.sap.engine.frame.cluster.transport.TransportFactory;
import com.sap.engine.lib.util.ConcurrentHashMapLongObject;
import com.sap.engine.lib.util.Queue;
import com.sap.engine.services.httptunneling.HttpTunnelingServiceFrame;
import com.sap.engine.services.httptunneling.HttpTunnelingSocket;
import com.sap.engine.services.httptunneling.ServerReader;
import com.sap.engine.services.httptunneling.ServerSocketListener;
import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;

public class HttpTunnelingServerSocket
extends ServerSocket {
    private ServerSocket server = null;
    private ServerSocketListener listener = null;
    private int port;
    private boolean closed = false;
    private int soTimeout = 0;
    private ServerReader[] readers;
    private Queue baseSockets = null;
    private Queue newSockets = null;
    private ConcurrentHashMapLongObject allSockets = null;
    long lastNumber = 0L;

    HttpTunnelingServerSocket(int port, TransportFactory socketFactory) throws IOException {
        super(port);
        super.close();
        this.server = socketFactory != null ? socketFactory.getServerSocket(port) : new ServerSocket(port);
        this.port = this.server.getLocalPort();
        this.createServiceThreads();
    }

    HttpTunnelingServerSocket(int port, int backlog, TransportFactory socketFactory) throws IOException {
        super(port);
        super.close();
        this.server = socketFactory != null ? socketFactory.getServerSocket(port, backlog) : new ServerSocket(port, backlog);
        this.port = this.server.getLocalPort();
        this.createServiceThreads();
    }

    HttpTunnelingServerSocket(int port, int backlog, String bindAddr, TransportFactory socketFactory) throws IOException {
        super(port);
        super.close();
        this.server = socketFactory != null ? socketFactory.getServerSocket(port, backlog, bindAddr) : new ServerSocket(port, backlog, InetAddress.getByName(bindAddr));
        this.port = port;
        this.createServiceThreads();
    }

    public HttpTunnelingServerSocket(int port) throws IOException {
        this(port, null);
    }

    public HttpTunnelingServerSocket(int port, int backlog) throws IOException {
        this(port, backlog, (TransportFactory)null);
    }

    private void createServiceThreads() {
        this.baseSockets = new Queue();
        this.newSockets = new Queue();
        this.allSockets = new ConcurrentHashMapLongObject();
        this.readers = new ServerReader[HttpTunnelingServiceFrame.prop_ReadersCount];
        int i = 0;
        while (i < this.readers.length) {
            this.readers[i] = new ServerReader(this, this.baseSockets, this.newSockets, this.allSockets);
            this.readers[i].setDaemon(true);
            this.readers[i].start();
            ++i;
        }
        this.listener = new ServerSocketListener(this);
        this.listener.setDaemon(true);
        this.listener.start();
    }

    Socket singleSocketAccept() throws IOException {
        return this.server.accept();
    }

    public Socket accept() throws IOException {
        HttpTunnelingSocket socket = null;
        long localSoTimeout = this.getSoTimeout();
        long elapsedTime = 0L;
        if (localSoTimeout > 0L) {
            Queue queue = this.newSockets;
            synchronized (queue) {
                socket = (HttpTunnelingSocket)this.newSockets.dequeue();
                while (socket == null && !this.closed) {
                    long enterTime = System.currentTimeMillis();
                    try {
                        this.newSockets.wait();
                    }
                    catch (InterruptedException iexc) {
                        HttpTunnelingServiceFrame.log(300, "Unexpected InterruptedException in HttpTunnelingServerSocket.accept:195 - " + iexc.getMessage());
                    }
                    if ((elapsedTime += System.currentTimeMillis() - enterTime) >= localSoTimeout) {
                        throw new InterruptedIOException();
                    }
                    socket = (HttpTunnelingSocket)this.newSockets.dequeue();
                }
                if (this.closed) {
                    throw new SocketException("socket closed");
                }
            }
        }
        Queue queue = this.newSockets;
        synchronized (queue) {
            socket = (HttpTunnelingSocket)this.newSockets.dequeue();
            while (socket == null && !this.closed) {
                try {
                    this.newSockets.wait();
                }
                catch (InterruptedException iexc) {
                    HttpTunnelingServiceFrame.log(300, "Unexpected InterruptedException in HttpTunnelingServerSocket.accept:219 - " + iexc.getMessage());
                }
                socket = (HttpTunnelingSocket)this.newSockets.dequeue();
            }
            if (this.closed) {
                throw new SocketException("socket closed");
            }
        }
        socket.setStatus((byte)2);
        return socket;
    }

    public int getLocalPort() {
        return this.port;
    }

    public synchronized void close() throws IOException {
        this.closed = true;
        this.listener.close();
        int i = 0;
        while (i < HttpTunnelingServiceFrame.prop_ReadersCount) {
            this.readers[i].interrupt();
            ++i;
        }
        Queue queue = this.newSockets;
        synchronized (queue) {
            this.newSockets.notifyAll();
        }
        this.closeSockets();
        this.server.close();
    }

    void closeSockets() {
        Object[] sockets = this.allSockets.getAllValues();
        int i = 0;
        while (i < sockets.length) {
            try {
                ((HttpTunnelingSocket)sockets[i]).close();
            }
            catch (IOException exc) {
                HttpTunnelingServiceFrame.log(400, "Unexpected exception in HttpTunnelingServerSocket.closeSockets - " + exc.getMessage());
            }
            ++i;
        }
    }

    public synchronized void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    public synchronized int getSoTimeout() {
        return this.soTimeout;
    }

    public InetAddress getInetAddress() {
        return this.server.getInetAddress();
    }

    public String toString() {
        return "HttpTunneling" + this.server.toString();
    }

    void addSocket(Socket newSocket) {
        Queue queue = this.baseSockets;
        synchronized (queue) {
            this.baseSockets.enqueue(newSocket);
            this.baseSockets.notify();
        }
    }

    void unregisterSocket(long number) {
        this.allSockets.remove(number);
    }

    public synchronized boolean isClosed() {
        return this.closed;
    }
}

