/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httptunneling;

import com.sap.engine.lib.util.ArrayByte;
import com.sap.engine.services.httptunneling.HttpTunnelingServiceFrame;
import com.sap.engine.services.httptunneling.HttpTunnelingSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;

public class HttpTunnelingInputStream
extends InputStream {
    private ArrayByte data = new ArrayByte();
    private HttpTunnelingSocket parentSocket = null;
    private int soTimeout = 0;
    private boolean locallyClosed = false;

    HttpTunnelingInputStream(HttpTunnelingSocket parentSocket) {
        this.parentSocket = parentSocket;
    }

    void addData(byte[] message) {
        if (!this.locallyClosed) {
            ArrayByte arrayByte = this.data;
            synchronized (arrayByte) {
                long elapsedTime = 0L;
                try {
                    while (this.data.size() + message.length > HttpTunnelingServiceFrame.prop_MaxBuffer) {
                        if (HttpTunnelingServiceFrame.prop_Timeout > 0) {
                            long enterTime = System.currentTimeMillis();
                            try {
                                this.data.wait((long)HttpTunnelingServiceFrame.prop_Timeout - elapsedTime);
                            }
                            catch (InterruptedException e) {
                                HttpTunnelingServiceFrame.log(300, "Unexpected InterruptedException in HttpTunnelingInputStream.addData - " + e.getMessage());
                            }
                            if ((elapsedTime += System.currentTimeMillis() - enterTime) < (long)HttpTunnelingServiceFrame.prop_Timeout) continue;
                            throw new InterruptedException();
                        }
                        this.data.wait();
                    }
                }
                catch (InterruptedException e) {
                    HttpTunnelingServiceFrame.log(400, "Connection killed: out of memory!");
                    try {
                        this.parentSocket.close();
                    }
                    catch (IOException ioe) {
                        HttpTunnelingServiceFrame.log(400, "Unexpected IOException in HttpTunnelingInputStream.addData - " + e.getMessage());
                    }
                    return;
                }
                this.data.addAll(message);
                this.data.notifyAll();
            }
        }
    }

    public int available() {
        if (this.locallyClosed) {
            return 0;
        }
        ArrayByte arrayByte = this.data;
        synchronized (arrayByte) {
            int n = this.data.size();
            return n;
        }
    }

    public int read() throws IOException {
        if (this.locallyClosed) {
            return -1;
        }
        ArrayByte arrayByte = this.data;
        synchronized (arrayByte) {
            int localSoTimeout = this.getSoTimeout();
            long elapsedTime = 0L;
            while (this.data.size() == 0 && this.parentSocket.getStatus() != 4 && this.parentSocket.getStatus() != 5 && !this.locallyClosed) {
                try {
                    if (localSoTimeout > 0) {
                        long enterTime = System.currentTimeMillis();
                        try {
                            this.data.wait((long)localSoTimeout - elapsedTime);
                        }
                        catch (InterruptedException iexc) {
                            HttpTunnelingServiceFrame.log(300, "Unexpected InterruptedException in HttpTunnelingInputStream.read:132 - " + iexc.getMessage());
                        }
                        if ((elapsedTime += System.currentTimeMillis() - enterTime) < (long)localSoTimeout) continue;
                        throw new InterruptedIOException();
                    }
                    this.data.wait();
                }
                catch (InterruptedException iexc) {
                    HttpTunnelingServiceFrame.log(300, "Unexpected InterruptedException in HttpTunnelingInputStream.read:144 - " + iexc.getMessage());
                }
            }
            if (this.parentSocket.getStatus() == 5 || this.locallyClosed) {
                if (this.data.size() > 0) {
                    byte result = this.data.removeAt(0);
                    this.data.notifyAll();
                    byte by = result;
                    return by;
                }
                int result = -1;
                return result;
            }
            if (this.parentSocket.getStatus() == 4) {
                throw new IOException("Socket Closed");
            }
            byte result = this.data.removeAt(0);
            this.data.notifyAll();
            byte by = result;
            return by;
        }
    }

    public int read(byte[] bytes) throws IOException {
        return this.read(bytes, 0, bytes.length);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public int read(byte[] bytes, int off, int length) throws IOException {
        if (this.locallyClosed) {
            return -1;
        }
        int localSoTimeout = this.getSoTimeout();
        long elapsedTime = 0L;
        ArrayByte arrayByte = this.data;
        synchronized (arrayByte) {
            while (this.data.size() == 0 && this.parentSocket.getStatus() != 4 && this.parentSocket.getStatus() != 5 && !this.locallyClosed) {
                try {
                    if (localSoTimeout > 0) {
                        long enterTime = System.currentTimeMillis();
                        try {
                            this.data.wait((long)localSoTimeout - elapsedTime);
                        }
                        catch (InterruptedException iexc) {
                            HttpTunnelingServiceFrame.log(300, "Unexpected InterruptedException in HttpTunnelingInputStream.read:208 - " + iexc.getMessage());
                        }
                        if ((elapsedTime += System.currentTimeMillis() - enterTime) < (long)localSoTimeout) continue;
                        throw new InterruptedIOException();
                    }
                    this.data.wait();
                }
                catch (InterruptedException iexc) {
                    HttpTunnelingServiceFrame.log(300, "Unexpected InterruptedException in HttpTunnelingInputStream.read:220 - " + iexc.getMessage());
                }
            }
            if (this.parentSocket.getStatus() == 4) {
                throw new IOException("Socket Closed");
            }
            int available = this.data.size();
            int actuallyRead = available <= length ? available : length;
            this.data.copyInto(0, bytes, off, actuallyRead);
            this.data.removeRange(0, actuallyRead);
            this.data.notifyAll();
            return actuallyRead;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long skip(long n) throws IOException {
        ArrayByte arrayByte = this.data;
        synchronized (arrayByte) {
            while ((long)this.data.size() < n && this.parentSocket.getStatus() != 4 && this.parentSocket.getStatus() != 5) {
                try {
                    this.data.wait();
                }
                catch (InterruptedException iexc) {
                    HttpTunnelingServiceFrame.log(300, "Unexpected InterruptedException in HttpTunnelingInputStream.skip - " + iexc.getMessage());
                }
            }
            if (this.parentSocket.getStatus() == 5) {
                int available = this.data.size();
                if (available == 0) {
                    return -1L;
                }
                int actuallyRead = (long)available <= n ? available : (int)n;
                this.data.removeRange(0, actuallyRead);
                return actuallyRead;
            }
            if (this.parentSocket.getStatus() == 4) {
                throw new IOException("Socket Closed");
            }
            this.data.removeRange(0, (int)n);
            return n;
        }
    }

    public void close() throws IOException {
        this.parentSocket.close();
    }

    void notifyAboutKill() {
        ArrayByte arrayByte = this.data;
        synchronized (arrayByte) {
            this.data.notifyAll();
        }
    }

    void notifyAboutSocketClosed() {
        ArrayByte arrayByte = this.data;
        synchronized (arrayByte) {
            this.data.notifyAll();
        }
    }

    public void closeLocally() {
        ArrayByte arrayByte = this.data;
        synchronized (arrayByte) {
            this.locallyClosed = true;
            this.data.notifyAll();
        }
    }

    synchronized void setSoTimeout(int soTimeout) {
        this.soTimeout = soTimeout;
    }

    synchronized int getSoTimeout() {
        return this.soTimeout;
    }
}

