/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httptunneling;

import com.sap.engine.services.httptunneling.HttpTunnelingServiceFrame;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;

public class HttpLib {
    public static final int MSG_NORMAL = 0;
    public static final int MSG_NEW = 1;
    public static final int MSG_HOLD = 2;
    public static final int MSG_RECEIVED = 4;
    public static final int MSG_KILL = 8;
    public static final int MSG_KILL_LOCALLY = 16;
    public static final long MSG_MASK = 255L;
    public static final long NUMBER_MASK = 0x7FFFFFFFFFFFFF00L;
    public static final long NUMBER_INCREMENT = 256L;
    public static final String CRLF = "\r\n";
    public static final String MESSAGE = "HttpTunneling: ";
    public static final String IDENTIFICATOR = "Identificator: ";
    public static final String LOCAL_IP = "Local-IP: ";
    public static final String LENGTH = "Content-Length: ";
    public static final String HOST = "Host: ";

    public static byte[] buildRequest(String host, int port, String id, int headerMessage, long headerNumber, int msgLen) {
        return HttpLib.buildRequest(host, port, id, (long)headerMessage + headerNumber, msgLen);
    }

    public static byte[] buildRequest(String host, int port, String id, int headerMessage, long headerNumber) {
        return HttpLib.buildRequest(host, port, id, (long)headerMessage + headerNumber, 0);
    }

    public static byte[] buildRequest(String host, int port, String id, long headerMessage) {
        return HttpLib.buildRequest(host, port, id, headerMessage, 0);
    }

    public static byte[] buildRequest(String host, int port, String id, long headerMessage, int msgLen) {
        return ("POST http://" + host + ':' + port + "/ HTTP/1.0\r\nReferer: SAP Labs Sofia\r\nAccept: */*\r\nHost: " + host + ':' + port + "\r\nHttpTunneling: " + headerMessage + "\r\nIdentificator: " + id + "\r\nContent-Length: " + msgLen + "\r\n\r\n").getBytes();
    }

    public static byte[] buildRequest(String host, int port, String id, String localip) {
        return ("POST http://" + host + ':' + port + "/ HTTP/1.0\r\nReferer: SAP Labs Sofia\r\nAccept: */*\r\nHost: " + host + ':' + port + "\r\nHttpTunneling: " + 1 + "\r\nIdentificator: " + id + CRLF + LOCAL_IP + localip + "\r\nContent-Length: " + 0 + "\r\n\r\n").getBytes();
    }

    public static byte[] buildResponse(long headerMessage) {
        return HttpLib.buildResponse(headerMessage, 0);
    }

    public static byte[] buildResponse(long headerMessage, int msgLen) {
        return ("HTTP/1.0 200 OK\r\nServer: SAP J2EE Engine\r\nHttpTunneling: " + headerMessage + "\r\nContent-Length: " + msgLen + "\r\n\r\n").getBytes();
    }

    private static String readLine(InputStream in) throws IOException {
        StringBuffer line = new StringBuffer();
        int i = 0;
        while ((i = in.read()) != -1) {
            if (i == 13) {
                in.read();
                return line.toString();
            }
            line.append((char)i);
            if (line.length() <= HttpTunnelingServiceFrame.prop_MaxHLLength) continue;
            throw new IOException("Invalid header");
        }
        throw new IOException();
    }

    public static String readHeader(InputStream in) throws IOException {
        StringBuffer header = new StringBuffer();
        String line = HttpLib.readLine(in);
        int count = 0;
        while (!line.equals("")) {
            if (++count > HttpTunnelingServiceFrame.prop_MaxHLines) {
                throw new IOException("Too many headers");
            }
            header.append(line);
            header.append(CRLF);
            line = HttpLib.readLine(in);
        }
        return header.toString();
    }

    public static byte[] readMessage(InputStream in, int length) throws IOException {
        int count;
        byte[] bytes = new byte[length];
        for (int read = 0; read != length; read += count) {
            count = in.read(bytes, read, length - read);
            if (count != -1) {
                continue;
            }
            throw new IOException("Connection reset by peer");
        }
        return bytes;
    }

    public static long getHeaderFullMessage(String header) throws UnsupportedEncodingException {
        try {
            int i = header.indexOf(MESSAGE) + MESSAGE.length();
            return Long.parseLong(header.substring(i, header.indexOf(CRLF, i)));
        }
        catch (Exception e) {
            throw new UnsupportedEncodingException(header);
        }
    }

    public static String getSocketId(String header) throws UnsupportedEncodingException {
        try {
            int i = header.indexOf(IDENTIFICATOR) + IDENTIFICATOR.length();
            return header.substring(i, header.indexOf(CRLF, i));
        }
        catch (Exception e) {
            throw new UnsupportedEncodingException(header);
        }
    }

    public static String getLocalIP(String header) throws UnsupportedEncodingException {
        try {
            int i = header.indexOf(LOCAL_IP) + LOCAL_IP.length();
            return header.substring(i, header.indexOf(CRLF, i));
        }
        catch (Exception e) {
            throw new UnsupportedEncodingException(header);
        }
    }

    public static String getHost(String header) throws UnsupportedEncodingException {
        try {
            int i = header.indexOf(HOST) + HOST.length();
            return header.substring(i, header.indexOf(":", i));
        }
        catch (Exception e) {
            throw new UnsupportedEncodingException(header);
        }
    }

    public static int getHeaderMessage(long headerMessage) {
        return (int)(headerMessage & 0xFFL);
    }

    public static long getHeaderNumber(long headerMessage) {
        return headerMessage & 0x7FFFFFFFFFFFFF00L;
    }

    public static int getMessageLength(String header) {
        try {
            int i = header.indexOf(LENGTH) + LENGTH.length();
            return Integer.parseInt(header.substring(i, header.indexOf(CRLF, i)));
        }
        catch (Exception e) {
            return 0;
        }
    }

    public static long getNextNumber(long currentNumber) {
        return currentNumber + 256L;
    }

    public static void timeoutWait(Object key, long timeout) throws InterruptedException {
        Object object = key;
        synchronized (object) {
            if (timeout == 0L) {
                key.wait();
            } else {
                key.wait(timeout);
            }
        }
    }
}

