/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httptunneling;

import com.sap.engine.services.httptunneling.HttpLib;
import com.sap.engine.services.httptunneling.HttpTunnelingServiceFrame;
import com.sap.engine.services.httptunneling.HttpTunnelingSocket;
import com.sap.engine.services.httptunneling.HttpTunnelingWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.net.Socket;

class ClientWriter
implements HttpTunnelingWriter {
    private String host;
    private int port;
    private long number;
    private HttpTunnelingSocket main;

    ClientWriter(String host, int port, long number, HttpTunnelingSocket main) {
        this.host = host;
        this.port = port;
        this.number = number;
        this.main = main;
    }

    public void send(byte[] bytes, int offset, int length, int type) throws IOException {
        Socket outputSocket = this.main.getSocket();
        OutputStream out = outputSocket.getOutputStream();
        out.write(HttpLib.buildRequest(this.host, this.port, this.main.getId(), type, this.number, length));
        if (bytes != null && bytes.length > 0) {
            out.write(bytes, offset, length);
        }
        out.flush();
        try {
            HttpLib.readHeader(outputSocket.getInputStream());
        }
        catch (IOException e) {
            this.main.kill();
        }
        try {
            out.close();
            outputSocket.close();
        }
        catch (Exception e) {
            HttpTunnelingServiceFrame.log(400, "Unexpected exception in ClientWriter.send - " + e.getMessage());
        }
    }

    public void close() {
        Socket outputSocket = null;
        OutputStream out = null;
        try {
            outputSocket = this.main.getSocket();
            out = outputSocket.getOutputStream();
            out.write(HttpLib.buildRequest(this.host, this.port, this.main.getId(), 8, this.number));
            out.flush();
            out.close();
            outputSocket.close();
            HttpLib.readHeader(outputSocket.getInputStream());
        }
        catch (Exception e) {
            HttpTunnelingServiceFrame.log(400, "Unexpected exception in ClientWriter.close - " + e.getMessage());
        }
    }

    public void notifyAboutKill() {
    }

    public void closeLocally() {
        Socket outputSocket = null;
        OutputStream out = null;
        try {
            outputSocket = this.main.getSocket();
            out = outputSocket.getOutputStream();
            out.write(HttpLib.buildRequest(this.host, this.port, this.main.getId(), 16, this.number));
            out.flush();
            out.close();
            outputSocket.close();
            HttpLib.readHeader(outputSocket.getInputStream());
        }
        catch (Exception e) {
            HttpTunnelingServiceFrame.log(400, "Unexpected exception in ClientWriter.closeLocally - " + e.getMessage());
        }
    }
}

