/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.httptunneling;

import com.sap.engine.services.httptunneling.HttpLib;
import com.sap.engine.services.httptunneling.HttpTunnelingInputStream;
import com.sap.engine.services.httptunneling.HttpTunnelingServiceFrame;
import com.sap.engine.services.httptunneling.HttpTunnelingSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.Socket;

class ClientReader
extends Thread {
    private Socket inputSocket = null;
    private InputStream in = null;
    private HttpTunnelingInputStream hin = null;
    private HttpTunnelingSocket main = null;
    private long number;
    private String host = null;
    private int port;
    private boolean closed = false;

    ClientReader(Socket inputSocket, String host, int port, HttpTunnelingInputStream hin, long number, HttpTunnelingSocket main) throws IOException {
        this.setDaemon(true);
        this.inputSocket = inputSocket;
        this.in = inputSocket.getInputStream();
        this.hin = hin;
        this.number = number;
        this.host = host;
        this.port = port;
        this.main = main;
    }

    public void run() {
        block13: {
            String header = null;
            try {
                while (!this.closed) {
                    header = HttpLib.readHeader(this.inputSocket.getInputStream());
                    long headerMessage = HttpLib.getHeaderFullMessage(header);
                    switch (HttpLib.getHeaderMessage(headerMessage)) {
                        case 0: {
                            ClientReader clientReader = this;
                            synchronized (clientReader) {
                                this.hin.addData(HttpLib.readMessage(this.in, HttpLib.getMessageLength(header)));
                                this.closeInput();
                                this.newInput();
                                break;
                            }
                        }
                        case 8: {
                            this.main.kill();
                            break;
                        }
                        case 16: {
                            ((HttpTunnelingInputStream)this.main.getInputStream()).closeLocally();
                            break;
                        }
                        default: {
                            throw new UnsupportedEncodingException();
                        }
                    }
                }
            }
            catch (UnsupportedEncodingException uee) {
                HttpTunnelingServiceFrame.log(500, "Connection with server killed - Invalid httptunneling header! \n" + header);
                if (!this.closed) {
                    this.main.kill();
                }
            }
            catch (Exception e) {
                HttpTunnelingServiceFrame.log(500, "Connection with server killed - " + e.toString());
                if (this.closed) break block13;
                this.main.kill();
            }
        }
    }

    private void newInput() throws IOException {
        this.inputSocket = this.main.getSocket();
        this.in = this.inputSocket.getInputStream();
        this.inputSocket.getOutputStream().write(HttpLib.buildRequest(this.host, this.port, this.main.getId(), 4, this.number));
    }

    private void closeInput() {
        try {
            this.in.close();
            this.inputSocket.close();
        }
        catch (Exception e) {
            HttpTunnelingServiceFrame.log(400, "Unexpected exception in ClientReader.closeInput - " + e.getMessage());
        }
        this.in = null;
        this.inputSocket = null;
    }

    synchronized void close() {
        this.closed = true;
        this.closeInput();
    }
}

