/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.file;

import com.sap.engine.services.file.FileData;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.Serializable;

public class RemoteFile
implements Serializable {
    static final long serialVersionUID = 2087149178522781984L;
    private File local;
    private FileData remote;
    private int bufferSize;

    public RemoteFile(File local, FileData remote) {
        this.local = local;
        this.remote = remote;
        this.bufferSize = 16384;
    }

    public synchronized void upload() throws IOException {
        RandomAccessFile in = new RandomAccessFile(this.local, "r");
        in.seek(0L);
        this.remote.openWrite();
        byte[] buffer = new byte[this.bufferSize];
        int read = in.read(buffer);
        while (read != -1) {
            this.remote.write(buffer, 0, read);
            read = in.read(buffer);
        }
        this.remote.closeWrite();
        in.close();
    }

    public synchronized void download() throws IOException {
        if (!this.local.getParentFile().exists()) {
            this.local.getParentFile().mkdirs();
        }
        RandomAccessFile out = new RandomAccessFile(this.local, "rw");
        out.seek(0L);
        this.remote.openRead();
        byte[] data = this.remote.read();
        while (data != null) {
            out.write(data);
            data = this.remote.read();
        }
        out.setLength(out.getFilePointer());
        this.remote.closeRead();
        out.close();
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public int getRemoteBufferSize() {
        return this.remote.getBufferSize();
    }

    public void setRemoteBufferSize(int size) {
        this.remote.setBufferSize(size);
    }
}

