/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.failover.storage;

import com.sap.engine.lib.io.FileUtils;
import com.sap.engine.services.failover.exceptions.PersistentStorageException;
import com.sap.engine.services.failover.serialization.ObjectSerializator;
import com.sap.engine.services.failover.storage.PersistentStorage;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class FilePersistentStorage
implements PersistentStorage {
    private static final Location LOCATION = Location.getLocation((String)"com.sap.engine.services.failover.storage");
    private String rootDir;
    private ObjectSerializator serializator;

    public FilePersistentStorage(ObjectSerializator _serializator, String _rootDir) {
        this.serializator = _serializator;
        this.rootDir = _rootDir;
    }

    public String getRootDir() {
        return this.rootDir;
    }

    public void setRootDir(String _rootDir) {
        this.rootDir = _rootDir;
    }

    public void serializeSession(String applicationName, String sessionId, Object appSession) throws PersistentStorageException {
        String path = this.rootDir + File.separator + applicationName + File.separator + sessionId + ".ser";
        FileOutputStream fOStream = null;
        File outputFile = null;
        boolean dirCreated = false;
        try {
            outputFile = new File(path);
            dirCreated = outputFile.getParentFile().mkdirs();
            fOStream = new FileOutputStream(outputFile);
            this.serializator.serializeObjectGraph(fOStream, appSession);
            fOStream.close();
        }
        catch (IOException ioex) {
            try {
                if (outputFile != null) {
                    if (fOStream != null) {
                        fOStream.close();
                    }
                    outputFile.delete();
                    if (dirCreated) {
                        outputFile.getParentFile().delete();
                    }
                }
            }
            catch (IOException exc) {
                LOCATION.traceThrowableT(100, null, (Throwable)exc);
            }
            PersistentStorageException toThrow = new PersistentStorageException("failover_0201", new String[]{applicationName, sessionId}, ioex);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
    }

    public void serializeSession(String applicationName, String sessionId, Object appSession, long expirationDuration) throws PersistentStorageException {
        this.serializeSession(applicationName, sessionId, appSession);
    }

    public Object readSession(String applicationName, String sessionId, ClassLoader appLoader) throws PersistentStorageException {
        return this.readObject(this.rootDir + File.separator + applicationName + File.separator + sessionId + ".ser", appLoader);
    }

    public String getType() {
        return "FilePersistentStorage";
    }

    public void deleteSession(String aliasName, String sessionId) throws PersistentStorageException {
        File tmpFile = new File(this.rootDir + File.separator + aliasName + File.separator + sessionId + ".ser");
        if (tmpFile.exists()) {
            tmpFile.delete();
        }
        if ((tmpFile = new File(this.rootDir + File.separator + aliasName + File.separator + sessionId + ".ser.security")).exists()) {
            tmpFile.delete();
        }
        this.deleteFolder(tmpFile.getParentFile());
    }

    public void deleteAllSessions(String aliasName) throws PersistentStorageException {
        File tmpFile = new File(this.rootDir + File.separator + aliasName);
        if (tmpFile.exists()) {
            FileUtils.deleteDirectory(tmpFile);
        }
    }

    public void destroy() {
    }

    private Object readObject(String path, ClassLoader appLoader) throws PersistentStorageException {
        try {
            FileInputStream fInStream = new FileInputStream(path);
            Object session = this.serializator.deserializeObjectGraph(fInStream, appLoader);
            fInStream.close();
            return session;
        }
        catch (ClassNotFoundException ex) {
            PersistentStorageException toThrow = new PersistentStorageException("failover_0202", ex);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        catch (IOException ioex) {
            PersistentStorageException toThrow = new PersistentStorageException("failover_0203", ioex);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
    }

    private void deleteFolder(File folder) {
        if (folder.exists() && folder.listFiles().length == 0) {
            folder.delete();
        }
    }
}

