/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.failover.storage;

import com.sap.engine.services.failover.db.SessionPersistentStorage;
import com.sap.engine.services.failover.db.SessionPersistentStorageImpl;
import com.sap.engine.services.failover.exceptions.PersistentStorageException;
import com.sap.engine.services.failover.serialization.ObjectSerializator;
import com.sap.engine.services.failover.storage.PersistentStorage;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.sql.DataSource;

public class DatabasePersistentStorage
implements PersistentStorage {
    private static final Location LOCATION = Location.getLocation((String)"com.sap.engine.services.failover.storage");
    private final SessionPersistentStorage db;
    private final ObjectSerializator objectSerializator;

    public DatabasePersistentStorage(ObjectSerializator _objectSerializator, DataSource dataSource) {
        this.objectSerializator = _objectSerializator;
        this.db = new SessionPersistentStorageImpl(dataSource);
    }

    public String getType() {
        return "DatabasePersistentStorage";
    }

    public Object readSession(String applicationName, String sessionId, ClassLoader appLoader) throws PersistentStorageException {
        byte[] bytes = this.db.readSession(applicationName, sessionId);
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            return this.objectSerializator.deserializeObjectGraph(bais, appLoader);
        }
        catch (IOException ioexc) {
            PersistentStorageException toThrow = new PersistentStorageException("failover_0213", null, ioexc);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        catch (ClassNotFoundException cexc) {
            PersistentStorageException toThrow = new PersistentStorageException("failover_0213", null, cexc);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
    }

    public void serializeSession(String applicationName, String sessionId, Object appSession) throws PersistentStorageException {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.objectSerializator.serializeObjectGraph(baos, appSession);
            bytes = baos.toByteArray();
        }
        catch (IOException ioexc) {
            PersistentStorageException toThrow = new PersistentStorageException("failover_0213", null, ioexc);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        this.db.writeSession(applicationName, sessionId, bytes, 0L);
    }

    public void serializeSession(String applicationName, String sessionId, Object appSession, long expirationDuration) throws PersistentStorageException {
        byte[] bytes = null;
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            this.objectSerializator.serializeObjectGraph(baos, appSession);
            bytes = baos.toByteArray();
        }
        catch (IOException ioexc) {
            PersistentStorageException toThrow = new PersistentStorageException("failover_0213", null, ioexc);
            toThrow.trace(LOCATION);
            throw toThrow;
        }
        this.db.writeSession(applicationName, sessionId, bytes, expirationDuration);
    }

    public void deleteSession(String aliasName, String sessionId) throws PersistentStorageException {
        this.db.deleteSession(aliasName, sessionId);
    }

    public void deleteAllSessions(String aliasName) throws PersistentStorageException {
        this.db.deleteAllSessions(aliasName);
    }

    public void setDataSource(DataSource ds) {
        ((SessionPersistentStorageImpl)this.db).setDataSource(ds);
    }

    public void destroy() {
    }
}

