/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.failover.db;

import com.sap.engine.services.failover.db.SQLStatements;
import com.sap.engine.services.failover.db.SessionPersistentStorage;
import com.sap.engine.services.failover.exceptions.PersistentStorageException;
import com.sap.tc.logging.Location;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Timestamp;
import javax.sql.DataSource;

public class SessionPersistentStorageImpl
implements SessionPersistentStorage {
    private static final Location LOCATION = Location.getLocation((String)"com.sap.engine.services.failover.db");
    private DataSource dataSource = null;

    public SessionPersistentStorageImpl(DataSource _datasource) {
        this.dataSource = _datasource;
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public byte[] readSession(String applicationName, String sessionId) throws PersistentStorageException {
        block13: {
            block12: {
                conn = null;
                try {
                    try {
                        conn = this.getConnection();
                        ps = conn.prepareStatement(SQLStatements.getSelectStatement());
                        ps.setString(1, applicationName);
                        ps.setString(2, sessionId);
                        rs = ps.executeQuery();
                        if (!rs.next()) {
                            toThrow = new PersistentStorageException("failover_0214", new String[]{applicationName, sessionId});
                            toThrow.trace(SessionPersistentStorageImpl.LOCATION, 100);
                            throw toThrow;
                        }
                        in = rs.getBinaryStream(1);
                        if (in != null) {
                            var7_12 = this.readFromStream(in);
                            var10_14 = null;
                            if (conn == null) return var7_12;
                            break block12;
                        }
                        blob = rs.getBlob(2);
                        if (blob == null) {
                            toThrow = new PersistentStorageException("failover_0214", new String[]{applicationName, sessionId});
                            toThrow.trace(SessionPersistentStorageImpl.LOCATION);
                            throw toThrow;
                        }
                        in = blob.getBinaryStream();
                        var8_20 = this.readFromStream(in);
                        break block13;
                    }
                    catch (IOException ioexc) {
                        toThrow = new PersistentStorageException("failover_0213", ioexc);
                        toThrow.trace(SessionPersistentStorageImpl.LOCATION);
                        throw toThrow;
                    }
                    catch (SQLException se) {
                        toThrow = new PersistentStorageException("failover_0212", se);
                        toThrow.trace(SessionPersistentStorageImpl.LOCATION);
                        throw toThrow;
                    }
                }
                catch (Throwable var9_22) {
                    var10_16 = null;
                    if (conn == null) throw var9_22;
                    try {
                        conn.close();
                        throw var9_22;
                    }
                    catch (SQLException sqlexc) {
                        SessionPersistentStorageImpl.LOCATION.traceThrowableT(300, null, (Throwable)sqlexc);
                        throw var9_22;
                    }
                }
            }
            ** try [egrp 2[TRYBLOCK] [3 : 258->267)] { 
lbl50:
            // 1 sources

            conn.close();
            return var7_12;
lbl52:
            // 1 sources

            catch (SQLException sqlexc) {
                SessionPersistentStorageImpl.LOCATION.traceThrowableT(300, null, (Throwable)sqlexc);
            }
            return var7_12;
        }
        var10_15 = null;
        if (conn == null) return var8_20;
        ** try [egrp 2[TRYBLOCK] [3 : 258->267)] { 
lbl60:
        // 1 sources

        conn.close();
        return var8_20;
lbl62:
        // 1 sources

        catch (SQLException sqlexc) {
            SessionPersistentStorageImpl.LOCATION.traceThrowableT(300, null, (Throwable)sqlexc);
        }
        return var8_20;
    }

    private byte[] readFromStream(InputStream in) throws IOException {
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        int num = in.read(buffer, 0, 1024);
        while (num != -1) {
            baos.write(buffer, 0, num);
            num = in.read(buffer, 0, 1024);
        }
        return baos.toByteArray();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void writeSession(String applicationName, String sessionId, byte[] sessionObject, long expirationDuration) throws PersistentStorageException {
        Connection conn;
        block7: {
            conn = null;
            conn = this.getConnection();
            PreparedStatement ps = null;
            int len = sessionObject.length;
            ps = len <= 2000 ? conn.prepareStatement(SQLStatements.getUpdateShortStatement()) : conn.prepareStatement(SQLStatements.getUpdateLongStatement());
            ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(sessionObject), len);
            ps.setTimestamp(2, this.getTimestamp(expirationDuration));
            ps.setString(3, applicationName);
            ps.setString(4, sessionId);
            int rows = ps.executeUpdate();
            if (rows != 0) break block7;
            ps = len <= 2000 ? conn.prepareStatement(SQLStatements.getCreateShortStatement()) : conn.prepareStatement(SQLStatements.getCreateLongStatement());
            ps.setString(1, applicationName);
            ps.setString(2, sessionId);
            ps.setBinaryStream(3, (InputStream)new ByteArrayInputStream(sessionObject), len);
            ps.setTimestamp(4, this.getTimestamp(expirationDuration));
            ps.executeUpdate();
        }
        Object var11_11 = null;
        if (conn == null) return;
        try {
            conn.close();
            return;
        }
        catch (SQLException sqlexc) {
            LOCATION.traceThrowableT(300, null, (Throwable)sqlexc);
        }
        return;
        {
            catch (SQLException se) {
                PersistentStorageException toThrow = new PersistentStorageException("failover_0212", se);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
        }
        catch (Throwable throwable) {
            Object var11_12 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException sqlexc) {
                LOCATION.traceThrowableT(300, null, (Throwable)sqlexc);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void createSession(String applicationName, String sessionId, byte[] sessionObject, long expirationDuration) throws PersistentStorageException {
        Connection conn = null;
        conn = this.getConnection();
        PreparedStatement ps = null;
        int len = sessionObject.length;
        ps = len <= 2000 ? conn.prepareStatement(SQLStatements.getCreateShortStatement()) : conn.prepareStatement(SQLStatements.getCreateLongStatement());
        ps.setString(1, applicationName);
        ps.setString(2, sessionId);
        ps.setBinaryStream(3, (InputStream)new ByteArrayInputStream(sessionObject), len);
        ps.setTimestamp(4, this.getTimestamp(expirationDuration));
        ps.executeUpdate();
        Object var10_10 = null;
        if (conn == null) return;
        try {
            conn.close();
            return;
        }
        catch (SQLException sqlexc) {
            LOCATION.traceThrowableT(300, null, (Throwable)sqlexc);
        }
        return;
        {
            catch (SQLException se) {
                PersistentStorageException toThrow = new PersistentStorageException("failover_0212", se);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException sqlexc) {
                LOCATION.traceThrowableT(300, null, (Throwable)sqlexc);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void updateSession(String applicationName, String sessionId, byte[] sessionObject, long expirationDuration) throws PersistentStorageException {
        Connection conn = null;
        conn = this.getConnection();
        PreparedStatement ps = null;
        int len = sessionObject.length;
        ps = len <= 2000 ? conn.prepareStatement(SQLStatements.getUpdateShortStatement()) : conn.prepareStatement(SQLStatements.getUpdateLongStatement());
        ps.setBinaryStream(1, (InputStream)new ByteArrayInputStream(sessionObject), len);
        ps.setTimestamp(2, this.getTimestamp(expirationDuration));
        ps.setString(3, applicationName);
        ps.setString(4, sessionId);
        ps.executeUpdate();
        Object var10_10 = null;
        if (conn == null) return;
        try {
            conn.close();
            return;
        }
        catch (SQLException sqlexc) {
            LOCATION.traceThrowableT(300, null, (Throwable)sqlexc);
        }
        return;
        {
            catch (SQLException se) {
                PersistentStorageException toThrow = new PersistentStorageException("failover_0212", se);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
        }
        catch (Throwable throwable) {
            Object var10_11 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException sqlexc) {
                LOCATION.traceThrowableT(300, null, (Throwable)sqlexc);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteSession(String applicationName, String sessionId) throws PersistentStorageException {
        Connection conn = null;
        conn = this.getConnection();
        PreparedStatement ps = conn.prepareStatement(SQLStatements.getDeleteStatement());
        ps.setString(1, applicationName);
        ps.setString(2, sessionId);
        ps.executeUpdate();
        Object var7_6 = null;
        if (conn == null) return;
        try {
            conn.close();
            return;
        }
        catch (SQLException sqlexc) {
            LOCATION.traceThrowableT(300, null, (Throwable)sqlexc);
        }
        return;
        {
            catch (SQLException se) {
                PersistentStorageException toThrow = new PersistentStorageException("failover_0212", se);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException sqlexc) {
                LOCATION.traceThrowableT(300, null, (Throwable)sqlexc);
            }
            throw throwable;
        }
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void deleteAllSessions(String applicationName) throws PersistentStorageException {
        Connection conn = null;
        conn = this.getConnection();
        PreparedStatement ps = conn.prepareStatement(SQLStatements.getDeleteAllStatement());
        ps.setString(1, applicationName);
        ps.executeUpdate();
        Object var6_5 = null;
        if (conn == null) return;
        try {
            conn.close();
            return;
        }
        catch (SQLException sqlexc) {
            LOCATION.traceThrowableT(300, null, (Throwable)sqlexc);
        }
        return;
        {
            catch (SQLException se) {
                PersistentStorageException toThrow = new PersistentStorageException("failover_0212", se);
                toThrow.trace(LOCATION);
                throw toThrow;
            }
        }
        catch (Throwable throwable) {
            Object var6_6 = null;
            if (conn == null) throw throwable;
            try {
                conn.close();
                throw throwable;
            }
            catch (SQLException sqlexc) {
                LOCATION.traceThrowableT(300, null, (Throwable)sqlexc);
            }
            throw throwable;
        }
    }

    public void setDataSource(DataSource ds) {
        this.dataSource = ds;
    }

    private Connection getConnection() throws SQLException, PersistentStorageException {
        if (this.dataSource == null) {
            PersistentStorageException toThrow = new PersistentStorageException("failover_0210");
            toThrow.log();
            throw toThrow;
        }
        return this.dataSource.getConnection();
    }

    private Timestamp getTimestamp(long duration) {
        if (duration == 0L) {
            return null;
        }
        return new Timestamp(duration + System.currentTimeMillis());
    }
}

