/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.util;

import com.sap.engine.services.ejb.util.WeakEntry;
import java.lang.ref.ReferenceQueue;

public class WeakHashtable {
    private static final int DEF_INITIAL_SIZE = 101;
    private static final float DEF_LOAD_FACTOR = 0.75f;
    private transient WeakEntry[] table;
    private transient int count = 0;
    private int threshold;
    private float loadFactor = 0.75f;
    private ReferenceQueue refQueue;

    public WeakHashtable(int aInitialCapacity) {
        if (aInitialCapacity <= 0) {
            aInitialCapacity = 101;
        }
        this.table = new WeakEntry[aInitialCapacity];
        this.threshold = (int)((float)aInitialCapacity * this.loadFactor);
        this.refQueue = new ReferenceQueue();
        this.count = 0;
    }

    public WeakHashtable() {
        this(101);
    }

    /*
     * WARNING - void declaration
     */
    private void processQueue() {
        WeakEntry we;
        while ((we = (WeakEntry)this.refQueue.poll()) != null) {
            void var1_1;
            if (var1_1.previous == null) {
                int index = (var1_1.hash & Integer.MAX_VALUE) % this.table.length;
                this.table[index] = var1_1.next;
            } else {
                var1_1.previous.next = var1_1.next;
            }
            if (var1_1.next != null) {
                var1_1.next.previous = var1_1.previous;
            }
            --this.count;
        }
    }

    public synchronized Object get(Object key) {
        this.processQueue();
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        WeakEntry e = this.table[index];
        while (e != null) {
            if (e.hash == hash && e.key.equals(key)) {
                return e.get();
            }
            e = e.next;
        }
        return null;
    }

    public synchronized Object put(Object key, Object value) {
        WeakEntry e;
        this.processQueue();
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % this.table.length;
        if (this.count >= this.threshold) {
            this.rehash();
            index = (hash & Integer.MAX_VALUE) % this.table.length;
        }
        this.table[index] = e = new WeakEntry(hash, key, value, this.table[index], this.refQueue);
        ++this.count;
        return null;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        WeakEntry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        WeakEntry[] newMap = new WeakEntry[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            WeakEntry temp = oldMap[i];
            while (temp != null) {
                WeakEntry first = temp;
                temp = temp.next;
                int newIndex = (first.hash & Integer.MAX_VALUE) % newCapacity;
                first.previous = null;
                first.next = newMap[newIndex];
                if (newMap[newIndex] != null) {
                    newMap[newIndex].previous = first;
                }
                newMap[newIndex] = first;
            }
        }
    }

    public int size() {
        return this.count;
    }
}

