/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.util;

import com.sap.engine.services.ejb.util.ObjectToStringException;
import com.sap.engine.services.ejb.util.ObjectToStringOutputStream;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.sql.Date;
import java.util.Hashtable;

public class ObjectToStringHashing {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing));
    public static final byte[] ascii_digits = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 123, 125};
    public static final byte[] ascii_delimitar = new byte[]{94};
    public static String delimitar = null;
    public static String digits = null;
    public static Hashtable methods = new Hashtable();
    public static final long lmask_ = 63L;
    public static final int mask_ = 63;
    public static final int digit_ln = 6;
    public static final int mask_4 = 15;
    public static final int mask_8 = 255;
    public static final int mask_16 = 65535;
    public static final long mask_32 = 0xFFFFFFFFL;
    static /* synthetic */ Class class$com$sap$engine$services$ejb$util$ObjectToStringHashing;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$util$Date;
    static /* synthetic */ Class class$java$sql$Date;
    static /* synthetic */ Class class$java$math$BigDecimal;
    static /* synthetic */ Class class$java$lang$Object;

    public static String getHash(byte b, int maxsize) {
        return ObjectToStringHashing.fit_to_size(ObjectToStringHashing.int_to_string(ObjectToStringHashing.byte_to_int(b)), maxsize);
    }

    public static String getHash(char c, int maxsize) {
        return ObjectToStringHashing.fit_to_size(ObjectToStringHashing.int_to_string(ObjectToStringHashing.char_to_int(c)), maxsize);
    }

    public static String getHash(short s, int maxsize) {
        return ObjectToStringHashing.fit_to_size(ObjectToStringHashing.int_to_string(ObjectToStringHashing.short_to_int(s)), maxsize);
    }

    public static String getHash(int i, int maxsize) {
        return ObjectToStringHashing.fit_to_size(ObjectToStringHashing.int_to_string(i), maxsize);
    }

    public static String getHash(long l, int maxsize) {
        return ObjectToStringHashing.fit_to_size(ObjectToStringHashing.long_to_string(l), maxsize);
    }

    public static String getHash(float f, int maxsize) {
        return ObjectToStringHashing.getHash(Float.floatToIntBits(f), maxsize);
    }

    public static String getHash(double d, int maxsize) {
        return ObjectToStringHashing.getHash(Double.doubleToLongBits(d), maxsize);
    }

    public static String getHash(Byte b, int maxsize) {
        return ObjectToStringHashing.getHash((byte)b, maxsize);
    }

    public static String getHash(Character c, int maxsize) {
        return ObjectToStringHashing.getHash(c.charValue(), maxsize);
    }

    public static String getHash(Short s, int maxsize) {
        return ObjectToStringHashing.getHash((short)s, maxsize);
    }

    public static String getHash(Integer i, int maxsize) {
        return ObjectToStringHashing.getHash((int)i, maxsize);
    }

    public static String getHash(Long l, int maxsize) {
        return ObjectToStringHashing.getHash((long)l, maxsize);
    }

    public static String getHash(Float f, int maxsize) {
        return ObjectToStringHashing.getHash(Float.floatToIntBits(f.floatValue()), maxsize);
    }

    public static String getHash(Double d, int maxsize) {
        return ObjectToStringHashing.getHash(Double.doubleToLongBits(d), maxsize);
    }

    public static String getHash(String str, int maxsize) {
        return ObjectToStringHashing.fit_to_size(str, maxsize);
    }

    public static String getHash(Date date, int maxsize) {
        return ObjectToStringHashing.getHash(date.toString(), maxsize);
    }

    public static String getHash(java.util.Date date, int maxsize) {
        return ObjectToStringHashing.getHash(date.toString(), maxsize);
    }

    public static String getHash(BigDecimal bigdecimal, int maxsize) {
        return ObjectToStringHashing.getHash(bigdecimal.toString(), maxsize);
    }

    public static String getCompoundHash(Object object, int maxsize) {
        try {
            StringBuffer sb = new StringBuffer(maxsize);
            Field[] fields = object.getClass().getFields();
            int i = 0;
            while (i < fields.length) {
                sb.append(ObjectToStringHashing.fieldToMethod(fields[i]).invoke(null, fields[i].get(object), new Integer(maxsize)));
                sb.append(delimitar);
                ++i;
            }
            if (sb.length() - 1 > maxsize) {
                int out_of_bounds = sb.length() - maxsize;
                String hash = null;
                sb = new StringBuffer(maxsize);
                int i2 = 0;
                while (i2 < fields.length) {
                    hash = (String)ObjectToStringHashing.fieldToMethod(fields[i2]).invoke(null, fields[i2].get(object), new Integer(Integer.MAX_VALUE));
                    int new_size = (hash.length() + 1) * out_of_bounds / (maxsize + 1 + out_of_bounds);
                    new_size = new_size > 2 ? new_size - 1 : 1;
                    hash = hash.substring(hash.length() - new_size);
                    sb.append(hash);
                    sb.append(delimitar);
                    ++i2;
                }
            }
            return sb.substring(0, sb.length() - 1);
        }
        catch (Exception ex) {
            LOCATION.traceThrowableT(500, null, (Throwable)ex);
            throw new ObjectToStringException("ejb_9017", new Object[]{object}, ex);
        }
    }

    public static String getCompoundHashNoError(Object object) {
        try {
            Method m = (Method)methods.get(object.getClass().getName());
            if (m == null) {
                return ObjectToStringHashing.getCompoundHash(object, 150);
            }
            return (String)m.invoke(null, object, new Integer(150));
        }
        catch (Exception ex) {
            LOCATION.traceThrowableT(300, null, (Throwable)ex);
            return "<Exception caught during serializaton : " + ex + ">";
        }
    }

    private static Method fieldToMethod(Field field) {
        String name = field.getType().getName();
        Method m = (Method)methods.get(name);
        if (m == null) {
            m = (Method)methods.get("java.lang.Object");
        }
        return m;
    }

    public static String getHash(Object obj, int maxsize) {
        try {
            ByteArrayOutputStream bos = null;
            ObjectToStringOutputStream oos = null;
            bos = new ByteArrayOutputStream();
            oos = new ObjectToStringOutputStream(bos);
            oos.writeObject(obj);
            byte[] bs = bos.toByteArray();
            return ObjectToStringHashing.byteArrayToString(bs, maxsize);
        }
        catch (IOException ioex) {
            LOCATION.traceThrowableT(500, null, (Throwable)ioex);
            throw new ObjectToStringException("ejb_9018", new Object[]{obj}, ioex);
        }
    }

    public static String byteArrayToString(byte[] old, int maxsize) {
        StringBuffer str = new StringBuffer(old.length >> 1);
        int triples = old.length / 3;
        int i = 0;
        while (i < triples) {
            str.append(ObjectToStringHashing.full_int_to_string(ObjectToStringHashing.triple_to_int(old[i], old[i + 1], old[i + 2])));
            i += 3;
        }
        switch (old.length - i) {
            case 0: {
                break;
            }
            case 1: {
                str.append(ObjectToStringHashing.full_int_to_string(ObjectToStringHashing.triple_to_int(old[i], 0, 0)));
                str.setLength(str.length() - 2);
                break;
            }
            case 2: {
                str.append(ObjectToStringHashing.full_int_to_string(ObjectToStringHashing.triple_to_int(old[i], old[i + 1], 0)));
                str.setLength(str.length() - 1);
            }
        }
        int k = str.length() - maxsize;
        while (k > 0) {
            int t = str.length() >> 1;
            t = t > k ? k : t;
            k -= t;
            StringBuffer new_sb = new StringBuffer(str.length());
            i = 0;
            while (i < t) {
                new_sb.append(str.charAt(i << 1));
                ++i;
            }
            i = t << 1;
            while (i < str.length()) {
                new_sb.append(str.charAt(i));
                ++i;
            }
            str = new_sb;
        }
        return str.toString();
    }

    private static int triple_to_int(int b1, int b2, int b3) {
        return ObjectToStringHashing.byte_to_int(b1) << 16 | ObjectToStringHashing.byte_to_int(b2) << 8 | ObjectToStringHashing.byte_to_int(b3);
    }

    private static int byte_to_int(int b) {
        return b & 0xFF;
    }

    private static int char_to_int(int c) {
        return c & 0xFFFF;
    }

    private static int short_to_int(int s) {
        return s & 0xFFFF;
    }

    private static long int_to_long(int i) {
        return (long)i & 0xFFFFFFFFL;
    }

    private static int long_hi(long l) {
        return (int)(l >> 32 & 0xFFFFFFFFL);
    }

    private static int long_lo(long l) {
        return (int)(l & 0xFFFFFFFFL);
    }

    private static String full_int_to_string(int i) {
        StringBuffer str = new StringBuffer(10);
        str.append(digits.charAt(ObjectToStringHashing.last_digit(i)));
        i = ObjectToStringHashing.shift_last_digit(i);
        str.append(digits.charAt(ObjectToStringHashing.last_digit(i)));
        i = ObjectToStringHashing.shift_last_digit(i);
        str.append(digits.charAt(ObjectToStringHashing.last_digit(i)));
        i = ObjectToStringHashing.shift_last_digit(i);
        str.append(digits.charAt(ObjectToStringHashing.last_digit(i)));
        return str.reverse().toString();
    }

    private static String int_to_string(int i) {
        if (i == 0) {
            return "0";
        }
        StringBuffer str = new StringBuffer(10);
        while (i != 0) {
            str.append(digits.charAt(ObjectToStringHashing.last_digit(i)));
            i = ObjectToStringHashing.shift_last_digit(i);
        }
        return str.reverse().toString();
    }

    private static String long_to_string(long l) {
        if (l == 0L) {
            return "0";
        }
        StringBuffer str = new StringBuffer(20);
        while (l != 0L) {
            str.append(digits.charAt(ObjectToStringHashing.last_digit(l)));
            l = ObjectToStringHashing.shift_last_digit(l);
        }
        return str.reverse().toString();
    }

    private static int last_digit(int i) {
        return i & 0x3F;
    }

    private static int last_digit(long l) {
        return (int)(l & 0x3FL);
    }

    private static long shift_last_digit(long l) {
        return l >> 6 & 0x3FFFFFFFFFFFFFFL;
    }

    private static int shift_last_digit(int i) {
        return i >> 6 & 0x3FFFFFF;
    }

    private static String fit_to_size(String str, int maxsize) {
        if (maxsize >= str.length()) {
            return str;
        }
        return str.substring(str.length() - maxsize);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            try {
                delimitar = new String(ascii_delimitar, "ASCII");
            }
            catch (UnsupportedEncodingException ueex) {
                LOCATION.traceThrowableT(200, null, (Throwable)ueex);
                delimitar = new String(ascii_delimitar, "ISO8859_1");
            }
            try {
                digits = new String(ascii_digits, "ASCII");
            }
            catch (UnsupportedEncodingException ueex) {
                digits = new String(ascii_digits, "ISO8859_1");
            }
        }
        catch (Exception ex) {
            LOCATION.traceThrowableT(500, null, (Throwable)ex);
            throw new ObjectToStringException("ejb_9016", null, ex);
        }
        try {
            methods.put("byte", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", Byte.TYPE, Integer.TYPE));
            methods.put("short", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", Short.TYPE, Integer.TYPE));
            methods.put("long", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", Long.TYPE, Integer.TYPE));
            methods.put("int", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", Integer.TYPE, Integer.TYPE));
            methods.put("char", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", Character.TYPE, Integer.TYPE));
            methods.put("float", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", Float.TYPE, Integer.TYPE));
            methods.put("double", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", Double.TYPE, Integer.TYPE));
            methods.put("java.lang.Byte", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", class$java$lang$Byte == null ? (class$java$lang$Byte = ObjectToStringHashing.class$("java.lang.Byte")) : class$java$lang$Byte, Integer.TYPE));
            methods.put("java.lang.Short", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", class$java$lang$Short == null ? (class$java$lang$Short = ObjectToStringHashing.class$("java.lang.Short")) : class$java$lang$Short, Integer.TYPE));
            methods.put("java.lang.Long", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", class$java$lang$Long == null ? (class$java$lang$Long = ObjectToStringHashing.class$("java.lang.Long")) : class$java$lang$Long, Integer.TYPE));
            methods.put("java.lang.Integer", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", class$java$lang$Integer == null ? (class$java$lang$Integer = ObjectToStringHashing.class$("java.lang.Integer")) : class$java$lang$Integer, Integer.TYPE));
            methods.put("java.lang.Character", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", class$java$lang$Character == null ? (class$java$lang$Character = ObjectToStringHashing.class$("java.lang.Character")) : class$java$lang$Character, Integer.TYPE));
            methods.put("java.lang.Float", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", class$java$lang$Float == null ? (class$java$lang$Float = ObjectToStringHashing.class$("java.lang.Float")) : class$java$lang$Float, Integer.TYPE));
            methods.put("java.lang.Double", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", class$java$lang$Double == null ? (class$java$lang$Double = ObjectToStringHashing.class$("java.lang.Double")) : class$java$lang$Double, Integer.TYPE));
            methods.put("java.util.Date", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", class$java$util$Date == null ? (class$java$util$Date = ObjectToStringHashing.class$("java.util.Date")) : class$java$util$Date, Integer.TYPE));
            methods.put("java.sql.Date", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", class$java$sql$Date == null ? (class$java$sql$Date = ObjectToStringHashing.class$("java.sql.Date")) : class$java$sql$Date, Integer.TYPE));
            methods.put("java.math.BigDecimal", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", class$java$math$BigDecimal == null ? (class$java$math$BigDecimal = ObjectToStringHashing.class$("java.math.BigDecimal")) : class$java$math$BigDecimal, Integer.TYPE));
            methods.put("java.lang.Object", (class$com$sap$engine$services$ejb$util$ObjectToStringHashing == null ? (class$com$sap$engine$services$ejb$util$ObjectToStringHashing = ObjectToStringHashing.class$("com.sap.engine.services.ejb.util.ObjectToStringHashing")) : class$com$sap$engine$services$ejb$util$ObjectToStringHashing).getMethod("getHash", class$java$lang$Object == null ? (class$java$lang$Object = ObjectToStringHashing.class$("java.lang.Object")) : class$java$lang$Object, Integer.TYPE));
        }
        catch (Exception ex) {
            LOCATION.traceThrowableT(500, null, (Throwable)ex);
            throw new ObjectToStringException("ejb_9016", null, ex);
        }
    }
}

