/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.util;

import com.sap.engine.lib.util.HashMapLongObject;
import com.sap.engine.lib.util.base.BaseDoublyLinkedList;
import com.sap.engine.lib.util.base.LinearItem;
import com.sap.engine.services.ejb.util.LRUHashtableItem;

public class LRUHashtable
extends HashMapLongObject {
    private static final int DEFAULT_INITIAL_CAPACITY = 101;
    private static final int DEFAULT_MAX_LRU_SIZE = 1000;
    private BaseDoublyLinkedList queue;

    public LRUHashtable() {
        this(101, 1000);
    }

    public LRUHashtable(int initialCapacity, int lruMaxSize) {
        super(initialCapacity);
        this.queue = new BaseDoublyLinkedList(lruMaxSize);
    }

    public void access(LRUHashtableItem value) {
        this.queue.removeItem(value);
        this.queue.addFirstItem(value);
    }

    public Object put(long key, Object value) {
        super.put(key, (LinearItem)value);
        if (!this.queue.addFirstItem((LinearItem)value)) {
            LRUHashtableItem removed = (LRUHashtableItem)this.queue.removeLastItem();
            this.queue.addFirstItem((LinearItem)value);
            super.remove(removed.getSessionKey());
            return removed;
        }
        return null;
    }

    public Object remove(long key) {
        LRUHashtableItem value = (LRUHashtableItem)super.remove(key);
        this.queue.removeItem(value);
        return value;
    }
}

