/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.util;

import com.sap.engine.services.ejb.util.EJBHashtableItem;

public class EJBHashtable {
    private static final int DEF_INITIAL_SIZE = 101;
    private static final float DEF_LOAD_FACTOR = 0.75f;
    private transient EJBHashtableItem[] table;
    private transient int count;
    private int threshold;
    private float loadFactor;

    public EJBHashtable(int initialCapacity, float loadFactor) {
        this.loadFactor = loadFactor;
        this.table = new EJBHashtableItem[initialCapacity];
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public EJBHashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public EJBHashtable() {
        this(101, 0.75f);
    }

    public int size() {
        return this.count;
    }

    public synchronized Object get(Object key, Object transaction) {
        EJBHashtableItem[] tab = this.table;
        int hash = key.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        EJBHashtableItem e = tab[index];
        while (e != null) {
            if (e.equals(key, transaction)) {
                return e;
            }
            e = e.getNextContext();
        }
        return null;
    }

    public synchronized void put(EJBHashtableItem value) {
        EJBHashtableItem next;
        EJBHashtableItem[] tab = this.table;
        int hash = value.hashCode();
        int index = (hash & Integer.MAX_VALUE) % tab.length;
        if (this.count >= this.threshold) {
            this.rehash();
            tab = this.table;
            index = (hash & Integer.MAX_VALUE) % tab.length;
        }
        if ((next = tab[index]) != null) {
            next.setPrevContext(value);
        }
        value.setNextContext(next);
        value.setPrevContext(null);
        tab[index] = value;
        ++this.count;
    }

    private void rehash() {
        int oldCapacity = this.table.length;
        EJBHashtableItem[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        EJBHashtableItem[] newMap = new EJBHashtableItem[newCapacity];
        this.threshold = (int)((float)newCapacity * this.loadFactor);
        this.table = newMap;
        int i = oldCapacity;
        while (i-- > 0) {
            EJBHashtableItem old = oldMap[i];
            while (old != null) {
                EJBHashtableItem currentItem = old;
                old = old.getNextContext();
                int index = (currentItem.hashCode() & Integer.MAX_VALUE) % newCapacity;
                EJBHashtableItem firstItemInNewBucket = newMap[index];
                if (firstItemInNewBucket != null) {
                    firstItemInNewBucket.setPrevContext(currentItem);
                }
                currentItem.setNextContext(firstItemInNewBucket);
                currentItem.setPrevContext(null);
                newMap[index] = currentItem;
            }
        }
    }

    public synchronized void remove(EJBHashtableItem value) {
        EJBHashtableItem prev = value.getPrevContext();
        EJBHashtableItem next = value.getNextContext();
        if (prev != null) {
            prev.setNextContext(next);
            if (next != null) {
                next.setPrevContext(prev);
            }
        } else {
            int hash = value.hashCode();
            int index = (hash & Integer.MAX_VALUE) % this.table.length;
            this.table[index] = next;
            if (next != null) {
                next.setPrevContext(null);
            }
        }
        --this.count;
    }

    public synchronized EJBHashtableItem[] getAllContexts() {
        EJBHashtableItem[] result = new EJBHashtableItem[this.count];
        int counter = 0;
        int i = 0;
        while (i < this.table.length) {
            EJBHashtableItem e = this.table[i];
            while (e != null) {
                result[counter++] = e;
                e = e.getNextContext();
            }
            ++i;
        }
        return result;
    }
}

