/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.util;

import com.sap.engine.services.ejb.exceptions.BaseRuntimeException;
import com.sap.tc.logging.Location;
import java.lang.reflect.Method;

public class ClassUtils {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$engine$services$ejb$util$ClassUtils == null ? (class$com$sap$engine$services$ejb$util$ClassUtils = ClassUtils.class$("com.sap.engine.services.ejb.util.ClassUtils")) : class$com$sap$engine$services$ejb$util$ClassUtils));
    static /* synthetic */ Class class$com$sap$engine$services$ejb$util$ClassUtils;

    private ClassUtils() {
    }

    public static boolean hasField(Class c, String fieldName) {
        try {
            return c.getField(fieldName) != null;
        }
        catch (NoSuchFieldException ex) {
            return false;
        }
    }

    public static boolean hasMethod(Class c, String methodName, Class[] params) {
        try {
            return c.getMethod(methodName, params) != null;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    public static boolean hasDeclaredMethod(Class c, String methodName, Class[] params) {
        try {
            return c.getDeclaredMethod(methodName, params) != null;
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
    }

    public static Method[] getDifferentMethods(Method[] methods) {
        Method[] newMethods = null;
        int repeated = 0;
        int pos = 0;
        int i = 0;
        while (i < methods.length - 1) {
            int j = i + 1;
            while (j < methods.length) {
                if (methods[j] != null && ClassUtils.equalsByDeclaration(methods[i], methods[j])) {
                    methods[i] = null;
                    ++repeated;
                    break;
                }
                ++j;
            }
            ++i;
        }
        if (repeated > 0) {
            newMethods = new Method[methods.length - repeated];
            int i2 = 0;
            while (i2 < methods.length) {
                if (methods[i2] != null) {
                    newMethods[pos++] = methods[i2];
                }
                ++i2;
            }
            return newMethods;
        }
        return methods;
    }

    private static boolean equalsByDeclaration(Method m1, Method m2) {
        Class<?>[] params1 = null;
        Class<?>[] params2 = null;
        if (m1.getName().equals(m2.getName()) && (params1 = m1.getParameterTypes()).length == (params2 = m2.getParameterTypes()).length) {
            int i = 0;
            while (i < params1.length) {
                if (params1[i] != params2[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static String method2string(Method m, boolean has_prefix) {
        try {
            StringBuffer sb = new StringBuffer();
            String name = m.getDeclaringClass().getName();
            sb.append(name + ".");
            name = m.getName();
            if (has_prefix) {
                sb.append(name.substring(1, name.length()) + "(");
            } else {
                sb.append(name + "(");
            }
            Class<?>[] params = m.getParameterTypes();
            int j = 0;
            while (j < params.length) {
                Class<?> param = params[j];
                String paramString = "";
                while (param.isArray()) {
                    paramString = paramString + "[]";
                    param = param.getComponentType();
                }
                paramString = param.getName() + paramString;
                sb.append(paramString);
                if (j < params.length - 1) {
                    sb.append(",");
                }
                ++j;
            }
            sb.append(")");
            return sb.toString();
        }
        catch (Exception e) {
            BaseRuntimeException toThrow = new BaseRuntimeException("", e);
            LOCATION.traceThrowableT(100, "", (Throwable)toThrow);
            return "<" + e + ">";
        }
    }

    public static String unfixClassName(String name) {
        int count = 0;
        int len = 0;
        StringBuffer sb = new StringBuffer(name);
        while (sb.charAt(len) == '[') {
            ++len;
            ++count;
        }
        if (count == 0) {
            return name;
        }
        char[] chars = new char[count * 2];
        int i = 0;
        while (i < chars.length) {
            chars[i++] = 91;
            chars[i++] = 93;
        }
        String str = sb.substring(count, name.length()).intern();
        str = str == "I" ? "int" : (str == "B" ? "byte" : (str == "C" ? "char" : (str == "J" ? "long" : (str == "Z" ? "boolean" : (str == "F" ? "float" : (str == "D" ? "double" : (str == "S" ? "short" : str.substring(1, str.length() - 1))))))));
        return str + new String(chars);
    }

    public static String fixClassName(String name) {
        int count = 0;
        int len = name.length() - 1;
        StringBuffer sb = new StringBuffer(name);
        while (sb.charAt(len) == ']') {
            len -= 2;
            ++count;
        }
        if (count == 0) {
            return name;
        }
        char[] chars = new char[count];
        int i = 0;
        while (i < chars.length) {
            chars[i] = 91;
            ++i;
        }
        String str = sb.substring(0, len + 1).intern();
        str = str == "int" ? "I" : (str == "byte" ? "B" : (str == "char" ? "C" : (str == "long" ? "J" : (str == "boolean" ? "Z" : (str == "float" ? "F" : (str == "double" ? "D" : (str == "short" ? "S" : "L" + str + ";")))))));
        return new String(chars) + str;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

