/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.util;

import com.sap.engine.boot.SystemProperties;
import com.sap.engine.compilation.CompilationFactory;
import com.sap.engine.compilation.Compiler;
import com.sap.engine.compilation.CompilerException;
import com.sap.engine.compilation.CompilerProcessFailureException;
import com.sap.engine.frame.core.configuration.Configuration;
import com.sap.engine.frame.core.configuration.ConfigurationException;
import com.sap.engine.frame.core.pool.PoolContext;
import com.sap.engine.lib.io.hash.FolderCompareResult;
import com.sap.engine.lib.io.hash.HashUtils;
import com.sap.engine.lib.util.iterators.ArrayEnumeration;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.EJBResourceAccessor;
import com.sap.engine.services.ejb.exceptions.BaseIOException;
import com.sap.engine.services.ejb.exceptions.BaseRuntimeException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBConfigurationException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBDeploymentException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBFileGenerationException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBFileOperationException;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipOutputStream;

public class AdminUtils {
    public static final String EXT_JAVA = ".java";
    public static final String EXT_CLASS = ".class";
    public static final String EXT_XML = ".xml";
    public static final String PRIMITIVE_BYTE = "byte";
    public static final String PRIMITIVE_CHAR = "char";
    public static final String PRIMITIVE_SHORT = "short";
    public static final String PRIMITIVE_INT = "int";
    public static final String PRIMITIVE_LONG = "long";
    public static final String PRIMITIVE_FLOAT = "float";
    public static final String PRIMITIVE_DOUBLE = "double";
    public static final String PRIMITIVE_BOOLEAN = "boolean";
    public static final char[] _reserved = new char[]{'|', '*', '@'};
    public static final char JNDI_SEP_CHAR = '/';
    public static final String JNDI_SEP_STRING = "/";
    public static final char ASTERISK_CHAR = '*';
    public static final String ASTERISK_STRING = "*";
    public static final char JAR_ENTRY_SEP_CHAR = '/';
    public static final String JAR_ENTRY_SEP_STRING = "/";
    private static final String JAR_ENTRIES_DELIMITER = ";";
    private static final String EMPTY = "";
    private static final String MFK_CLASSES_PACKAGE = "com/sap/engine/services/ejb/entity/finder/";
    private static final int MFK_CLASSES_COUNT = 9;
    private static final String UTF8 = "UTF8";
    private static final String PROP_JAVA_CLASS_PATH = "java.class.path";
    public static PoolContext poolContext = null;
    private static String[] mfkClasses = null;
    private static byte[][] mfkSources = null;

    public static void initMFKSources(ClassLoader add_ejb_loader) {
        mfkSources = new byte[9][];
        int i = 0;
        while (i < 9) {
            InputStream source = add_ejb_loader.getResourceAsStream(mfkClasses[i]);
            try {
                AdminUtils.mfkSources[i] = AdminUtils.read(source);
            }
            catch (IOException ioe) {
                throw new BaseRuntimeException("ejb_9061", new Object[]{mfkClasses[i]}, ioe);
            }
            ++i;
        }
    }

    public static void copyFile(File source, File dest) throws IOException {
        if (!dest.getParentFile().exists()) {
            dest.getParentFile().mkdirs();
        }
        FileInputStream fis = new FileInputStream(source);
        FileOutputStream fos = new FileOutputStream(dest);
        byte[] byteBuffer = poolContext.get(1024);
        int length = fis.read(byteBuffer, 0, 1024);
        while (length != -1) {
            fos.write(byteBuffer, 0, length);
            length = fis.read(byteBuffer, 0, 1024);
        }
        fis.close();
        fos.flush();
        fos.close();
        poolContext.release(byteBuffer);
    }

    public static void copyFileToDir(File file, File dir) throws IOException {
        File dest = new File(dir, file.getName());
        AdminUtils.copyFile(file, dest);
    }

    public static byte[] read(InputStream source) throws IOException {
        byte[] byteBuffer = poolContext.get(1024);
        try {
            byte[] byArray = AdminUtils.read(source, byteBuffer);
            Object var4_3 = null;
            poolContext.release(byteBuffer);
            return byArray;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            poolContext.release(byteBuffer);
            throw throwable;
        }
    }

    private static byte[] read(InputStream source, byte[] byteBuffer) throws IOException {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        int length = source.read(byteBuffer, 0, 1024);
        while (length != -1) {
            buffer.write(byteBuffer, 0, length);
            length = source.read(byteBuffer, 0, 1024);
        }
        source.close();
        buffer.flush();
        buffer.close();
        return buffer.toByteArray();
    }

    public static File writeToFile(InputStream source, File dir, String fileName) throws IOException {
        File newFile = new File(dir, fileName);
        if (!newFile.getParentFile().exists()) {
            newFile.getParentFile().mkdirs();
        }
        FileOutputStream fos = new FileOutputStream(newFile);
        byte[] byteBuffer = poolContext.get(1024);
        int length = source.read(byteBuffer, 0, 1024);
        while (length != -1) {
            fos.write(byteBuffer, 0, length);
            length = source.read(byteBuffer, 0, 1024);
        }
        source.close();
        fos.flush();
        fos.close();
        poolContext.release(byteBuffer);
        return newFile;
    }

    public static void writeCRCIndexForFolder(File dir, String crcFileName, String indexFileName, File appRootDir, Configuration ejbConfig) throws IOException, ConfigurationException {
        byte[] b = HashUtils.generateDirHash(dir);
        File file = new File(appRootDir, crcFileName);
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(b);
        fos.flush();
        fos.close();
        ejbConfig.addFileEntry(file);
        b = HashUtils.getIndexForFolder(dir);
        file = new File(appRootDir, indexFileName);
        fos = new FileOutputStream(file);
        fos.write(b);
        fos.flush();
        fos.close();
        ejbConfig.addFileEntry(file);
    }

    public static void updateCRCIndexForFolder(File dir, String crcFileName, String indexFileName, File appRootDir, Configuration ejbConfig) throws IOException, ConfigurationException {
        byte[] b = HashUtils.generateDirHash(dir);
        File file = new File(appRootDir, crcFileName);
        FileOutputStream fos = new FileOutputStream(file);
        fos.write(b);
        fos.flush();
        fos.close();
        ejbConfig.updateFile(file, true);
        b = HashUtils.getIndexForFolder(dir);
        file = new File(appRootDir, indexFileName);
        fos = new FileOutputStream(file);
        fos.write(b);
        fos.flush();
        fos.close();
        ejbConfig.updateFile(file, true);
    }

    public static void makeConsistent(File jarsDir, Configuration jarsConfig, Configuration ejbConfig, String crcFileName, String indexFileName, Vector warnings) throws EJBDeploymentException {
        if (!jarsDir.exists()) {
            jarsDir.mkdirs();
            try {
                String[] fileNames = jarsConfig.getAllFileEntryNames();
                int i = 0;
                while (i < fileNames.length) {
                    InputStream stream = jarsConfig.getFile(fileNames[i]);
                    AdminUtils.writeToFile(stream, jarsDir, fileNames[i]);
                    ++i;
                }
            }
            catch (ConfigurationException ce) {
                throw new EJBConfigurationException("ejb_9029", (Throwable)((Object)ce));
            }
            catch (IOException ioe) {
                throw new EJBFileOperationException("ejb_9030", (Throwable)ioe);
            }
        }
        try {
            InputStream isCRC = ejbConfig.getFile(crcFileName);
            byte[] persistentCRC = AdminUtils.read(isCRC);
            byte[] localCRC = HashUtils.generateDirHash(jarsDir);
            if (!AdminUtils.equalsByteArrays(persistentCRC, localCRC)) {
                InputStream isIndex = ejbConfig.getFile(indexFileName);
                byte[] persistentIndex = AdminUtils.read(isIndex);
                FolderCompareResult fcr = HashUtils.compareFolders(jarsDir, persistentIndex);
                ArrayEnumeration arrayEnumeration = fcr.getDeletedEntries();
                while (arrayEnumeration.hasNext()) {
                    String deletedFile = ((String)arrayEnumeration.next()).substring(1);
                    if (new File(jarsDir, deletedFile).delete()) continue;
                    warnings.add("Can not delete file: " + deletedFile + ".");
                }
                arrayEnumeration = fcr.getNewFolders();
                while (arrayEnumeration.hasNext()) {
                    String newFolder = ((String)arrayEnumeration.next()).substring(1);
                    if (new File(jarsDir, newFolder).mkdirs()) continue;
                    warnings.add("Can not create folder: " + newFolder + ".");
                }
                arrayEnumeration = fcr.getFilesForDownload();
                while (arrayEnumeration.hasNext()) {
                    String newFile = ((String)arrayEnumeration.next()).substring(1);
                    InputStream is = jarsConfig.getFile(newFile);
                    AdminUtils.writeToFile(is, jarsDir, newFile);
                }
            }
        }
        catch (ConfigurationException ce) {
            throw new EJBConfigurationException("ejb_9029", (Throwable)((Object)ce));
        }
        catch (IOException ioe) {
            throw new EJBFileOperationException("ejb_9031", (Throwable)ioe);
        }
    }

    public static boolean equalsByteArrays(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        int i = 0;
        while (i < a.length) {
            if (a[i] != b[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static void delFolder(File dir) {
        if (dir.isFile()) {
            dir.delete();
            return;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                AdminUtils.delFolder(files[i]);
            } else {
                files[i].delete();
            }
            ++i;
        }
        dir.delete();
    }

    public static void emptyFolder(File dir) {
        if (!dir.isDirectory()) {
            return;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                AdminUtils.delFolder(files[i]);
            } else {
                files[i].delete();
            }
            ++i;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void extractJar(File jarFile, File dirName) throws IOException {
        byte[] buff = poolContext.get(1024);
        BufferedInputStream bin = null;
        InputStream in = null;
        String entryName = null;
        File destFile = null;
        int index = 0;
        FileOutputStream out = null;
        ZipFile jar = null;
        try {
            jar = new ZipFile(jarFile);
            ZipEntry entry = null;
            Enumeration<? extends ZipEntry> e = jar.entries();
            while (e.hasMoreElements()) {
                entry = e.nextElement();
                if (entry == null) continue;
                entryName = entry.getName().replace('/', File.separatorChar);
                index = entryName.lastIndexOf(File.separatorChar);
                if (index != -1) {
                    new File(dirName, entryName.substring(0, index)).mkdirs();
                }
                if (entry.isDirectory()) continue;
                destFile = new File(dirName, entryName);
                out = new FileOutputStream(destFile);
                try {
                    in = jar.getInputStream(entry);
                }
                catch (IllegalStateException iex) {
                    jar = new ZipFile(jarFile);
                    in = jar.getInputStream(entry);
                }
                bin = new BufferedInputStream(in);
                try {
                    while ((index = bin.read(buff)) == buff.length) {
                        out.write(buff, 0, index);
                    }
                    if (index > 0) {
                        out.write(buff, 0, index);
                    }
                    out.flush();
                }
                catch (EOFException ex) {
                    throw new BaseIOException("ejb_9020");
                }
                in.close();
                bin.close();
                out.close();
            }
            Object var14_14 = null;
            poolContext.release(buff);
            if (jar == null) return;
        }
        catch (Throwable throwable) {
            Object var14_15 = null;
            poolContext.release(buff);
            if (jar == null) throw throwable;
            jar.close();
            throw throwable;
        }
        jar.close();
    }

    public static void compile(String classPath, String destDir, String[] javaFiles) throws DeploymentException {
        Compiler compiler;
        int filesToCompile = javaFiles.length;
        if (filesToCompile == 0) {
            return;
        }
        try {
            compiler = CompilationFactory.getCompiler((Properties)null);
        }
        catch (IOException e) {
            throw new EJBFileGenerationException("ejb_2157", (Throwable)e);
        }
        compiler.setNowarn(true);
        compiler.setEncoding(UTF8);
        compiler.setDirectory(destDir);
        compiler.addSourcepath(".");
        compiler.addClasspath(classPath + File.pathSeparatorChar + SystemProperties.getProperty(PROP_JAVA_CLASS_PATH));
        int i = 0;
        while (i < filesToCompile) {
            compiler.addJavaFileToCompile(destDir + File.separatorChar + javaFiles[i]);
            ++i;
        }
        EJBResourceAccessor.location.infoT("Compiling " + filesToCompile + " source files to " + destDir);
        try {
            try {
                compiler.compile();
            }
            catch (CompilerProcessFailureException cpfe) {
                throw new EJBFileGenerationException("ejb_9021", new Object[]{cpfe.getMessage()}, cpfe);
            }
            catch (CompilerException ce) {
                String errors = compiler.getErrorMessage();
                throw new EJBFileGenerationException("ejb_9021", new Object[]{errors}, ce);
            }
            Object var10_7 = null;
        }
        catch (Throwable throwable) {
            Object var10_8 = null;
            compiler.close();
            throw throwable;
        }
        compiler.close();
    }

    public static boolean differentJarFiles(File file1, File file2, Properties props) throws IOException {
        ZipFile jar2;
        StringBuffer addedEntries;
        StringBuffer changedEntries;
        StringBuffer removedEntries;
        block11: {
            removedEntries = new StringBuffer();
            changedEntries = new StringBuffer();
            addedEntries = new StringBuffer();
            ZipFile jar1 = null;
            jar2 = null;
            try {
                jar1 = new ZipFile(file1);
                jar2 = new ZipFile(file2);
                Enumeration<? extends ZipEntry> entries = jar1.entries();
                while (entries.hasMoreElements()) {
                    long crc2;
                    ZipEntry entry1 = entries.nextElement();
                    if (entry1.isDirectory()) continue;
                    String entryName = entry1.getName();
                    ZipEntry entry2 = jar2.getEntry(entryName);
                    if (entry2 == null) {
                        removedEntries.append(entryName).append(JAR_ENTRIES_DELIMITER);
                        continue;
                    }
                    long crc1 = entry1.getCrc();
                    if (crc1 == (crc2 = entry2.getCrc()) && crc1 != -1L) continue;
                    changedEntries.append(entryName).append(JAR_ENTRIES_DELIMITER);
                }
                Enumeration<? extends ZipEntry> entries2 = jar2.entries();
                while (entries2.hasMoreElements()) {
                    String entryName;
                    ZipEntry entry1;
                    ZipEntry entry2 = entries2.nextElement();
                    if (entry2.isDirectory() || (entry1 = jar1.getEntry(entryName = entry2.getName())) != null) continue;
                    addedEntries.append(entryName).append(JAR_ENTRIES_DELIMITER);
                }
                Object var17_16 = null;
                if (jar1 == null) break block11;
            }
            catch (Throwable throwable) {
                Object var17_17 = null;
                if (jar1 != null) {
                    jar1.close();
                }
                if (jar2 != null) {
                    jar2.close();
                }
                throw throwable;
            }
            jar1.close();
        }
        if (jar2 != null) {
            jar2.close();
        }
        boolean result = false;
        if (removedEntries.length() > 0) {
            ((Hashtable)props).put("removed_entries:" + file1.getName(), removedEntries.toString());
            result = true;
        }
        if (changedEntries.length() > 0) {
            ((Hashtable)props).put("changed_entries:" + file1.getName(), changedEntries.toString());
            result = true;
        }
        if (addedEntries.length() > 0) {
            ((Hashtable)props).put("added_entries:" + file1.getName(), addedEntries.toString());
            result = true;
        }
        return result;
    }

    public static void makeJar(File dir, String jarFileName) throws IOException {
        byte[] byteBuffer = poolContext.get(1024);
        ZipOutputStream jar = null;
        try {
            jar = new ZipOutputStream(new FileOutputStream(jarFileName));
        }
        catch (IOException ioerr) {
            throw new BaseIOException("ejb_9025", new Object[]{jarFileName}, ioerr);
        }
        try {
            try {
                File[] files = dir.listFiles();
                int i = 0;
                while (i < files.length) {
                    Vector entries = AdminUtils.listNames(files[i]);
                    Enumeration e = entries.elements();
                    while (e.hasMoreElements()) {
                        String entryName = (String)e.nextElement();
                        if (!entryName.endsWith(EXT_CLASS)) continue;
                        jar.putNextEntry(new ZipEntry(entryName));
                        FileInputStream fis = new FileInputStream(new File(dir, entryName.replace('/', File.separatorChar)));
                        jar.write(AdminUtils.read(fis, byteBuffer));
                        jar.closeEntry();
                    }
                    ++i;
                }
            }
            catch (IOException ioe) {
                throw new BaseIOException("ejb_9024", ioe);
            }
            Object var11_12 = null;
            poolContext.release(byteBuffer);
        }
        catch (Throwable throwable) {
            Object var11_13 = null;
            poolContext.release(byteBuffer);
            jar.close();
            throw throwable;
        }
        jar.close();
    }

    public static void makeClientJar(File tempDir, HashSet entryNames, String fullJarName) throws IOException {
        byte[] byteBuffer = poolContext.get(1024);
        ZipOutputStream jar = new ZipOutputStream(new FileOutputStream(fullJarName));
        try {
            Iterator it = entryNames.iterator();
            while (it.hasNext()) {
                String fileName = (String)it.next();
                jar.putNextEntry(new ZipEntry(fileName.replace(File.separatorChar, '/')));
                FileInputStream fis = new FileInputStream(new File(tempDir, fileName));
                jar.write(AdminUtils.read(fis, byteBuffer));
                jar.closeEntry();
            }
            int s = 0;
            while (s < 9) {
                jar.putNextEntry(new ZipEntry(mfkClasses[s]));
                jar.write(mfkSources[s]);
                jar.closeEntry();
                ++s;
            }
            Object var9_9 = null;
            poolContext.release(byteBuffer);
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            poolContext.release(byteBuffer);
            jar.close();
            throw throwable;
        }
        jar.close();
    }

    public static String convertClassName(Class cl) {
        return AdminUtils.convertClassName(cl.getName());
    }

    public static String convertClassName(String className) {
        if (className.charAt(0) != '[') {
            return className.replace('$', '.');
        }
        int first = className.indexOf(91);
        int last = className.lastIndexOf(91);
        char ch = className.charAt(last + 1);
        String st = EMPTY;
        int i = 0;
        while (i <= last - first) {
            st = st + "[]";
            ++i;
        }
        switch (ch) {
            case 'B': {
                return PRIMITIVE_BYTE + st;
            }
            case 'C': {
                return PRIMITIVE_CHAR + st;
            }
            case 'D': {
                return PRIMITIVE_DOUBLE + st;
            }
            case 'F': {
                return PRIMITIVE_FLOAT + st;
            }
            case 'I': {
                return PRIMITIVE_INT + st;
            }
            case 'J': {
                return PRIMITIVE_LONG + st;
            }
            case 'S': {
                return PRIMITIVE_SHORT + st;
            }
            case 'Z': {
                return PRIMITIVE_BOOLEAN + st;
            }
            case 'L': {
                String name = className.substring(last + 2, className.length() - 1) + st;
                return name.replace('$', '.');
            }
        }
        return EMPTY;
    }

    public static boolean isPrimitiveType(String type) {
        return type == null || type.equals(PRIMITIVE_INT) || type.equals(PRIMITIVE_BYTE) || type.equals(PRIMITIVE_CHAR) || type.equals(PRIMITIVE_SHORT) || type.equals(PRIMITIVE_LONG) || type.equals(PRIMITIVE_DOUBLE) || type.equals(PRIMITIVE_FLOAT) || type.equals(PRIMITIVE_BOOLEAN);
    }

    private static Vector listNames(File dir) throws IOException {
        Vector<String> result = new Vector<String>();
        String fileName = dir.getName();
        if (dir.isFile()) {
            result.add(fileName);
            return result;
        }
        File[] files = dir.listFiles();
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                Vector newFiles = AdminUtils.listNames(files[i]);
                Enumeration e = newFiles.elements();
                while (e.hasMoreElements()) {
                    result.add(fileName + "/" + (String)e.nextElement());
                }
            } else {
                result.add(fileName + "/" + files[i].getName());
            }
            ++i;
        }
        return result;
    }

    public static boolean stringInArray(String[] array, String str) {
        if (array == null) {
            return false;
        }
        int i = 0;
        while (i < array.length) {
            if (str.equals(array[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static String[] getValues(Properties props, String property) {
        String value = props.getProperty(property);
        if (value == null) {
            return new String[0];
        }
        StringTokenizer tokenizer = new StringTokenizer(value, JAR_ENTRIES_DELIMITER);
        String[] res = new String[tokenizer.countTokens()];
        int i = 0;
        while (tokenizer.hasMoreTokens()) {
            res[i++] = tokenizer.nextToken();
        }
        return res;
    }

    public static void addJarsForClasspath(HashSet set, String[] jars) {
        if (jars == null) {
            return;
        }
        int i = 0;
        while (i < jars.length) {
            set.add(jars[i]);
            ++i;
        }
    }

    public static String trimLeadingChars(String s, char c) {
        int length = s.length();
        int pos = 0;
        while (pos < length && s.charAt(pos) == c) {
            ++pos;
        }
        return s.substring(pos);
    }

    static {
        mfkClasses = new String[9];
        AdminUtils.mfkClasses[0] = "com/sap/engine/services/ejb/entity/finder/MultipleFinderKeyImpl.class";
        AdminUtils.mfkClasses[1] = "com/sap/engine/services/ejb/entity/finder/MultipleFinderKeyImplp4_Skel.class";
        AdminUtils.mfkClasses[2] = "com/sap/engine/services/ejb/entity/finder/_MultipleFinderKeyImpl_Tie.class";
        AdminUtils.mfkClasses[3] = "com/sap/engine/services/ejb/entity/finder/EJBIterator.class";
        AdminUtils.mfkClasses[4] = "com/sap/engine/services/ejb/entity/finder/EJBCollection.class";
        AdminUtils.mfkClasses[5] = "com/sap/engine/services/ejb/entity/finder/EJBEnumeration.class";
        AdminUtils.mfkClasses[6] = "com/sap/engine/services/ejb/entity/finder/_MultipleFinderKey_Stub.class";
        AdminUtils.mfkClasses[7] = "com/sap/engine/services/ejb/entity/finder/MultipleFinderKey.class";
        AdminUtils.mfkClasses[8] = "com/sap/engine/services/ejb/entity/finder/MultipleFinderKey_Stub.class";
    }
}

