/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.util;

import java.util.StringTokenizer;
import javax.naming.Context;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameClassPair;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;

public class AdminJNDIUtils {
    public static Context getContext(Context root, String name) throws NamingException {
        Context ctx = null;
        try {
            ctx = (Context)root.lookup(name);
        }
        catch (NamingException ne) {
            try {
                ctx = AdminJNDIUtils.createSubcontext(root, name);
            }
            catch (NamingException nex) {
                ctx = (Context)root.lookup(name);
            }
        }
        return ctx;
    }

    public static Context createSubcontext(Context root, String name) throws NamingException {
        Context current = root;
        String temp = null;
        StringTokenizer st = new StringTokenizer(name, "/");
        while (st.hasMoreTokens()) {
            temp = st.nextToken();
            try {
                current = (Context)current.lookup(temp);
            }
            catch (NamingException ne) {
                try {
                    current = current.createSubcontext(temp);
                }
                catch (NameAlreadyBoundException nabe) {
                    current = (Context)current.lookup(temp);
                }
            }
        }
        return current;
    }

    public static void bind(Context root, String name, Object obj) throws NamingException {
        String s;
        Context current = root;
        StringTokenizer st = new StringTokenizer(name, "/");
        while (true) {
            s = st.nextToken();
            if (!st.hasMoreTokens()) break;
            current = AdminJNDIUtils.createSubcontext(current, s);
        }
        current.rebind(s, obj);
    }

    public static void unbind(Context root, String name) throws NamingException {
        String s;
        Context current = root;
        StringBuffer subcontext = new StringBuffer();
        StringTokenizer st = new StringTokenizer(name, "/");
        while (true) {
            s = st.nextToken();
            if (!st.hasMoreTokens()) break;
            current = (Context)current.lookup(s);
            subcontext.append("/").append(s);
        }
        current.unbind(s);
        if (subcontext.length() > 0 && AdminJNDIUtils.isEmpty(current)) {
            AdminJNDIUtils.destroyContexts(root, subcontext.substring(1));
        }
    }

    public static void destroyContexts(Context root, String contextToDestroy) throws NamingException {
        AdminJNDIUtils.destroyContext(root, contextToDestroy);
        int index = contextToDestroy.lastIndexOf(47);
        if (index == -1) {
            return;
        }
        String subcontext = contextToDestroy.substring(0, index);
        Context ctx = (Context)root.lookup(subcontext);
        while (AdminJNDIUtils.isEmpty(ctx)) {
            root.destroySubcontext(subcontext);
            index = subcontext.lastIndexOf(47);
            if (index == -1) {
                return;
            }
            subcontext = subcontext.substring(0, index);
            ctx = (Context)root.lookup(subcontext);
        }
    }

    private static void destroyContext(Context root, String contextToDestroy) throws NamingException {
        AdminJNDIUtils.emptyContext((Context)root.lookup(contextToDestroy));
        root.destroySubcontext(contextToDestroy);
    }

    public static void emptyContext(Context root) throws NamingException {
        NameClassPair pair = null;
        NamingEnumeration<NameClassPair> ne = root.list("");
        while (ne.hasMoreElements()) {
            pair = (NameClassPair)ne.nextElement();
            if (AdminJNDIUtils.isContext(pair.getClassName())) {
                AdminJNDIUtils.emptyContext((Context)root.lookup(pair.getName()));
                root.destroySubcontext(pair.getName());
                continue;
            }
            root.unbind(pair.getName());
        }
    }

    private static boolean isContext(String name) {
        return name.indexOf("javax.naming.Context") != -1 || name.indexOf("javax.naming.directory.DirContext") != -1;
    }

    private static boolean isEmpty(Context ctx) throws NamingException {
        NamingEnumeration<NameClassPair> ne = ctx.list("");
        return !ne.hasMoreElements();
    }
}

