/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.entity.finder;

import com.sap.engine.services.ejb.entity.pm.Persistent;
import com.sap.engine.services.ejb.entity.pm.PersistentCache;
import com.sap.engine.services.ejb.entity.pm.TransactionContext;
import com.sap.engine.services.ejb.entity.pm.UpdatablePersistent;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.AbstractCollection;

public class SelectAbstractCollectionInitializer {
    public static void initLocal(AbstractCollection collection, ResultSet rset, Persistent persistent, PersistentCache pCache) throws SQLException {
        while (rset.next()) {
            Object pk = persistent.extractPrimaryKey(rset);
            collection.add(pCache.getEJBLocalObject(pk));
        }
    }

    public static void initRemote(AbstractCollection collection, ResultSet rset, Persistent persistent, PersistentCache pCache) throws SQLException {
        while (rset.next()) {
            Object pk = persistent.extractPrimaryKey(rset);
            collection.add(pCache.getEJBObject(pk));
        }
    }

    public static void initLocal(AbstractCollection collection, ResultSet rset, Persistent persistent, PersistentCache pCache, TransactionContext tc, boolean loadSelected, boolean setLock) throws SQLException {
        boolean repRead = tc.getPM().getIsolationLevel() == 1;
        while (rset.next()) {
            Object pk = persistent.extractPrimaryKey(rset);
            if (loadSelected) {
                Persistent up = pCache.getLoadedPersistent(pk, rset, repRead, setLock);
                if (setLock) {
                    ((UpdatablePersistent)up).setWriteLock(tc, false);
                }
            }
            collection.add(pCache.getEJBLocalObject(pk));
        }
    }

    public static void initRemote(AbstractCollection collection, ResultSet rset, Persistent persistent, PersistentCache pCache, TransactionContext tc, boolean loadSelected, boolean setLock) throws SQLException {
        boolean repRead = tc.getPM().getIsolationLevel() == 1;
        while (rset.next()) {
            Object pk = persistent.extractPrimaryKey(rset);
            if (loadSelected) {
                Persistent up = pCache.getLoadedPersistent(pk, rset, repRead, setLock);
                if (setLock) {
                    ((UpdatablePersistent)up).setWriteLock(tc, false);
                }
            }
            collection.add(pCache.getEJBObject(pk));
        }
    }
}

