/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.xml;

import com.sap.engine.lib.util.ArrayInt;
import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DataBaseProperties;
import com.sap.engine.services.ejb.deploy.descriptors.DependentValueDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.M2MRelationFieldMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RDependentValueMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RPersistentFieldMap;
import com.sap.engine.services.ejb.deploy.descriptors.rmap.RRelationFieldMap;
import com.sap.engine.services.ejb.deploy.tools.sql.Mappings;
import com.sap.engine.services.ejb.deploy.tools.sql.SetInfo;
import com.sap.engine.services.ejb.deploy.xml.ParseUtils;
import com.sap.engine.services.ejb.exceptions.BaseIllegalArgumentException;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLParserException;
import com.sap.engine.services.ejb.util.AdminUtils;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PersistentParser
extends ParseUtils {
    private static final String XML_NAME = "persistent.xml";
    private EJBJarDescriptor ejbJar;
    private AbstractSchema schema;
    private Element root;
    private Vector warnings;
    private ClassLoader loader;

    public void parseXML(EJBJarDescriptor _ejbJar, BufferedInputStream _xmlStream, Vector _warnings, ClassLoader _loader) throws DeploymentException {
        try {
            ClassLoader cl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
            StandardDOMParser parser = new StandardDOMParser();
            Thread.currentThread().setContextClassLoader(cl);
            parser.setValidation(true);
            Document doc = parser.parse((InputStream)_xmlStream);
            this.root = doc.getDocumentElement();
            _xmlStream.close();
        }
        catch (SAXException e) {
            throw new EJBXMLParserException("ejb_2200", new String[]{XML_NAME, _ejbJar.getJarName()}, e);
        }
        catch (IOException io) {
            throw new EJBXMLParserException("ejb_2200", new String[]{XML_NAME, _ejbJar.getJarName()}, io);
        }
        this.ejbJar = _ejbJar;
        this.warnings = _warnings;
        this.loader = _loader;
        this.schema = this.ejbJar.getAbstractSchema();
        this.scanDocument();
    }

    protected String getXMLFileName() {
        return XML_NAME;
    }

    protected String getEJBJarFileName() {
        return this.ejbJar.getJarName();
    }

    protected Vector getWarnings() {
        return this.warnings;
    }

    protected ClassLoader getClassLoader() {
        return this.loader;
    }

    private void scanDocument() throws DeploymentException {
        int i;
        DataBaseProperties dbProps = this.processDBProps();
        this.schema.setDBProperties(dbProps);
        this.schema.setSwitchOffVerification(this.doesTagExist(this.root, "switch-off-verification"));
        this.schema.setCreateTablesAtDeploy(this.doesTagExist(this.root, "create-tables-at-deploy"));
        this.initLocking();
        Element tempEl = this.getFirstElementByName(this.root, "entity-beans");
        if (tempEl != null) {
            NodeList nl = tempEl.getElementsByTagName("entity-bean");
            i = 0;
            while (i < nl.getLength()) {
                this.scanEntityEJB((Element)nl.item(i));
                ++i;
            }
        }
        CMPEntityDescriptor[] cmpDescrs = this.schema.getDescriptors();
        i = 0;
        while (i < cmpDescrs.length) {
            if (cmpDescrs[i].getTableName() == null) {
                throw new EJBXMLParserException("ejb_2341", new String[]{cmpDescrs[i].getEjbName()});
            }
            ++i;
        }
        this.relationships();
    }

    private void initLocking() {
        Element locking = this.getFirstElementByName(this.root, "locking");
        if (locking == null) {
            this.schema.setLockingType(1);
        } else {
            String lockingType = locking.getAttribute("type");
            if (lockingType.equals("Administrative")) {
                this.schema.setLockingType(0);
            } else if (lockingType.equals("Table")) {
                this.schema.setLockingType(1);
            } else if (lockingType.equals("Local")) {
                this.schema.setLockingType(2);
            } else {
                throw new BaseIllegalArgumentException("ejb_2186");
            }
        }
    }

    private void relationships() throws DeploymentException {
        Element relEl = this.getFirstElementByName(this.root, "relationships");
        if (relEl == null) {
            return;
        }
        NodeList nl = relEl.getElementsByTagName("table-relation");
        int m2mRelId = 0;
        int i = 0;
        while (i < nl.getLength()) {
            boolean m2mRealtionship;
            Element el2;
            String ejbName2;
            CMPEntityDescriptor dscr2;
            Element tableRel = (Element)nl.item(i);
            NodeList relation = tableRel.getElementsByTagName("table-relationship-role");
            Element el1 = (Element)relation.item(0);
            String ejbName1 = this.getElementText(this.getFirstElementByName(el1, "ejb-name"));
            CMPEntityDescriptor dscr1 = this.schema.getDescriptor(ejbName1);
            if (dscr1 == null) {
                throw new EJBXMLParserException("ejb_2302", new String[]{ejbName1});
            }
            String cmrFieldName1 = null;
            Element cmrFieldEl1 = this.getFirstElementByName(el1, "cmr-field");
            if (cmrFieldEl1 != null && (cmrFieldName1 = this.getElementText(cmrFieldEl1)).equals("")) {
                cmrFieldName1 = null;
            }
            if ((dscr2 = this.schema.getDescriptor(ejbName2 = this.getElementText(this.getFirstElementByName(el2 = (Element)relation.item(1), "ejb-name")))) == null) {
                throw new EJBXMLParserException("ejb_2302", new String[]{ejbName2});
            }
            String cmrFieldName2 = null;
            Element cmrFieldEl2 = this.getFirstElementByName(el2, "cmr-field");
            if (cmrFieldEl2 != null && (cmrFieldName2 = this.getElementText(cmrFieldEl2)).equals("")) {
                cmrFieldName2 = null;
            }
            PersistentField[] pk1 = dscr1.getPKCmpFields();
            PersistentField[] pk2 = dscr2.getPKCmpFields();
            RelationDescriptor relDescr = this.schema.getRelationDescriptor(dscr1.getId(), dscr2.getId(), cmrFieldName1, cmrFieldName2);
            if (relDescr == null) {
                throw new EJBXMLParserException("ejb_2303", new String[]{ejbName1, cmrFieldName1, ejbName2, cmrFieldName2});
            }
            OneSideRelationDescriptor side1 = relDescr.getSide1();
            OneSideRelationDescriptor side2 = relDescr.getSide2();
            boolean cmr1ToCmr2 = true;
            cmr1ToCmr2 = side1.getEjbId() == dscr1.getId();
            Element el = this.getFirstElementByName(tableRel, "help-table");
            boolean bl = m2mRealtionship = el != null;
            if (m2mRealtionship) {
                String helpTable = this.getElementText(el);
                M2MRelationFieldMap m2mRelMap = new M2MRelationFieldMap(m2mRelId++);
                m2mRelMap.setHelpTable(helpTable);
                String[] fk1 = this.getFkColumnsInOrder(el1, pk1, ejbName1, ejbName2);
                String[] fk2 = this.getFkColumnsInOrder(el2, pk2, ejbName1, ejbName2);
                if (fk1.length == 0 || fk2.length == 0) {
                    throw new EJBXMLParserException("ejb_2343", new String[]{ejbName1, ejbName2});
                }
                if (cmr1ToCmr2) {
                    m2mRelMap.setColumns1(fk1);
                    m2mRelMap.setColumns2(fk2);
                } else {
                    m2mRelMap.setColumns2(fk1);
                    m2mRelMap.setColumns1(fk2);
                }
                relDescr.setM2MMap(m2mRelMap);
            }
            if (cmr1ToCmr2) {
                this.fillOneSideRelation(el1, side1, pk2, ejbName1, ejbName2, m2mRealtionship);
                this.fillOneSideRelation(el2, side2, pk1, ejbName2, ejbName1, m2mRealtionship);
            } else {
                this.fillOneSideRelation(el2, side1, pk1, ejbName1, ejbName2, m2mRealtionship);
                this.fillOneSideRelation(el1, side2, pk2, ejbName2, ejbName1, m2mRealtionship);
            }
            ++i;
        }
        this.isEachCmrFieldDefined();
    }

    private void isEachCmrFieldDefined() throws DeploymentException {
        RelationDescriptor[] allRel = this.schema.getRelDescriptors();
        int i = 0;
        while (i < allRel.length) {
            OneSideRelationDescriptor side1 = allRel[i].getSide1();
            if (side1.getFieldDBMap() == null || side1.getMultiplicityType() == 4 && allRel[i].getM2MMap() == null) {
                OneSideRelationDescriptor side2 = allRel[i].getSide2();
                CMPEntityDescriptor descr1 = this.schema.getDescriptor(side1.getEjbId());
                CMPEntityDescriptor descr2 = this.schema.getDescriptor(side2.getEjbId());
                String ejbName1 = descr1.getEjbName();
                String ejbName2 = descr2.getEjbName();
                throw new EJBXMLParserException("ejb_2343", new String[]{ejbName1, ejbName2});
            }
            ++i;
        }
    }

    private void fillOneSideRelation(Element tableRelRoleEl, OneSideRelationDescriptor side, PersistentField[] pkFields, String ejbName1, String ejbName2, boolean m2m) throws DeploymentException {
        RRelationFieldMap dbMap = new RRelationFieldMap();
        String sKeyType = tableRelRoleEl.getAttribute("key-type");
        dbMap.setKey(this.convertKeyType(sKeyType));
        if (m2m) {
            dbMap.setColumn(new String[0]);
            if (dbMap.getKey() != 1) {
                dbMap.setKey(1);
                this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": Relationship between " + ejbName1 + " and " + ejbName2 + " with multiplicity M:N is defined incorrectly in persistnt.xml. <table-relationship-role> element, side " + ejbName1 + ", value of 'key-type' attribute should be PrimaryKey.");
            }
        } else {
            String[] fkColumns = this.getFkColumnsInOrder(tableRelRoleEl, pkFields, ejbName1, ejbName2);
            if (fkColumns.length == 0 && !sKeyType.equals("PrimaryKey")) {
                throw new EJBXMLParserException("ejb_2343", new String[]{ejbName1, ejbName2});
            }
            dbMap.setColumn(fkColumns);
        }
        side.setFieldDBMap(dbMap);
    }

    private void scanEntityEJB(Element ejb) throws DeploymentException {
        NodeList selectForUpdList;
        String ejbName = this.getElementText(this.getFirstElementByName(ejb, "ejb-name"));
        CMPEntityDescriptor dscr = this.schema.getDescriptor(ejbName);
        if (dscr == null) {
            this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": persistent.xml contains information about CMP Entity Bean with name : <" + ejbName + "> which is not described in the ejb-jar.xml");
            return;
        }
        dscr.setTableName(this.getElementText(this.getFirstElementByName(ejb, "table-name")));
        PersistentField[] cmp = dscr.getCmpFields();
        PersistentField[] pkCmp = dscr.getPKCmpFields();
        NodeList nl = ejb.getElementsByTagName("field-map");
        int i = 0;
        while (i < nl.getLength()) {
            Element tempEl = (Element)nl.item(i);
            String fieldName = this.getElementText(this.getFirstElementByName(tempEl, "field-name"));
            PersistentField persistentField = null;
            int pos = this.getPosInArray(cmp, fieldName);
            int pkPos = -1;
            if (pos == -1) {
                pkPos = this.getPosInArray(pkCmp, fieldName);
                if (pkPos == -1) {
                    throw new EJBXMLParserException("ejb_2304", new String[]{ejbName, fieldName});
                }
                persistentField = pkCmp[pkPos];
            } else {
                persistentField = cmp[pos];
            }
            if (this.isMappedToSetOfColumns(persistentField, tempEl)) {
                this.processDependentDBMap((DependentValueDescriptor)persistentField, tempEl);
            } else {
                persistentField = this.processSingleDBMap(persistentField, tempEl);
                if (pkPos != -1) {
                    pkCmp[pkPos] = persistentField;
                } else {
                    cmp[pos] = persistentField;
                }
            }
            NodeList mutableList = tempEl.getElementsByTagName("mutable");
            if (mutableList != null && mutableList.getLength() > 0) {
                persistentField.setMutable(true);
            }
            ++i;
        }
        this.isEachCmpFieldDescribed(pkCmp, ejbName);
        this.isEachCmpFieldDescribed(cmp, ejbName);
        nl = ejb.getElementsByTagName("finder-descriptor");
        boolean cmp11 = dscr.getCmpVersion() == 1;
        FinderDescriptor[] finders = dscr.getFinderDescriptors();
        Class<?> homeClass = null;
        if (cmp11 && finders.length == 0) {
            String homeClassName = dscr.getRemoteHomeInterface();
            try {
                homeClass = this.loader.loadClass(homeClassName);
            }
            catch (ClassNotFoundException cnfe) {
                throw new EJBXMLParserException("ejb_2307", new String[]{homeClassName}, cnfe);
            }
            finders = new FinderDescriptor[nl.getLength()];
            int k = 0;
            while (k < nl.getLength()) {
                Element tempEl = (Element)nl.item(k);
                finders[k] = this.fillFinderDescriptor11(tempEl, homeClass, dscr);
                ++k;
            }
            dscr.setFinderDescriptors(finders);
        } else {
            int i2 = 0;
            while (i2 < nl.getLength()) {
                Element tempEl = (Element)nl.item(i2);
                this.fillFinderDescriptor20(finders, tempEl, dscr);
                ++i2;
            }
        }
        NodeList readOnlyList = ejb.getElementsByTagName("read-only");
        if (readOnlyList != null && readOnlyList.getLength() > 0) {
            dscr.setReadOnly(true);
        }
        if ((selectForUpdList = ejb.getElementsByTagName("select-for-update")) != null && selectForUpdList.getLength() > 0) {
            dscr.setSelectForUpdate(true);
        }
    }

    private void isEachCmpFieldDescribed(PersistentField[] cmp, String ejbName) throws DeploymentException {
        int i = 0;
        while (i < cmp.length) {
            if (cmp[i].getFieldDBMap() == null) {
                throw new EJBXMLParserException("ejb_2342", new String[]{cmp[i].getFieldName(), ejbName});
            }
            ++i;
        }
    }

    private int getPosInArray(PersistentField[] cmp, String field) {
        int i = 0;
        while (i < cmp.length) {
            if (field.equals(cmp[i].getFieldName())) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    private int getColumnPos(DependentValueDescriptor dvCmp, String subfield, String fieldName) throws DeploymentException {
        String[] dvFields = dvCmp.getValueFieldNames();
        int i = 0;
        while (i < dvFields.length) {
            if (subfield.equals(dvFields[i])) {
                return i;
            }
            ++i;
        }
        throw new EJBXMLParserException("ejb_2306", new String[]{subfield, fieldName});
    }

    private String[] getFkColumnsInOrder(Element tableRelRoleEl, PersistentField[] pkFields, String ejbName1, String ejbName2) throws DeploymentException {
        NodeList fkColumns = tableRelRoleEl.getElementsByTagName("fk-column");
        if (fkColumns.getLength() == 0) {
            return new String[0];
        }
        if (fkColumns.getLength() != pkFields.length) {
            throw new EJBXMLParserException("ejb_2339", new String[]{ejbName1, ejbName2});
        }
        String[] result = new String[fkColumns.getLength()];
        int i = 0;
        while (i < fkColumns.getLength()) {
            Element fkColumn = (Element)fkColumns.item(i);
            Element pkFieldNameEl = this.getFirstElementByName(fkColumn, "pk-field-name");
            Element columnNameEl = this.getFirstElementByName(fkColumn, "column-name");
            String refPkFieldName = this.getElementText(pkFieldNameEl);
            String columnName = this.getElementText(columnNameEl);
            int j = 0;
            while (j < pkFields.length) {
                String pkFieldName = pkFields[j].getFieldName();
                if (pkFieldName.equals(refPkFieldName)) {
                    if (result[j] != null) {
                        throw new EJBXMLParserException("ejb_2340", new String[]{columnName, refPkFieldName, ejbName1, ejbName2});
                    }
                    result[j] = columnName;
                    break;
                }
                ++j;
            }
            ++i;
        }
        int j = 0;
        while (j < result.length) {
            if (result[j] == null) {
                throw new EJBXMLParserException("ejb_2344", new String[]{pkFields[j].getFieldName(), ejbName1, ejbName2});
            }
            ++j;
        }
        return result;
    }

    private int convertKeyType(String keyStr) {
        if (keyStr.equals("PrimaryKey")) {
            return 1;
        }
        if (keyStr.equals("ForeignKey")) {
            return 2;
        }
        if (keyStr.equals("UniqueKey")) {
            return 3;
        }
        return 0;
    }

    private void fillFinderDescriptor20(FinderDescriptor[] fDscrs, Element el, CMPEntityDescriptor cmpDscr) throws DeploymentException {
        String methodName = this.getElementText(this.getFirstElementByName(el, "method-name"));
        Element paramsEl = this.getFirstElementByName(el, "method-params");
        NodeList paramsList = paramsEl.getElementsByTagName("method-param");
        String[] paramsTypesFromXml = new String[paramsList.getLength()];
        int j = 0;
        while (j < paramsList.getLength()) {
            paramsTypesFromXml[j] = this.getElementText((Element)paramsList.item(j));
            ++j;
        }
        int i = 0;
        while (i < fDscrs.length) {
            if (fDscrs[i].getMethodName().equals(methodName)) {
                String[] paramsTypes = fDscrs[i].getParamsTypes();
                boolean paramFound = false;
                if (paramsTypes.length == paramsTypesFromXml.length) {
                    if (paramsTypes.length == 0) {
                        paramFound = true;
                    } else {
                        int j2 = 0;
                        while (j2 < paramsTypes.length) {
                            paramFound = false;
                            int k = 0;
                            while (k < paramsTypesFromXml.length) {
                                if (paramsTypes[j2].equals(paramsTypesFromXml[k])) {
                                    paramFound = true;
                                    break;
                                }
                                ++k;
                            }
                            if (!paramFound) break;
                            ++j2;
                        }
                    }
                    Element criteriaEl = null;
                    if (paramFound) {
                        if (!fDscrs[i].isSelect()) {
                            fDscrs[i].setParamsTypes(paramsTypesFromXml);
                            criteriaEl = this.getFirstElementByName(el, "criteria");
                            if (criteriaEl != null) {
                                fDscrs[i].setSQLStatement(this.getElementText(criteriaEl));
                                this.replaceArgs(fDscrs[i], cmpDscr.getEjbName());
                            }
                        }
                        fDscrs[i].setStoringMode(el.getElementsByTagName("switch-off-storing").getLength() == 0);
                        fDscrs[i].setQLVersionTo2_1(el.getElementsByTagName("ql-2.1-compatible").getLength() > 0);
                        fDscrs[i].setLazyLoading(el.getElementsByTagName("lazy-loading").getLength() > 0);
                        this.parseFetchSize(el, fDscrs[i]);
                        this.parseLockMode(el, fDscrs[i]);
                        if (criteriaEl != null && fDscrs[i].getLockMode() != null) {
                            StringBuffer methodName1 = new StringBuffer(methodName);
                            methodName1.append("(");
                            int l = 0;
                            while (l < paramsTypes.length) {
                                if (l > 0) {
                                    methodName1.append(",");
                                }
                                methodName1.append(paramsTypes[l]);
                                ++l;
                            }
                            methodName1.append(")");
                            this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": A custom SQL is specified for method " + methodName1.toString() + ".The additional option for setting '" + fDscrs[i].getLockMode() + "' lock on the selected entries will be ignored.");
                            fDscrs[i].setLockMode(null);
                        }
                        return;
                    }
                }
            }
            ++i;
        }
        if (methodName.equals("findByPrimaryKey") && paramsTypesFromXml.length == 1 && paramsTypesFromXml[0].equals(cmpDscr.getPrimaryKeyClass())) {
            FinderDescriptor findByPKDescr = new FinderDescriptor();
            findByPKDescr.setMethodName(methodName);
            findByPKDescr.setParamsTypes(new String[]{cmpDscr.getPrimaryKeyClass()});
            findByPKDescr.setStoringMode(el.getElementsByTagName("switch-off-storing").getLength() == 0);
            findByPKDescr.setLazyLoading(el.getElementsByTagName("lazy-loading").getLength() > 0);
            this.parseFetchSize(el, findByPKDescr);
            this.parseLockMode(el, findByPKDescr);
            findByPKDescr.setIsFindByPK(true);
            FinderDescriptor[] newFDscrs = new FinderDescriptor[fDscrs.length + 1];
            newFDscrs[0] = findByPKDescr;
            System.arraycopy(fDscrs, 0, newFDscrs, 1, fDscrs.length);
            cmpDscr.setFinderDescriptors(newFDscrs);
            return;
        }
        throw new EJBXMLParserException("ejb_2308", new String[]{this.methodToStr(methodName, paramsTypesFromXml), cmpDscr.getEjbName()});
    }

    private void parseFetchSize(Element parentEl, FinderDescriptor f) {
        Element fetchSizeEl = this.getFirstElementByName(parentEl, "fetch-size");
        if (fetchSizeEl != null) {
            try {
                int fetchSize = Integer.parseInt(this.getElementText(fetchSizeEl));
                if (fetchSize < 1) {
                    this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": the <fetch-size> must be positive integer. The <fetch-size> is ignored.");
                } else {
                    f.setFetchSize(fetchSize);
                }
            }
            catch (NumberFormatException nfe) {
                this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": the <fetch-size> does not contain a parsable integer. The <fetch-size> is ignored.");
            }
        }
    }

    private void parseLockMode(Element el, FinderDescriptor f) {
        NodeList loadModeNL = el.getElementsByTagName("load-selected-objects");
        if (loadModeNL.getLength() > 0) {
            f.setToLoadSelectedObjects(true);
            String lockMode = ((Element)loadModeNL.item(0)).getAttribute("lock");
            if (!lockMode.equals("")) {
                f.setLockMode(lockMode);
            }
        }
    }

    private FinderDescriptor fillFinderDescriptor11(Element el, Class homeClass, CMPEntityDescriptor cmpDescr) throws DeploymentException {
        String sqlStatemnt;
        String methodName = this.getElementText(this.getFirstElementByName(el, "method-name"));
        Element paramsEl = this.getFirstElementByName(el, "method-params");
        NodeList paramsList = paramsEl.getElementsByTagName("method-param");
        String[] paramsTypesFromXml = new String[paramsList.getLength()];
        int j = 0;
        while (j < paramsList.getLength()) {
            paramsTypesFromXml[j] = this.getElementText((Element)paramsList.item(j));
            ++j;
        }
        Class[] paramsClass = this.getParamClasses(paramsTypesFromXml, homeClass.getName(), methodName);
        Method reflIntfMethod = null;
        try {
            reflIntfMethod = homeClass.getMethod(methodName, paramsClass);
        }
        catch (NoSuchMethodException nsme1) {
            throw new EJBXMLParserException("ejb_2308", new String[]{this.methodToStr(methodName, paramsTypesFromXml), homeClass.getName()});
        }
        FinderDescriptor finder = new FinderDescriptor();
        finder.setMethodName(methodName);
        finder.setParamsTypes(paramsTypesFromXml);
        if (methodName.equals("findByPrimaryKey") && paramsTypesFromXml.length == 1 && paramsTypesFromXml[0].equals(cmpDescr.getPrimaryKeyClass())) {
            finder.setIsFindByPK(true);
        }
        finder.setFinder();
        finder.setReturnType(reflIntfMethod.getReturnType().getName());
        Class<?>[] exceptionsClass = reflIntfMethod.getExceptionTypes();
        String[] exceptions = new String[exceptionsClass.length];
        int n = 0;
        while (n < exceptionsClass.length) {
            exceptions[n] = exceptionsClass[n].getName();
            ++n;
        }
        finder.setExceptions(exceptions);
        finder.setRemote();
        Element criteriaEl = this.getFirstElementByName(el, "criteria");
        if (criteriaEl != null) {
            sqlStatemnt = this.getElementText(criteriaEl);
            if (sqlStatemnt.equals("")) {
                throw new EJBXMLParserException("ejb_2338", new String[]{this.methodToStr(methodName, paramsTypesFromXml), homeClass.getName()});
            }
            if (cmpDescr.useSelectForUpdate()) {
                sqlStatemnt = sqlStatemnt + " for update ";
            }
        } else {
            throw new EJBXMLParserException("ejb_2338", new String[]{this.methodToStr(methodName, paramsTypesFromXml), homeClass.getName()});
        }
        finder.setSQLStatement(sqlStatemnt);
        this.replaceArgs(finder, cmpDescr.getEjbName());
        finder.setStoringMode(el.getElementsByTagName("switch-off-storing").getLength() == 0);
        finder.setLazyLoading(el.getElementsByTagName("lazy-loading").getLength() > 0);
        this.parseFetchSize(el, finder);
        this.parseLockMode(el, finder);
        if (criteriaEl != null && finder.getLockMode() != null) {
            this.warnings.add(this.getEJBJarFileName() + ", " + this.getXMLFileName() + ": A custom SQL is specified for method " + reflIntfMethod.toString() + ".The additional option for setting '" + finder.getLockMode() + "' lock on the selected entries will be ignored.");
            finder.setLockMode(null);
        }
        return finder;
    }

    private String methodToStr(String methodName, String[] params) {
        StringBuffer sBuff = new StringBuffer(methodName);
        sBuff.append("(");
        int i = 0;
        while (i < params.length) {
            sBuff.append(" ");
            sBuff.append(params[i]);
            ++i;
        }
        sBuff.append(")");
        return sBuff.toString();
    }

    private void replaceArgs(FinderDescriptor descr, String ejbName) throws DeploymentException {
        String criteria = descr.getSQLStatement();
        if (criteria.indexOf(63) == -1) {
            descr.setSetInfo(new SetInfo[0]);
            return;
        }
        int pos = 0;
        int index = 0;
        String res = "";
        Vector<SetInfo> vSetInfo = new Vector<SetInfo>();
        while ((pos = criteria.indexOf(63)) != -1) {
            Class paramClass;
            ++index;
            res = res + criteria.substring(0, pos) + "?";
            criteria = criteria.substring(pos + 1);
            int i = 1;
            while (i < criteria.length() && Character.isDigit(criteria.charAt(i))) {
                ++i;
            }
            int paramId = -1;
            try {
                paramId = Integer.parseInt(criteria.substring(0, i));
            }
            catch (NumberFormatException nfe) {
                throw new EJBXMLParserException("ejb_2309", new String[]{descr.getSQLStatement(), descr.getMethodName()});
            }
            if (paramId > descr.getParamsTypes().length) {
                throw new EJBXMLParserException("ejb_2309", new String[]{descr.getSQLStatement(), descr.getMethodName()});
            }
            String paramType = descr.getParamsTypes()[paramId - 1];
            try {
                paramClass = ParseUtils.getClassFromString(paramType, this.loader);
            }
            catch (ClassNotFoundException de) {
                throw new EJBXMLParserException("ejb_2236", new Object[]{ejbName, descr.getMethodName(), paramType}, de);
            }
            int defSqlType = Mappings.getDefaultSqlTypeForJavaType(paramClass);
            SetInfo info = new SetInfo();
            info.setFieldName("param" + paramId);
            info.setSetObject(Mappings.getSetMethodForSelectStInFindMethod(defSqlType, paramClass, index, "param" + paramId));
            if (!AdminUtils.isPrimitiveType(paramType)) {
                info.setSetNull(Mappings.getSetNull(defSqlType, index));
            }
            vSetInfo.addElement(info);
            criteria = criteria.substring(i);
        }
        res = res + criteria;
        descr.setSQLStatement(res);
        descr.setSetInfo(vSetInfo.toArray(new SetInfo[vSetInfo.size()]));
    }

    private DataBaseProperties processDBProps() throws DeploymentException {
        Element dbPool = this.getFirstElementByName(this.root, "db-properties");
        if (dbPool == null) {
            throw new EJBXMLParserException("ejb_2337");
        }
        String dsName = this.getElementText(this.getFirstElementByName(dbPool, "data-source-name"));
        DataBaseProperties dbProps = new DataBaseProperties();
        dbProps.setDataSourceName(dsName);
        Element dbVendorEl = this.getFirstElementByName(dbPool, "database-vendor");
        if (dbVendorEl != null) {
            String dbVendorName = dbVendorEl.getAttribute("name");
            dbProps.setDBVendorName(dbVendorName);
        }
        return dbProps;
    }

    private boolean doesTagExist(Element parentEl, String tagName) {
        Element tagEl = this.getFirstElementByName(parentEl, tagName);
        return tagEl != null;
    }

    private boolean isMappedToSetOfColumns(PersistentField persistentField, Element parentEl) throws DeploymentException {
        NodeList columnNamesNL = parentEl.getElementsByTagName("dv-column");
        if (columnNamesNL.getLength() > 0) {
            if (!(persistentField instanceof DependentValueDescriptor)) {
                throw new EJBXMLParserException("ejb_2305", new String[]{persistentField.getFieldType()});
            }
            return true;
        }
        return false;
    }

    private void processDependentDBMap(DependentValueDescriptor dvCmp, Element parentEl) throws DeploymentException {
        NodeList columnNamesNL = parentEl.getElementsByTagName("dv-column");
        String[] columnName = new String[columnNamesNL.getLength()];
        int[] jdbcColumnType = new int[columnNamesNL.getLength()];
        int j = 0;
        while (j < columnNamesNL.getLength()) {
            Element subFieldEl = (Element)columnNamesNL.item(j);
            String subfield = this.getElementText(this.getFirstElementByName(subFieldEl, "subfield-name"));
            int columnPos = this.getColumnPos(dvCmp, subfield, dvCmp.getFieldName());
            columnName[columnPos] = this.getElementText(this.getFirstElementByName(subFieldEl, "column-name"));
            Class fieldClass = dvCmp.getValueFieldClasses()[columnPos];
            jdbcColumnType[columnPos] = Mappings.getDefaultSqlTypeForJavaType(fieldClass);
            ++j;
        }
        RDependentValueMap fieldDBMap = new RDependentValueMap();
        fieldDBMap.setDvColumnName(columnName);
        fieldDBMap.setDvColumnType(jdbcColumnType);
        String sKeyType = parentEl.getAttribute("key-type");
        fieldDBMap.setKey(this.convertKeyType(sKeyType));
        dvCmp.setFieldDBMap(fieldDBMap);
        if (columnNamesNL.getLength() < dvCmp.getValueFieldNames().length) {
            this.delNeedlessSubfields(dvCmp);
        } else if (columnNamesNL.getLength() > dvCmp.getValueFieldNames().length) {
            throw new EJBXMLParserException("ejb_2305", new String[]{dvCmp.getFieldType()});
        }
        Class[] subFieldClasses = dvCmp.getValueFieldClasses();
        int i = 0;
        while (i < subFieldClasses.length) {
            if (Mappings.getDefaultSqlTypeForJavaType(subFieldClasses[i]) == 2004) {
                throw new EJBXMLParserException("ejb_2242", new String[]{dvCmp.getFieldType(), subFieldClasses[i].getName(), dvCmp.getFieldName()});
            }
            ++i;
        }
    }

    private void delNeedlessSubfields(DependentValueDescriptor dv) {
        Vector<String> vSubFieldNames = new Vector<String>();
        Vector<String> vSubFieldTypes = new Vector<String>();
        Vector<Class> vSubFieldClasses = new Vector<Class>();
        Vector<String> vColumnNames = new Vector<String>();
        ArrayInt vJdbcColumnTypes = new ArrayInt();
        String[] subFieldNames = dv.getValueFieldNames();
        String[] subFieldTypes = dv.getValueFieldTypes();
        Class[] subFieldClasses = dv.getValueFieldClasses();
        RDependentValueMap dbMap = (RDependentValueMap)dv.getFieldDBMap();
        String[] columnNames = dbMap.getDvColumnName();
        int[] columnTypes = dbMap.getDvColumnType();
        int i = 0;
        while (i < columnNames.length) {
            if (columnNames[i] != null) {
                vSubFieldNames.add(subFieldNames[i]);
                vSubFieldTypes.add(subFieldTypes[i]);
                vSubFieldClasses.add(subFieldClasses[i]);
                vColumnNames.add(columnNames[i]);
                vJdbcColumnTypes.add(columnTypes[i]);
            }
            ++i;
        }
        dv.setValueFieldNames(vSubFieldNames.toArray(new String[vSubFieldNames.size()]));
        dv.setValueFieldTypes(vSubFieldTypes.toArray(new String[vSubFieldTypes.size()]));
        dv.setValueFieldClasses(vSubFieldClasses.toArray(new Class[vSubFieldClasses.size()]));
        dbMap.setDvColumnName(vColumnNames.toArray(new String[vColumnNames.size()]));
        dbMap.setDvColumnType(vJdbcColumnTypes.toArray());
    }

    private PersistentField processSingleDBMap(PersistentField cmpField, Element parentEl) throws DeploymentException {
        PersistentField newPersistentField = null;
        if (cmpField instanceof DependentValueDescriptor) {
            DependentValueDescriptor dvCmp = (DependentValueDescriptor)cmpField;
            newPersistentField = new PersistentField();
            newPersistentField.setFieldName(dvCmp.getFieldName());
            newPersistentField.setFieldType(dvCmp.getFieldType());
            newPersistentField.setFieldClass(dvCmp.getFieldClass());
            newPersistentField.setDV(true);
            if (cmpField.isCompoundPK()) {
                newPersistentField.setCompoundPK();
            }
        } else {
            newPersistentField = cmpField;
        }
        RPersistentFieldMap fieldDBMap = new RPersistentFieldMap();
        String columnName = this.getElementText(this.getFirstElementByName(parentEl, "column-name"));
        fieldDBMap.setColumnName(columnName);
        Class fieldClass = newPersistentField.getFieldClass();
        fieldDBMap.setColumnType(Mappings.getDefaultSqlTypeForJavaType(fieldClass));
        String sKeyType = parentEl.getAttribute("key-type");
        fieldDBMap.setKey(this.convertKeyType(sKeyType));
        newPersistentField.setFieldDBMap(fieldDBMap);
        return newPersistentField;
    }
}

