/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.xml;

import com.sap.engine.lib.xml.StandardDOMParser;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.ejb.deploy.tools.sql.Mappings;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLParserException;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class ParseUtils {
    protected ParseUtils() {
    }

    protected Element getFirstElementByName(Element el, String name) {
        NodeList nl = el.getElementsByTagName(name);
        return (Element)nl.item(0);
    }

    protected String getElementText(Element el) {
        String data = "";
        NodeList nodeList = el.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 3) {
                StandardDOMParser.trimWhiteSpaces((Node)node);
                data = ((Text)node).getData();
                break;
            }
            if (node.getNodeType() == 4) {
                data = node.getNodeValue();
                break;
            }
            ++i;
        }
        if (this.getWarnings() != null && data.equals("")) {
            this.getWarnings().add("JAR File: " + this.getEJBJarFileName() + " XML file: " + this.getXMLFileName() + " Element: " + el.getTagName() + " is empty. It is not recommended to use empty value elements. Please remove the element or define its value!");
        }
        return data;
    }

    protected Class[] getParamClasses(String[] params, String ejbName, String methodName) throws DeploymentException {
        Class[] paramsClass = null;
        if (params != null) {
            paramsClass = new Class[params.length];
            int k = 0;
            while (k < params.length) {
                try {
                    paramsClass[k] = ParseUtils.getClassFromString(params[k], this.getClassLoader());
                }
                catch (ClassNotFoundException de) {
                    throw new EJBXMLParserException("ejb_2236", new Object[]{ejbName, methodName, params[k]}, de);
                }
                ++k;
            }
        } else {
            paramsClass = new Class[]{};
        }
        return paramsClass;
    }

    public static Class getClassFromString(String className, ClassLoader loader) throws ClassNotFoundException {
        Class<?> cl = Mappings.getPrimitiveClass(className);
        if (cl == null) {
            cl = loader.loadClass(className);
        }
        return cl;
    }

    protected abstract String getXMLFileName();

    protected abstract String getEJBJarFileName();

    protected abstract Vector getWarnings();

    protected abstract ClassLoader getClassLoader();
}

