/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.xml;

import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.ejb.deploy.xml.EJBJarParserConstants;
import com.sap.engine.services.ejb.deploy.xml.XMLGenerator;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLParserException;
import java.lang.reflect.Method;
import java.util.AbstractCollection;
import java.util.HashSet;
import java.util.Vector;

public class MethodsExtractor {
    static MethodEntry[] getAllMethodsInBean(String methodName, String methodIntf, DeploymentDescriptor ddescr, ClassLoader loader, String descrip, boolean containerTxAttrib) throws ClassNotFoundException, DeploymentException {
        if (ddescr instanceof MessageDrivenDescriptor) {
            Class<?> clazz = loader.loadClass(ddescr.getClassName());
            Class<?>[] interfaces = null;
            HashSet allInterfaces = new HashSet();
            while (clazz != null) {
                interfaces = clazz.getInterfaces();
                int i = 0;
                while (i < interfaces.length) {
                    allInterfaces.add(interfaces[i]);
                    ++i;
                }
                clazz = clazz.getSuperclass();
            }
            interfaces = ((AbstractCollection)allInterfaces).toArray(new Class[allInterfaces.size()]);
            Vector<MethodEntry> entries = new Vector<MethodEntry>();
            if (methodName.equals("*")) {
                int i = 0;
                while (i < interfaces.length) {
                    Method[] methods = interfaces[i].getMethods();
                    int j = 0;
                    while (j < methods.length) {
                        entries.add(new MethodEntry(ddescr.getEjbName(), null, methods[j], descrip));
                        ++j;
                    }
                    ++i;
                }
                return entries.toArray(new MethodEntry[entries.size()]);
            }
            int i = 0;
            while (i < interfaces.length) {
                Method[] methods = interfaces[i].getMethods();
                int j = 0;
                while (j < methods.length) {
                    if (methods[j].getName().equals(methodName)) {
                        entries.add(new MethodEntry(ddescr.getEjbName(), null, methods[j], descrip));
                    }
                    ++j;
                }
                ++i;
            }
            if (entries.size() == 0) {
                throw new EJBXMLParserException("ejb_2225", new Object[]{methodName, ddescr.getEjbName()});
            }
            return entries.toArray(new MethodEntry[entries.size()]);
        }
        Class<?> remoteIntf = null;
        Class<?> homeIntf = null;
        Class<?> localIntf = null;
        Class<?> localHomeIntf = null;
        if (ddescr.getRemoteInterface() != null) {
            remoteIntf = loader.loadClass(ddescr.getRemoteInterface());
        }
        if (ddescr.getRemoteHomeInterface() != null) {
            homeIntf = loader.loadClass(ddescr.getRemoteHomeInterface());
        }
        if (ddescr.getLocalInterface() != null) {
            localIntf = loader.loadClass(ddescr.getLocalInterface());
        }
        if (ddescr.getLocalHomeInterface() != null) {
            localHomeIntf = loader.loadClass(ddescr.getLocalHomeInterface());
        }
        if (methodIntf != null) {
            return MethodsExtractor.getWithSpecifiedMethodInterface(methodIntf, remoteIntf, ddescr, homeIntf, localIntf, localHomeIntf, methodName, descrip);
        }
        return MethodsExtractor.getWithNotSpecifiedMethodInterface(ddescr, descrip, remoteIntf, methodName, containerTxAttrib, localIntf, homeIntf, localHomeIntf);
    }

    private static MethodEntry[] getWithNotSpecifiedMethodInterface(DeploymentDescriptor ddescr, String descrip, Class remoteIntf, String methodName, boolean containerTxAttrib, Class localIntf, Class homeIntf, Class localHomeIntf) throws EJBXMLParserException {
        Method method;
        int i;
        Method[] methods;
        Vector<MethodEntry> methodEntries = new Vector<MethodEntry>();
        boolean found = false;
        boolean sessionBean = ddescr instanceof SessionDescriptor;
        MethodEntry beanEntry = new MethodEntry((Method)null);
        beanEntry.setEjbName(ddescr.getEjbName());
        beanEntry.setMethodInterface(null);
        beanEntry.setMethodDescription(descrip);
        methodEntries.add(beanEntry);
        if (remoteIntf != null) {
            methods = remoteIntf.getMethods();
            if (methodName.equals("*")) {
                i = 0;
                while (i < methods.length) {
                    method = methods[i];
                    if (!MethodsExtractor.overriddenMethod(method, remoteIntf)) {
                        if (containerTxAttrib) {
                            if (!MethodsExtractor.containsIn(EJBJarParserConstants.EJBOBJECT_METHODS, method.getName(), sessionBean)) {
                                methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Remote", method, descrip));
                            }
                        } else {
                            methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Remote", method, descrip));
                        }
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < methods.length) {
                    method = methods[i];
                    if (!MethodsExtractor.overriddenMethod(method, remoteIntf) && method.getName().equals(methodName)) {
                        found = true;
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Remote", method, descrip));
                    }
                    ++i;
                }
            }
        }
        if (localIntf != null) {
            methods = localIntf.getMethods();
            if (methodName.equals("*")) {
                i = 0;
                while (i < methods.length) {
                    method = methods[i];
                    if (!MethodsExtractor.overriddenMethod(method, localIntf)) {
                        if (containerTxAttrib) {
                            if (!MethodsExtractor.containsIn(EJBJarParserConstants.EJBLOCALOBJECT_METHODS, method.getName(), sessionBean)) {
                                methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Local", method, descrip));
                            }
                        } else {
                            methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Local", method, descrip));
                        }
                    }
                    ++i;
                }
            } else {
                i = 0;
                while (i < methods.length) {
                    method = methods[i];
                    if (!MethodsExtractor.overriddenMethod(method, localIntf) && method.getName().equals(methodName)) {
                        found = true;
                        methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Local", method, descrip));
                    }
                    ++i;
                }
            }
        }
        if (!sessionBean || !containerTxAttrib) {
            if (homeIntf != null) {
                methods = homeIntf.getMethods();
                if (methodName.equals("*")) {
                    i = 0;
                    while (i < methods.length) {
                        method = methods[i];
                        if (!MethodsExtractor.overriddenMethod(method, homeIntf)) {
                            if (containerTxAttrib) {
                                if (!MethodsExtractor.containsIn(EJBJarParserConstants.EJBHOME_METHODS, method.getName(), false)) {
                                    methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Home", method, descrip));
                                }
                            } else {
                                methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Home", method, descrip));
                            }
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < methods.length) {
                        method = methods[i];
                        if (!MethodsExtractor.overriddenMethod(method, homeIntf) && method.getName().equals(methodName)) {
                            found = true;
                            methodEntries.add(new MethodEntry(ddescr.getEjbName(), "Home", method, descrip));
                        }
                        ++i;
                    }
                }
            }
            if (localHomeIntf != null) {
                methods = localHomeIntf.getMethods();
                if (methodName.equals("*")) {
                    i = 0;
                    while (i < methods.length) {
                        method = methods[i];
                        if (!MethodsExtractor.overriddenMethod(method, localHomeIntf)) {
                            methodEntries.add(new MethodEntry(ddescr.getEjbName(), "LocalHome", method, descrip));
                        }
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < methods.length) {
                        method = methods[i];
                        if (!MethodsExtractor.overriddenMethod(method, localHomeIntf) && method.getName().equals(methodName)) {
                            found = true;
                            methodEntries.add(new MethodEntry(ddescr.getEjbName(), "LocalHome", method, descrip));
                        }
                        ++i;
                    }
                }
            }
        }
        if (!found && !methodName.equals("*")) {
            throw new EJBXMLParserException("ejb_2228", new Object[]{methodName, ddescr.getEjbName()});
        }
        return methodEntries.toArray(new MethodEntry[methodEntries.size()]);
    }

    private static MethodEntry[] getWithSpecifiedMethodInterface(String methodIntf, Class remoteIntf, DeploymentDescriptor ddescr, Class homeIntf, Class localIntf, Class localHomeIntf, String methodName, String descrip) throws EJBXMLParserException {
        Class currClass = null;
        if (methodIntf.equals("Remote")) {
            if (remoteIntf == null) {
                throw new EJBXMLParserException("ejb_2226", new Object[]{"Remote", ddescr.getEjbName()});
            }
            currClass = remoteIntf;
        } else if (methodIntf.equals("Home")) {
            if (homeIntf == null) {
                throw new EJBXMLParserException("ejb_2226", new Object[]{"Home", ddescr.getEjbName()});
            }
            currClass = homeIntf;
        } else if (methodIntf.equals("Local")) {
            if (localIntf == null) {
                throw new EJBXMLParserException("ejb_2226", new Object[]{"Local", ddescr.getEjbName()});
            }
            currClass = localIntf;
        } else if (methodIntf.equals("LocalHome")) {
            if (localHomeIntf == null) {
                throw new EJBXMLParserException("ejb_2226", new Object[]{"LocalHome", ddescr.getEjbName()});
            }
            currClass = localHomeIntf;
        }
        Vector<MethodEntry> methodEntries = new Vector<MethodEntry>();
        Method[] methods = currClass.getMethods();
        if (methodName.equals("*")) {
            MethodEntry beanEntry = new MethodEntry((Method)null);
            beanEntry.setEjbName(ddescr.getEjbName());
            beanEntry.setMethodInterface(methodIntf);
            beanEntry.setMethodDescription(descrip);
            methodEntries.add(beanEntry);
            int i = 0;
            while (i < methods.length) {
                Method method = methods[i];
                if (!MethodsExtractor.overriddenMethod(method, currClass)) {
                    methodEntries.add(new MethodEntry(ddescr.getEjbName(), methodIntf, method, descrip));
                }
                ++i;
            }
        } else {
            boolean found = false;
            int i = 0;
            while (i < methods.length) {
                Method method = methods[i];
                if (!MethodsExtractor.overriddenMethod(method, currClass) && method.getName().equals(methodName)) {
                    found = true;
                    methodEntries.add(new MethodEntry(ddescr.getEjbName(), methodIntf, method, descrip));
                }
                ++i;
            }
            if (!found) {
                throw new EJBXMLParserException("ejb_2227", new Object[]{methodName, methodIntf, ddescr.getEjbName()});
            }
        }
        return methodEntries.toArray(new MethodEntry[methodEntries.size()]);
    }

    private static boolean overriddenMethod(Method method, Class clazz) {
        if (method.getDeclaringClass().equals(clazz)) {
            return false;
        }
        return XMLGenerator.definedMethod(clazz, method.getName(), method.getParameterTypes());
    }

    private static boolean containsIn(String[] excludeMethods, String method, boolean sessionBean) {
        if (sessionBean && method.equals("remove")) {
            return true;
        }
        int i = 0;
        while (i < excludeMethods.length) {
            if (method.equals(excludeMethods[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

