/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.xml;

import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.ejb.deploy.xml.XMLGenerator;
import java.util.Vector;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EnvironmentXmlUtil {
    public static void loadEnvEntries(Document mainDocument, Element parent, EnvironmentEntry[] envEntries, Vector errors) {
        if (envEntries == null || envEntries.length == 0) {
            return;
        }
        int i = 0;
        while (i < envEntries.length) {
            String entryName = envEntries[i].getEntryName();
            if (entryName == null || entryName.trim().equals("")) {
                errors.add("env-entry-name for env-entry is missing.");
            } else {
                String entryType = envEntries[i].getEntryType();
                if (entryType == null || !EnvironmentXmlUtil.checkEnvEntryType(entryType)) {
                    errors.add("Wrong value for env-entry-type: " + entryType);
                } else {
                    Element envEntryEl = mainDocument.createElement("env-entry");
                    String entryDescription = envEntries[i].getEntryDescription();
                    if (entryDescription != null && !entryDescription.trim().equals("")) {
                        XMLGenerator.load(mainDocument, envEntryEl, entryDescription, "description");
                    }
                    XMLGenerator.load(mainDocument, envEntryEl, entryName, "env-entry-name");
                    XMLGenerator.load(mainDocument, envEntryEl, entryType, "env-entry-type");
                    Object entryValue = envEntries[i].getEntryValue();
                    if (entryValue != null && !entryValue.toString().trim().equals("")) {
                        XMLGenerator.load(mainDocument, envEntryEl, entryValue.toString(), "env-entry-value");
                    }
                    parent.appendChild(envEntryEl);
                }
            }
            ++i;
        }
    }

    private static boolean checkEnvEntryType(String type) {
        return type.equals("java.lang.String") || type.equals("java.lang.Boolean") || type.equals("java.lang.Character") || type.equals("java.lang.Integer") || type.equals("java.lang.Byte") || type.equals("java.lang.Short") || type.equals("java.lang.Long") || type.equals("java.lang.Float") || type.equals("java.lang.Double");
    }

    public static void loadEjbRefs(Document mainDocument, Element parent, EJBeanReference[] ejbRefs, Vector errors) {
        if (ejbRefs == null || ejbRefs.length == 0) {
            return;
        }
        int i = 0;
        while (i < ejbRefs.length) {
            String referenceName = ejbRefs[i].getReferenceName();
            if (referenceName == null || referenceName.trim().equals("")) {
                errors.add("ejb-ref-name for ejb-ref is missing.");
            } else {
                String homeInterface = ejbRefs[i].getHomeInterfaceName();
                if (homeInterface == null || homeInterface.trim().equals("")) {
                    errors.add("Home iterface for ejb-ref " + referenceName + " is missing.");
                } else {
                    String remoteInterface = ejbRefs[i].getRemoteInterfaceName();
                    if (remoteInterface == null || remoteInterface.trim().equals("")) {
                        errors.add("Remote iterface for ejb-ref " + referenceName + " is missing.");
                    } else {
                        Element ejbRefEl = mainDocument.createElement("ejb-ref");
                        String referenceDescription = ejbRefs[i].getReferenceDescription();
                        if (referenceDescription != null && !referenceDescription.trim().equals("")) {
                            XMLGenerator.load(mainDocument, ejbRefEl, referenceDescription, "description");
                        }
                        XMLGenerator.load(mainDocument, ejbRefEl, referenceName, "ejb-ref-name");
                        String type = ejbRefs[i].getType() == 1 ? "Entity" : "Session";
                        XMLGenerator.load(mainDocument, ejbRefEl, type, "ejb-ref-type");
                        XMLGenerator.load(mainDocument, ejbRefEl, homeInterface, "home");
                        XMLGenerator.load(mainDocument, ejbRefEl, remoteInterface, "remote");
                        String referenceEjbLink = ejbRefs[i].getReferenceEjbLink();
                        if (referenceEjbLink != null && !referenceEjbLink.trim().equals("")) {
                            XMLGenerator.load(mainDocument, ejbRefEl, referenceEjbLink, "ejb-link");
                        }
                        parent.appendChild(ejbRefEl);
                    }
                }
            }
            ++i;
        }
    }

    public static void loadEjbLocalRefs(Document mainDocument, Element parent, EJBeanLocalReference[] ejbLocalRefs, Vector errors) {
        if (ejbLocalRefs == null) {
            return;
        }
        int i = 0;
        while (i < ejbLocalRefs.length) {
            String referenceName = ejbLocalRefs[i].getReferenceName();
            if (referenceName == null || referenceName.trim().equals("")) {
                errors.add("ejb-ref-name for ejb-local-ref is missing.");
            } else {
                String localHomeInterface = ejbLocalRefs[i].getLocalHomeInterfaceName();
                if (localHomeInterface == null || localHomeInterface.trim().equals("")) {
                    errors.add("Local home iterface for ejb-local-ref " + referenceName + " is missing.");
                } else {
                    String localInterface = ejbLocalRefs[i].getLocalInterfaceName();
                    if (localInterface == null || localInterface.trim().equals("")) {
                        errors.add("Local iterface for ejb-local-ref " + referenceName + " is missing.");
                    } else {
                        Element ejbLocalRefEl = mainDocument.createElement("ejb-local-ref");
                        String referenceDescription = ejbLocalRefs[i].getReferenceDescription();
                        if (referenceDescription != null && !referenceDescription.trim().equals("")) {
                            XMLGenerator.load(mainDocument, ejbLocalRefEl, referenceDescription, "description");
                        }
                        XMLGenerator.load(mainDocument, ejbLocalRefEl, referenceName, "ejb-ref-name");
                        String type = ejbLocalRefs[i].getType() == 1 ? "Entity" : "Session";
                        XMLGenerator.load(mainDocument, ejbLocalRefEl, type, "ejb-ref-type");
                        XMLGenerator.load(mainDocument, ejbLocalRefEl, localHomeInterface, "local-home");
                        XMLGenerator.load(mainDocument, ejbLocalRefEl, localInterface, "local");
                        String referenceEjbLink = ejbLocalRefs[i].getReferenceEjbLink();
                        if (referenceEjbLink != null && !referenceEjbLink.trim().equals("")) {
                            XMLGenerator.load(mainDocument, ejbLocalRefEl, referenceEjbLink, "ejb-link");
                        }
                        parent.appendChild(ejbLocalRefEl);
                    }
                }
            }
            ++i;
        }
    }

    public static void loadSecurityRoleRefs(Document mainDocument, Element parent, SecurityRoleReference[] secRoleRefs, Vector errors) {
        if (secRoleRefs == null || secRoleRefs.length == 0) {
            return;
        }
        int i = 0;
        while (i < secRoleRefs.length) {
            String roleName = secRoleRefs[i].getRoleName();
            if (roleName == null || roleName.trim().equals("")) {
                errors.add("role-name for security-role-ref is missing.");
            } else {
                Element secRoleRefEl = mainDocument.createElement("security-role-ref");
                String description = secRoleRefs[i].getDescription();
                if (description != null && !description.trim().equals("")) {
                    XMLGenerator.load(mainDocument, secRoleRefEl, description, "description");
                }
                XMLGenerator.load(mainDocument, secRoleRefEl, roleName, "role-name");
                String roleLink = secRoleRefs[i].getSecurityRoleName();
                if (roleLink != null && !roleLink.trim().equals("")) {
                    XMLGenerator.load(mainDocument, secRoleRefEl, roleLink, "role-link");
                }
                parent.appendChild(secRoleRefEl);
            }
            ++i;
        }
    }

    public static void loadResourceEnvRefs(Document mainDocument, Element parent, ResourceEnvReference[] resEnvRefs, Vector errors) {
        if (resEnvRefs == null) {
            return;
        }
        int i = 0;
        while (i < resEnvRefs.length) {
            String resEnvRefName = resEnvRefs[i].getName();
            if (resEnvRefName == null || resEnvRefName.trim().equals("")) {
                errors.add("resource-env-ref-name for resource-env-ref is missing.");
            } else {
                String resEnvRefType = resEnvRefs[i].getType();
                if (resEnvRefType == null || resEnvRefType.trim().equals("")) {
                    errors.add("resource-env-ref-type for resource-env-ref " + resEnvRefName + " is missing.");
                } else {
                    Element resEnvRefEl = mainDocument.createElement("resource-env-ref");
                    String description = resEnvRefs[i].getDescription();
                    if (description != null && !description.trim().equals("")) {
                        XMLGenerator.load(mainDocument, resEnvRefEl, description, "description");
                    }
                    XMLGenerator.load(mainDocument, resEnvRefEl, resEnvRefName, "resource-env-ref-name");
                    XMLGenerator.load(mainDocument, resEnvRefEl, resEnvRefType, "resource-env-ref-type");
                    parent.appendChild(resEnvRefEl);
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    public static void loadResourceRefs(Document mainDocument, Element parent, ResourceReference[] resRefs, Vector errors) {
        if (resRefs == null) {
            return;
        }
        i = 0;
        while (i < resRefs.length) {
            block6: {
                block8: {
                    block7: {
                        block5: {
                            resourceName = resRefs[i].getResourceName();
                            if (resourceName != null && !resourceName.trim().equals("")) break block5;
                            errors.add("res-ref-name for resource-ref is missing.");
                            break block6;
                        }
                        resourceType = resRefs[i].getResourceType();
                        if (resourceType != null && !resourceType.trim().equals("")) break block7;
                        errors.add("res-type for resource-ref " + resourceName + " is missing.");
                        break block6;
                    }
                    resAuth = null;
                    if (resRefs[i].getResourceAuthorization() != 3) break block8;
                    resAuth = "Application";
                    ** GOTO lbl27
                }
                if (resRefs[i].getResourceAuthorization() != 2) {
                    errors.add("Wrong value for res-auth. It must be either \"Application\" or \"Container\"");
                } else {
                    resAuth = "Container";
lbl27:
                    // 2 sources

                    resRefEl = mainDocument.createElement("resource-ref");
                    resourceDescription = resRefs[i].getResourceDescription();
                    if (resourceDescription != null && !resourceDescription.trim().equals("")) {
                        XMLGenerator.load(mainDocument, resRefEl, resourceDescription, "description");
                    }
                    XMLGenerator.load(mainDocument, resRefEl, resourceName, "res-ref-name");
                    XMLGenerator.load(mainDocument, resRefEl, resourceType, "res-type");
                    XMLGenerator.load(mainDocument, resRefEl, resAuth, "res-auth");
                    sharingScope = resRefs[i].getResourceSharingScope() == 0 ? "Shareable" : "Unshareable";
                    XMLGenerator.load(mainDocument, resRefEl, sharingScope, "res-sharing-scope");
                    parent.appendChild(resRefEl);
                }
            }
            ++i;
        }
    }
}

