/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.xml;

import com.sap.engine.lib.io.SerializableFile;
import com.sap.engine.services.deploy.container.DeploymentException;
import com.sap.engine.services.deploy.ear.common.EJBeanLocalReference;
import com.sap.engine.services.deploy.ear.common.EJBeanReference;
import com.sap.engine.services.deploy.ear.common.EnvironmentEntry;
import com.sap.engine.services.deploy.ear.common.MethodEntry;
import com.sap.engine.services.deploy.ear.common.ResourceEnvReference;
import com.sap.engine.services.deploy.ear.common.ResourceReference;
import com.sap.engine.services.deploy.ear.common.SecurityRoleReference;
import com.sap.engine.services.ejb.deploy.descriptors.AbstractSchema;
import com.sap.engine.services.ejb.deploy.descriptors.AccessControls;
import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.ControlDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.DeploymentDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EJBJarDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.MessageDrivenDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.OneSideRelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import com.sap.engine.services.ejb.deploy.descriptors.SecurityIdentity;
import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.ejb.deploy.xml.EnvironmentXmlUtil;
import com.sap.engine.services.ejb.deploy.xml.XMLGenerator;
import com.sap.engine.services.ejb.exceptions.deployment.EJBXMLGeneratorException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EJBJarGenerator
extends XMLGenerator {
    public static final String UTF8 = "UTF-8";
    public static final String dtd = "<!DOCTYPE ejb-jar PUBLIC '-//Sun Microsystems, Inc.//DTD Enterprise JavaBeans 2.0//EN' 'http://java.sun.com/dtd/ejb-jar_2_0.dtd'>";

    public Document loadEJBJarDescriptor(EJBJarDescriptor ejbJar, Vector warnings) throws DeploymentException {
        DeploymentDescriptor[] dd;
        SerializableFile largeIcon;
        SerializableFile smallIcon;
        String displayName;
        DocumentBuilder builder = null;
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClass().getClassLoader());
        try {
            builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        }
        catch (ParserConfigurationException pce) {
            throw new EJBXMLGeneratorException("ejb_2321", (Throwable)pce);
        }
        Thread.currentThread().setContextClassLoader(cl);
        Document mainDocument = builder.newDocument();
        Element ejbJarEl = mainDocument.createElement("ejb-jar");
        mainDocument.appendChild(ejbJarEl);
        String description = ejbJar.getDescription();
        if (description != null && !description.trim().equals("")) {
            XMLGenerator.load(mainDocument, ejbJarEl, description, "description");
        }
        if ((displayName = ejbJar.getDisplayName()) != null && !displayName.trim().equals("")) {
            XMLGenerator.load(mainDocument, ejbJarEl, displayName, "display-name");
        }
        if ((smallIcon = ejbJar.getSmallIcon()) != null && smallIcon.getFileName() != null && !smallIcon.getFileName().trim().equals("")) {
            XMLGenerator.load(mainDocument, ejbJarEl, smallIcon.getFileName(), "small-icon");
        }
        if ((largeIcon = ejbJar.getLargeIcon()) != null && largeIcon.getFileName() != null && !largeIcon.getFileName().trim().equals("")) {
            XMLGenerator.load(mainDocument, ejbJarEl, largeIcon.getFileName(), "large-icon");
        }
        if ((dd = ejbJar.getDDescriptors()) != null && dd.length > 0) {
            Element enterpriseBeansEl = mainDocument.createElement("enterprise-beans");
            int i = 0;
            while (i < dd.length) {
                if (dd[i] instanceof EntityDescriptor) {
                    this.loadEntityDescriptor(mainDocument, enterpriseBeansEl, (EntityDescriptor)dd[i], warnings);
                } else if (dd[i] instanceof SessionDescriptor) {
                    this.loadSessionDescriptor(mainDocument, enterpriseBeansEl, (SessionDescriptor)dd[i], warnings);
                } else if (dd[i] instanceof MessageDrivenDescriptor) {
                    this.loadMessageDrivenDescriptor(mainDocument, enterpriseBeansEl, (MessageDrivenDescriptor)dd[i], warnings);
                }
                ++i;
            }
            ejbJarEl.appendChild(enterpriseBeansEl);
        } else {
            warnings.add("Ejb-jar " + ejbJar.getJarName() + " contains no beans.");
        }
        AbstractSchema schema = ejbJar.getAbstractSchema();
        if (schema != null && schema.getDescriptors() != null && schema.getDescriptors().length > 0) {
            this.loadRelationships(mainDocument, ejbJarEl, schema);
        }
        Element assemblyDescriptorEl = mainDocument.createElement("assembly-descriptor");
        this.loadMethodPermissions(mainDocument, assemblyDescriptorEl, ejbJar);
        this.loadContainerTransactions(mainDocument, assemblyDescriptorEl, ejbJar);
        this.loadExcludeList(mainDocument, assemblyDescriptorEl, ejbJar);
        ejbJarEl.appendChild(assemblyDescriptorEl);
        return mainDocument;
    }

    private void loadRelationships(Document mainDocument, Element ejbJarEl, AbstractSchema schema) {
        RelationDescriptor[] relations = schema.getRelDescriptors();
        if (relations == null || relations.length == 0) {
            return;
        }
        Element relationEl = null;
        String relationDescr = null;
        OneSideRelationDescriptor side1 = null;
        OneSideRelationDescriptor side2 = null;
        Element relationsEl = mainDocument.createElement("relationships");
        int i = 0;
        while (i < relations.length) {
            if (relations[i] != null) {
                relationEl = mainDocument.createElement("ejb-relation");
                relationDescr = relations[i].getRelationDescription();
                if (relationDescr != null && !relationDescr.equals("")) {
                    XMLGenerator.load(mainDocument, relationEl, relationDescr, "description");
                }
                if ((relationDescr = relations[i].getRelationName()) != null && !relationDescr.equals("")) {
                    XMLGenerator.load(mainDocument, relationEl, relationDescr, "ejb-relation-name");
                }
                side1 = relations[i].getSide1();
                side2 = relations[i].getSide2();
                if (side1 != null || side2 != null) {
                    // empty if block
                }
                this.loadRelationRole(mainDocument, relationEl, schema, side1);
                this.loadRelationRole(mainDocument, relationEl, schema, side2);
                relationsEl.appendChild(relationEl);
            }
            ++i;
        }
        ejbJarEl.appendChild(relationsEl);
    }

    private void loadRelationRole(Document mainDocument, Element relationEl, AbstractSchema schema, OneSideRelationDescriptor side) {
        String name;
        Element role1El = mainDocument.createElement("ejb-relationship-role");
        String description = side.getRoleDescription();
        if (description != null && !description.equals("")) {
            XMLGenerator.load(mainDocument, role1El, description, "description");
        }
        if ((name = side.getRoleName()) != null && !name.equals("")) {
            XMLGenerator.load(mainDocument, role1El, name, "ejb-relationship-role-name");
        }
        String multiplicity = null;
        if (side.getMultiplicityType() == 4 || side.getMultiplicityType() == 3) {
            multiplicity = "Many";
        } else if (side.getMultiplicityType() == 1 || side.getMultiplicityType() == 2) {
            multiplicity = "One";
        }
        XMLGenerator.load(mainDocument, role1El, multiplicity, "multiplicity");
        if (side.isCascade()) {
            role1El.appendChild(mainDocument.createElement("cascade-delete"));
        }
        Element roleSourceEl = mainDocument.createElement("relationship-role-source");
        int id = side.getEjbId();
        CMPEntityDescriptor cmpd = schema.getDescriptor(id);
        if (cmpd == null || cmpd.getEjbName() == null || cmpd.getEjbName().equals("")) {
            // empty if block
        }
        String destEjbName = cmpd.getEjbName();
        XMLGenerator.load(mainDocument, roleSourceEl, destEjbName, "ejb-name");
        role1El.appendChild(roleSourceEl);
        id = side.getCmrId();
        RelationField cmr = cmpd.getRelationField(id);
        if (cmr != null && cmr.getFieldName() != null && !cmr.getFieldName().equals("")) {
            Element fieldEl = mainDocument.createElement("cmr-field");
            description = cmr.getDescription();
            if (description != null && !description.equals("")) {
                XMLGenerator.load(mainDocument, fieldEl, description, "description");
            }
            name = cmr.getFieldName();
            XMLGenerator.load(mainDocument, fieldEl, name, "cmr-field-name");
            String type = cmr.getFieldType();
            if (type != null && !type.equals("")) {
                XMLGenerator.load(mainDocument, fieldEl, type, "cmr-field-type");
            }
            role1El.appendChild(fieldEl);
        }
        relationEl.appendChild(role1El);
    }

    private void loadExcludeList(Document mainDocument, Element assemblyDescriptorEl, EJBJarDescriptor ejbJar) {
        DeploymentDescriptor[] dd = ejbJar.getDDescriptors();
        Element excludeListEl = mainDocument.createElement("exclude-list");
        if (ejbJar.getExcludeListDescription() != null && !ejbJar.getExcludeListDescription().equals("")) {
            XMLGenerator.load(mainDocument, excludeListEl, ejbJar.getExcludeListDescription(), "description");
        }
        MethodEntry[] entries = null;
        Element methodEl = null;
        int i = 0;
        while (i < dd.length) {
            entries = dd[i].getUncalableMethods();
            if (entries != null && entries.length > 0) {
                int j = 0;
                while (j < entries.length) {
                    methodEl = mainDocument.createElement("method");
                    if (entries[j].getMethodDescription() != null && !entries[j].getMethodDescription().trim().equals("")) {
                        XMLGenerator.load(mainDocument, methodEl, entries[j].getMethodDescription(), "description");
                    }
                    XMLGenerator.load(mainDocument, methodEl, dd[i].getEjbName(), "ejb-name");
                    if (entries[j].getMethodInterface() != null) {
                        XMLGenerator.load(mainDocument, methodEl, entries[j].getMethodInterface(), "method-intf");
                    }
                    XMLGenerator.load(mainDocument, methodEl, entries[j].getMethodName(), "method-name");
                    if (entries[j].getParameters() != null) {
                        this.loadMethodParams(mainDocument, methodEl, entries[j].getParameters());
                    }
                    excludeListEl.appendChild(methodEl);
                    ++j;
                }
            }
            ++i;
        }
        if (excludeListEl.getChildNodes() != null && excludeListEl.getChildNodes().getLength() > 0) {
            assemblyDescriptorEl.appendChild(excludeListEl);
        }
    }

    private void loadContainerTransactions(Document mainDocument, Element assemblyDescriptorEl, EJBJarDescriptor ejbJar) {
        DeploymentDescriptor[] dd = ejbJar.getDDescriptors();
        ControlDescriptor[] cd = null;
        ControlDescriptor oneCd = null;
        String[] trNames = null;
        Element containerTrEl = null;
        Hashtable<ControlDescriptor, String> methods = null;
        Enumeration keys = null;
        Element methodEl = null;
        int i = 0;
        while (i < dd.length) {
            int j;
            trNames = null;
            cd = dd[i].getTransactionDescriptors();
            if (cd != null) {
                j = 0;
                while (j < cd.length) {
                    if (cd[j].getTxName() != null) {
                        trNames = this.concatArrays(new String[]{cd[j].getTxName()}, trNames);
                    }
                    ++j;
                }
            }
            if (!(trNames == null || trNames.length == 0 || dd[i] instanceof SessionDescriptor && ((SessionDescriptor)dd[i]).getTransactionType() == 0 || dd[i] instanceof MessageDrivenDescriptor && ((MessageDrivenDescriptor)dd[i]).getTransactionType() == 0 || cd == null || cd.length == 0)) {
                j = 0;
                while (j < cd.length) {
                    methods = new Hashtable<ControlDescriptor, String>();
                    containerTrEl = mainDocument.createElement("container-transaction");
                    if (cd[j].getDescription() != null && !cd[j].getDescription().trim().equals("")) {
                        XMLGenerator.load(mainDocument, containerTrEl, cd[j].getDescription(), "description");
                    }
                    int k = 0;
                    while (k < trNames.length) {
                        if (trNames[k].equals(cd[j].getTxName())) {
                            methods.put(cd[j], dd[i].getEjbName());
                        }
                        ++k;
                    }
                    keys = methods.keys();
                    methodEl = null;
                    while (keys.hasMoreElements()) {
                        methodEl = mainDocument.createElement("method");
                        oneCd = (ControlDescriptor)keys.nextElement();
                        this.loadMethodElement(mainDocument, methodEl, (String)methods.get(oneCd), oneCd);
                        containerTrEl.appendChild(methodEl);
                    }
                    XMLGenerator.load(mainDocument, containerTrEl, cd[j].getTxName(), "trans-attribute");
                    assemblyDescriptorEl.appendChild(containerTrEl);
                    ++j;
                }
            }
            ++i;
        }
    }

    private void loadMethodPermissions(Document mainDocument, Element assemblyDescriptorEl, EJBJarDescriptor ejbJar) {
        DeploymentDescriptor[] dd = ejbJar.getDDescriptors();
        AccessControls[] ac = null;
        AccessControls access = null;
        String[] roles = null;
        String uncheckedRole = "unchecked" + System.currentTimeMillis();
        Element roleNameEl = null;
        int i = 0;
        while (i < dd.length) {
            ac = dd[i].getAccessControlEntries();
            if (ac != null) {
                int j = 0;
                while (j < ac.length) {
                    if (ac[j].getUnchecked()) {
                        roles = this.concatArrays(new String[]{new String(uncheckedRole)}, roles);
                    } else if (ac[j].getSecurityRoleNames() != null) {
                        roles = this.concatArrays(ac[j].getSecurityRoleNames(), roles);
                    }
                    ++j;
                }
            }
            ++i;
        }
        if (roles == null || roles.length == 0) {
            return;
        }
        Hashtable<AccessControls, String> methods = null;
        String roleName = null;
        Element methodPermissionEl = null;
        Element methodEl = null;
        Enumeration keys = null;
        int i2 = 0;
        while (i2 < roles.length) {
            roleName = roles[i2];
            methods = new Hashtable<AccessControls, String>();
            methodPermissionEl = mainDocument.createElement("method-permission");
            if (!roleName.equals(uncheckedRole)) {
                XMLGenerator.load(mainDocument, methodPermissionEl, roleName, "role-name");
            } else {
                roleNameEl = mainDocument.createElement("unchecked");
                methodPermissionEl.appendChild(roleNameEl);
            }
            int j = 0;
            while (j < dd.length) {
                ac = dd[j].getAccessControlEntries();
                int k = 0;
                while (k < ac.length) {
                    if (this.containsRole(roleName, ac[k]) || ac[k].getUnchecked() && roleName.equals(uncheckedRole)) {
                        methods.put(ac[k], dd[j].getEjbName());
                    }
                    ++k;
                }
                ++j;
            }
            if (methods.size() == 0) {
                assemblyDescriptorEl.appendChild(methodPermissionEl);
            } else {
                keys = methods.keys();
                while (keys.hasMoreElements()) {
                    methodEl = mainDocument.createElement("method");
                    access = (AccessControls)keys.nextElement();
                    this.loadMethodElement(mainDocument, methodEl, (String)methods.get(access), access);
                    methodPermissionEl.appendChild(methodEl);
                }
                assemblyDescriptorEl.appendChild(methodPermissionEl);
            }
            ++i2;
        }
    }

    private void loadMethodElement(Document mainDocument, Element methodsEl, String ejbName, AccessControls access) {
        if (access.getDescription() != null && !access.getDescription().trim().equals("")) {
            XMLGenerator.load(mainDocument, methodsEl, access.getDescription(), "description");
        }
        XMLGenerator.load(mainDocument, methodsEl, ejbName, "ejb-name");
        if (access.getMethod().getMethodInterface() != null && !access.getMethod().getMethodInterface().trim().equals("")) {
            XMLGenerator.load(mainDocument, methodsEl, access.getMethod().getMethodInterface(), "method-intf");
        }
        if (!access.getMethod().isMethodSpecified()) {
            XMLGenerator.load(mainDocument, methodsEl, "*", "method-name");
            return;
        }
        XMLGenerator.load(mainDocument, methodsEl, access.getMethod().getMethodName(), "method-name");
        if (access.getMethod().getParameters() != null) {
            this.loadMethodParams(mainDocument, methodsEl, access.getMethod().getParameters());
        }
    }

    private void loadMethodElement(Document mainDocument, Element methodsEl, String ejbName, ControlDescriptor cd) {
        if (cd.getMethodEntry().getMethodDescription() != null && !cd.getMethodEntry().getMethodDescription().trim().equals("")) {
            XMLGenerator.load(mainDocument, methodsEl, cd.getMethodEntry().getMethodDescription(), "description");
        }
        XMLGenerator.load(mainDocument, methodsEl, ejbName, "ejb-name");
        if (cd.getMethodEntry().getMethodInterface() != null && !cd.getMethodEntry().getMethodInterface().trim().equals("")) {
            XMLGenerator.load(mainDocument, methodsEl, cd.getMethodEntry().getMethodInterface(), "method-intf");
        }
        if (!cd.getMethodEntry().isMethodSpecified()) {
            XMLGenerator.load(mainDocument, methodsEl, "*", "method-name");
            return;
        }
        XMLGenerator.load(mainDocument, methodsEl, cd.getMethodEntry().getMethodName(), "method-name");
        if (cd.getMethodEntry().getParameters() != null) {
            this.loadMethodParams(mainDocument, methodsEl, cd.getMethodEntry().getParameters());
        }
    }

    private void loadMethodParams(Document mainDocument, Element parent, String[] params) {
        if (params != null) {
            Element newEl = mainDocument.createElement("method-params");
            int j = 0;
            while (j < params.length) {
                XMLGenerator.load(mainDocument, newEl, this.convertClassName(params[j]), "method-param");
                ++j;
            }
            parent.appendChild(newEl);
        }
    }

    private boolean containsRole(String name, AccessControls ac) {
        String[] sr = ac.getSecurityRoleNames();
        if (sr == null) {
            return false;
        }
        int i = 0;
        while (i < sr.length) {
            if (name.equals(sr[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private void loadMessageDrivenDescriptor(Document mainDocument, Element ejbJarEl, MessageDrivenDescriptor mdd, Vector warnings) {
        ResourceEnvReference[] resEnvRefs;
        ResourceReference[] resRefs;
        SecurityIdentity secIdentity;
        Hashtable secRoleRefs;
        EJBeanLocalReference[] localRefs;
        EJBeanReference[] ejbRefs;
        EnvironmentEntry[] envEntr;
        Element messageBean = mainDocument.createElement("message-driven");
        ejbJarEl.appendChild(messageBean);
        if (mdd.getDescription() != null && !mdd.getDescription().trim().equals("")) {
            XMLGenerator.load(mainDocument, messageBean, mdd.getDescription(), "description");
        }
        if (mdd.getDisplayName() != null && !mdd.getDisplayName().trim().equals("")) {
            XMLGenerator.load(mainDocument, messageBean, mdd.getDisplayName(), "display-name");
        }
        if (mdd.getSmallIcon() != null && mdd.getSmallIcon().getFileName() != null && !mdd.getSmallIcon().getFileName().trim().equals("")) {
            XMLGenerator.load(mainDocument, messageBean, mdd.getSmallIcon().getFileName(), "small-icon");
        }
        if (mdd.getLargeIcon() != null && mdd.getLargeIcon().getFileName() != null && !mdd.getLargeIcon().getFileName().trim().equals("")) {
            XMLGenerator.load(mainDocument, messageBean, mdd.getLargeIcon().getFileName(), "large-icon");
        }
        if (mdd.getEjbName() != null && !mdd.getEjbName().trim().equals("")) {
            XMLGenerator.load(mainDocument, messageBean, mdd.getEjbName(), "ejb-name");
        } else {
            warnings.add("Field 'relationship-role-source' from deployment descriptor is missing.");
        }
        if (mdd.getClassName() != null && !mdd.getClassName().trim().equals("")) {
            XMLGenerator.load(mainDocument, messageBean, mdd.getClassName(), "ejb-class");
        } else {
            warnings.add("Bean Class for bean \"" + mdd.getEjbName() + "\" is missing in deployment descriptor.");
        }
        String type = mdd.getTransactionType() == 1 ? "Container" : "Bean";
        XMLGenerator.load(mainDocument, messageBean, type, "transaction-type");
        if (mdd.getMessageSelector() != null && !mdd.getMessageSelector().trim().equals("")) {
            XMLGenerator.load(mainDocument, messageBean, mdd.getMessageSelector(), "message-selector");
        }
        if (mdd.getAcknowledgeMode() != null && !mdd.getAcknowledgeMode().trim().equals("")) {
            XMLGenerator.load(mainDocument, messageBean, mdd.getAcknowledgeMode(), "acknowledge-mode");
        }
        Element messageDrivenDestination = null;
        if (mdd.getDestinationType() != null && !mdd.getDestinationType().trim().equals("")) {
            messageDrivenDestination = mainDocument.createElement("message-driven-destination");
            XMLGenerator.load(mainDocument, messageDrivenDestination, mdd.getDestinationType(), "destination-type");
        }
        if (mdd.getSubscriptionDurability() != null && !mdd.getSubscriptionDurability().trim().equals("")) {
            if (messageDrivenDestination == null) {
                messageDrivenDestination = mainDocument.createElement("message-driven-destination");
            }
            XMLGenerator.load(mainDocument, messageDrivenDestination, mdd.getSubscriptionDurability(), "subscription-durability");
        }
        if (messageDrivenDestination != null) {
            messageBean.appendChild(messageDrivenDestination);
        }
        if ((envEntr = mdd.getEnvironmentEntries()) != null && envEntr.length > 0) {
            EnvironmentXmlUtil.loadEnvEntries(mainDocument, messageBean, envEntr, warnings);
        }
        if ((ejbRefs = mdd.getEJBeanReferences()) != null && ejbRefs.length > 0) {
            EnvironmentXmlUtil.loadEjbRefs(mainDocument, messageBean, ejbRefs, warnings);
        }
        if ((localRefs = mdd.getEJBeanLocalReferences()) != null) {
            EnvironmentXmlUtil.loadEjbLocalRefs(mainDocument, messageBean, localRefs, warnings);
        }
        if ((secRoleRefs = mdd.getRoleReferences()) != null) {
            SecurityRoleReference[] refs = secRoleRefs.values().toArray(new SecurityRoleReference[0]);
            EnvironmentXmlUtil.loadSecurityRoleRefs(mainDocument, messageBean, refs, warnings);
        }
        if ((secIdentity = mdd.getSecurityIdentity()) != null) {
            this.loadSecurityIdentity(messageBean, secIdentity, warnings, mainDocument);
        }
        if ((resRefs = mdd.getResourceReferences()) != null) {
            EnvironmentXmlUtil.loadResourceRefs(mainDocument, messageBean, resRefs, warnings);
        }
        if ((resEnvRefs = mdd.getResourceEnvReferences()) != null) {
            EnvironmentXmlUtil.loadResourceEnvRefs(mainDocument, messageBean, resEnvRefs, warnings);
        }
        ejbJarEl.appendChild(messageBean);
    }

    private void loadEntityDescriptor(Document mainDocument, Element ejbJarEl, EntityDescriptor ed, Vector warnings) {
        FinderDescriptor[] ejbFindSelectDescr;
        ResourceEnvReference[] resEnvRefs;
        ResourceReference[] resRefs;
        SecurityIdentity secIdentity;
        Hashtable secRoleRefs;
        EJBeanLocalReference[] localRefs;
        EJBeanReference[] ejbRefs;
        EnvironmentEntry[] envEntr;
        int cmpVersion;
        boolean isCMP;
        Element entityBean;
        block42: {
            String pk;
            block47: {
                int i;
                PersistentField[] pField;
                Element cmpFieldEl;
                Vector<String> checkCMPField;
                block43: {
                    entityBean = mainDocument.createElement("entity");
                    ejbJarEl.appendChild(entityBean);
                    if (ed.getDescription() != null && !ed.getDescription().trim().equals("")) {
                        XMLGenerator.load(mainDocument, entityBean, ed.getDescription(), "description");
                    }
                    if (ed.getDisplayName() != null && !ed.getDisplayName().trim().equals("")) {
                        XMLGenerator.load(mainDocument, entityBean, ed.getDisplayName(), "display-name");
                    }
                    if (ed.getSmallIcon() != null && ed.getSmallIcon().getFileName() != null && !ed.getSmallIcon().getFileName().trim().equals("")) {
                        XMLGenerator.load(mainDocument, entityBean, ed.getSmallIcon().getFileName(), "small-icon");
                    }
                    if (ed.getLargeIcon() != null && ed.getLargeIcon().getFileName() != null && !ed.getLargeIcon().getFileName().trim().equals("")) {
                        XMLGenerator.load(mainDocument, entityBean, ed.getLargeIcon().getFileName(), "large-icon");
                    }
                    if (ed.getEjbName() != null && !ed.getEjbName().trim().equals("")) {
                        XMLGenerator.load(mainDocument, entityBean, ed.getEjbName(), "ejb-name");
                    } else {
                        warnings.add("Field 'relationship-role-source' from deployment descriptor is missing.");
                    }
                    boolean hasAnyHome = false;
                    boolean hasAnyComponentInt = false;
                    if (ed.getRemoteHomeInterface() != null && !ed.getRemoteHomeInterface().trim().equals("")) {
                        hasAnyHome = true;
                        XMLGenerator.load(mainDocument, entityBean, ed.getRemoteHomeInterface(), "home");
                    }
                    if (ed.getRemoteInterface() != null && !ed.getRemoteInterface().trim().equals("")) {
                        hasAnyComponentInt = true;
                        XMLGenerator.load(mainDocument, entityBean, ed.getRemoteInterface(), "remote");
                    }
                    if (ed.getLocalHomeInterface() != null && !ed.getLocalHomeInterface().trim().equals("")) {
                        hasAnyHome = true;
                        XMLGenerator.load(mainDocument, entityBean, ed.getLocalHomeInterface(), "local-home");
                    }
                    if (ed.getLocalInterface() != null && !ed.getLocalInterface().trim().equals("")) {
                        hasAnyComponentInt = true;
                        XMLGenerator.load(mainDocument, entityBean, ed.getLocalInterface(), "local");
                    }
                    if (!hasAnyComponentInt || !hasAnyHome) {
                        warnings.add(" Component or Home interface for bean \"" + ed.getEjbName() + "\"are missing.");
                    }
                    if (ed.getClassName() != null && !ed.getClassName().trim().equals("")) {
                        XMLGenerator.load(mainDocument, entityBean, ed.getClassName(), "ejb-class");
                    } else {
                        warnings.add("Bean Class for bean \"" + ed.getEjbName() + "\" is missing in deployment descriptor.");
                    }
                    String persistence = ed.getPersistenceType() == 1 ? "Container" : "Bean";
                    XMLGenerator.load(mainDocument, entityBean, persistence, "persistence-type");
                    if (ed.getPrimaryKeyClass() != null && !ed.getPrimaryKeyClass().trim().equals("")) {
                        XMLGenerator.load(mainDocument, entityBean, ed.getPrimaryKeyClass(), "prim-key-class");
                    } else {
                        warnings.add("Primary key class for bean \"" + ed.getEjbName() + "\" is missing.");
                    }
                    String reentrant = ed.isReentrant() ? "True" : "False";
                    XMLGenerator.load(mainDocument, entityBean, reentrant, "reentrant");
                    isCMP = false;
                    cmpVersion = 0;
                    if (!(ed instanceof CMPEntityDescriptor)) break block42;
                    checkCMPField = new Vector<String>();
                    isCMP = true;
                    cmpVersion = ((CMPEntityDescriptor)ed).getCmpVersion();
                    if (cmpVersion == 1) {
                        XMLGenerator.load(mainDocument, entityBean, "1.x", "cmp-version");
                    } else {
                        XMLGenerator.load(mainDocument, entityBean, "2.x", "cmp-version");
                        String abstractSchemaName = ((CMPEntityDescriptor)ed).getAbstractSchemaName();
                        if (abstractSchemaName != null && !abstractSchemaName.trim().equals("")) {
                            XMLGenerator.load(mainDocument, entityBean, abstractSchemaName, "abstract-schema-name");
                        }
                    }
                    cmpFieldEl = null;
                    cmpFieldEl = mainDocument.createElement("cmp-field");
                    pk = ((CMPEntityDescriptor)ed).getPKFieldName();
                    if (pk != null && !pk.trim().equals("")) {
                        checkCMPField.add(pk.trim());
                        XMLGenerator.load(mainDocument, cmpFieldEl, pk, "field-name");
                        entityBean.appendChild(cmpFieldEl);
                    }
                    if ((pField = ((CMPEntityDescriptor)ed).getCmpFields()) == null || pField.length <= 0) break block43;
                    i = 0;
                    while (i < pField.length) {
                        block45: {
                            block46: {
                                block44: {
                                    cmpFieldEl = mainDocument.createElement("cmp-field");
                                    if (pField[i].getDescription() != null && !pField[i].getDescription().trim().equals("")) {
                                        XMLGenerator.load(mainDocument, cmpFieldEl, pField[i].getDescription(), "description");
                                    }
                                    if (pField[i].getFieldName() == null || pField[i].getFieldName().trim().equals("")) break block44;
                                    if (checkCMPField.contains(pField[i].getFieldName())) break block45;
                                    checkCMPField.add(pField[i].getFieldName().trim());
                                    XMLGenerator.load(mainDocument, cmpFieldEl, pField[i].getFieldName(), "field-name");
                                    break block46;
                                }
                                warnings.add("Bean \"" + ed.getEjbName() + "\" : Missing name for cmp field.");
                            }
                            entityBean.appendChild(cmpFieldEl);
                        }
                        ++i;
                    }
                }
                if ((pField = ((CMPEntityDescriptor)ed).getPKCmpFields()) == null || pField.length <= 0) break block47;
                i = 0;
                while (i < pField.length) {
                    block49: {
                        block50: {
                            block48: {
                                cmpFieldEl = mainDocument.createElement("cmp-field");
                                if (pField[i].getDescription() != null && !pField[i].getDescription().trim().equals("")) {
                                    XMLGenerator.load(mainDocument, cmpFieldEl, pField[i].getDescription(), "description");
                                }
                                if (pField[i].getFieldName() == null || pField[i].getFieldName().trim().equals("")) break block48;
                                if (checkCMPField.contains(pField[i].getFieldName())) break block49;
                                checkCMPField.add(pField[i].getFieldName().trim());
                                XMLGenerator.load(mainDocument, cmpFieldEl, pField[i].getFieldName(), "field-name");
                                break block50;
                            }
                            warnings.add("Bean \"" + ed.getEjbName() + "\" : Missing name for cmp field.");
                        }
                        entityBean.appendChild(cmpFieldEl);
                    }
                    ++i;
                }
            }
            if (pk != null && !pk.trim().equals("")) {
                XMLGenerator.load(mainDocument, entityBean, pk, "primkey-field");
            }
        }
        if ((envEntr = ed.getEnvironmentEntries()) != null && envEntr.length > 0) {
            EnvironmentXmlUtil.loadEnvEntries(mainDocument, entityBean, envEntr, warnings);
        }
        if ((ejbRefs = ed.getEJBeanReferences()) != null && ejbRefs.length > 0) {
            EnvironmentXmlUtil.loadEjbRefs(mainDocument, entityBean, ejbRefs, warnings);
        }
        if ((localRefs = ed.getEJBeanLocalReferences()) != null) {
            EnvironmentXmlUtil.loadEjbLocalRefs(mainDocument, entityBean, localRefs, warnings);
        }
        if ((secRoleRefs = ed.getRoleReferences()) != null) {
            SecurityRoleReference[] refs = secRoleRefs.values().toArray(new SecurityRoleReference[0]);
            EnvironmentXmlUtil.loadSecurityRoleRefs(mainDocument, entityBean, refs, warnings);
        }
        if ((secIdentity = ed.getSecurityIdentity()) != null) {
            this.loadSecurityIdentity(entityBean, secIdentity, warnings, mainDocument);
        }
        if ((resRefs = ed.getResourceReferences()) != null) {
            EnvironmentXmlUtil.loadResourceRefs(mainDocument, entityBean, resRefs, warnings);
        }
        if ((resEnvRefs = ed.getResourceEnvReferences()) != null) {
            EnvironmentXmlUtil.loadResourceEnvRefs(mainDocument, entityBean, resEnvRefs, warnings);
        }
        if (isCMP && (ejbFindSelectDescr = ((CMPEntityDescriptor)ed).getFinderDescriptors()) != null && ejbFindSelectDescr.length > 0 && cmpVersion == 2) {
            Element ejbFindEl = null;
            Element queryMethodEl = null;
            Element paramsEl = null;
            int i = 0;
            while (i < ejbFindSelectDescr.length) {
                ejbFindEl = mainDocument.createElement("query");
                if (ejbFindSelectDescr[i].getDescription() != null && !ejbFindSelectDescr[i].getDescription().trim().equals("")) {
                    XMLGenerator.load(mainDocument, ejbFindEl, ejbFindSelectDescr[i].getDescription(), "description");
                }
                if (ejbFindSelectDescr[i].getMethodName() != null && !ejbFindSelectDescr[i].getMethodName().trim().equals("")) {
                    queryMethodEl = mainDocument.createElement("query-method");
                    XMLGenerator.load(mainDocument, queryMethodEl, ejbFindSelectDescr[i].getMethodName(), "method-name");
                    String[] params = ejbFindSelectDescr[i].getParamsTypes();
                    paramsEl = mainDocument.createElement("method-params");
                    if (params != null) {
                        int j = 0;
                        while (j < params.length) {
                            XMLGenerator.load(mainDocument, paramsEl, this.convertClassName(params[j]), "method-param");
                            ++j;
                        }
                    }
                    queryMethodEl.appendChild(paramsEl);
                    ejbFindEl.appendChild(queryMethodEl);
                } else {
                    warnings.add("Bean \"" + ed.getEjbName() + "\" : Query element contains no methods.");
                }
                if (ejbFindSelectDescr[i].isLocal()) {
                    XMLGenerator.load(mainDocument, ejbFindEl, "Local", "result-type-mapping");
                } else {
                    XMLGenerator.load(mainDocument, ejbFindEl, "Remote", "result-type-mapping");
                }
                if (ejbFindSelectDescr[i].getQuery() != null && !ejbFindSelectDescr[i].getQuery().trim().equals("")) {
                    XMLGenerator.load(mainDocument, ejbFindEl, ejbFindSelectDescr[i].getQuery(), "ejb-ql");
                } else {
                    warnings.add("Bean \"" + ed.getEjbName() + "\" : Query element contains no ejb-ql statement.");
                }
                entityBean.appendChild(ejbFindEl);
                ++i;
            }
        }
        ejbJarEl.appendChild(entityBean);
    }

    private void loadSessionDescriptor(Document mainDocument, Element ejbJarEl, SessionDescriptor sd, Vector warnings) {
        ResourceEnvReference[] resEnvRefs;
        ResourceReference[] resRefs;
        SecurityIdentity secIdentity;
        Hashtable secRoleRefs;
        EJBeanLocalReference[] localRefs;
        EJBeanReference[] ejbRefs;
        Element sessionBean = mainDocument.createElement("session");
        ejbJarEl.appendChild(sessionBean);
        if (sd.getDescription() != null && !sd.getDescription().trim().equals("")) {
            XMLGenerator.load(mainDocument, sessionBean, sd.getDescription(), "description");
        }
        if (sd.getDisplayName() != null && !sd.getDisplayName().trim().equals("")) {
            XMLGenerator.load(mainDocument, sessionBean, sd.getDisplayName(), "display-name");
        }
        if (sd.getSmallIcon() != null && sd.getSmallIcon().getFileName() != null && !sd.getSmallIcon().getFileName().trim().equals("")) {
            XMLGenerator.load(mainDocument, sessionBean, sd.getSmallIcon().getFileName(), "small-icon");
        }
        if (sd.getLargeIcon() != null && sd.getLargeIcon().getFileName() != null && !sd.getLargeIcon().getFileName().trim().equals("")) {
            XMLGenerator.load(mainDocument, sessionBean, sd.getLargeIcon().getFileName(), "large-icon");
        }
        if (sd.getEjbName() != null && !sd.getEjbName().trim().equals("")) {
            XMLGenerator.load(mainDocument, sessionBean, sd.getEjbName(), "ejb-name");
        } else {
            warnings.add(" Field ejb-name is missing in ejb descriptor.");
        }
        boolean hasAnyHome = false;
        boolean hasAnyComponentInt = false;
        if (sd.getRemoteHomeInterface() != null && !sd.getRemoteHomeInterface().trim().equals("")) {
            hasAnyHome = true;
            XMLGenerator.load(mainDocument, sessionBean, sd.getRemoteHomeInterface(), "home");
        }
        if (sd.getRemoteInterface() != null && !sd.getRemoteInterface().trim().equals("")) {
            hasAnyComponentInt = true;
            XMLGenerator.load(mainDocument, sessionBean, sd.getRemoteInterface(), "remote");
        }
        if (sd.getLocalHomeInterface() != null && !sd.getLocalHomeInterface().trim().equals("")) {
            hasAnyHome = true;
            XMLGenerator.load(mainDocument, sessionBean, sd.getLocalHomeInterface(), "local-home");
        }
        if (sd.getLocalInterface() != null && !sd.getLocalInterface().trim().equals("")) {
            hasAnyComponentInt = true;
            XMLGenerator.load(mainDocument, sessionBean, sd.getLocalInterface(), "local");
        }
        if (!hasAnyComponentInt || !hasAnyHome) {
            warnings.add(" Component or Home interface for bean \"" + sd.getEjbName() + "\"are missing.");
        }
        if (sd.getClassName() != null && !sd.getClassName().trim().equals("")) {
            XMLGenerator.load(mainDocument, sessionBean, sd.getClassName(), "ejb-class");
        } else {
            warnings.add(" Component or Home interface for bean \"" + sd.getEjbName() + "\"are missing.");
        }
        String type = null;
        type = sd.getSessionType() == 1 ? "Stateful" : "Stateless";
        XMLGenerator.load(mainDocument, sessionBean, type, "session-type");
        type = sd.getTransactionType() == 1 ? "Container" : "Bean";
        XMLGenerator.load(mainDocument, sessionBean, type, "transaction-type");
        EnvironmentEntry[] envEntr = sd.getEnvironmentEntries();
        if (envEntr != null && envEntr.length > 0) {
            EnvironmentXmlUtil.loadEnvEntries(mainDocument, sessionBean, envEntr, warnings);
        }
        if ((ejbRefs = sd.getEJBeanReferences()) != null && ejbRefs.length > 0) {
            EnvironmentXmlUtil.loadEjbRefs(mainDocument, sessionBean, ejbRefs, warnings);
        }
        if ((localRefs = sd.getEJBeanLocalReferences()) != null) {
            EnvironmentXmlUtil.loadEjbLocalRefs(mainDocument, sessionBean, localRefs, warnings);
        }
        if ((secRoleRefs = sd.getRoleReferences()) != null) {
            SecurityRoleReference[] refs = secRoleRefs.values().toArray(new SecurityRoleReference[0]);
            EnvironmentXmlUtil.loadSecurityRoleRefs(mainDocument, sessionBean, refs, warnings);
        }
        if ((secIdentity = sd.getSecurityIdentity()) != null) {
            this.loadSecurityIdentity(sessionBean, secIdentity, warnings, mainDocument);
        }
        if ((resRefs = sd.getResourceReferences()) != null) {
            EnvironmentXmlUtil.loadResourceRefs(mainDocument, sessionBean, resRefs, warnings);
        }
        if ((resEnvRefs = sd.getResourceEnvReferences()) != null) {
            EnvironmentXmlUtil.loadResourceEnvRefs(mainDocument, sessionBean, resEnvRefs, warnings);
        }
        ejbJarEl.appendChild(sessionBean);
    }

    private void loadSecurityIdentity(Element parent, SecurityIdentity secIdentity, Vector warnings, Document mainDocument) {
        Element secIdentityEl = mainDocument.createElement("security-identity");
        if (secIdentity.getDescription() != null) {
            XMLGenerator.load(mainDocument, secIdentityEl, secIdentity.getDescription(), "description");
        }
        if (secIdentity.isCallerIdentity()) {
            secIdentityEl.appendChild(mainDocument.createElement("use-caller-identity"));
        } else {
            Element runAsEl = mainDocument.createElement("run-as");
            if (secIdentity.getRunAsIdentity().getDescription() != null && !secIdentity.getRunAsIdentity().getDescription().trim().equals("")) {
                XMLGenerator.load(mainDocument, runAsEl, secIdentity.getRunAsIdentity().getDescription(), "description");
            }
            if (secIdentity.getRunAsIdentity().getSecurityRoleName() != null && !secIdentity.getRunAsIdentity().getSecurityRoleName().trim().equals("")) {
                XMLGenerator.load(mainDocument, runAsEl, secIdentity.getRunAsIdentity().getSecurityRoleName(), "role-name");
            } else {
                warnings.add("Run as identity role name is missing.");
            }
            secIdentityEl.appendChild(runAsEl);
        }
        parent.appendChild(secIdentityEl);
    }

    private String[] concatArrays(String[] arr1, String[] arr2) {
        if (arr1 == null) {
            return arr2;
        }
        if (arr2 == null) {
            return arr1;
        }
        Vector<String> resultV = new Vector<String>();
        int i = 0;
        while (i < arr1.length) {
            resultV.add(arr1[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < arr2.length) {
            if (!resultV.contains(arr2[i2])) {
                resultV.add(arr2[i2]);
            }
            ++i2;
        }
        if (resultV.size() > 0) {
            Object[] res = new String[resultV.size()];
            resultV.copyInto(res);
            return res;
        }
        return null;
    }

    private String convertClassName(String className) {
        if (className.charAt(0) != '[') {
            return className;
        }
        int first = className.indexOf(91);
        int last = className.lastIndexOf(91);
        char ch = className.charAt(last + 1);
        String st = "";
        int i = 0;
        while (i <= last - first) {
            st = st + "[]";
            ++i;
        }
        switch (ch) {
            case 'B': {
                return "byte" + st;
            }
            case 'C': {
                return "char" + st;
            }
            case 'D': {
                return "double" + st;
            }
            case 'F': {
                return "float" + st;
            }
            case 'I': {
                return "int" + st;
            }
            case 'J': {
                return "long" + st;
            }
            case 'S': {
                return "short" + st;
            }
            case 'Z': {
                return "boolean" + st;
            }
            case 'L': {
                return className.substring(last + 2, className.length() - 1) + st;
            }
        }
        return "";
    }
}

