/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier.session;

import com.sap.engine.services.ejb.deploy.descriptors.SessionDescriptor;
import com.sap.engine.services.ejb.deploy.verifier.BeanClassCheck;
import com.sap.engine.services.ejb.deploy.verifier.BusinessMethodCheck;
import com.sap.engine.services.ejb.deploy.verifier.CheckUtils;
import com.sap.engine.services.ejb.deploy.verifier.LocalHomeInterfaceCheck;
import com.sap.engine.services.ejb.deploy.verifier.LocalInterfaceCheck;
import com.sap.engine.services.ejb.deploy.verifier.RemoteHomeInterfaceCheck;
import com.sap.engine.services.ejb.deploy.verifier.RemoteInterfaceCheck;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class SessionBeanCheck {
    static /* synthetic */ Class class$javax$ejb$SessionBean;
    static /* synthetic */ Class class$javax$transaction$UserTransaction;
    static /* synthetic */ Class class$javax$ejb$EJBObject;
    static /* synthetic */ Class class$javax$ejb$EJBHome;
    static /* synthetic */ Class class$javax$ejb$EJBLocalObject;
    static /* synthetic */ Class class$javax$ejb$EJBLocalHome;
    static /* synthetic */ Class class$javax$ejb$SessionSynchronization;

    public static void check(SessionDescriptor sesDescr, Vector results, ClassLoader loader) {
        String localName;
        String remoteName;
        String ejbLocalHomeName;
        String ejbName = sesDescr.getEjbName();
        if (sesDescr.getSessionType() != 0 && sesDescr.getSessionType() != 1) {
            results.add("Bean " + ejbName + ": session type is not specified. Stateful or Stateless session type must be specified for session beans. EJB Specification 22.2.");
        }
        boolean stateless = sesDescr.getSessionType() == 0;
        Class sessionClass = CheckUtils.loadClass(loader, sesDescr.getClassName(), results, ejbName);
        if (sessionClass == null) {
            return;
        }
        if (!(class$javax$ejb$SessionBean == null ? (class$javax$ejb$SessionBean = SessionBeanCheck.class$("javax.ejb.SessionBean")) : class$javax$ejb$SessionBean).isAssignableFrom(sessionClass)) {
            results.add("Bean " + ejbName + ": the ejb-class must implement, directly or indirectly, the javax.ejb.SessionBean interface. EJB specification 7.10.2.");
        }
        BeanClassCheck.check(sessionClass, false, results);
        CheckUtils.checkInterfacesExistence(sesDescr, results, ejbName);
        String ejbHomeName = sesDescr.getRemoteHomeInterface();
        if (ejbHomeName != null) {
            SessionBeanCheck.checkEJBHome(loader, ejbHomeName, results, ejbName, sesDescr, stateless, sessionClass);
        }
        if ((ejbLocalHomeName = sesDescr.getLocalHomeInterface()) != null) {
            SessionBeanCheck.checkEJBLocalHome(loader, ejbLocalHomeName, results, ejbName, sesDescr, stateless, sessionClass);
        }
        if ((remoteName = sesDescr.getRemoteInterface()) != null) {
            Class<?> remoteClass = null;
            try {
                remoteClass = loader.loadClass(remoteName);
            }
            catch (ClassNotFoundException cnfe) {
                results.add("Bean " + ejbName + ": can not load remote interface " + remoteName + ". Reason: " + cnfe.toString());
            }
            RemoteInterfaceCheck.check(sesDescr, remoteClass, sessionClass, results);
        }
        if ((localName = sesDescr.getLocalInterface()) != null) {
            Class<?> localClass = null;
            try {
                localClass = loader.loadClass(localName);
            }
            catch (ClassNotFoundException cnfe) {
                results.add("Bean " + ejbName + ": can not load local interface " + localName + ". Reason: " + cnfe.toString());
            }
            LocalInterfaceCheck.check(sesDescr, localClass, sessionClass, results);
        }
        Field[] fields = sessionClass.getFields();
        int i = 0;
        while (i < fields.length) {
            if (Modifier.isTransient(fields[i].getModifiers())) {
                results.add("Warning. Bean " + ejbName + ": field " + fields[i].getName() + " defined within session bean class " + sessionClass.getName() + " is defined as transient. Session bean fields should not be defined in the session bean class as transient.");
                Class<?> fType = fields[i].getType();
                if ((class$javax$transaction$UserTransaction == null ? SessionBeanCheck.class$("javax.transaction.UserTransaction") : class$javax$transaction$UserTransaction).isAssignableFrom(fType) || (class$javax$transaction$UserTransaction == null ? SessionBeanCheck.class$("javax.transaction.UserTransaction") : class$javax$transaction$UserTransaction).isAssignableFrom(fType) || (class$javax$ejb$EJBObject == null ? SessionBeanCheck.class$("javax.ejb.EJBObject") : class$javax$ejb$EJBObject).isAssignableFrom(fType) || (class$javax$ejb$EJBHome == null ? SessionBeanCheck.class$("javax.ejb.EJBHome") : class$javax$ejb$EJBHome).isAssignableFrom(fType) || (class$javax$ejb$EJBLocalObject == null ? SessionBeanCheck.class$("javax.ejb.EJBLocalObject") : class$javax$ejb$EJBLocalObject).isAssignableFrom(fType) || (class$javax$ejb$EJBLocalHome == null ? SessionBeanCheck.class$("javax.ejb.EJBLocalHome") : class$javax$ejb$EJBLocalHome).isAssignableFrom(fType)) {
                    results.add("Warning. Bean " + ejbName + ": field " + fields[i].getName() + " defined within session bean class " + sessionClass.getName() + " is defined as transient. Session bean fields should not store in a transient field a reference to any of the following objects: SessionContext object; environment JNDI naming context and any its subcontexts; home and remote interfaces; and the UserTransaction interface. EJB specification 7.4.1.");
                }
            }
            ++i;
        }
        if ((class$javax$ejb$SessionSynchronization == null ? (class$javax$ejb$SessionSynchronization = SessionBeanCheck.class$("javax.ejb.SessionSynchronization")) : class$javax$ejb$SessionSynchronization).isAssignableFrom(sessionClass)) {
            if (stateless) {
                results.add("Bean " + ejbName + ": " + sessionClass + " does not properly implement the SessionSynchronization interface. SessionSynchronization interface must not be implemented by a stateless Session Bean. EJB specification 7.5.3.");
            } else if (sesDescr.getTransactionType() == 0) {
                results.add("Bean " + ejbName + ": " + sessionClass + " does not properly implement the SessionSynchronization interface. SessionSynchronization interface may be implemented only by a stateful Session Bean using container-managed transactions. EJB specification 7.5.3.");
            }
        }
        if ((class$javax$ejb$EJBObject == null ? (class$javax$ejb$EJBObject = SessionBeanCheck.class$("javax.ejb.EJBObject")) : class$javax$ejb$EJBObject).isAssignableFrom(sessionClass) || (class$javax$ejb$EJBHome == null ? (class$javax$ejb$EJBHome = SessionBeanCheck.class$("javax.ejb.EJBHome")) : class$javax$ejb$EJBHome).isAssignableFrom(sessionClass) || (class$javax$ejb$EJBLocalObject == null ? (class$javax$ejb$EJBLocalObject = SessionBeanCheck.class$("javax.ejb.EJBLocalObject")) : class$javax$ejb$EJBLocalObject).isAssignableFrom(sessionClass) || (class$javax$ejb$EJBLocalHome == null ? (class$javax$ejb$EJBLocalHome = SessionBeanCheck.class$("javax.ejb.EJBLocalHome")) : class$javax$ejb$EJBLocalHome).isAssignableFrom(sessionClass)) {
            results.add("Warning. Bean " + ejbName + ": maybe " + sessionClass.getName() + " class implements the enterprise Bean's remote, local, local-home or home interface. It is recommended that the enterprise bean class not implement the remote interface to prevent inadvertent passing of this as a method argument or result. EJB specification 7.10.2.");
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void checkEJBLocalHome(ClassLoader loader, String ejbLocalHomeName, Vector results, String ejbName, SessionDescriptor sesDescr, boolean stateless, Class sessionClass) {
        ejbLocalHomeClass = null;
        try {
            ejbLocalHomeClass = loader.loadClass(ejbLocalHomeName);
        }
        catch (ClassNotFoundException cnfe) {
            results.add("Bean " + ejbName + ": can not load local home interface " + ejbLocalHomeName + ". Reason: " + cnfe.toString());
            return;
        }
        LocalHomeInterfaceCheck.check(sesDescr, ejbLocalHomeClass, results);
        allEjbLocalHomeMethods = ejbLocalHomeClass.getMethods();
        if (allEjbLocalHomeMethods.length == 1) {
            if (stateless) {
                results.add("Bean " + ejbName + ": stateless session bean must define exactly one create method with no arguments in its local home interface.");
            } else {
                results.add("Bean " + ejbName + ": at least one create<METHOD> method must be declared in the local home interface of a session stateful bean.");
            }
        }
        i = 0;
        while (i < allEjbLocalHomeMethods.length) {
            block24: {
                block25: {
                    if (allEjbLocalHomeMethods[i].getDeclaringClass().getName().equals("javax.ejb.EJBLocalHome")) break block24;
                    methodName = allEjbLocalHomeMethods[i].getName();
                    methodArgs = allEjbLocalHomeMethods[i].getParameterTypes();
                    if (!methodName.startsWith("create")) {
                        results.add("Bean " + ejbName + ": there must be defined only create<METHOD> methods in the session bean local home interface.");
                    }
                    if (stateless) {
                        if (!methodName.equals("create")) {
                            results.add("Bean " + ejbName + ": the local home interface of a stateless session bean must have only one create() method with no arguments. Please remove method(s) with name " + methodName + ".");
                        }
                        if (methodArgs.length != 0) {
                            results.add("Bean " + ejbName + ": the local home interface of a stateless session bean must have only one create() method with no arguments. Please remove create method(s) with arguments.");
                        }
                    }
                    if (!allEjbLocalHomeMethods[i].getReturnType().getName().equals(sesDescr.getLocalInterface())) {
                        results.add("Bean " + ejbName + ": the return type for a create<METHOD> method of the session bean local home interface must be the session bean local interface type. EJB specification 7.10.8.");
                    }
                    ejbCreateMethodName = "ejbC" + methodName.substring(1);
                    ejbCreateMethod = null;
                    try {
                        ejbCreateMethod = sessionClass.getMethod(ejbCreateMethodName, methodArgs);
                    }
                    catch (NoSuchMethodException nsme) {
                        argsToName = "";
                        l = 0;
                        ** while (l < methodArgs.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        argsToName = argsToName + methodArgs[l].getName() + " ";
                        ++l;
                        continue;
                    }
lbl48:
                    // 1 sources

                    results.add("Bean " + ejbName + ": can not find method " + ejbCreateMethodName + "(" + argsToName + ") " + " in ejb-class " + sessionClass.getName() + ". Each create method must be named create<METHOD>, and it must match one of the ejbCreate<METHOD> methods defined in the session bean class. The matching ejbCreate<METHOD> method must have the same number and types of arguments. EJB Specification 7.10.8.");
                    break block25;
                    catch (SecurityException seex) {
                        results.add("Bean " + ejbName + ": can not access ejbCreate method(s). Reason: " + seex.toString());
                    }
                }
                if (ejbCreateMethod != null) {
                    BusinessMethodCheck.check(ejbName, ejbCreateMethod, false, true, results);
                    if (!ejbCreateMethod.getReturnType().getName().equals("void")) {
                        results.add("Bean " + ejbName + ": the return type of all ejbCreate<Method>(s) must be void. EJB specification 7.10.3.");
                    }
                    exceptions = allEjbLocalHomeMethods[i].getExceptionTypes();
                    ejbExceptions = ejbCreateMethod.getExceptionTypes();
                    foundCrEx = false;
                    l = 0;
                    while (l < exceptions.length) {
                        if (exceptions[l].getName().equals("javax.ejb.CreateException")) {
                            foundCrEx = true;
                        }
                        ++l;
                    }
                    if (!foundCrEx) {
                        results.add("Bean " + ejbName + ": all ejbCreate<Method> methods must throw javax.ejb.CreateException. EJB specification 7.10.8.");
                    }
                    m = 0;
                    while (m < ejbExceptions.length) {
                        exName = ejbExceptions[m].getName();
                        fnd = false;
                        n = 0;
                        while (n < exceptions.length) {
                            if (exceptions[n].getName().equals(exName)) {
                                fnd = true;
                            }
                            ++n;
                        }
                        if (!fnd) {
                            results.add("Bean " + ejbName + ": exception " + exName + " found in the throws clause of method " + ejbCreateMethodName + " but not found in the throws clause of method " + methodName + " as required. EJB specification 7.10.8.");
                        }
                        ++m;
                    }
                }
            }
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void checkEJBHome(ClassLoader loader, String ejbHomeName, Vector results, String ejbName, SessionDescriptor sesDescr, boolean stateless, Class sessionClass) {
        ejbHomeClass = null;
        try {
            ejbHomeClass = loader.loadClass(ejbHomeName);
        }
        catch (ClassNotFoundException cnfe) {
            results.add("Bean " + ejbName + ": can not load home interface " + ejbHomeName + ". Reason : " + cnfe.toString());
            return;
        }
        RemoteHomeInterfaceCheck.check(sesDescr, ejbHomeClass, results);
        allEjbHomeMethods = ejbHomeClass.getMethods();
        if (allEjbHomeMethods.length == 4) {
            if (stateless) {
                results.add("Bean " + ejbName + ": stateless session bean must define exactly one create method with no arguments in its home interface.");
            } else {
                results.add("Bean " + ejbName + ": at least one create<METHOD> method must be declared in the home interface of a session stateful bean.");
            }
        }
        i = 0;
        while (i < allEjbHomeMethods.length) {
            block24: {
                block25: {
                    if (allEjbHomeMethods[i].getDeclaringClass().getName().equals("javax.ejb.EJBHome")) break block24;
                    methodName = allEjbHomeMethods[i].getName();
                    methodArgs = allEjbHomeMethods[i].getParameterTypes();
                    if (!methodName.startsWith("create")) {
                        results.add("Bean " + ejbName + ": there must be only create<METHOD> methods in the session bean home interface. Please remove method(s) with name " + methodName);
                    }
                    if (stateless) {
                        if (!methodName.equals("create")) {
                            results.add("Bean " + ejbName + ": the home interface of a stateless session bean must have only one create() method with no arguments. Please remove method(s) with name " + methodName + ".");
                        }
                        if (methodArgs.length != 0) {
                            results.add("Bean " + ejbName + ": the home interface of a stateless session bean must have only one create() method with no arguments. Please remove create method(s) with arguments.");
                        }
                    }
                    if (!allEjbHomeMethods[i].getReturnType().getName().equals(sesDescr.getRemoteInterface())) {
                        results.add("Bean " + ejbName + ": the return type of a create<METHOD> method in the session bean home interface must be the session bean's remote interface type. EJB specification 7.10.6.");
                    }
                    ejbCreateMethodName = "ejbC" + methodName.substring(1);
                    ejbCreateMethod = null;
                    try {
                        ejbCreateMethod = sessionClass.getMethod(ejbCreateMethodName, methodArgs);
                    }
                    catch (NoSuchMethodException nsme) {
                        argsToName = "";
                        l = 0;
                        ** while (l < methodArgs.length)
                    }
lbl-1000:
                    // 1 sources

                    {
                        argsToName = argsToName + methodArgs[l].getName() + " ";
                        ++l;
                        continue;
                    }
lbl48:
                    // 1 sources

                    results.add("Bean " + ejbName + ": can not find method " + ejbCreateMethodName + "(" + argsToName + ") " + " in ejb-class " + sessionClass.getName() + ". Each create method must be named create<METHOD>, and it must match one of the ejbCreate<METHOD> methods defined in the session bean class. The matching ejbCreate<METHOD> method must have the same number and types of arguments. EJB Specification 7.10.6.");
                    break block25;
                    catch (SecurityException seex) {
                        results.add("Bean " + ejbName + ": can not access ejbCreate method(s). Reason : " + seex.toString());
                    }
                }
                if (ejbCreateMethod != null) {
                    if (!ejbCreateMethod.getReturnType().getName().equals("void")) {
                        results.add("Bean " + ejbName + ": the return type of all ejbCreate<Method>(s) must be void. EJB specification 7.10.3.");
                    }
                    exceptions = allEjbHomeMethods[i].getExceptionTypes();
                    ejbExceptions = ejbCreateMethod.getExceptionTypes();
                    foundCrEx = false;
                    l = 0;
                    while (l < exceptions.length) {
                        if (exceptions[l].getName().equals("javax.ejb.CreateException")) {
                            foundCrEx = true;
                        }
                        ++l;
                    }
                    if (!foundCrEx) {
                        results.add("Bean " + ejbName + ": method " + methodName + " found but does not throw javax.ejb.CreateException as required. EJB specification 7.10.6.");
                    }
                    m = 0;
                    while (m < ejbExceptions.length) {
                        exName = ejbExceptions[m].getName();
                        fnd = false;
                        n = 0;
                        while (n < exceptions.length) {
                            if (exceptions[n].getName().equals(exName)) {
                                fnd = true;
                            }
                            ++n;
                        }
                        if (!fnd) {
                            results.add("Bean " + ejbName + ": exception " + exName + " found in the throws clause of method " + ejbCreateMethodName + " but not found in the throws clause of method " + methodName + " as required. EJB specification 7.10.6.");
                        }
                        ++m;
                    }
                }
            }
            ++i;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

