/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier.entity;

import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.FinderDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import com.sap.engine.services.ejb.deploy.verifier.BeanClassCheck;
import com.sap.engine.services.ejb.deploy.verifier.CheckUtils;
import com.sap.engine.services.ejb.deploy.verifier.LocalHomeInterfaceCheck;
import com.sap.engine.services.ejb.deploy.verifier.LocalInterfaceCheck;
import com.sap.engine.services.ejb.deploy.verifier.RemoteHomeInterfaceCheck;
import com.sap.engine.services.ejb.deploy.verifier.RemoteInterfaceCheck;
import com.sap.engine.services.ejb.deploy.verifier.entity.CMPFieldChecker;
import com.sap.engine.services.ejb.deploy.verifier.entity.CMRFieldChecker;
import com.sap.engine.services.ejb.deploy.verifier.entity.EntityPKCheck;
import com.sap.engine.services.ejb.deploy.verifier.entity.MultiplePKCheck;
import com.sap.engine.services.ejb.util.ClassUtils;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class EntityCMP20Check {
    static /* synthetic */ Class class$javax$ejb$EntityBean;

    public static void check(CMPEntityDescriptor entDescr, Vector results, ClassLoader loader) {
        String ejbName = entDescr.getEjbName();
        String entityClassName = entDescr.getClassName();
        String pkClassName = entDescr.getPrimaryKeyClass();
        Class entityClass = CheckUtils.loadClass(loader, entityClassName, results, ejbName);
        Class pkClass = CheckUtils.loadClass(loader, ClassUtils.fixClassName(pkClassName), results, ejbName);
        String remoteName = entDescr.getRemoteInterface();
        Class remoteClass = null;
        if (remoteName != null) {
            remoteClass = CheckUtils.loadClass(loader, remoteName, results, ejbName);
        }
        String localName = entDescr.getLocalInterface();
        Class localClass = null;
        if (localName != null) {
            localClass = CheckUtils.loadClass(loader, localName, results, ejbName);
        }
        String homeName = entDescr.getRemoteHomeInterface();
        Class homeClass = null;
        if (homeName != null) {
            homeClass = CheckUtils.loadClass(loader, homeName, results, ejbName);
        }
        String localHomeName = entDescr.getLocalHomeInterface();
        Class localHomeClass = null;
        if (localHomeName != null) {
            localHomeClass = CheckUtils.loadClass(loader, localHomeName, results, ejbName);
        }
        if (!entDescr.isUnknownPK()) {
            EntityCMP20Check.checkPrimaryKey(entDescr, pkClass, results, ejbName, remoteClass, localClass);
        }
        Method[] allBeanMethods = entityClass.getMethods();
        int c = 0;
        while (c < allBeanMethods.length) {
            if (allBeanMethods[c].getName().startsWith("ejbFind")) {
                results.add("Bean <" + ejbName + ">: " + allBeanMethods[c].getName() + " is declared. It is not allowed //see 10.6.2.");
            }
            ++c;
        }
        EntityCMP20Check.checkForAbstractMethods(allBeanMethods, entDescr, results);
        if (entityClass != null) {
            if (!(class$javax$ejb$EntityBean == null ? (class$javax$ejb$EntityBean = EntityCMP20Check.class$("javax.ejb.EntityBean")) : class$javax$ejb$EntityBean).isAssignableFrom(entityClass)) {
                results.add("Bean <" + ejbName + ">: the ejb-class must implement, directly or indirectly, the javax.ejb.EntityBean interface. EJB Specification 10.6.2.");
            }
            BeanClassCheck.check(entityClass, true, results);
        }
        CheckUtils.checkInterfacesExistence(entDescr, results, ejbName);
        EntityCMP20Check.checkInterfaces(homeClass, entDescr, results, entityClass, ejbName, localHomeClass, localHomeName, remoteClass, localClass);
        EntityCMP20Check.checkSelectMethods(entityClass, results, entDescr, homeClass, remoteClass, localHomeClass, localClass);
        PersistentField[] cmpFields = entDescr.getCmpFields();
        RelationField[] cmrFields = entDescr.getCmrFields();
        int i = 0;
        while (i < cmpFields.length) {
            CMPFieldChecker.check(cmpFields[i], i, results, ejbName, entityClass, loader);
            ++i;
        }
        if (cmrFields != null) {
            int i2 = 0;
            while (i2 < cmrFields.length) {
                CMRFieldChecker.check(cmrFields[i2], i2, loader, results, ejbName, entityClass, remoteClass);
                ++i2;
            }
        }
    }

    private static void checkForAbstractMethods(Method[] allBeanMethods, CMPEntityDescriptor entDescr, Vector results) {
        int c = 0;
        while (c < allBeanMethods.length) {
            String methodName;
            Method beanMethod = allBeanMethods[c];
            if (Modifier.isAbstract(beanMethod.getModifiers()) && !(methodName = beanMethod.getName()).startsWith("ejbSelect")) {
                String methodNamePrefix = methodName.substring(0, 3);
                String upMethodName = methodName.substring(3);
                boolean fieldFound = false;
                if (methodNamePrefix.equals("get") || methodNamePrefix.equals("set")) {
                    PersistentField[] pFields = entDescr.getPKCmpFields();
                    int p = 0;
                    while (p < pFields.length) {
                        PersistentField pField = pFields[p];
                        String upFieldName = Character.toUpperCase(pField.getFieldName().charAt(0)) + pField.getFieldName().substring(1);
                        if (upMethodName.equals(upFieldName)) {
                            fieldFound = true;
                            break;
                        }
                        ++p;
                    }
                    if (!fieldFound) {
                        String upFieldName;
                        PersistentField pField;
                        pFields = entDescr.getCmpFields();
                        if (pFields != null) {
                            int p2 = 0;
                            while (p2 < pFields.length) {
                                pField = pFields[p2];
                                upFieldName = Character.toUpperCase(pField.getFieldName().charAt(0)) + pField.getFieldName().substring(1);
                                if (upMethodName.equals(upFieldName)) {
                                    fieldFound = true;
                                    break;
                                }
                                ++p2;
                            }
                        }
                        if (!fieldFound && (pFields = entDescr.getCmrFields()) != null) {
                            int p3 = 0;
                            while (p3 < pFields.length) {
                                pField = pFields[p3];
                                upFieldName = Character.toUpperCase(pField.getFieldName().charAt(0)) + pField.getFieldName().substring(1);
                                if (upMethodName.equals(upFieldName)) {
                                    fieldFound = true;
                                    break;
                                }
                                ++p3;
                            }
                        }
                    }
                }
                if (!fieldFound) {
                    results.add("Bean <" + entDescr.getEjbName() + ">: Method " + methodName + " in the bean class is abstract. Only ejbSelect<METHOD> methods and the accessor methods of the bean's abstract persistence schema must be abstract.");
                }
            }
            ++c;
        }
    }

    private static void checkSelectMethods(Class entityClass, Vector results, CMPEntityDescriptor entDescr, Class homeClass, Class remoteClass, Class localHomeClass, Class localClass) {
        Method[] beanMethods = entityClass.getDeclaredMethods();
        int p = 0;
        while (p < beanMethods.length) {
            String beanMethodName = beanMethods[p].getName();
            if (beanMethodName.startsWith("ejbSelect")) {
                EntityCMP20Check.checkSelectMethod(beanMethods[p], results, entDescr, homeClass, remoteClass, localHomeClass, localClass);
            }
            ++p;
        }
    }

    private static void checkSelectMethod(Method selectMethod, Vector results, CMPEntityDescriptor entDescr, Class homeClass, Class remoteClass, Class localHomeClass, Class localClass) {
        String beanMethodName = selectMethod.getName();
        String ejbName = entDescr.getEjbName();
        if (!EntityCMP20Check.isDeclaredEJBQLForFinderSelectMethod(selectMethod, entDescr)) {
            results.add("Bean " + ejbName + ": " + beanMethodName + " method does not have EJB QL specified in the ejb-jar.xml. EJB Specification 10.6.14.");
        }
        if (!Modifier.isPublic(selectMethod.getModifiers())) {
            results.add("Bean <" + ejbName + ">: " + beanMethodName + " method is not defined as public //see 10.6.7.");
        }
        if (!Modifier.isAbstract(selectMethod.getModifiers())) {
            results.add("Bean <" + ejbName + ">: " + beanMethodName + " method is not defined as abstract //see 10.6.7.");
        }
        Class<?>[] selectExceptions = selectMethod.getExceptionTypes();
        boolean finderExceptionDefined = false;
        int exc = 0;
        while (exc < selectExceptions.length) {
            if (selectExceptions[exc].getName().equals("javax.ejb.FinderException") || selectExceptions[exc].getName().equals("FinderException")) {
                finderExceptionDefined = true;
                break;
            }
            ++exc;
        }
        if (!finderExceptionDefined) {
            results.add("Bean <" + ejbName + ">: <" + beanMethodName + "> method does not throw javax.ejb.FinderException //see 10.6.7.");
        }
        if (homeClass != null && remoteClass != null) {
            if (ClassUtils.hasMethod(remoteClass, beanMethodName, selectMethod.getParameterTypes())) {
                results.add("Bean <" + ejbName + ">: <" + beanMethodName + "> method is declared in the remote interface of the bean //see 10.5.7.");
            }
            if (ClassUtils.hasMethod(homeClass, beanMethodName, selectMethod.getParameterTypes())) {
                results.add("Bean <" + ejbName + ">: <" + beanMethodName + "> method is declared in the home interface of the bean //see 10.5.7.");
            }
        }
        if (localHomeClass != null && localClass != null) {
            if (ClassUtils.hasMethod(localClass, beanMethodName, selectMethod.getParameterTypes())) {
                results.add("Bean <" + ejbName + ">: <" + beanMethodName + "> method is declared in the local interface of the bean //see 10.5.7.");
            }
            if (ClassUtils.hasMethod(localHomeClass, beanMethodName, selectMethod.getParameterTypes())) {
                results.add("Bean <" + ejbName + ">: <" + beanMethodName + "> method is declared in the local home interface of the bean. //see 10.5.7.");
            }
        }
    }

    private static void checkInterfaces(Class homeClass, CMPEntityDescriptor entDescr, Vector results, Class entityClass, String ejbName, Class localHomeClass, String localHomeName, Class remoteClass, Class localClass) {
        int i;
        boolean findByPK;
        if (homeClass != null) {
            RemoteHomeInterfaceCheck.check(entDescr, homeClass, results);
            Method[] allHomeMethods = homeClass.getMethods();
            findByPK = false;
            i = 0;
            while (i < allHomeMethods.length) {
                if (!allHomeMethods[i].getDeclaringClass().getName().equals("javax.ejb.EJBHome") && EntityCMP20Check.checkHomeInterfaceMethod(allHomeMethods[i], entDescr, entityClass, results, true)) {
                    findByPK = true;
                }
                ++i;
            }
            if (!findByPK) {
                results.add("Bean <" + ejbName + ">: Method findByPrimaryKey is not defined in the remote home interface. The remote home interface must always include the findByPrimaryKey method, which is always a single-object finder. The method must declare the primary key class as the method argument //see 10.6.10.");
            }
        }
        if (localHomeClass != null) {
            LocalHomeInterfaceCheck.check(entDescr, localHomeClass, results);
            Method[] allLocalHomeMethods = localHomeClass.getMethods();
            findByPK = false;
            i = 0;
            while (i < allLocalHomeMethods.length) {
                if (!allLocalHomeMethods[i].getDeclaringClass().getName().equals("javax.ejb.EJBLocalHome") && EntityCMP20Check.checkHomeInterfaceMethod(allLocalHomeMethods[i], entDescr, entityClass, results, false)) {
                    findByPK = true;
                }
                ++i;
            }
            if (!findByPK) {
                results.add("Bean <" + ejbName + ">: method findByPrimaryKey(<PrimaryKeyClass>) not found in local home interface <" + localHomeName + ">. The local home interface must always include the findByPrimaryKey method, which is always a single-object finder. The method must declare the primary key class as the method argument //see 10.6.12.");
            }
        }
        if (remoteClass != null) {
            RemoteInterfaceCheck.check(entDescr, remoteClass, entityClass, results);
        }
        if (localClass != null) {
            LocalInterfaceCheck.check(entDescr, localClass, entityClass, results);
        }
    }

    private static void checkPrimaryKey(CMPEntityDescriptor entDescr, Class pkClass, Vector results, String ejbName, Class remoteClass, Class localClass) {
        if (!pkClass.getName().startsWith("java.") && pkClass.getFields().length == 0) {
            results.add("Bean " + entDescr.getEjbName() + " has compound primery key. The primary key class " + pkClass.getName() + " should define its persistent fields as public. EJB Specification 10.8.2 .");
            return;
        }
        PersistentField[] pkCmp = entDescr.getPKCmpFields();
        if (!pkCmp[0].isCompoundPK()) {
            EntityPKCheck.check(entDescr, pkClass, results);
            if (!pkCmp[0].getFieldType().equals(entDescr.getPrimaryKeyClass())) {
                results.add("Bean <" + ejbName + ">: the pk-type is not equal to the cmp-field type.");
            }
        } else {
            MultiplePKCheck.check(entDescr, pkClass, results);
        }
        if (pkClass != null) {
            String setPKMethod = "set " + Character.toUpperCase(pkCmp[0].getFieldName().charAt(0)) + pkCmp[0].getFieldName().substring(1);
            Class[] setPKParams = new Class[]{pkClass};
            if (remoteClass != null && ClassUtils.hasMethod(remoteClass, setPKMethod, setPKParams)) {
                results.add("Bean <" + ejbName + ">: the set accessor methods for the primary key cmp-fields should not be exposed in the remote interface of the bean //see 10.3.1.");
            }
            if (localClass != null && ClassUtils.hasMethod(localClass, setPKMethod, setPKParams)) {
                results.add("Bean <" + ejbName + ">: the set accessor methods for the primary key cmp-fields should not be exposed in the local interface of the bean //see 10.3.1.");
            }
        }
    }

    private static boolean checkHomeInterfaceMethod(Method method, CMPEntityDescriptor entDescr, Class entityClass, Vector results, boolean remote) {
        Class<?>[] methodArgs = method.getParameterTypes();
        String methodName = method.getName();
        String ejbName = entDescr.getEjbName();
        boolean findByPK = false;
        if (methodName.startsWith("create")) {
            EntityCMP20Check.checkCreateMethod(method, entDescr, entityClass, results, remote);
        } else if (methodName.startsWith("find")) {
            findByPK = EntityCMP20Check.checkFinderMethod(method, entDescr, entityClass, results, remote);
        } else {
            String ejbHomeMethodName = "ejbHome" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
            Method ejbHomeMethod = null;
            try {
                ejbHomeMethod = entityClass.getMethod(ejbHomeMethodName, methodArgs);
            }
            catch (NoSuchMethodException nsme) {
                results.add("Bean " + ejbName + ": can not find " + ejbHomeMethodName + ", or parameters are incorrect in entity bean's class.");
            }
            catch (SecurityException secEx) {
                results.add("Bean " + ejbName + ": can not access ejbHome<Method>. Reason: " + secEx.toString());
            }
            if (ejbHomeMethod != null && !method.getReturnType().getName().equals(ejbHomeMethod.getReturnType().getName())) {
                results.add("Bean " + ejbName + ": The return type of " + methodName + " differs from the return type of " + ejbHomeMethodName + ".");
            }
        }
        return findByPK;
    }

    private static void checkCreateMethod(Method method, CMPEntityDescriptor entDescr, Class entityClass, Vector results, boolean remote) {
        Class<?>[] methodArgs = method.getParameterTypes();
        String methodName = method.getName();
        String ejbName = entDescr.getEjbName();
        String pkClassName = entDescr.getPrimaryKeyClass();
        Class[] createExceptions = EntityCMP20Check.checkCreateDeclarationInInterface(method, entDescr, results, remote, ejbName);
        String ejbCreateMethodName = "ejbC" + methodName.substring(1);
        String ejbPostCreateMethodName = "ejbPostC" + methodName.substring(1);
        Method ejbCreateMethod = null;
        Method ejbPostCreateMethod = null;
        try {
            ejbCreateMethod = entityClass.getMethod(ejbCreateMethodName, methodArgs);
        }
        catch (NoSuchMethodException nsme) {
            results.add("Bean " + ejbName + ": can not find " + ejbCreateMethodName + ", or wrong parameters are declared. Each create method should have a corresponding ejbCreate<METHOD> defined in the enterprise bean class //see 10.6.10.");
        }
        catch (SecurityException secEx) {
            results.add("Bean " + ejbName + ": can not access ejbCreate<Method>. Reason: " + secEx.toString());
        }
        if (ejbCreateMethod != null) {
            if (!ejbCreateMethod.getReturnType().getName().equals(pkClassName)) {
                results.add("Bean " + ejbName + ": Illegal return type for method " + ejbCreateMethodName + ". The return type must be the entity bean's primary key type // 10.6.4.");
            }
            Class<?>[] ejbCreateExceptions = ejbCreateMethod.getExceptionTypes();
            boolean throwCreateExc = false;
            int m = 0;
            while (m < ejbCreateExceptions.length) {
                if (ejbCreateExceptions[m].getName().equals("javax.ejb.CreateException") || ejbCreateExceptions[m].getName().equals("CreateException")) {
                    throwCreateExc = true;
                    break;
                }
                ++m;
            }
            if (!throwCreateExc) {
                results.add("Bean " + ejbName + ": " + ejbCreateMethod.getName() + " method must throw javax.ejb.CreateException. EJB Specification 10.6.4.");
            }
            if (createExceptions.length < ejbCreateExceptions.length) {
                results.add("Bean " + ejbName + ": the set of exceptions defined for create<METHOD> must be a superset of the exceptions defined for ejbCreate<METHOD> // 10.6.10.");
            } else {
                int m2 = 0;
                while (m2 < ejbCreateExceptions.length) {
                    boolean foundExc = false;
                    String exName = ejbCreateExceptions[m2].getName();
                    int n = 0;
                    while (n < createExceptions.length) {
                        if (exName.equals(createExceptions[n].getName())) {
                            foundExc = true;
                            break;
                        }
                        ++n;
                    }
                    if (!foundExc) {
                        results.add("Bean " + ejbName + ": exception " + exName + " is defined in throws clause of " + ejbCreateMethodName + " but is not declared in throws clause of coresponding create<Method> //see 10.6.10..");
                    }
                    ++m2;
                }
            }
        }
        try {
            ejbPostCreateMethod = entityClass.getMethod(ejbPostCreateMethodName, methodArgs);
        }
        catch (NoSuchMethodException nsme) {
            results.add("Bean " + ejbName + ": can not find ejbPostCreate<Method>: " + ejbPostCreateMethodName + ", or parameters are not correct. For each ejbCreate<METHOD> method, the entity bean class must define a matching ejbPostCreate<METHOD> method //see 10.6.5.");
        }
        catch (SecurityException secEx) {
            results.add("Bean " + ejbName + ": can not access ejbPostCreate<Method>. Reason " + secEx.toString());
        }
        if (ejbPostCreateMethod != null) {
            Class<?>[] ejbPostCreateExceptions;
            if (!ejbPostCreateMethod.getReturnType().getName().equals("void")) {
                results.add("Bean " + ejbName + ": Illegal return type for method " + ejbPostCreateMethodName + ". The return type must be void //see 10.6.5.");
            }
            if (createExceptions.length < (ejbPostCreateExceptions = ejbPostCreateMethod.getExceptionTypes()).length) {
                results.add("Bean " + ejbName + ": the set of exceptions defined for create<METHOD> must be a superset of the exceptions defined for ejbPostCreate<METHOD> // 10.6.10.");
            } else {
                int m = 0;
                while (m < ejbPostCreateExceptions.length) {
                    boolean foundExc = false;
                    String exName = ejbPostCreateExceptions[m].getName();
                    int n = 0;
                    while (n < createExceptions.length) {
                        if (exName.equals(createExceptions[n].getName())) {
                            foundExc = true;
                            break;
                        }
                        ++n;
                    }
                    if (!foundExc) {
                        results.add("Bean " + ejbName + ": exception " + exName + " is defined in throws clause of " + ejbPostCreateMethod + " but is not declared in throws clause of coresponding create<Method> //see 10.6.10..");
                    }
                    ++m;
                }
            }
        }
    }

    private static Class[] checkCreateDeclarationInInterface(Method method, CMPEntityDescriptor entDescr, Vector results, boolean remote, String ejbName) {
        if (remote) {
            if (!method.getReturnType().getName().equals(entDescr.getRemoteInterface())) {
                results.add("Bean " + ejbName + ": the return type of " + method.getName() + " method must be the entity bean's remote interface type //see 10.6.10.");
            }
        } else if (!method.getReturnType().getName().equals(entDescr.getLocalInterface())) {
            results.add("Bean " + ejbName + ": the return type of " + method.getName() + " method must be the entity bean's local interface type //see 10.6.10.");
        }
        Class[] createExceptions = method.getExceptionTypes();
        boolean declaredCreateException = false;
        int m = 0;
        while (m < createExceptions.length) {
            if (createExceptions[m].getName().equals("javax.ejb.CreateException")) {
                declaredCreateException = true;
                break;
            }
            ++m;
        }
        if (!declaredCreateException) {
            results.add("Bean " + ejbName + ": " + method.getName() + " method must throw javax.ejb.CreateException.");
        }
        return createExceptions;
    }

    private static boolean checkFinderMethod(Method method, CMPEntityDescriptor entDescr, Class entityClass, Vector results, boolean remote) {
        String ejbFindMethodName;
        boolean findByPK = false;
        Class[] methodArgs = method.getParameterTypes();
        String methodName = method.getName();
        String ejbName = entDescr.getEjbName();
        String pkClassName = entDescr.getPrimaryKeyClass();
        if (methodName.equals("findByPrimaryKey") && methodArgs.length == 1 && methodArgs[0].getName().equals(pkClassName)) {
            findByPK = true;
            if (remote) {
                if (!method.getReturnType().getName().equals(entDescr.getRemoteInterface())) {
                    results.add("Bean " + ejbName + ": findByPrimaryKey method has invalid return type, the entity beans's remote interface must be returned.");
                }
            } else if (!method.getReturnType().getName().equals(entDescr.getLocalInterface())) {
                results.add("Bean " + ejbName + ": findByPrimaryKey method has invalid return type, the entity beans's local interface must be returned.");
            }
        } else {
            String returnType = method.getReturnType().getName();
            if (!(returnType.equals(entDescr.getRemoteInterface()) || returnType.equals(entDescr.getLocalInterface()) || returnType.equals("java.util.Collection") || returnType.equals("java.util.Enumeration"))) {
                results.add("Bean " + ejbName + ": the return type of " + method.getName() + " is " + returnType + ", but it must be the entity bean's remote interface, local interface, java.util.Collection, or java.util.Enumeration.");
            }
            if (!EntityCMP20Check.isDeclaredEJBQLForFinderSelectMethod(method, entDescr)) {
                results.add("Bean " + ejbName + ": " + methodName + " method does not have EJB QL specified in the ejb-jar.xml. EJB Specification 10.6.14.");
            }
        }
        if (ClassUtils.hasMethod(entityClass, ejbFindMethodName = "ejbF" + methodName.substring(1), methodArgs)) {
            results.add("Warning Bean " + ejbName + ": " + ejbFindMethodName + " method is defined in ejb-class.");
        }
        if (!EntityCMP20Check.checkFinderDeclarationForFinderException(method)) {
            results.add("Bean " + ejbName + ": " + methodName + " method does not throw javax.ejb.FinderException. The throws clause of a finder method must include javax.ejb.FinderException. EJB Specification 10.6.10.");
        }
        return findByPK;
    }

    private static boolean isDeclaredEJBQLForFinderSelectMethod(Method method, CMPEntityDescriptor entDescr) {
        FinderDescriptor[] finders = entDescr.getFinderDescriptors();
        int i = 0;
        while (i < finders.length) {
            if (finders[i].isCompatible(method)) {
                return finders[i].getQuery() != null;
            }
            ++i;
        }
        return false;
    }

    private static boolean checkFinderDeclarationForFinderException(Method method) {
        Class<?>[] findExceptions = method.getExceptionTypes();
        int m = 0;
        while (m < findExceptions.length) {
            if (findExceptions[m].getName().equals("javax.ejb.FinderException")) {
                return true;
            }
            ++m;
        }
        return false;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

