/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier.entity;

import com.sap.engine.services.ejb.deploy.descriptors.CMPEntityDescriptor;
import com.sap.engine.services.ejb.deploy.descriptors.PersistentField;
import com.sap.engine.services.ejb.deploy.descriptors.RelationField;
import com.sap.engine.services.ejb.deploy.verifier.BeanClassCheck;
import com.sap.engine.services.ejb.deploy.verifier.CheckUtils;
import com.sap.engine.services.ejb.deploy.verifier.RemoteHomeInterfaceCheck;
import com.sap.engine.services.ejb.deploy.verifier.RemoteInterfaceCheck;
import com.sap.engine.services.ejb.deploy.verifier.RmiIiopUtils;
import com.sap.engine.services.ejb.deploy.verifier.entity.EntityPKCheck;
import com.sap.engine.services.ejb.util.ClassUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Vector;

public class EntityCMP11Check {
    static /* synthetic */ Class class$javax$ejb$EntityBean;

    public static void check(CMPEntityDescriptor entDescr, Vector results, ClassLoader loader) {
        PersistentField[] pkCmp;
        String ejbName = entDescr.getEjbName();
        String entityClassName = entDescr.getClassName();
        Class<?> entityClass = null;
        String pkClassName = entDescr.getPrimaryKeyClass();
        try {
            entityClass = loader.loadClass(entityClassName);
        }
        catch (ClassNotFoundException cnfe) {
            results.add("Bean " + ejbName + ": Cannot load ejb-class " + entityClassName + ".");
            return;
        }
        if (!entDescr.isUnknownPK()) {
            Class pkClass = CheckUtils.loadClass(loader, ClassUtils.fixClassName(pkClassName), results, ejbName);
            EntityPKCheck.check(entDescr, pkClass, results);
        }
        if (!(pkCmp = entDescr.getPKCmpFields())[0].isCompoundPK() && !pkCmp[0].getFieldType().equals(pkClassName)) {
            results.add("Bean " + ejbName + ": The pk-type is not equal to the cmp-field type. EJB 2.0 Specification, chapter 10.8.1.");
        }
        Method[] allBeanMethods = entityClass.getDeclaredMethods();
        int c = 0;
        while (c < allBeanMethods.length) {
            if (allBeanMethods[c].getName().startsWith("ejbFind")) {
                results.add("Bean " + ejbName + ": Method " + allBeanMethods[c].getName() + " declared in the bean class. CMP entity beans should not declare ejbFind<METHOD>(...) methods.");
            }
            ++c;
        }
        if (!(class$javax$ejb$EntityBean == null ? (class$javax$ejb$EntityBean = EntityCMP11Check.class$("javax.ejb.EntityBean")) : class$javax$ejb$EntityBean).isAssignableFrom(entityClass)) {
            results.add("Bean " + ejbName + ": The ejb-class must implement, directly or indirectly, the javax.ejb.EntityBean interface. EJB 2.0 Specification, chapter 10.6.2.");
        }
        BeanClassCheck.check(entityClass, false, results);
        if (entDescr.getLocalInterface() != null) {
            results.add("Bean " + ejbName + ": CMP 1.1 entity beans must not have local interfaces.");
        }
        if (entDescr.getLocalHomeInterface() != null) {
            results.add("Bean " + ejbName + ": CMP 1.1 entity beans must not have local home interfaces.");
        }
        if (entDescr.getRemoteInterface() != null && entDescr.getRemoteHomeInterface() == null) {
            results.add("Bean " + ejbName + ": Remote interface found, but remote home interface not found.");
        }
        if (entDescr.getRemoteInterface() == null && entDescr.getRemoteHomeInterface() != null) {
            results.add("Bean " + ejbName + ": Remote home interface found, but remote interface not found.");
        }
        if (entDescr.getRemoteInterface() == null && entDescr.getRemoteHomeInterface() == null) {
            results.add("Bean " + ejbName + ": Cannot find home and remote home interfaces. They are mandatory for CMP 1.1 entity beans.");
        }
        String ejbHomeName = entDescr.getRemoteHomeInterface();
        Class<?> ejbHomeClass = null;
        try {
            ejbHomeClass = loader.loadClass(ejbHomeName);
        }
        catch (ClassNotFoundException cnfe) {
            results.add("Bean " + ejbName + ": Cannot load remote home interface " + ejbHomeName + ". Reason: " + cnfe.toString());
            return;
        }
        RemoteHomeInterfaceCheck.check(entDescr, ejbHomeClass, results);
        Method[] allEjbHomeMethods = ejbHomeClass.getMethods();
        boolean definedFindByPK = false;
        int i = 0;
        while (i < allEjbHomeMethods.length) {
            if (!allEjbHomeMethods[i].getDeclaringClass().getName().equals("javax.ejb.EJBHome")) {
                int m;
                Method homeIntfMethod = allEjbHomeMethods[i];
                String methodName = homeIntfMethod.getName();
                Class[] methodArgs = homeIntfMethod.getParameterTypes();
                if (methodName.equals("findByPrimaryKey") && methodArgs.length == 1 && methodArgs[0].getName().equals(pkClassName)) {
                    definedFindByPK = true;
                    if (!homeIntfMethod.getReturnType().getName().equals(entDescr.getRemoteInterface())) {
                        results.add("Bean " + ejbName + ": findByPrimaryKey(...) method found, but with invalid return type. findByPrimaryKey(...) method must return the entity beans's remote interface. EJB 2.0 Specification, chapter 12.2.9.");
                    }
                    if (ClassUtils.hasMethod(entityClass, "ejbFindByPrimaryKey", methodArgs)) {
                        results.add("Warning! Bean " + ejbName + ": Method ejbFindByPrimaryKey(...) is defined in ejb-class.");
                    }
                    Class<?>[] findByPKExceptions = homeIntfMethod.getExceptionTypes();
                    boolean foundFinderException = false;
                    m = 0;
                    while (m < findByPKExceptions.length) {
                        if (findByPKExceptions[m].getName().equals("javax.ejb.FinderException")) {
                            foundFinderException = true;
                            break;
                        }
                        ++m;
                    }
                    if (!foundFinderException) {
                        results.add("Bean " + ejbName + ": Method findByPrimaryKey(...) does not throw javax.ejb.FinderException. The throws clause of a finder method must include the javax.ejb.FinderException. EJB 2.0 Specification, chapter 12.2.9.");
                    }
                }
                if (methodName.startsWith("create")) {
                    if (!homeIntfMethod.getReturnType().getName().equals(entDescr.getRemoteInterface())) {
                        results.add("Bean " + ejbName + ": The return type of a create<METHOD> " + methodName + " must be the entity bean's remote interface type. EJB 2.0 Specification, chapter 12.2.9.");
                    }
                    Class<?>[] createExceptions = homeIntfMethod.getExceptionTypes();
                    boolean foundCreateException = false;
                    m = 0;
                    while (m < createExceptions.length) {
                        if (createExceptions[m].getName().equals("javax.ejb.CreateException")) {
                            foundCreateException = true;
                            break;
                        }
                        ++m;
                    }
                    if (!foundCreateException) {
                        results.add("Bean " + ejbName + ": Method " + methodName + " does not throw javax.ejb.CreateException. The throws clause of a create<METHOD> method must include the javax.ejb.CreateException. EJB 2.0 Specification, chapter 12.2.9.");
                    }
                    String ejbCreateMethodName = "ejbC" + methodName.substring(1);
                    String ejbPostCreateMethodName = "ejbPostC" + methodName.substring(1);
                    Method ejbCreateMethod = null;
                    Method ejbPostCreateMethod = null;
                    try {
                        ejbCreateMethod = entityClass.getMethod(ejbCreateMethodName, methodArgs);
                    }
                    catch (NoSuchMethodException nsme) {
                        results.add("Bean " + ejbName + ": Cannot find method " + ejbCreateMethodName + " or parameters are not correct. Each create method name must match one of the ejbCreate<METHOD> methods defined in the enterprise bean class. EJB 2.0 Specification, chapter 12.2.9.");
                    }
                    catch (SecurityException secEx) {
                        results.add("Bean " + ejbName + ": Cannot access method " + ejbCreateMethodName + ". Reason: " + secEx.toString());
                    }
                    if (ejbCreateMethod != null) {
                        if (!ejbCreateMethod.getReturnType().getName().equals(pkClassName)) {
                            results.add("Bean " + ejbName + ": Illegal return type for method " + ejbCreateMethodName + ". The return type must be the entity bean's primary key type. EJB 2.0 Specification, chapter 12.2.3.");
                        }
                        Class<?>[] ejbCreateExceptions = ejbCreateMethod.getExceptionTypes();
                        foundCreateException = false;
                        int m2 = 0;
                        while (m2 < ejbCreateExceptions.length) {
                            if (ejbCreateExceptions[m2].getName().equals("javax.ejb.CreateException")) {
                                foundCreateException = true;
                                break;
                            }
                            ++m2;
                        }
                        if (!foundCreateException) {
                            results.add("Bean " + ejbName + ": The throws clause of " + ejbCreateMethodName + " method must include the javax.ejb.CreateException. EJB 2.0 Specification, chapter 10.6.4.");
                        }
                        try {
                            ejbPostCreateMethod = entityClass.getMethod(ejbPostCreateMethodName, methodArgs);
                        }
                        catch (NoSuchMethodException nsme) {
                            results.add("Bean " + ejbName + ": Cannot find method " + ejbPostCreateMethodName + " or parameters are not correct. For each ejbCreate<METHOD>(...) method, the entity bean class must define a matching ejbPostCreate<METHOD>(...) method. EJB 2.0 Specification, chapter 12.2.4.");
                        }
                        catch (SecurityException secEx) {
                            results.add("Bean " + ejbName + ": Cannot access method " + ejbPostCreateMethodName + ". Reason: " + secEx.toString());
                        }
                        if (ejbPostCreateMethod != null) {
                            if (!ejbPostCreateMethod.getReturnType().getName().equals("void")) {
                                results.add("Bean " + ejbName + ": Illegal return type for method " + ejbPostCreateMethodName + ". The return type must be void. EJB 2.0 Specification, chapter 12.2.4.");
                            }
                            Class<?>[] ejbPostCreateExceptions = ejbPostCreateMethod.getExceptionTypes();
                            int m3 = 0;
                            while (m3 < ejbCreateExceptions.length) {
                                boolean foundInIntf = false;
                                int n = 0;
                                while (n < createExceptions.length) {
                                    if (ejbCreateExceptions[m3].getName().equals(createExceptions[n].getName())) {
                                        foundInIntf = true;
                                        break;
                                    }
                                    ++n;
                                }
                                if (!foundInIntf) {
                                    results.add("Bean " + ejbName + ": Exception " + ejbCreateExceptions[m3].getName() + " defined in the throws clause of method " + ejbCreateMethodName + " in the enterprise bean class, but not defined in the throws clause of coresponding create<METHOD> method in the remote home interface. EJB 2.0 Specification, chapter 12.2.9.");
                                }
                                ++m3;
                            }
                            int m4 = 0;
                            while (m4 < ejbPostCreateExceptions.length) {
                                boolean foundInIntf = false;
                                int n = 0;
                                while (n < createExceptions.length) {
                                    if (ejbPostCreateExceptions[m4].getName().equals(createExceptions[n].getName())) {
                                        foundInIntf = true;
                                        break;
                                    }
                                    ++n;
                                }
                                if (!foundInIntf) {
                                    results.add("Bean " + ejbName + ": Exception " + ejbPostCreateExceptions[m4].getName() + " defined in the throws clause of method " + ejbPostCreateMethodName + " in the enterprise bean class, but not defined in the throws clause of coresponding create<METHOD> method in the remote home interface. EJB 2.0 Specification, chapter 12.2.9.");
                                }
                                ++m4;
                            }
                        }
                    }
                } else if (methodName.startsWith("find")) {
                    Class<?>[] finderExceptions = homeIntfMethod.getExceptionTypes();
                    boolean throwsFinderException = false;
                    int f = 0;
                    while (f < finderExceptions.length) {
                        if (finderExceptions[f].getName().equals("javax.ejb.FinderException")) {
                            throwsFinderException = true;
                            break;
                        }
                        ++f;
                    }
                    if (!throwsFinderException) {
                        results.add("Bean " + ejbName + ": Method " + methodName + " does not throw javax.ejb.FinderException. The throws clause of a finder method must include the javax.ejb.FinderException. EJB 2.0 Specification, chapter 12.2.9.");
                    }
                }
            }
            ++i;
        }
        if (!definedFindByPK) {
            results.add("Bean " + ejbName + ": Method findByPrimaryKey(...) not found in remote home interface " + ejbHomeName + ". The remote home interface must always include the findByPrimaryKey method, which is always a single-object finder. The method must declare the primary key class as the method argument. EJB 2.0 Specification, chapter 12.2.9.");
        }
        String remoteName = entDescr.getRemoteInterface();
        Class<?> remoteClass = null;
        try {
            remoteClass = loader.loadClass(remoteName);
        }
        catch (ClassNotFoundException cnfe) {
            results.add("Bean " + ejbName + ": Cannot load remote interface " + remoteName + ". Reason: " + cnfe.toString());
            return;
        }
        RemoteInterfaceCheck.check(entDescr, remoteClass, entityClass, results);
        Field[] fields = entityClass.getFields();
        PersistentField[] cmpFields = entDescr.getCmpFields();
        RelationField[] cmrFields = entDescr.getCmrFields();
        if (cmrFields != null && cmrFields.length > 0) {
            results.add("Bean " + ejbName + ": EJB 2.0 does not support the use of the cmr-field, ejb-relation, or query deployment descriptor elements or their subelements for EJB 1.1 entity beans. EJB 2.0 Specification, chapter 14.1.1.");
        }
        int i2 = 0;
        while (i2 < cmpFields.length) {
            String fieldName = cmpFields[i2].getFieldName();
            Field field = null;
            int j = 0;
            while (j < fields.length) {
                if (fieldName.equals(fields[j].getName())) {
                    field = fields[j];
                    break;
                }
                ++j;
            }
            if (field != null) {
                if (!RmiIiopUtils.isPersistentFieldTypeValid(field.getType())) {
                    results.add("Bean " + ejbName + ": cmp-field " + fieldName + " does not have a valid persistent field type. EJB 2.0 Specification, chapter 14.1.1.");
                }
                if (Modifier.isTransient(field.getModifiers())) {
                    results.add("Bean " + ejbName + ": cmp-field " + fieldName + " is transient, but cmp-fields must not be transient. EJB 2.0 Specification, chapter 14.1.1.");
                }
                if (!Modifier.isPublic(field.getModifiers())) {
                    results.add("Bean " + ejbName + ": cmp-field " + fieldName + " is not public, but cpm-fields must be public. EJB 2.0 Specification, chapter 14.1.1.");
                }
            } else {
                results.add("Bean " + ejbName + ": cmp-field " + fieldName + " defined in ejb-jar.xml, but not found in entity bean class.");
            }
            ++i2;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

