/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.services.ejb.deploy.verifier.entity;

import com.sap.engine.services.ejb.deploy.descriptors.EntityDescriptor;
import com.sap.engine.services.ejb.deploy.verifier.BeanClassCheck;
import com.sap.engine.services.ejb.deploy.verifier.BusinessMethodCheck;
import com.sap.engine.services.ejb.deploy.verifier.CheckUtils;
import com.sap.engine.services.ejb.deploy.verifier.LocalHomeInterfaceCheck;
import com.sap.engine.services.ejb.deploy.verifier.LocalInterfaceCheck;
import com.sap.engine.services.ejb.deploy.verifier.RemoteHomeInterfaceCheck;
import com.sap.engine.services.ejb.deploy.verifier.RemoteInterfaceCheck;
import com.sap.engine.services.ejb.deploy.verifier.entity.EntityPKCheck;
import java.lang.reflect.Method;
import java.util.Vector;

public class EntityBMPCheck {
    static /* synthetic */ Class class$javax$ejb$EntityBean;

    public static void check(EntityDescriptor entDescr, Vector results, ClassLoader loader) {
        String localName;
        String remoteName;
        String ejbLocalHomeName;
        String ejbName = entDescr.getEjbName();
        String entityClassName = entDescr.getClassName();
        String pkClassName = entDescr.getPrimaryKeyClass();
        Class entityClass = CheckUtils.loadClass(loader, entityClassName, results, ejbName);
        if (entityClass == null) {
            return;
        }
        Class pkClass = CheckUtils.loadClass(loader, pkClassName, results, ejbName);
        EntityPKCheck.check(entDescr, pkClass, results);
        if (!(class$javax$ejb$EntityBean == null ? (class$javax$ejb$EntityBean = EntityBMPCheck.class$("javax.ejb.EntityBean")) : class$javax$ejb$EntityBean).isAssignableFrom(entityClass)) {
            results.add("Bean " + ejbName + ". The ejb-class must implement, directly or indirectly, the javax.ejb.EntityBean interface. EJB Specification 10.6.2.");
        }
        BeanClassCheck.check(entityClass, false, results);
        CheckUtils.checkInterfacesExistence(entDescr, results, ejbName);
        String ejbHomeName = entDescr.getRemoteHomeInterface();
        if (ejbHomeName != null) {
            Class ejbHomeClass = CheckUtils.loadClass(loader, ejbHomeName, results, ejbName);
            EntityBMPCheck.checkEJBHome(entDescr, ejbHomeClass, results, ejbName, entityClass, pkClassName, entityClassName, ejbHomeName);
        }
        if ((ejbLocalHomeName = entDescr.getLocalHomeInterface()) != null) {
            Class ejbLocalHomeClass = CheckUtils.loadClass(loader, ejbLocalHomeName, results, ejbName);
            EntityBMPCheck.checkEJBLocalHome(entDescr, ejbLocalHomeClass, results, ejbName, entityClass, pkClassName, entityClassName, ejbLocalHomeName);
        }
        if ((remoteName = entDescr.getRemoteInterface()) != null) {
            Class remoteClass = CheckUtils.loadClass(loader, remoteName, results, ejbName);
            RemoteInterfaceCheck.check(entDescr, remoteClass, entityClass, results);
        }
        if ((localName = entDescr.getLocalInterface()) != null) {
            Class localClass = CheckUtils.loadClass(loader, localName, results, ejbName);
            LocalInterfaceCheck.check(entDescr, localClass, entityClass, results);
        }
    }

    private static void checkEJBLocalHome(EntityDescriptor entDescr, Class ejbLocalHomeClass, Vector results, String ejbName, Class entityClass, String pkClassName, String entityClassName, String ejbLocalHomeName) {
        LocalHomeInterfaceCheck.check(entDescr, ejbLocalHomeClass, results);
        Method[] allEjbLocalHomeMethods = ejbLocalHomeClass.getMethods();
        boolean findByPK = false;
        int i = 0;
        while (i < allEjbLocalHomeMethods.length) {
            if (!allEjbLocalHomeMethods[i].getDeclaringClass().getName().equals("javax.ejb.EJBLocalHome")) {
                Method localHomeIntfMethod = allEjbLocalHomeMethods[i];
                String methodName = localHomeIntfMethod.getName();
                Class<?>[] methodArgs = localHomeIntfMethod.getParameterTypes();
                if (methodName.startsWith("create")) {
                    if (!localHomeIntfMethod.getReturnType().getName().equals(entDescr.getLocalInterface())) {
                        results.add("Bean " + ejbName + ". The return type of a create<METHOD> " + localHomeIntfMethod.getName() + " must be the entity bean's local interface type. EJB Specification 10.6.12.");
                    }
                    Class[] createExceptions = localHomeIntfMethod.getExceptionTypes();
                    boolean fnd = false;
                    int m = 0;
                    while (m < createExceptions.length) {
                        if (createExceptions[m].getName().equals("javax.ejb.CreateException")) {
                            fnd = true;
                            break;
                        }
                        ++m;
                    }
                    if (!fnd) {
                        results.add("Bean " + ejbName + ". The throws clause of a create<METHOD> " + localHomeIntfMethod.getName() + " method must include javax.ejb.CreateException. EJB Specification 10.6.12.");
                    }
                    String ejbCreateMethodName = "ejbC" + methodName.substring(1);
                    String ejbPostCreateMethodName = "ejbPostC" + methodName.substring(1);
                    Method ejbCreateMethod = null;
                    Method ejbPostCreateMethod = null;
                    try {
                        ejbCreateMethod = entityClass.getMethod(ejbCreateMethodName, methodArgs);
                    }
                    catch (NoSuchMethodException nsme) {
                        results.add("Bean " + ejbName + ". Can not find ejbCreate<Method> " + ejbCreateMethodName + ", or parameters are not correct. Each create method name must match one of the ejbCreate<METHOD> methods defined in the enterprise bean class. EJB Specification 10.6.12.");
                    }
                    catch (SecurityException secEx) {
                        results.add("Bean " + ejbName + ". Can not access ejbCreate<Method>(s) from local interface. Reason: " + secEx.toString());
                    }
                    if (ejbCreateMethod != null) {
                        if (!ejbCreateMethod.getReturnType().getName().equals(pkClassName)) {
                            results.add("Bean " + ejbName + ". Illegal return type for method " + ejbCreateMethodName + ". The return type must be the entity bean's primary key type. EJB Specification 10.6.4.");
                        }
                        Class[] ejbCreateExceptions = ejbCreateMethod.getExceptionTypes();
                        fnd = false;
                        int m2 = 0;
                        while (m2 < ejbCreateExceptions.length) {
                            if (ejbCreateExceptions[m2].getName().equals("javax.ejb.CreateException")) {
                                fnd = true;
                                break;
                            }
                            ++m2;
                        }
                        if (!fnd) {
                            results.add("Bean " + ejbName + ". The throws clause of a ejbCreate<METHOD> " + ejbCreateMethodName + " method must include javax.ejb.CreateException. EJB Specification 10.6.4.");
                        }
                        try {
                            ejbPostCreateMethod = entityClass.getMethod(ejbPostCreateMethodName, methodArgs);
                        }
                        catch (NoSuchMethodException nsme) {
                            results.add("Bean " + ejbName + ". Can not find ejbPostCreate<Method> " + ejbPostCreateMethodName + ", or parameters are not correct. For each ejbCreate<METHOD>(...) method, the entity bean class must define a matching ejbPostCreate<METHOD>(...) method. EJB Specification 10.6.5.");
                        }
                        catch (SecurityException secEx) {
                            results.add("Bean " + ejbName + ". Can not access ejbPostCreate<Method>(s). Reason: " + secEx.toString());
                        }
                        if (ejbPostCreateMethod != null) {
                            if (!ejbPostCreateMethod.getReturnType().getName().equals("void")) {
                                results.add("Bean " + ejbName + ". Illegal return type for method " + ejbPostCreateMethodName + ". The return type must be void. EJB Specification 10.6.5.");
                            }
                            Class[] ejbPostCreateExceptions = ejbPostCreateMethod.getExceptionTypes();
                            if (!CheckUtils.areBeanMethodExceptionsSubsetOfInterfaceMethodExceptions(ejbCreateExceptions, createExceptions)) {
                                results.add("Bean " + ejbName + ". Some of the exceptions defined in the throws clause of the method " + ejbCreateMethodName + " are not included in the throws clause of the corresponding create<METHOD>.");
                            }
                            if (!CheckUtils.areBeanMethodExceptionsSubsetOfInterfaceMethodExceptions(ejbPostCreateExceptions, createExceptions)) {
                                results.add("Bean " + ejbName + ". Some of the exceptions defined in the throws clause of the method " + ejbPostCreateMethodName + " are not included in the throws clause of the corresponding create<METHOD>.");
                            }
                        }
                    }
                } else if (methodName.startsWith("find")) {
                    if (methodName.equals("findByPrimaryKey") && methodArgs.length == 1 && methodArgs[0].getName().equals(pkClassName)) {
                        findByPK = true;
                        if (!localHomeIntfMethod.getReturnType().getName().equals(entDescr.getLocalInterface())) {
                            results.add("Bean " + ejbName + ". findByPrimaryKey method was found in local home interface, but with invalid return type. findByPrimaryKey must return the entity beans's local interface.");
                        }
                        Method ejbFindByPKMethod = null;
                        try {
                            ejbFindByPKMethod = entityClass.getMethod("ejbFindByPrimaryKey", methodArgs);
                        }
                        catch (NoSuchMethodException nsme) {
                            results.add("Bean " + ejbName + ". Can not find ejbFindByPrimaryKey(<PrimaryKeyClass>) in entity bean's class " + entityClassName + ".");
                        }
                        catch (SecurityException secEx) {
                            results.add("Bean " + ejbName + ". Can not access ejbFindByPrimaryKey(<PrimaryKeyClass>). Reason: " + secEx.toString());
                        }
                        if (ejbFindByPKMethod != null) {
                            if (!ejbFindByPKMethod.getReturnType().getName().equals(pkClassName)) {
                                results.add("Bean " + ejbName + ". The return type of ejbFindByPrimaryKey method must be the enterprise bean's primary key type, but found " + ejbFindByPKMethod.getReturnType().getName() + ".");
                            }
                            Class[] findByPKExceptions = localHomeIntfMethod.getExceptionTypes();
                            Class[] ejbFindByPKExceptions = ejbFindByPKMethod.getExceptionTypes();
                            if (!CheckUtils.areBeanMethodExceptionsSubsetOfInterfaceMethodExceptions(ejbFindByPKExceptions, findByPKExceptions)) {
                                results.add("Bean " + ejbName + ". Some of the exceptions defined in the throws clause of the method ejbFindByPrimaryKey(<PrimaryKeyClass>) are not included in the throws clause of the method findByPrimaryKey(<PrimaryKeyClass>).");
                            }
                            boolean fnd = false;
                            int m = 0;
                            while (m < findByPKExceptions.length) {
                                if (findByPKExceptions[m].getName().equals("javax.ejb.FinderException")) {
                                    fnd = true;
                                }
                                ++m;
                            }
                            if (!fnd) {
                                results.add("Bean " + ejbName + ". findByPrimaryKey(<PrimaryKeyClass>) does not throws javax.ejb.FinderException. The throws clause of a finder method must include javax.ejb.FinderException. EJB Specification 10.6.12.");
                            }
                        }
                    } else {
                        String returnType = localHomeIntfMethod.getReturnType().getName();
                        if (!(returnType.equals(entDescr.getLocalInterface()) || returnType.equals("java.util.Collection") || returnType.equals("java.util.Enumeration"))) {
                            results.add("Bean " + ejbName + ". The return type of a finder method in the local home interface must be the entity bean's local interface, java.util.Collection, or java.util.Enumeration, but found " + returnType + ".");
                        }
                        String ejbFindMethodName = "ejbF" + methodName.substring(1);
                        Method ejbFindMethod = null;
                        try {
                            ejbFindMethod = entityClass.getMethod(ejbFindMethodName, methodArgs);
                        }
                        catch (NoSuchMethodException nsme) {
                            results.add("Bean " + ejbName + ". Can not find " + ejbFindMethodName + ", or parameters are incorrect in entity bean's class " + entityClassName + ".");
                        }
                        catch (SecurityException secEx) {
                            results.add("Bean " + ejbName + ". Can not access ejbFind<Method>(s). Reason: " + secEx.toString());
                        }
                        if (ejbFindMethod != null) {
                            String ejbReturnType = ejbFindMethod.getReturnType().getName();
                            if (!(ejbReturnType.equals(pkClassName) || ejbReturnType.equals("java.util.Collection") || ejbReturnType.equals("java.util.Enumeration"))) {
                                results.add("Bean " + ejbName + ". The return type of ejbFinder methods must be the entity bean's primary key class, java.util.Collection, or java.util.Enumeration, but found " + returnType + ".");
                            }
                            Class[] findExceptions = localHomeIntfMethod.getExceptionTypes();
                            Class[] ejbFindExceptions = ejbFindMethod.getExceptionTypes();
                            if (!CheckUtils.areBeanMethodExceptionsSubsetOfInterfaceMethodExceptions(ejbFindExceptions, findExceptions)) {
                                results.add("Bean " + ejbName + ". Some of the exceptions defined in the throws clause of the method " + ejbFindMethodName + " are not included in the throws clause of the method " + methodName + ".");
                            }
                            boolean fnd = false;
                            int m = 0;
                            while (m < findExceptions.length) {
                                if (findExceptions[m].getName().equals("javax.ejb.FinderException")) {
                                    fnd = true;
                                }
                                ++m;
                            }
                            if (!fnd) {
                                results.add("Bean " + ejbName + ". Method " + methodName + " does not throws javax.ejb.FinderException. The throws clause of a finder method must include javax.ejb.FinderException. EJB Specification 10.6.12.");
                            }
                            if (ejbReturnType.equals("java.util.Collection") || ejbReturnType.equals("java.util.Enumeration")) {
                                fnd = false;
                                int m3 = 0;
                                while (m3 < ejbFindExceptions.length) {
                                    if (ejbFindExceptions[m3].getName().equals("javax.ejb.ObjectNotFoundException")) {
                                        fnd = true;
                                        break;
                                    }
                                    ++m3;
                                }
                                if (fnd) {
                                    results.add("Bean " + ejbName + ". Method " + ejbFindMethodName + " throws ObjectNotFoundException. Multi-object finder methods must not throw this exception.");
                                }
                            }
                        }
                    }
                } else {
                    String ejbLocalHomeMethodName = "ejbHome" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
                    Method ejbLocalHomeMethod = null;
                    try {
                        ejbLocalHomeMethod = entityClass.getMethod(ejbLocalHomeMethodName, methodArgs);
                    }
                    catch (NoSuchMethodException nsme) {
                        results.add("Bean " + ejbName + ". Can not find " + ejbLocalHomeMethodName + ", or parameters are incorrect in entity bean's class " + entityClassName + ".");
                    }
                    catch (SecurityException secEx) {
                        results.add("Bean " + ejbName + ". Can not access ejbHome<Method>(s). Reason: " + secEx.toString());
                    }
                    if (ejbLocalHomeMethod != null) {
                        if (!localHomeIntfMethod.getReturnType().getName().equals(ejbLocalHomeMethod.getReturnType().getName())) {
                            results.add("Bean " + ejbName + ". Return types of " + methodName + " and " + ejbLocalHomeMethodName + " are different, but they must be equal.");
                        }
                        Class[] localHomeExceptions = localHomeIntfMethod.getExceptionTypes();
                        Class[] ejbHomeExceptions = ejbLocalHomeMethod.getExceptionTypes();
                        if (!CheckUtils.areBeanMethodExceptionsSubsetOfInterfaceMethodExceptions(ejbHomeExceptions, localHomeExceptions)) {
                            results.add("Bean " + ejbName + ". Some of the exceptions defined in the throws clause of the method " + ejbLocalHomeMethodName + " are not included in the throws clause of the method " + methodName + ".");
                        }
                    }
                }
            }
            ++i;
        }
        if (!findByPK) {
            results.add("Bean " + ejbName + ". Method findByPrimaryKey(<PrimaryKeyClass>) not found in local home interface " + ejbLocalHomeName + ". The local home interface must always include the findByPrimaryKey method, which is always a single-object finder. The method must declare the primary key class as the method argument. EJB Specification 10.6.12.");
        }
    }

    private static void checkEJBHome(EntityDescriptor entDescr, Class ejbHomeClass, Vector results, String ejbName, Class entityClass, String pkClassName, String entityClassName, String ejbHomeName) {
        RemoteHomeInterfaceCheck.check(entDescr, ejbHomeClass, results);
        Method[] allEjbHomeMethods = ejbHomeClass.getMethods();
        boolean findByPK = false;
        int i = 0;
        while (i < allEjbHomeMethods.length) {
            if (!allEjbHomeMethods[i].getDeclaringClass().getName().equals("javax.ejb.EJBHome")) {
                Method homeIntfMethod = allEjbHomeMethods[i];
                String methodName = homeIntfMethod.getName();
                Class<?>[] methodArgs = homeIntfMethod.getParameterTypes();
                if (methodName.startsWith("create")) {
                    if (!homeIntfMethod.getReturnType().getName().equals(entDescr.getRemoteInterface())) {
                        results.add("Bean " + ejbName + ". The return type of a create<METHOD> " + homeIntfMethod.getName() + " must be the entity bean's remote interface type. EJB Specification 10.6.10.");
                    }
                    Class[] createExceptions = homeIntfMethod.getExceptionTypes();
                    boolean fnd = false;
                    int m = 0;
                    while (m < createExceptions.length) {
                        if (createExceptions[m].getName().equals("javax.ejb.CreateException")) {
                            fnd = true;
                            break;
                        }
                        ++m;
                    }
                    if (!fnd) {
                        results.add("Bean " + ejbName + ". The throws clause of a create<METHOD> " + homeIntfMethod.getName() + " method must include javax.ejb.CreateException.");
                    }
                    String ejbCreateMethodName = "ejbC" + methodName.substring(1);
                    String ejbPostCreateMethodName = "ejbPostC" + methodName.substring(1);
                    Method ejbCreateMethod = null;
                    Method ejbPostCreateMethod = null;
                    try {
                        ejbCreateMethod = entityClass.getMethod(ejbCreateMethodName, methodArgs);
                    }
                    catch (NoSuchMethodException nsme) {
                        results.add("Bean " + ejbName + ". Can not find ejbCreate<Method> " + ejbCreateMethodName + ", or parameters are not correct. Each create method name must match one of the ejbCreate<METHOD> methods defined in the enterprise bean class. EJB Specification 10.6.10.");
                    }
                    catch (SecurityException secEx) {
                        results.add("Bean " + ejbName + ". Can not access ejbCreate<Method>(s). Reason " + secEx.toString());
                    }
                    if (ejbCreateMethod != null) {
                        if (!ejbCreateMethod.getReturnType().getName().equals(pkClassName)) {
                            results.add("Bean " + ejbName + ". Illegal return type for method " + ejbCreateMethodName + ". The return type must be the entity bean's primary key type. EJB Specification 10.6.4.");
                        }
                        Class[] ejbCreateExceptions = ejbCreateMethod.getExceptionTypes();
                        fnd = false;
                        int m2 = 0;
                        while (m2 < ejbCreateExceptions.length) {
                            if (ejbCreateExceptions[m2].getName().equals("javax.ejb.CreateException")) {
                                fnd = true;
                                break;
                            }
                            ++m2;
                        }
                        if (!fnd) {
                            results.add("Bean " + ejbName + ". The throws clause of a ejbCreate<METHOD> " + ejbCreateMethodName + " method must include javax.ejb.CreateException. EJB Specification 10.6.4.");
                        }
                        try {
                            ejbPostCreateMethod = entityClass.getMethod(ejbPostCreateMethodName, methodArgs);
                        }
                        catch (NoSuchMethodException nsme) {
                            results.add("Bean " + ejbName + ". Can not find ejbPostCreate<Method> " + ejbPostCreateMethodName + ", or parameters are not correct. For each ejbCreate<METHOD>(...) method, the entity bean class must define a matching ejbPostCreate<METHOD>(...) method. EJB Specification 10.6.5.");
                        }
                        catch (SecurityException secEx) {
                            results.add("Bean " + ejbName + ". Can not access ejbPostCreate<Method>(s). Reason " + secEx.toString());
                        }
                        if (ejbPostCreateMethod != null) {
                            if (ejbPostCreateMethod != null && !ejbPostCreateMethod.getReturnType().getName().equals("void")) {
                                results.add("Bean " + ejbName + ". Illegal return type for method " + ejbPostCreateMethodName + ". The return type must be void. EJB Specification 10.6.5.");
                            }
                            Class[] ejbPostCreateExceptions = ejbPostCreateMethod.getExceptionTypes();
                            if (!CheckUtils.areBeanMethodExceptionsSubsetOfInterfaceMethodExceptions(ejbCreateExceptions, createExceptions)) {
                                results.add("Bean " + ejbName + ". Some of the exceptions defined in the throws clause of the method " + ejbCreateMethodName + " are not included in the throws clause of the corresponding create<METHOD>.");
                            }
                            if (!CheckUtils.areBeanMethodExceptionsSubsetOfInterfaceMethodExceptions(ejbPostCreateExceptions, createExceptions)) {
                                results.add("Bean " + ejbName + ". Some of the exceptions defined in the throws clause of the method " + ejbPostCreateMethodName + " are not included in the throws clause of the corresponding create<METHOD>.");
                            }
                        }
                    }
                } else if (methodName.startsWith("find")) {
                    if (methodName.equals("findByPrimaryKey") && methodArgs.length == 1 && methodArgs[0].getName().equals(pkClassName)) {
                        findByPK = true;
                        if (!homeIntfMethod.getReturnType().getName().equals(entDescr.getRemoteInterface())) {
                            results.add("Bean " + ejbName + ". findByPrimaryKey method was found in remote home interface, but with invalid return type. findByPrimaryKey must return the entity beans's remote interface.");
                        }
                        Method ejbFindByPKMethod = null;
                        try {
                            ejbFindByPKMethod = entityClass.getMethod("ejbFindByPrimaryKey", methodArgs);
                        }
                        catch (NoSuchMethodException nsme) {
                            results.add("Bean " + ejbName + ". Can not find ejbFindByPrimaryKey(<PrimaryKeyClass>) in entity bean's class " + entityClassName + ".");
                        }
                        catch (SecurityException secEx) {
                            results.add("Bean " + ejbName + ". Can not access ejbFindByPrimaryKey(<PrimaryKeyClass>). Reason: " + secEx.toString());
                        }
                        if (ejbFindByPKMethod != null) {
                            if (!ejbFindByPKMethod.getReturnType().getName().equals(pkClassName)) {
                                results.add("Bean " + ejbName + ". The return type of ejbFindByPrimaryKey method must be the enterprise bean's primary key type, but found " + ejbFindByPKMethod.getReturnType().getName() + ".");
                            }
                            Class[] findByPKExceptions = homeIntfMethod.getExceptionTypes();
                            Class[] ejbFindByPKExceptions = ejbFindByPKMethod.getExceptionTypes();
                            if (!CheckUtils.areBeanMethodExceptionsSubsetOfInterfaceMethodExceptions(ejbFindByPKExceptions, findByPKExceptions)) {
                                results.add("Bean " + ejbName + ". Some of the exceptions defined in the throws clause of the method ejbFindByPrimaryKey(<PrimaryKeyClass>) are not included in the throws clause of the method findByPrimaryKey(<PrimaryKeyClass>).");
                            }
                            boolean fnd = false;
                            int m = 0;
                            while (m < findByPKExceptions.length) {
                                if (findByPKExceptions[m].getName().equals("javax.ejb.FinderException")) {
                                    fnd = true;
                                }
                                ++m;
                            }
                            if (!fnd) {
                                results.add("Bean " + ejbName + ". findByPrimaryKey(<PrimaryKeyClass>) does not throw javax.ejb.FinderException. The throws clause of a finder method must include javax.ejb.FinderException. EJB Specification 10.6.10.");
                            }
                        }
                    } else {
                        String returnType = homeIntfMethod.getReturnType().getName();
                        if (!(returnType.equals(entDescr.getRemoteInterface()) || returnType.equals("java.util.Collection") || returnType.equals("java.util.Enumeration"))) {
                            results.add("Bean " + ejbName + ". The return type of a finder method in remote home interface must be the entity bean's remote interface, java.util.Collection, or java.util.Enumeration, but found " + returnType + ".");
                        }
                        String ejbFindMethodName = "ejbF" + methodName.substring(1);
                        Method ejbFindMethod = null;
                        try {
                            ejbFindMethod = entityClass.getMethod(ejbFindMethodName, methodArgs);
                        }
                        catch (NoSuchMethodException nsme) {
                            results.add("Bean " + ejbName + ". Can not find " + ejbFindMethodName + ", or parameters are incorrect in entity bean's class " + entityClassName + ".");
                        }
                        catch (SecurityException secEx) {
                            results.add("Bean " + ejbName + ". Can not access ejbFind<Method>(s). Reason: " + secEx.toString());
                        }
                        if (ejbFindMethod != null) {
                            String ejbReturnType = ejbFindMethod.getReturnType().getName();
                            if (!(ejbReturnType.equals(pkClassName) || ejbReturnType.equals("java.util.Collection") || ejbReturnType.equals("java.util.Enumeration"))) {
                                results.add("Bean " + ejbName + ". The return type of ejbFinder methods must be the entity bean's primary key class, java.util.Collection, or java.util.Enumeration, but found " + returnType + ".");
                            }
                            Class[] findExceptions = homeIntfMethod.getExceptionTypes();
                            Class[] ejbFindExceptions = ejbFindMethod.getExceptionTypes();
                            if (!CheckUtils.areBeanMethodExceptionsSubsetOfInterfaceMethodExceptions(ejbFindExceptions, findExceptions)) {
                                results.add("Bean " + ejbName + ". Some of the exceptions defined in the throws clause of the method " + ejbFindMethodName + " are not included in the throws clause of the method " + methodName + ".");
                            }
                            boolean fnd = false;
                            int m = 0;
                            while (m < findExceptions.length) {
                                if (findExceptions[m].getName().equals("javax.ejb.FinderException")) {
                                    fnd = true;
                                }
                                ++m;
                            }
                            if (!fnd) {
                                results.add("Bean " + ejbName + ". Method " + methodName + " does not throw javax.ejb.FinderException. The throws clause of a finder method must include javax.ejb.FinderException. EJB Specification 10.6.10.");
                            }
                            if (ejbReturnType.equals("java.util.Collection") || ejbReturnType.equals("java.util.Enumeration")) {
                                fnd = false;
                                int m3 = 0;
                                while (m3 < ejbFindExceptions.length) {
                                    if (ejbFindExceptions[m3].getName().equals("javax.ejb.ObjectNotFoundException")) {
                                        fnd = true;
                                        break;
                                    }
                                    ++m3;
                                }
                                if (fnd) {
                                    results.add("Bean " + ejbName + ". Method " + ejbFindMethodName + " throws ObjectNotFoundException.  Multi-object finder methods must not throw this exception.");
                                }
                            }
                        }
                    }
                } else {
                    String ejbHomeMethodName = "ejbHome" + methodName.substring(0, 1).toUpperCase() + methodName.substring(1);
                    Method ejbHomeMethod = null;
                    try {
                        ejbHomeMethod = entityClass.getMethod(ejbHomeMethodName, methodArgs);
                    }
                    catch (NoSuchMethodException nsme) {
                        results.add("Bean " + ejbName + ". Can not find " + ejbHomeMethodName + ", or parameters are incorrect in entity bean's class " + entityClassName + ".");
                    }
                    catch (SecurityException secEx) {
                        results.add("Bean " + ejbName + ". Can not access ejbHome<Method>(s). Reason: " + secEx.toString());
                    }
                    if (ejbHomeMethod != null) {
                        BusinessMethodCheck.check(ejbName, ejbHomeMethod, true, true, results);
                        if (!homeIntfMethod.getReturnType().getName().equals(ejbHomeMethod.getReturnType().getName())) {
                            results.add("Bean " + ejbName + ". Return types of " + methodName + " and " + ejbHomeMethodName + " are different, but they must be equal.");
                        }
                        Class[] homeExceptions = homeIntfMethod.getExceptionTypes();
                        Class[] ejbHomeExceptions = ejbHomeMethod.getExceptionTypes();
                        if (!CheckUtils.areBeanMethodExceptionsSubsetOfInterfaceMethodExceptions(ejbHomeExceptions, homeExceptions)) {
                            results.add("Bean " + ejbName + ". Some of the exceptions defined in the throws clause of the method " + ejbHomeMethodName + " are not included in the throws clause of the method " + methodName + ".");
                        }
                    }
                }
            }
            ++i;
        }
        if (!findByPK) {
            results.add("Bean " + ejbName + ". Method findByPrimaryKey(<PrimaryKeyClass>) not found in home interface " + ejbHomeName + ". The remote home interface must always include the findByPrimaryKey method, which is always a single-object finder. The method must declare the primary key class as the method argument. EJB Specification 10.6.10.");
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

